/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.admin;

import com.metamatrix.admin.api.embedded.EmbeddedConfigAdmin;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.AdminOptions;
import com.metamatrix.admin.api.objects.AdminStatus;
import com.metamatrix.admin.api.objects.LogConfiguration;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.admin.objects.MMAdminObject;
import com.metamatrix.admin.objects.MMAdminStatus;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorArchive;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.config.model.BasicConnectorArchive;
import com.metamatrix.common.config.model.BasicExtensionModule;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.dqp.embedded.DQPEmbeddedManager;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.admin.BaseAdmin;
import com.metamatrix.dqp.embedded.configuration.ConnectorConfigurationReader;
import com.metamatrix.dqp.embedded.configuration.ConnectorConfigurationWriter;
import com.metamatrix.dqp.embedded.configuration.ServerConfigFileWriter;
import com.metamatrix.dqp.embedded.configuration.VDBConfigurationReader;
import com.metamatrix.dqp.embedded.configuration.VDBConfigurationWriter;
import com.metamatrix.license.LicenseChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DQPConfigAdminImpl
extends BaseAdmin
implements EmbeddedConfigAdmin {
    public DQPConfigAdminImpl(DQPEmbeddedManager manager) {
        super(manager);
    }

    public void setSystemProperty(String propertyName, String propertyValue) throws AdminException {
        try {
            this.getConfigurationService().setSystemProperty(propertyName, propertyValue);
        }
        catch (Exception e2) {
            this.handleSystemException(e2);
        }
    }

    public void updateSystemProperties(Properties properties) throws AdminException {
        try {
            this.getConfigurationService().updateSystemProperties(properties);
        }
        catch (Exception e2) {
            this.handleSystemException(e2);
        }
    }

    public void setProperty(String identifier, String className, String propertyName, String propertyValue) throws AdminException {
        Properties properties = new Properties();
        properties.setProperty(propertyName, propertyValue);
        this.updateProperties(identifier, className, properties);
    }

    public void updateProperties(String identifier, String className, Properties properties) throws AdminException {
        Collection adminObjects = this.getAdminObjects(identifier, className);
        if (adminObjects == null || adminObjects.size() == 0) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.No_Objects_Found", identifier, className));
        }
        if (adminObjects.size() > 1) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Multiple_Objects_Found", identifier, className));
        }
        AdminObject adminObject = (AdminObject)adminObjects.iterator().next();
        int typeCode = MMAdminObject.getObjectType(className);
        switch (typeCode) {
            case 19: {
                this.updateSystemProperties(properties);
                break;
            }
            case 2: {
                try {
                    String bindingName = adminObject.getName();
                    ConnectorBinding binding = this.getDataService().getConnectorBinding(bindingName);
                    ComponentTypeID id = binding.getComponentTypeID();
                    ConnectorBindingType type = this.getConfigurationService().getConnectorType(id.getName());
                    Properties encryptedProperties = new Properties();
                    encryptedProperties.putAll((Map<?, ?>)properties);
                    Iterator<Object> iter = properties.keySet().iterator();
                    while (iter.hasNext()) {
                        String propertyName = (String)iter.next();
                        boolean needsEncryption = this.isMaskedProperty(propertyName, type);
                        if (!needsEncryption) continue;
                        String propertyValue = properties.getProperty(propertyName);
                        propertyValue = this.encryptString(propertyValue);
                        encryptedProperties.put(propertyName, propertyValue);
                    }
                    binding = ConnectorConfigurationReader.addConnectorBindingProperties(binding, encryptedProperties);
                    this.getDataService().updateConnectorBinding(binding);
                }
                catch (MetaMatrixComponentException e2) {
                    this.handleSystemException(e2);
                }
                catch (MetaMatrixProcessingException e3) {
                    this.handleProcessingException(e3);
                }
                catch (ApplicationLifecycleException e4) {
                    this.handleProcessingException(e4);
                }
                break;
            }
            default: {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.can_not_set_property"));
            }
        }
    }

    public void addConnectorType(String name, char[] cdkFile) throws AdminException {
        try {
            if (name == null || !name.matches("\\w+(\\s*\\w)*")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ct_name"));
            }
            if (cdkFile == null || cdkFile.length == 0) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ct_source"));
            }
            if (this.getConfigurationService().getConnectorType(name) != null) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Connector_type_exists", new Object[]{name}));
            }
            ConnectorBindingType type = ConnectorConfigurationReader.loadConnectorType(cdkFile);
            this.saveConnectorType(type, false);
        }
        catch (Exception e2) {
            this.handleSystemException(e2);
        }
    }

    public void deleteConnectorType(String name) throws AdminException {
        try {
            if (name == null || !name.matches("\\w+(\\s*\\w)*")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ct_name"));
            }
            this.getConfigurationService().deleteConnectorType(name);
        }
        catch (Exception e2) {
            this.handleSystemException(e2);
        }
    }

    public com.metamatrix.admin.api.objects.ConnectorBinding addConnectorBinding(String name, String type, Properties properties, AdminOptions options) throws AdminException {
        if (options == null) {
            options = new AdminOptions(2);
        }
        if (name == null || !name.matches("\\w+(\\s*\\w)*")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_cb_name"));
        }
        if (type == null || !type.matches("\\w+(\\s*\\w)*")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ct_name"));
        }
        ConnectorBinding binding = null;
        try {
            ConnectorBindingType ctype;
            if (this.bindingExists(name)) {
                if (options.containsOption(4)) {
                    throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.addBindingEixists", new String[]{name}));
                }
                if (options.containsOption(2)) {
                    binding = this.getDataService().getConnectorBinding(name);
                    return (com.metamatrix.admin.api.objects.ConnectorBinding)this.convertToAdminObjects(binding);
                }
            }
            if ((ctype = this.getConfigurationService().getConnectorType(type)) == null) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.connector_type_not_exists", new String[]{type}));
            }
            binding = ConnectorConfigurationReader.loadConnectorBinding(name, properties, ctype);
            AdminStatus status = this.checkDecryption(binding, ctype);
            if (status.getCode() == -101 && !options.containsOption(8)) {
                throw new AdminProcessingException(status.getCode(), status.getMessage());
            }
            this.addConnectorBinding(name, binding, ctype, true);
        }
        catch (AdminException e2) {
            throw e2;
        }
        catch (Exception e3) {
            this.handleSystemException(e3);
        }
        return (com.metamatrix.admin.api.objects.ConnectorBinding)this.convertToAdminObjects(binding);
    }

    boolean bindingExists(String name) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        ConnectorBinding binding = this.getDataService().getConnectorBinding(name);
        return binding != null;
    }

    boolean bindingTypeExists(String name) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        ConnectorBindingType type = this.getConfigurationService().getConnectorType(name);
        return type != null;
    }

    public com.metamatrix.admin.api.objects.ConnectorBinding addConnectorBinding(String name, char[] xmlFile, AdminOptions options) throws AdminException {
        if (options == null) {
            options = new AdminOptions(2);
        }
        if (name == null || !name.matches("\\w+(\\s*\\w)*")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_cb_name"));
        }
        if (xmlFile == null || xmlFile.length == 0) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_cb_source"));
        }
        ConnectorBinding binding = null;
        try {
            ConnectorBindingType type;
            if (this.bindingExists(name)) {
                if (options.containsOption(4)) {
                    throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.addBindingEixists", new String[]{name}));
                }
                if (options.containsOption(2)) {
                    binding = this.getDataService().getConnectorBinding(name);
                    return (com.metamatrix.admin.api.objects.ConnectorBinding)this.convertToAdminObjects(binding);
                }
            }
            if (this.bindingTypeExists((type = ConnectorConfigurationReader.loadConnectorType(xmlFile)).getName()) && options.containsOption(4)) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.addBinding_type_exists", new String[]{name, type.getName()}));
            }
            binding = ConnectorConfigurationReader.loadConnectorBinding(name, xmlFile);
            AdminStatus status = this.checkDecryption(binding, type);
            if (status.getCode() == -101 && !options.containsOption(8)) {
                throw new AdminProcessingException(status.getCode(), status.getMessage());
            }
            this.addConnectorBinding(name, binding, type, true);
        }
        catch (AdminException e2) {
            throw e2;
        }
        catch (Exception e3) {
            this.handleSystemException(e3);
        }
        return (com.metamatrix.admin.api.objects.ConnectorBinding)this.convertToAdminObjects(binding);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addConnectorBinding(String name, ConnectorBinding binding, ConnectorBindingType type, boolean replace) throws AdminException {
        if (type == null || binding == null) throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.connector_load_failed_wrong_contents", name));
        if (!binding.getComponentTypeID().getName().equals(type.getName())) throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.connector_load_failed_wrong_type", name));
        try {
            if (this.getConfigurationService().getConnectorType(type.getName()) == null || replace) {
                this.saveConnectorType(type, replace);
            }
            this.getDataService().addConnectorBinding(name, binding, replace);
            return;
        }
        catch (Exception e2) {
            this.handleSystemException(e2);
        }
    }

    public void deleteConnectorBinding(String identifier) throws AdminException {
        try {
            if (identifier == null || !identifier.matches("\\w+(\\s*\\w)*")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_cb_name"));
            }
            this.getDataService().deleteConnectorBinding(identifier);
        }
        catch (Exception e2) {
            this.handleSystemException(e2);
        }
    }

    private VDB addVDB(String name, byte[] vdbFile, char[] defFile, AdminOptions options) throws AdminException {
        if (options == null) {
            options = new AdminOptions(2);
        }
        if (name == null || !name.matches("\\w+")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_vdb_name"));
        }
        if (vdbFile == null || vdbFile.length == 0) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_vdb_source"));
        }
        if (defFile == null) {
            DQPEmbeddedPlugin.logInfo("Admin.load_combined_vdb", new Object[]{name});
        }
        VDBDefn vdb = null;
        try {
            vdb = VDBConfigurationReader.loadVDB(name, defFile, vdbFile);
            if (!LicenseChecker.hasValidProductLicense("Sources", "5.0", vdb.getConnectorBindings().size())) {
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("Admin.bindings_exceeded_limit"));
            }
            this.addConnectorBindingsInVdb(vdb, options);
            VDBDefn deployedVDB = this.getVDBService().deployVDB(vdb);
            if (deployedVDB.getStatus() == 3) {
                try {
                    this.startVDBConnectorBindings(deployedVDB);
                }
                catch (Exception e2) {}
            }
        }
        catch (AdminException e3) {
            throw e3;
        }
        catch (Exception e4) {
            this.handleSystemException(e4);
        }
        return (VDB)this.convertToAdminObjects(vdb);
    }

    void addConnectorBindingsInVdb(VDBDefn vdb, AdminOptions options) throws MetaMatrixComponentException, MetaMatrixProcessingException, AdminProcessingException, AdminException {
        ConnectorBinding binding;
        ArrayList<ConnectorBinding> newbindings = new ArrayList<ConnectorBinding>();
        ArrayList vdbbindings = new ArrayList(vdb.getConnectorBindings().values());
        Iterator i2 = vdbbindings.iterator();
        while (i2.hasNext()) {
            binding = (ConnectorBinding)i2.next();
            if (this.bindingExists(binding.getName())) {
                if (options.containsOption(4)) {
                    throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.addBindingEixists", new String[]{binding.getName()}));
                }
                if (!options.containsOption(1)) continue;
                newbindings.add(binding);
                continue;
            }
            newbindings.add(binding);
        }
        i2 = newbindings.iterator();
        while (i2.hasNext()) {
            binding = (ConnectorBinding)i2.next();
            ConnectorBindingType type = (ConnectorBindingType)vdb.getConnectorType(binding.getComponentTypeID().getName());
            if (this.bindingTypeExists(type.getName()) && options.containsOption(4)) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.addBinding_type_exists", new String[]{binding.getName(), type.getName()}));
            }
            AdminStatus status = this.checkDecryption(binding, type);
            if (status.getCode() == -101 && !options.containsOption(8)) {
                throw new AdminProcessingException(status.getCode(), status.getMessage());
            }
            this.addConnectorBinding(binding.getName(), binding, type, true);
        }
    }

    private void startVDBConnectorBindings(VDBDefn vdb) throws MetaMatrixComponentException, MetaMatrixProcessingException, ApplicationLifecycleException {
        Collection models = vdb.getModels();
        Iterator i2 = models.iterator();
        while (i2.hasNext()) {
            String bindingName;
            ModelInfo model = (ModelInfo)i2.next();
            if (!model.isPhysical() || (bindingName = (String)this.getVDBService().getConnectorBindingNames(vdb.getName(), vdb.getVersion(), model.getName()).get(0)) == null) continue;
            this.getDataService().startConnectorBinding(bindingName);
        }
    }

    private AdminStatus checkDecryption(ConnectorBinding binding, ConnectorBindingType type) {
        try {
            Properties props = binding.getProperties();
            Iterator<Object> it = props.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (!this.isMaskedProperty(name, type)) continue;
                this.decryptProperty(props.getProperty(name));
            }
        }
        catch (MetaMatrixComponentException e2) {
            return new MMAdminStatus(-101, "AdminStatus.CODE_DECRYPTION_FAILED", binding.getName());
        }
        return new MMAdminStatus(0, "AdminStatus.CODE_SUCCESS");
    }

    boolean isMaskedProperty(String propName, ComponentType type) {
        ComponentTypeDefn typeDef;
        return type != null && (typeDef = type.getComponentTypeDefinition(propName)) != null && typeDef.getPropertyDefinition().isMasked();
    }

    String decryptProperty(String value) throws MetaMatrixComponentException {
        if (value != null && value.length() > 0) {
            try {
                return new String(CryptoUtil.stringDecrypt(value.toCharArray()));
            }
            catch (CryptoException e2) {
                throw new MetaMatrixComponentException((Throwable)e2);
            }
        }
        return value;
    }

    public VDB addVDB(String name, byte[] vdbFile, AdminOptions options) throws AdminException {
        return this.addVDB(name, vdbFile, null, options);
    }

    public void addExtensionModule(String type, String sourceName, byte[] source, String description) throws AdminException {
        try {
            if (sourceName == null) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ext_source_name"));
            }
            if (source == null || source.length == 0) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ext_source"));
            }
            if (!sourceName.endsWith(".jar")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ext_module"));
            }
            ExtensionModule previousModule = null;
            try {
                previousModule = this.getConfigurationService().getExtensionModule(sourceName);
            }
            catch (MetaMatrixComponentException e2) {
                // empty catch block
            }
            if (previousModule != null) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.extension_module_exists", new Object[]{sourceName}));
            }
            BasicExtensionModule extModule = new BasicExtensionModule(sourceName, type, description, source);
            this.getConfigurationService().saveExtensionModule(extModule);
        }
        catch (MetaMatrixComponentException e3) {
            this.handleSystemException(e3);
        }
        catch (MetaMatrixProcessingException e4) {
            this.handleProcessingException(e4);
        }
    }

    public void deleteExtensionModule(String sourceName) throws AdminException {
        try {
            if (sourceName == null) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ext_source_name"));
            }
            this.getConfigurationService().deleteExtensionModule(sourceName);
        }
        catch (MetaMatrixComponentException e2) {
            this.handleSystemException(e2);
        }
        catch (MetaMatrixProcessingException e3) {
            this.handleProcessingException(e3);
        }
    }

    public void assignBindingToModel(String connectorBindingName, String vdbName, String vdbVersion, String modelName) throws AdminException {
        if (connectorBindingName == null || !connectorBindingName.matches("\\w+(\\s*\\w)*")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_cb_name"));
        }
        if (vdbName == null || vdbVersion == null || !vdbName.matches("\\w+")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_vdb_name"));
        }
        if (modelName == null || !modelName.matches("\\w+(\\s*\\w)*")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_model_name"));
        }
        List bindingList = new ArrayList();
        try {
            bindingList = this.getDataService().getConnectorBindings();
        }
        catch (MetaMatrixComponentException err) {
            this.handleSystemException(err);
        }
        catch (MetaMatrixProcessingException err) {
            this.handleProcessingException(err);
        }
        for (int i2 = 0; i2 < bindingList.size(); ++i2) {
            ConnectorBinding binding = (ConnectorBinding)bindingList.get(i2);
            if (!binding.getName().equals(connectorBindingName)) continue;
            ArrayList<ConnectorBinding> list = new ArrayList<ConnectorBinding>();
            list.add(binding);
            try {
                this.getVDBService().mapConnectorBindings(vdbName, vdbVersion, modelName, list);
            }
            catch (MetaMatrixComponentException err) {
                this.handleSystemException(err);
            }
            catch (MetaMatrixProcessingException err) {
                this.handleProcessingException(err);
            }
            return;
        }
        throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Vdb_or_Model_notfound"));
    }

    public LogConfiguration getLogConfiguration() throws AdminException {
        return (LogConfiguration)this.convertToAdminObjects(LogManager.getLogConfiguration());
    }

    public void setLogConfiguration(LogConfiguration config) throws AdminException {
        LogManager.setLogConfiguration((com.metamatrix.common.log.LogConfiguration)this.convertToNativeObjects(config));
    }

    public byte[] exportExtensionModule(String sourceName) throws AdminException {
        try {
            if (sourceName == null) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ext_source_name"));
            }
            ExtensionModule extModule = this.getConfigurationService().getExtensionModule(sourceName);
            return extModule.getFileContents();
        }
        catch (MetaMatrixComponentException e2) {
            this.handleSystemException(e2);
        }
        catch (MetaMatrixProcessingException e3) {
            this.handleProcessingException(e3);
        }
        return null;
    }

    public char[] exportConfiguration() throws AdminException {
        try {
            ConfigurationModelContainer model = this.getConfigurationService().getSystemConfiguration();
            return ServerConfigFileWriter.writeToCharArray(model);
        }
        catch (MetaMatrixComponentException e2) {
            this.handleSystemException(e2);
        }
        catch (MetaMatrixProcessingException e3) {
            this.handleProcessingException(e3);
        }
        return null;
    }

    public char[] exportConnectorBinding(String identifier) throws AdminException {
        try {
            if (identifier == null || !identifier.matches("\\w+(\\s*\\w)*")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_cb_name"));
            }
            List bindingList = this.getDataService().getConnectorBindings();
            ArrayList<ConnectorBinding> matchedList = new ArrayList<ConnectorBinding>();
            Iterator i2 = bindingList.iterator();
            while (i2.hasNext()) {
                ConnectorBinding binding = (ConnectorBinding)i2.next();
                if (!this.matches(identifier, binding.getName())) continue;
                matchedList.add(binding);
            }
            if (!matchedList.isEmpty()) {
                ConnectorBinding[] bindings = matchedList.toArray(new ConnectorBinding[matchedList.size()]);
                ConnectorBindingType[] types = new ConnectorBindingType[bindings.length];
                for (int i3 = 0; i3 < bindings.length; ++i3) {
                    types[i3] = this.getConfigurationService().getConnectorType(bindings[i3].getComponentTypeID().getName());
                }
                return ConnectorConfigurationWriter.writeToCharArray(bindings, types);
            }
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Connector_binding_does_not_exists", identifier));
        }
        catch (MetaMatrixComponentException e2) {
            this.handleSystemException(e2);
        }
        catch (MetaMatrixProcessingException e3) {
            this.handleProcessingException(e3);
        }
        return null;
    }

    public char[] exportConnectorType(String identifier) throws AdminException {
        try {
            if (identifier == null || !identifier.matches("\\w+(\\s*\\w)*")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ct_name"));
            }
            List typesList = this.getConfigurationService().getConnectorTypes();
            ArrayList<ConnectorBindingType> matchedList = new ArrayList<ConnectorBindingType>();
            Iterator i2 = typesList.iterator();
            while (i2.hasNext()) {
                ConnectorBindingType type = (ConnectorBindingType)i2.next();
                if (!this.matches(identifier, type.getName())) continue;
                matchedList.add(type);
            }
            if (!matchedList.isEmpty()) {
                ConnectorBindingType[] types = matchedList.toArray(new ConnectorBindingType[matchedList.size()]);
                return ConnectorConfigurationWriter.writeToCharArray(types);
            }
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Connector_type_does_not_exists", identifier));
        }
        catch (MetaMatrixComponentException e2) {
            this.handleSystemException(e2);
        }
        catch (MetaMatrixProcessingException e3) {
            this.handleProcessingException(e3);
        }
        return null;
    }

    public byte[] exportVDB(String name, String version) throws AdminException {
        try {
            if (name == null || version == null || !name.matches("\\w+")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_vdb_name"));
            }
            VDBDefn vdb = this.getConfigurationService().getVDB(name, version);
            if (vdb != null) {
                return VDBConfigurationWriter.writeToByteArray(vdb);
            }
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.vdb_does_not_exists", name, version));
        }
        catch (MetaMatrixComponentException e2) {
            this.handleSystemException(e2);
        }
        catch (MetaMatrixProcessingException e3) {
            this.handleProcessingException(e3);
        }
        return null;
    }

    public void addConnectorArchive(byte[] contents, AdminOptions options) throws AdminException {
        if (options == null) {
            options = new AdminOptions(2);
        }
        if (contents == null || contents.length == 0) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ct_source"));
        }
        try {
            HashSet previouslyAddedModules = new HashSet();
            ConnectorArchive archive = ConnectorConfigurationReader.loadConnectorArchive(contents);
            ConnectorBindingType[] connectorTypes = archive.getConnectorTypes();
            for (int typeIndex = 0; typeIndex < connectorTypes.length; ++typeIndex) {
                ExtensionModule[] extModules;
                String connectorName = connectorTypes[typeIndex].getName();
                ConnectorBindingType type = this.getConfigurationService().getConnectorType(connectorName);
                if (type == null) {
                    type = connectorTypes[typeIndex];
                    extModules = archive.getExtensionModules(type);
                    this.checkAddingConnectorType(type, extModules, options, previouslyAddedModules);
                    this.saveConnectorType(type, false);
                } else {
                    if (options.containsOption(4)) {
                        throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Connector_type_exists", new Object[]{connectorName}));
                    }
                    if (options.containsOption(2)) continue;
                    if (options.containsOption(1)) {
                        this.deleteConnectorType(connectorName);
                        type = connectorTypes[typeIndex];
                        extModules = archive.getExtensionModules(type);
                        this.checkAddingConnectorType(type, extModules, options, previouslyAddedModules);
                        this.saveConnectorType(type, true);
                    }
                }
                type = connectorTypes[typeIndex];
                extModules = archive.getExtensionModules(type);
                this.checkAddingConnectorType(type, extModules, options, previouslyAddedModules);
            }
            Iterator i2 = previouslyAddedModules.iterator();
            while (i2.hasNext()) {
                ExtensionModule extModule = (ExtensionModule)i2.next();
                this.addExtensionModule(extModule.getModuleType(), extModule.getFullName(), extModule.getFileContents(), extModule.getDescription());
            }
        }
        catch (MetaMatrixComponentException e2) {
            this.handleSystemException(e2);
        }
        catch (MetaMatrixProcessingException e3) {
            this.handleProcessingException(e3);
        }
    }

    void checkAddingConnectorType(ConnectorBindingType type, ExtensionModule[] extModules, AdminOptions options, HashSet ignorableModules) throws MetaMatrixComponentException, MetaMatrixProcessingException, AdminException {
        for (int i2 = 0; i2 < extModules.length; ++i2) {
            boolean add = true;
            String moduleName = extModules[i2].getFullName();
            ExtensionModule previousModule = null;
            if (ignorableModules.contains(extModules[i2])) continue;
            try {
                previousModule = this.getConfigurationService().getExtensionModule(moduleName);
            }
            catch (MetaMatrixComponentException e2) {
                // empty catch block
            }
            if (previousModule != null && options.containsOption(4)) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.extension_module_exists", new Object[]{previousModule.getFullName()}));
            }
            if (previousModule != null && options.containsOption(2)) {
                add = false;
            } else if (previousModule != null && options.containsOption(1)) {
                this.deleteExtensionModule(previousModule.getFullName());
            }
            if (!add) continue;
            ignorableModules.add(extModules[i2]);
        }
    }

    public byte[] exportConnectorArchive(String identifier) throws AdminException {
        try {
            if (identifier == null || !identifier.matches("\\w*(\\s*\\w)*(\\*)?")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_ct_name"));
            }
            BasicConnectorArchive archive = new BasicConnectorArchive();
            List connectorTypes = this.getConfigurationService().getConnectorTypes();
            Iterator i2 = connectorTypes.iterator();
            while (i2.hasNext()) {
                ConnectorBindingType type = (ConnectorBindingType)i2.next();
                if (type == null || !this.matches(identifier, type.getName())) continue;
                archive.addConnectorType(type);
                String[] extModules = type.getExtensionModules();
                for (int m2 = 0; m2 < extModules.length; ++m2) {
                    ExtensionModule extModule = this.getConfigurationService().getExtensionModule(extModules[m2]);
                    if (extModule == null) {
                        throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("DataService.ext_module_not_found", extModules[m2]));
                    }
                    archive.addExtensionModule(type, extModule);
                }
            }
            if (archive.getConnectorTypes().length == 0) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Connector_type_does_not_exists", identifier));
            }
            return ConnectorConfigurationWriter.writeToByteArray(archive);
        }
        catch (MetaMatrixComponentException e2) {
            this.handleSystemException(e2);
        }
        catch (MetaMatrixProcessingException e3) {
            this.handleProcessingException(e3);
        }
        return null;
    }

    private void saveConnectorType(ConnectorBindingType type, boolean replace) throws MetaMatrixProcessingException, MetaMatrixComponentException {
        if (!replace && !LicenseChecker.hasValidProductLicense("Connector/Custom", "5.0")) {
            throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.custom_connectors_restricted"));
        }
        this.getConfigurationService().saveConnectorType(type);
    }
}

