/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.configuration;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.config.api.ConnectorArchive;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import java.io.ByteArrayOutputStream;
import java.util.Properties;

public class ConnectorConfigurationWriter {
    private static final XMLConfigurationImportExportUtility UTIL = new XMLConfigurationImportExportUtility();

    public static char[] writeToCharArray(ConnectorBinding[] bindings, ConnectorBindingType[] types) throws MetaMatrixComponentException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            UTIL.exportConnectorBindings(bos, bindings, types, ConnectorConfigurationWriter.getPropertiesForExporting());
            char[] contents = bos.toString().toCharArray();
            bos.close();
            return contents;
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException(e2);
        }
    }

    public static char[] writeToCharArray(ConnectorBindingType[] bindingTypes) throws MetaMatrixComponentException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            UTIL.exportComponentTypes(bos, bindingTypes, ConnectorConfigurationWriter.getPropertiesForExporting());
            char[] contents = bos.toString().toCharArray();
            bos.close();
            return contents;
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException(e2);
        }
    }

    public static byte[] writeToByteArray(ConnectorArchive connectorArchive) throws MetaMatrixComponentException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        try {
            byte[] contents;
            UTIL.exportConnectorArchive(bos, connectorArchive, ConnectorConfigurationWriter.getPropertiesForExporting());
            byte[] byArray = contents = bos.toByteArray();
            return byArray;
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException(e2);
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception e3) {}
        }
    }

    static Properties getPropertiesForExporting() {
        Properties properties = new Properties();
        properties.put("ApplicationCreatedBy", "EmbeddedAdmin");
        properties.put("ApplicationVersion", "4.3");
        properties.put("UserCreatedBy", "dqpadmin");
        return properties;
    }
}

