/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.cache;

import com.metamatrix.core.util.HashCodeUtil;
import java.util.List;

public class CacheID {
    private String scopeID;
    private String command;
    private int hashCode;
    private List preparedStatementValues;

    public CacheID(String scopeID, String command) {
        this(scopeID, command, null);
    }

    public CacheID(String scopeID, String command, List preparedStatementValue) {
        this.scopeID = scopeID;
        this.command = command;
        this.preparedStatementValues = preparedStatementValue;
        this.hashCode = HashCodeUtil.expHashCode(HashCodeUtil.hashCode(HashCodeUtil.hashCode(0, scopeID), command), this.preparedStatementValues);
    }

    public String getCommand() {
        return this.command;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof CacheID)) {
            return false;
        }
        CacheID that = (CacheID)obj;
        return this.scopeID.equals(that.scopeID) && this.command.equals(that.command) && this.compareParamValues(this.preparedStatementValues, that.preparedStatementValues);
    }

    private boolean compareParamValues(List thisPreparedStatementValues, List thatPreparedStatementValues) {
        if (thisPreparedStatementValues == null && thatPreparedStatementValues == null) {
            return true;
        }
        if (thisPreparedStatementValues == null && thatPreparedStatementValues != null || thisPreparedStatementValues != null && thatPreparedStatementValues == null) {
            return false;
        }
        int size = thisPreparedStatementValues.size();
        if (size != thatPreparedStatementValues.size()) {
            return false;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            if (thisPreparedStatementValues.get(i2).equals(thatPreparedStatementValues.get(i2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

