/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.metadata;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.data.metadata.runtime.MetadataObject;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import com.metamatrix.dqp.internal.datamgr.metadata.ElementImpl;
import com.metamatrix.dqp.internal.datamgr.metadata.GroupImpl;
import com.metamatrix.dqp.internal.datamgr.metadata.MetadataIDImpl;
import com.metamatrix.dqp.internal.datamgr.metadata.MetadataObjectImpl;
import com.metamatrix.dqp.internal.datamgr.metadata.ParameterIDImpl;
import com.metamatrix.dqp.internal.datamgr.metadata.ParameterImpl;
import com.metamatrix.dqp.internal.datamgr.metadata.ProcedureIDImpl;
import com.metamatrix.dqp.internal.datamgr.metadata.ProcedureImpl;
import com.metamatrix.dqp.internal.datamgr.metadata.RuntimeMetadataImpl;
import com.metamatrix.query.m.a;
import com.metamatrix.query.m.e;
import java.util.List;

public class MetadataFactory {
    private e metadata;

    public MetadataFactory(e metadata) {
        ArgCheck.isNotNull(metadata);
        this.metadata = metadata;
    }

    public RuntimeMetadata createRuntimeMetadata() {
        return new RuntimeMetadataImpl(this);
    }

    public MetadataID createMetadataID(Object metadataID, int type) throws QueryMetadataException, MetaMatrixComponentException {
        if (type == 1 && this.metadata.isVirtualGroup(metadataID)) {
            return null;
        }
        MetadataIDImpl id = new MetadataIDImpl(metadataID, this.metadata);
        id.setType(type);
        return id;
    }

    public MetadataID createProcedureID(Object metadataID) throws QueryMetadataException, MetaMatrixComponentException {
        String procName = this.metadata.getFullName(metadataID);
        a info = this.metadata.getStoredProcedureInfoForProcedure(procName);
        ProcedureIDImpl id = new ProcedureIDImpl(metadataID, info, this, this.metadata);
        id.setType(2);
        return id;
    }

    public MetadataID createParameterID(ProcedureIDImpl procedureID, Object metadataID) throws QueryMetadataException, MetaMatrixComponentException {
        ParameterIDImpl id = new ParameterIDImpl(metadataID, procedureID, this.metadata);
        id.setType(3);
        return id;
    }

    public MetadataID createResultSetID(ProcedureIDImpl procedureID, Object metadataID, List resultSetColumns) throws QueryMetadataException, MetaMatrixComponentException {
        ParameterIDImpl id = new ParameterIDImpl(metadataID, procedureID, this.metadata, resultSetColumns);
        id.setType(3);
        return id;
    }

    public MetadataObject createMetadataObject(MetadataID id) throws QueryMetadataException, MetaMatrixComponentException, ConnectorException {
        int type = id.getType();
        MetadataIDImpl idImpl = (MetadataIDImpl)id;
        MetadataObjectImpl mObj = null;
        if (type == 1) {
            mObj = new GroupImpl(idImpl);
        } else if (type == 0) {
            mObj = new ElementImpl(idImpl);
        } else if (type == 2) {
            mObj = new ProcedureImpl(idImpl);
        } else if (type == 3) {
            mObj = new ParameterImpl(idImpl);
        }
        return mObj;
    }

    public byte[] getBinaryVDBResource(String resourcePath) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getBinaryVDBResource(resourcePath);
    }

    public String getCharacterVDBResource(String resourcePath) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getCharacterVDBResource(resourcePath);
    }

    public String[] getVDBResourcePaths() throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getVDBResourcePaths();
    }
}

