/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.cache.CacheID;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import com.metamatrix.dqp.internal.cache.ResultSetCacheUtil;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.internal.process.ConnectorRequestInfo;
import com.metamatrix.dqp.internal.process.DQPProcessorContext;
import com.metamatrix.dqp.internal.process.DataTierManager;
import com.metamatrix.dqp.internal.process.MessageHandler;
import com.metamatrix.dqp.internal.process.PreparedPlanCache;
import com.metamatrix.dqp.internal.process.ProcessWorkerFactory;
import com.metamatrix.dqp.internal.process.QueueAdapter;
import com.metamatrix.dqp.internal.process.Request;
import com.metamatrix.dqp.internal.process.RequestManager;
import com.metamatrix.dqp.internal.process.WorkItem;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.DQPInboundMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.service.BufferService;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.TrackingService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.query.e.f;
import com.metamatrix.query.e.j.a;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.transaction.xa.XAException;

public class DQPCore {
    private int maxCodeTableRecords = 10000;
    private int maxCodeTables = 20;
    private static final int DEFAULT_MAX_CODE_TABLE_RECORDS = 10000;
    private static final int DEFAULT_MAX_CODE_TABLES = 20;
    private static final int DEFAULT_PROCESSOR_TIMESLICE = 2000;
    private ApplicationEnvironment env;
    private Map connectorCapabilitiesCache;
    private BufferManager bufferManager;
    private DataTierManager dataTierMgr;
    private RequestManager requestMgr = new RequestManager();
    private PreparedPlanCache prepPlanCache;
    private TrackingService tracker;
    private TransactionService transactionService;
    private MetadataService metadataService;
    private ResultSetCache rsCache;
    private WorkerPool processWorkerPool;
    private boolean processDebugAllowed;
    private boolean updatesAllowed;
    private boolean transactionsAllowed;
    private boolean virtualLayerAllowed;
    private boolean xmlAllowed;
    private static final String PROCESS_PLAN_QUEUE_NAME = "QueryProcessorQueue";
    private MessageHandler messageHandler = null;

    public DQPCore(ApplicationEnvironment env) {
        this.env = env;
        Properties props = env.getApplicationProperties();
        boolean DQPAllowed = LicenseChecker.hasValidProductLicense("Query Engine", "5.0", false);
        LogManager.logInfo("DQP", DQPPlugin.Util.getString("DQPCore.License_allows_DQP_{0}", Boolean.valueOf(DQPAllowed).toString()));
        this.transactionsAllowed = LicenseChecker.hasValidProductLicense("Query/Transactions", "5.0", false);
        LogManager.logInfo("DQP", DQPPlugin.Util.getString("DQPCore.License_allows_transactions__{0}", Boolean.valueOf(this.transactionsAllowed).toString()));
        this.updatesAllowed = LicenseChecker.hasValidProductLicense("Query/Updates", "5.0", false);
        LogManager.logInfo("DQP", DQPPlugin.Util.getString("DQPCore.License_allows_updates__{0}", Boolean.valueOf(this.updatesAllowed).toString()));
        this.virtualLayerAllowed = LicenseChecker.hasValidProductLicense("Views/Relational", "5.0", false);
        LogManager.logInfo("DQP", DQPPlugin.Util.getString("DQPCore.virtual_allowed", (Object)this.virtualLayerAllowed));
        this.xmlAllowed = LicenseChecker.hasValidProductLicense("Views/XML", "5.0", false);
        LogManager.logInfo("DQP", DQPPlugin.Util.getString("DQPCore.xml_allowed", (Object)this.xmlAllowed));
        Properties rsCacheProps = null;
        if (Boolean.valueOf(props.getProperty("ResultSetCacheEnabled", "false")).booleanValue()) {
            rsCacheProps = new Properties();
            rsCacheProps.setProperty("maxSize", props.getProperty("ResultSetCacheMaxSize", "0"));
            rsCacheProps.setProperty("maxAge", props.getProperty("ResultSetCacheMaxAge", "0"));
            rsCacheProps.setProperty("scope", props.getProperty("ResultSetCacheScope", "vdb"));
            try {
                this.rsCache = new ResultSetCache(rsCacheProps);
            }
            catch (MetaMatrixComponentException e2) {
                LogManager.logWarning("DQP", (Throwable)e2, DQPPlugin.Util.getString("DQPCORE.6"));
            }
        }
        int maxSizeTotal = Integer.parseInt(props.getProperty("MaxPlanCacheSize", "0"));
        this.prepPlanCache = new PreparedPlanCache(maxSizeTotal);
        String procDebugStr = props.getProperty("ProcessorDebugAllowed", "false");
        Boolean procDebugAllowed = Boolean.valueOf(procDebugStr);
        LogManager.logInfo("DQP", DQPPlugin.Util.getString("DQPCore.Processor_debug_allowed_{0}", this.processDebugAllowed));
        this.initialize(this.getInteger(props, "MinFetchSize", "DQPCore.Exception_trying_to_determine_min_fetch_size."), this.getInteger(props, "MaxFetchSize", "DQPCore.Exception_trying_to_determine_max_fetch_size."), this.getInteger(props, "MaxCodeTables", "DQPCore.Exception_trying_to_determine_maximum_number_of_code_tables."), this.getInteger(props, "MaxCodeTableRecords", "DQPCore.Exception_trying_to_determine_maximum_record_size_of_a_code_table."), this.getInteger(props, "ProcessorTimeslice", "DQPCore.Exception_trying_to_determine_processor_timeslice_from_{0}."), Integer.parseInt(props.getProperty("ProcessPoolMaxThreads", "15")), Integer.parseInt(props.getProperty("ProcessPoolThreadTTL", "120000")), procDebugAllowed);
    }

    private Integer getInteger(Properties props, String propertyName, String errorMessageKey) {
        String propertyText = props.getProperty(propertyName);
        if (propertyText != null) {
            try {
                return new Integer(propertyText);
            }
            catch (NumberFormatException e2) {
                Object[] params = new Object[]{propertyText};
                String msg = DQPPlugin.Util.getString(errorMessageKey, (Object)params);
                LogManager.logWarning("DQP", (Throwable)e2, msg);
            }
        }
        return null;
    }

    private void initialize(Integer minFetchSizeSetting, Integer maxFetchSizeSetting, Integer maxCodeTablesSetting, Integer maxCodeTableRecordsSetting, Integer processorTimesliceSetting, int maxThreads, int threadTTL, boolean procDebugFlag) {
        this.initializeSettings(minFetchSizeSetting, maxFetchSizeSetting, maxCodeTablesSetting, maxCodeTableRecordsSetting, procDebugFlag);
        this.initializeServices();
        this.initializeProcessing(maxThreads, threadTTL, processorTimesliceSetting);
        this.connectorCapabilitiesCache = new HashMap();
        this.messageHandler = new MessageHandler(this, this.tracker, this.transactionService, this.transactionsAllowed, this.metadataService, this.requestMgr, this.prepPlanCache, this.env);
    }

    private void initializeSettings(Integer minFetchSizeSetting, Integer maxFetchSizeSetting, Integer maxCodeTablesSetting, Integer maxCodeTableRecordsSetting, boolean procDebugFlag) {
        if (maxCodeTablesSetting != null) {
            this.maxCodeTables = maxCodeTablesSetting;
        }
        if (maxCodeTableRecordsSetting != null) {
            this.maxCodeTableRecords = maxCodeTableRecordsSetting;
        }
        this.processDebugAllowed = procDebugFlag;
    }

    private void initializeServices() {
        BufferService bufferService = (BufferService)this.env.findService("dqp.buffer");
        this.bufferManager = bufferService.getBufferManager();
        this.tracker = (TrackingService)this.env.findService("dqp.tracking");
        this.transactionService = (TransactionService)this.env.findService("dqp.transaction");
        this.metadataService = (MetadataService)this.env.findService("dqp.metadata");
    }

    private void initializeProcessing(int maxThreads, int threadTTL, Integer processorTimesliceSetting) {
        int processorTimeslice = 2000;
        if (processorTimesliceSetting != null) {
            processorTimeslice = processorTimesliceSetting;
        }
        ProcessWorkerFactory processWorkerFactory = new ProcessWorkerFactory(this.requestMgr, this.bufferManager, processorTimeslice, this.tracker, this.rsCache);
        this.processWorkerPool = new WorkerPool(PROCESS_PLAN_QUEUE_NAME, processWorkerFactory, maxThreads, threadTTL);
        this.requestMgr.setWorkQueue(new QueueAdapter(this.processWorkerPool));
        processWorkerFactory.setProcessPool(this.processWorkerPool);
        this.dataTierMgr = new DataTierManager(this.requestMgr, (DataService)this.env.findService("dqp.data"), (MetadataService)this.env.findService("dqp.metadata"), (VDBService)this.env.findService("dqp.vdb"), (TransactionService)this.env.findService("dqp.transaction"), (BufferService)this.env.findService("dqp.buffer"), this.processWorkerPool, this.maxCodeTables, this.maxCodeTableRecords);
        processWorkerFactory.setDataTierManager(this.dataTierMgr);
    }

    public void stop() {
        this.processWorkerPool.shutdown();
    }

    public Message process(DQPInboundMessage message) throws QueryParserException, QueryResolverException, QueryValidatorException, QueryPlannerException, QueryMetadataException, MetaMatrixComponentException, XATransactionException, XAException {
        return this.messageHandler.processMessage(message);
    }

    public Collection getRequestsByClient(ClientConnection clientConnection) {
        return this.requestMgr.getRequestsByClient(clientConnection);
    }

    public Map getRequestMapByClient(ClientConnection clientConnection) {
        return this.requestMgr.getRequestMapByClient(clientConnection);
    }

    public Map getRequests() {
        return this.requestMgr.getRequests();
    }

    Message processRequestMessage(RequestMessage requestMsg) throws MetaMatrixComponentException, QueryParserException, QueryResolverException, QueryValidatorException, QueryPlannerException {
        if (requestMsg.isLobRequest()) {
            try {
                int size;
                String streamingBatchSize;
                Properties envProps;
                int chunkSize = requestMsg.getChunkSize();
                if (chunkSize > 0 && (envProps = this.env.getApplicationProperties()) != null && (streamingBatchSize = envProps.getProperty("metamatrix.server.streamingBatchSize")) != null && (size = Integer.parseInt(streamingBatchSize) * 1024) > 0) {
                    chunkSize = size;
                }
                this.processWorkerPool.addWork(new WorkItem(requestMsg.getRequestID(), requestMsg.getValueID(), requestMsg.getStartPosition(), chunkSize));
            }
            catch (QueueSuspendedException e2) {
                throw new MetaMatrixComponentException((Throwable)e2);
            }
            return null;
        }
        Request request = Request.createRequest(requestMsg, this.env, this.prepPlanCache, this.bufferManager, this.dataTierMgr, this.requestMgr, this.processWorkerPool, this.connectorCapabilitiesCache, this.transactionService, this.updatesAllowed, this.rsCache, this.processDebugAllowed, this.virtualLayerAllowed, this.xmlAllowed);
        request.processRequest();
        if (requestMsg.isSynchronousRequest()) {
            return new ResultsMessage(requestMsg, new List[0], Collections.EMPTY_LIST, false);
        }
        return null;
    }

    public void processCursorRequest(RequestID reqID, int batchFirst, int batchLast) throws MetaMatrixComponentException {
        if (LogManager.isMessageToBeRecorded("DQP", 5)) {
            LogManager.logDetail("DQP", "DQP process cursor request from " + batchFirst + " to " + batchLast);
        }
        if (this.isValidRequestID(reqID)) {
            try {
                WorkItem workItem = this.hasResultsInCache(reqID) ? new WorkItem(reqID, this.rsCache) : new WorkItem(reqID);
                this.requestMgr.markNeedsResults(reqID, workItem, batchFirst, batchLast);
            }
            catch (QueueSuspendedException e2) {
                this.requestMgr.removeRequest(reqID);
                throw new MetaMatrixComponentException((Throwable)e2);
            }
        } else {
            throw new MetaMatrixComponentException(DQPPlugin.Util.getString("DQPCore.The_request_has_been_cancelled.", reqID));
        }
    }

    private boolean hasResultsInCache(RequestID reqID) {
        if (this.rsCache == null) {
            return false;
        }
        RequestMessage requestMsg = this.requestMgr.getRequest(reqID);
        if (requestMsg == null) {
            return false;
        }
        if (!requestMsg.useResultSetCache()) {
            return false;
        }
        CacheID cID = ResultSetCacheUtil.createCacheID(requestMsg, this.rsCache);
        return this.rsCache.hasResults(cID);
    }

    Collection getQueueStatistics() {
        if (this.processWorkerPool == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WorkerPoolStats> statList = new ArrayList<WorkerPoolStats>(1);
        statList.add(this.processWorkerPool.getStats());
        return statList;
    }

    Collection getQueueStatistics(String name) {
        if (!name.equalsIgnoreCase(PROCESS_PLAN_QUEUE_NAME) || this.processWorkerPool == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WorkerPoolStats> stats = new ArrayList<WorkerPoolStats>(2);
        stats.add(this.processWorkerPool.getStats());
        return stats;
    }

    public void cancelRequest(RequestID requestID, ClientConnection clientConnection) throws MetaMatrixComponentException {
        if (requestID == null) {
            this.terminateConnection(clientConnection, true);
        } else {
            this.requestMgr.markRequestCancelled(requestID);
            this.sendCancelMessage(requestID);
            this.closeRequest(requestID);
        }
    }

    void cancelRequest(RequestID requestID, int nodeID, ClientConnection clientConnection) throws MetaMatrixComponentException {
        if (requestID == null) {
            return;
        }
        if (!this.isValidRequestID(requestID)) {
            return;
        }
        if (clientConnection == null) {
            return;
        }
        ConnectorRequestInfo conInfo = this.requestMgr.getConnectorInfo(requestID, nodeID);
        if (conInfo != null) {
            this.cancelConnectorInfo(conInfo);
            Object[] errorParams = new Object[]{requestID, new Integer(nodeID)};
            String errorMsg = DQPPlugin.Util.getString("DQPCore.The_atomic_request_has_been_cancelled.", errorParams);
            LogManager.logDetail("DQP", errorMsg);
            ResultsMessage errorResults = new ResultsMessage(conInfo.getAtomicRequest(), true);
            errorResults.setException(new ConnectorException(errorMsg));
            this.dataTierMgr.deliverMessage(errorResults, null);
            RequestMessage request = this.requestMgr.getRequest(requestID);
            if (!request.supportsPartialResults()) {
                this.closeRequest(requestID);
            }
        }
    }

    void closeRequest(RequestID requestID, ClientConnection clientConnection) throws MetaMatrixComponentException {
        if (requestID == null) {
            this.terminateConnection(clientConnection, false);
        } else {
            this.closeRequest(requestID);
        }
    }

    private void terminateConnection(ClientConnection clientConnection, boolean sendCancellationsToClient) throws MetaMatrixComponentException {
        if (clientConnection == null) {
            return;
        }
        String connectionID = (String)clientConnection.getConnectionProperty("connectionID");
        Iterator iter = this.getRequestsByClient(clientConnection).iterator();
        while (iter.hasNext()) {
            RequestMessage rMsg = (RequestMessage)iter.next();
            this.requestMgr.markRequestCancelled(rMsg.getRequestID());
            if (sendCancellationsToClient) {
                this.sendCancelMessage(rMsg.getRequestID());
            }
            this.closeRequest(rMsg.getRequestID());
        }
        List requestIDs = this.requestMgr.getRequestIdByclient(clientConnection);
        Iterator i2 = requestIDs.iterator();
        while (i2.hasNext()) {
            RequestID reqId = (RequestID)i2.next();
            this.closeRequest(reqId);
        }
        if (connectionID != null) {
            try {
                this.bufferManager.removeTupleSources(connectionID);
            }
            catch (Exception e2) {
                LogManager.logWarning("DQP", (Throwable)e2, "Failed to remove buffered tuples for connection " + connectionID);
            }
        }
        this.clearPlanCache(clientConnection);
    }

    private boolean isValidRequestID(RequestID requestID) {
        RequestMessage request = this.requestMgr.getRequest(requestID);
        return request != null;
    }

    private void closeRequest(RequestID requestID) throws MetaMatrixComponentException {
        if (LogManager.isMessageToBeRecorded("DQP", 5)) {
            LogManager.logDetail("DQP", "cancelQuery for requestID=" + requestID);
        }
        if (this.isValidRequestID(requestID)) {
            RequestMessage request = this.requestMgr.getRequest(requestID);
            if (this.rsCache != null && request != null) {
                CacheID cID = ResultSetCacheUtil.createCacheID(request, this.rsCache);
                this.rsCache.removeTempResults(cID);
            }
            List conInfoList = this.requestMgr.getAllConnectorInfo(requestID);
            MetaMatrixComponentException exception = null;
            try {
                this.cancelConnectorInfos(conInfoList);
            }
            catch (MetaMatrixComponentException e2) {
                exception = e2;
            }
            this.notifyProcessorOfClosing(requestID);
            try {
                this.removeTupleSource(requestID, request == null ? false : request.isXMLQuery());
            }
            catch (MetaMatrixComponentException e3) {
                exception = e3;
            }
            this.requestMgr.removeRequest(requestID);
            if (exception != null) {
                throw exception;
            }
        }
    }

    private void cancelConnectorInfos(List conInfoList) throws MetaMatrixComponentException {
        if (conInfoList != null && !conInfoList.isEmpty()) {
            Iterator i2 = conInfoList.iterator();
            while (i2.hasNext()) {
                ConnectorRequestInfo conInfo = (ConnectorRequestInfo)i2.next();
                this.cancelConnectorInfo(conInfo);
            }
        }
    }

    private void cancelConnectorInfo(ConnectorRequestInfo conInfo) throws MetaMatrixComponentException {
        if (conInfo == null) {
            return;
        }
        ConnectorID connectorID = conInfo.getConnectorID();
        if (connectorID != null) {
            AtomicRequestMessage cancelRequest = conInfo.getAtomicRequest();
            cancelRequest.setType(3);
            cancelRequest.setConnectorID(connectorID);
            this.dataTierMgr.registerRequest(cancelRequest);
        }
    }

    private void removeTupleSource(RequestID requestID, boolean isXML) throws MetaMatrixComponentException {
        if (LogManager.isMessageToBeRecorded("DQP", 5)) {
            LogManager.logDetail("DQP", "Removing tuplesource for the request " + requestID);
        }
        try {
            TupleSourceID tupleSourceID = this.requestMgr.getResultsID(requestID);
            if (tupleSourceID == null) {
                return;
            }
            if (isXML) {
                TupleSource ts = this.bufferManager.getTupleSource(tupleSourceID);
                try {
                    List row;
                    ts.openSource();
                    while ((row = ts.nextTuple()) != null) {
                        Object value;
                        if (row.size() == 0 || !((value = row.get(0)) instanceof a)) continue;
                        a valueID = (a)value;
                        this.bufferManager.removeTupleSource(valueID.a());
                    }
                }
                catch (BlockedException e2) {
                    // empty catch block
                }
            }
            this.bufferManager.removeTupleSource(tupleSourceID);
        }
        catch (TupleSourceNotFoundException e3) {
        }
        catch (RemoteException ex) {
            throw new MetaMatrixComponentException((Throwable)ex, ex.getMessage());
        }
    }

    private void notifyProcessorOfClosing(RequestID requestID) {
        f processor = this.requestMgr.getProcessor(requestID);
        if (processor != null) {
            processor.a();
        }
    }

    private void clearPlanCache(ClientConnection clientConn) {
        if (clientConn == null) {
            return;
        }
        this.prepPlanCache.clear(clientConn);
    }

    private void sendCancelMessage(RequestID requestID) {
        RequestMessage request = this.requestMgr.getRequest(requestID);
        if (request != null) {
            ResultsMessage response = new ResultsMessage(request, false);
            Object[] errorParams = new Object[]{requestID};
            String errorMsg = DQPPlugin.Util.getString("DQPCore.The_request_has_been_cancelled.", errorParams);
            MetaMatrixComponentException error = new MetaMatrixComponentException(errorMsg);
            LogManager.logDetail("DQP", errorMsg);
            response.setException(error);
            f processor = this.requestMgr.getProcessor(requestID);
            if (processor == null) {
                return;
            }
            DQPProcessorContext context = (DQPProcessorContext)processor.c();
            ClientConnection clientConn = context.getClientConnection();
            try {
                clientConn.send(response, context.getMessageKey());
            }
            catch (CommunicationException e2) {
                Object[] params = new Object[]{requestID};
                String msg = DQPPlugin.Util.getString("ProcessWorker.Failed_to_deliver_response_for_{0}", (Object)params);
                LogManager.logDetail("DQP", msg);
            }
        }
    }

    void clearPlanCache() {
        LogManager.logInfo("DQP", DQPPlugin.Util.getString("DQPCore.Clearing_prepared_plan_cache"));
        this.prepPlanCache.clearAll();
    }

    void clearCodeTableCache() {
        LogManager.logInfo("DQP", DQPPlugin.Util.getString("DQPCore.Clearing_code_table_cache"));
        this.dataTierMgr.clearCodeTables();
    }

    public void clearResultSetCache() {
        if (this.rsCache != null) {
            this.rsCache.clear();
        }
    }

    int getFinalRowCount(RequestID requestID) {
        TupleSourceID tupleSourceID = this.requestMgr.getResultsID(requestID);
        try {
            return this.bufferManager.getFinalRowCount(tupleSourceID);
        }
        catch (Throwable t2) {
            return -1;
        }
    }
}

