/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.query.b.a.c;
import com.metamatrix.query.b.b.b;
import com.metamatrix.query.m.a;
import com.metamatrix.query.m.e;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class QueryMetadataWrapper
implements e {
    private String vdbName;
    private String vdbVersion;
    private VDBService vdbService;
    private e actualMetadata;

    public QueryMetadataWrapper(e actualMetadata, String vdbName, String vdbVersion, VDBService vdbService) {
        this.vdbName = vdbName;
        this.vdbService = vdbService;
        this.actualMetadata = actualMetadata;
        this.vdbVersion = vdbVersion;
    }

    protected e getActualMetadata() {
        return this.actualMetadata;
    }

    protected String getVdbName() {
        return this.vdbName;
    }

    protected VDBService getVdbService() {
        return this.vdbService;
    }

    protected String getVdbVersion() {
        return this.vdbVersion;
    }

    public Object getElementID(String elementName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getElementID(elementName);
    }

    public Object getGroupID(String groupName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getGroupID(groupName);
    }

    public Collection getGroupsForPartialName(String partialGroupName) throws MetaMatrixComponentException, QueryMetadataException {
        Collection result = this.actualMetadata.getGroupsForPartialName(partialGroupName);
        if (result == null || result.isEmpty()) {
            return result;
        }
        HashSet<String> filteredResult = new HashSet<String>();
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            String groupName = (String)iter.next();
            Object groupID = this.actualMetadata.getGroupID(groupName);
            Object modelID = this.actualMetadata.getModelID(groupID);
            String modelName = this.actualMetadata.getFullName(modelID);
            int visibility = this.vdbService.getModelVisibility(this.vdbName, this.vdbVersion, modelName);
            if (visibility != 0) continue;
            filteredResult.add(groupName);
        }
        return filteredResult;
    }

    public Object getModelID(Object groupOrElementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getModelID(groupOrElementID);
    }

    public String getFullName(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getFullName(metadataID);
    }

    public String getFullElementName(String fullGroupName, String shortElementName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getFullElementName(fullGroupName, shortElementName);
    }

    public String getShortElementName(String fullElementName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getShortElementName(fullElementName);
    }

    public String getGroupName(String fullElementName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getGroupName(fullElementName);
    }

    public List getElementIDsInGroupID(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getElementIDsInGroupID(groupID);
    }

    public Object getGroupIDForElementID(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getGroupIDForElementID(elementID);
    }

    public a getStoredProcedureInfoForProcedure(String fullyQualifiedProcedureName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getStoredProcedureInfoForProcedure(fullyQualifiedProcedureName);
    }

    public String getElementType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getElementType(elementID);
    }

    public Object getDefaultValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getDefaultValue(elementID);
    }

    public Object getMinimumValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getMinimumValue(elementID);
    }

    public Object getMaximumValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getMaximumValue(elementID);
    }

    public int getDistinctValues(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getDistinctValues(elementID);
    }

    public int getNullValues(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getNullValues(elementID);
    }

    public int getPosition(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getPosition(elementID);
    }

    public int getPrecision(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getPrecision(elementID);
    }

    public int getScale(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getScale(elementID);
    }

    public int getRadix(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getRadix(elementID);
    }

    public boolean isVirtualGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.isVirtualGroup(groupID);
    }

    public boolean isVirtualModel(Object modelID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.isVirtualModel(modelID);
    }

    public b getVirtualPlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getVirtualPlan(groupID);
    }

    public String getInsertPlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getInsertPlan(groupID);
    }

    public String getUpdatePlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getUpdatePlan(groupID);
    }

    public String getDeletePlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getDeletePlan(groupID);
    }

    public boolean modelSupports(Object modelID, int modelConstant) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.modelSupports(modelID, modelConstant);
    }

    public boolean groupSupports(Object groupID, int groupConstant) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.groupSupports(groupID, groupConstant);
    }

    public boolean elementSupports(Object elementID, int elementConstant) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.elementSupports(elementID, elementConstant);
    }

    public Properties getExtensionProperties(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getExtensionProperties(metadataID);
    }

    public int getMaxSetSize(Object modelID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getMaxSetSize(modelID);
    }

    public Collection getIndexesInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getIndexesInGroup(groupID);
    }

    public Collection getUniqueKeysInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getUniqueKeysInGroup(groupID);
    }

    public Collection getForeignKeysInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getForeignKeysInGroup(groupID);
    }

    public Object getPrimaryKeyIDForForeignKeyID(Object foreignKeyID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getPrimaryKeyIDForForeignKeyID(foreignKeyID);
    }

    public Collection getAccessPatternsInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getAccessPatternsInGroup(groupID);
    }

    public List getElementIDsInIndex(Object index) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getElementIDsInIndex(index);
    }

    public List getElementIDsInKey(Object key) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getElementIDsInKey(key);
    }

    public List getElementIDsInAccessPattern(Object accessPattern) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getElementIDsInAccessPattern(accessPattern);
    }

    public boolean isXMLGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.isXMLGroup(groupID);
    }

    public boolean isTemporaryGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.isTemporaryGroup(groupID);
    }

    public c getMappingNode(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getMappingNode(groupID);
    }

    public String getVirtualDatabaseName() throws MetaMatrixComponentException, QueryMetadataException {
        return this.vdbName;
    }

    public Collection getXMLTempGroups(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getXMLTempGroups(groupID);
    }

    public int getCardinality(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getCardinality(groupID);
    }

    public List getXMLSchemas(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getXMLSchemas(groupID);
    }

    public String getNameInSource(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getNameInSource(metadataID);
    }

    public int getElementLength(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getElementLength(elementID);
    }

    public boolean hasMaterialization(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.hasMaterialization(groupID);
    }

    public Object getMaterialization(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getMaterialization(groupID);
    }

    public Object getMaterializationStage(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getMaterializationStage(groupID);
    }

    public String getNativeType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getNativeType(elementID);
    }

    public boolean isProcedureInputElement(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.isProcedureInputElement(elementID);
    }

    public byte[] getBinaryVDBResource(String resourcePath) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getBinaryVDBResource(resourcePath);
    }

    public String getCharacterVDBResource(String resourcePath) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getCharacterVDBResource(resourcePath);
    }

    public String[] getVDBResourcePaths() throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getVDBResourcePaths();
    }

    public String getModeledType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getModeledType(elementID);
    }

    public String getModeledBaseType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getModeledBaseType(elementID);
    }

    public String getModeledPrimitiveType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.actualMetadata.getModeledPrimitiveType(elementID);
    }
}

