/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.log;

import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.internal.core.log.BasePlatformLogWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.eclipse.core.runtime.IStatus;

public class PlatformLogWriter
extends BasePlatformLogWriter {
    protected Writer outLog = null;
    protected Writer errorLog = null;
    protected boolean newSession = true;
    private boolean outLogIsSystem = false;
    private boolean errLogIsSystem = false;

    public PlatformLogWriter(File file) {
        super(file);
    }

    public PlatformLogWriter(OutputStream out) {
        this(out, out);
    }

    public PlatformLogWriter(OutputStream out, OutputStream error) {
        this.outLog = this.logForStream(out);
        this.errorLog = this.logForStream(error);
        if (out == System.out || out == System.err) {
            this.outLogIsSystem = true;
        }
        if (error == System.out || error == System.err) {
            this.errLogIsSystem = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void logMessage(IStatus status, long timestamp, String pluginID, String threadName) {
        if (this.getLogFile() != null) {
            this.openLogFile();
        }
        if (this.outLog == null) {
            this.outLog = this.logForStream(System.out);
        }
        if (this.errorLog == null) {
            this.errorLog = this.logForStream(System.err);
        }
        try {
            block12: {
                boolean isError = false;
                try {
                    if (status.getSeverity() == 4) {
                        PlatformLogWriter.write(this.errorLog, status, timestamp, threadName, null, 0);
                        isError = true;
                    } else {
                        PlatformLogWriter.write(this.outLog, status, timestamp, threadName, null, 0);
                    }
                    Object var8_7 = null;
                    if (!isError) break block12;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (isError) {
                        this.errorLog.flush();
                        throw throwable;
                    }
                    this.outLog.flush();
                    throw throwable;
                }
                this.errorLog.flush();
                return;
            }
            this.outLog.flush();
            return;
        }
        catch (Exception e2) {
            System.err.println("An exception occurred while writing to the platform log:");
            e2.printStackTrace(System.err);
            System.err.println("Logging to the console instead.");
            try {
                Writer log = this.logForStream(System.err);
                PlatformLogWriter.write(log, status, timestamp, threadName, null, 0);
                log.flush();
                return;
            }
            catch (Exception e22) {
                System.err.println("An exception occurred while logging to the console:");
                e22.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeLogFile() throws IOException {
        try {
            if (this.outLog != null) {
                this.outLog.flush();
                this.outLog.close();
            }
        }
        finally {
            this.outLog = null;
        }
    }

    protected void openLogFile() {
        try {
            this.errorLog = this.outLog = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getLogFile().getAbsolutePath(), true), "UTF-8"));
            if (this.newSession) {
                this.writeHeader(this.outLog);
                this.newSession = false;
            }
        }
        catch (IOException e2) {
            this.errorLog = this.outLog = this.logForStream(System.err);
        }
    }

    protected Writer logForStream(OutputStream output) {
        try {
            return new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            return new BufferedWriter(new OutputStreamWriter(output));
        }
    }

    public synchronized void shutdown() {
        try {
            if (this.getLogFile() != null) {
                this.closeLogFile();
                this.setLogFile(null);
            } else {
                Writer old;
                if (this.outLog != null && !this.outLogIsSystem) {
                    old = this.outLog;
                    this.outLog = null;
                    old.flush();
                    old.close();
                }
                if (this.errorLog != null && !this.errLogIsSystem) {
                    old = this.errorLog;
                    this.errorLog = null;
                    old.flush();
                    old.close();
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PlatformLogWriter)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PlatformLogWriter that = (PlatformLogWriter)obj;
        if (this.getLogFile() != null) {
            return this.getLogFile().equals(that.getLogFile());
        }
        if (that.getLogFile() != null) {
            return false;
        }
        return this.outLog == that.outLog && this.errorLog == that.errorLog;
    }

    public int hashCode() {
        int hash = 0;
        if (this.getLogFile() != null) {
            hash = HashCodeUtil.hashCode(hash, this.getLogFile());
        } else {
            hash = HashCodeUtil.hashCode(hash, this.outLog);
            hash = HashCodeUtil.hashCode(hash, this.errorLog);
        }
        return hash;
    }

    public String toString() {
        if (this.getLogFile() != null) {
            return "PlatformLogWriter " + this.getLogFile();
        }
        if (this.outLog != this.errorLog) {
            return "PlatformLogWriter " + this.outLog + "/" + this.errorLog;
        }
        return "PlatformLogWriter " + this.outLog;
    }
}

