/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml.xmi;

import com.metamatrix.internal.core.xml.xmi.ModelImportInfo;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TerminatingXMIHeaderContentHandler
extends DefaultHandler {
    public static final String HEADER_FOUND_EXCEPTION_MESSAGE = "HeaderFoundException";
    public static final String XMI_NOT_FOUND_EXCEPTION_MESSAGE = "XMINotFoundException";
    private static final String XMI_TAG_NAME = "XMI";
    private static final String VIRTUAL_DATABASE_TAG_NAME = "VirtualDatabase";
    private static final String MODEL_ANNOTATION_TAG_NAME = "ModelAnnotation";
    private static final String XMI_VERSION_0020_ATTRIBUTE_NAME = "xmi:version";
    private static final String XMI_VERSION_0011_ATTRIBUTE_NAME = "xmi.version";
    private static final String PRODUCER_NAME_ATTRIBUTE_NAME = "ProducerName";
    private static final String PRODUCER_VERSION_ATTRIBUTE_NAME = "ProducerVersion";
    private static final String UUID_ATTRIBUTE_NAME = "uuid";
    private static final String DESCRIPTION_ATTRIBUTE_NAME = "description";
    private static final String PRIMARY_URI_ATTRIBUTE_NAME = "primaryMetamodelUri";
    private static final String MODEL_TYPE_ATTRIBUTE_NAME = "modelType";
    private static final String VISIBLE_ATTRIBUTE_NAME = "visible";
    private static final String MODEL_NAMESPACE_URI = "namespaceURI";
    private static final String MODEL_IMPORT_TAG_NAME = "modelImports";
    private static final String MODELS_TAG_NAME = "models";
    private static final String IMPORT_PATH_ATTRIBUTE_NAME = "path";
    private static final String IMPORT_LOC_ATTRIBUTE_NAME = "modelLocation";
    private static final String IMPORT_NAME_ATTRIBUTE_NAME = "name";
    private static final String IMPORT_TYPE_ATTRIBUTE_NAME = "modelType";
    private static final String IMPORT_UUID_ATTRIBUTE_NAME = "uuid";
    private static final String IMPORT_PRIMARY_METAMODEL_URI_ATTRIBUTE_NAME = "primaryMetamodelUri";
    private boolean foundXmiStartElement = false;
    private boolean foundAnnotationStartElement = false;
    private boolean foundAnnotationEndElement = false;
    private boolean foundVdbStartElement = false;
    private boolean foundVdbEndElement = false;
    private XMIHeader header;

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.getXmiHeader().addNamespaceURI(uri);
        super.startPrefixMapping(prefix, uri);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equalsIgnoreCase(XMI_TAG_NAME)) {
            this.processAttributes(atts);
            this.foundXmiStartElement = true;
        } else if (localName.equalsIgnoreCase(MODEL_ANNOTATION_TAG_NAME)) {
            this.processAttributes(atts);
            this.foundAnnotationStartElement = true;
        } else if (localName.equalsIgnoreCase(VIRTUAL_DATABASE_TAG_NAME)) {
            this.processVdbAttributes(atts);
            this.foundAnnotationStartElement = true;
            this.foundVdbStartElement = true;
        } else if (localName.equalsIgnoreCase(MODELS_TAG_NAME) && this.foundVdbStartElement) {
            this.processImportAttributes(atts);
        } else if (localName.equalsIgnoreCase(MODEL_IMPORT_TAG_NAME)) {
            this.processImportAttributes(atts);
        }
        this.checkForCompletion();
        super.startElement(uri, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.checkForCompletion();
        if (localName.equals(MODEL_ANNOTATION_TAG_NAME)) {
            this.foundAnnotationEndElement = true;
        } else if (localName.equals(VIRTUAL_DATABASE_TAG_NAME)) {
            this.foundAnnotationEndElement = true;
            this.foundVdbEndElement = true;
        }
        super.endElement(namespaceURI, localName, qName);
    }

    public XMIHeader getXmiHeader() {
        if (this.header == null) {
            this.header = new XMIHeader();
        }
        return this.header;
    }

    private void checkForCompletion() throws SAXException {
        if (!(this.foundXmiStartElement || this.foundAnnotationStartElement || this.foundVdbStartElement)) {
            throw new SAXException(XMI_NOT_FOUND_EXCEPTION_MESSAGE);
        }
        if (this.foundAnnotationStartElement && this.foundAnnotationEndElement && !this.foundVdbStartElement) {
            throw new SAXException(HEADER_FOUND_EXCEPTION_MESSAGE);
        }
        if (this.foundVdbStartElement && this.foundVdbEndElement) {
            throw new SAXException(HEADER_FOUND_EXCEPTION_MESSAGE);
        }
    }

    private void processAttributes(Attributes atts) {
        for (int i2 = 0; i2 < atts.getLength(); ++i2) {
            String name = atts.getLocalName(i2);
            String value = atts.getValue(i2);
            String qname = atts.getQName(i2);
            if (name.equalsIgnoreCase("uuid") && !this.foundVdbStartElement) {
                this.getXmiHeader().setUUID(value);
                continue;
            }
            if (name.equalsIgnoreCase(DESCRIPTION_ATTRIBUTE_NAME)) {
                this.getXmiHeader().setDescription(value);
                continue;
            }
            if (name.equalsIgnoreCase(PRODUCER_NAME_ATTRIBUTE_NAME)) {
                this.getXmiHeader().setProducerName(value);
                continue;
            }
            if (name.equalsIgnoreCase(PRODUCER_VERSION_ATTRIBUTE_NAME)) {
                this.getXmiHeader().setProducerVersion(value);
                continue;
            }
            if (name.equalsIgnoreCase("primaryMetamodelUri")) {
                this.getXmiHeader().setPrimaryMetamodelURI(value);
                continue;
            }
            if (name.equalsIgnoreCase("modelType")) {
                this.getXmiHeader().setModelType(value);
                continue;
            }
            if (name.equalsIgnoreCase(MODEL_NAMESPACE_URI)) {
                this.getXmiHeader().setModelNamespaceUri(value);
                continue;
            }
            if (name.equalsIgnoreCase(VISIBLE_ATTRIBUTE_NAME)) {
                this.getXmiHeader().setVisible(value);
                continue;
            }
            if (qname.equalsIgnoreCase(XMI_VERSION_0020_ATTRIBUTE_NAME)) {
                this.getXmiHeader().setXmiVersion(value);
                continue;
            }
            if (!qname.equalsIgnoreCase(XMI_VERSION_0011_ATTRIBUTE_NAME)) continue;
            this.getXmiHeader().setXmiVersion(value);
        }
    }

    private void processVdbAttributes(Attributes atts) {
        for (int i2 = 0; i2 < atts.getLength(); ++i2) {
            String name = atts.getLocalName(i2);
            String value = atts.getValue(i2);
            String qname = atts.getQName(i2);
            if (name.equalsIgnoreCase("uuid")) {
                this.getXmiHeader().setUUID(value);
                continue;
            }
            if (!qname.equalsIgnoreCase(XMI_VERSION_0020_ATTRIBUTE_NAME)) continue;
            this.getXmiHeader().setXmiVersion(value);
        }
    }

    private void processImportAttributes(Attributes atts) {
        ModelImportInfo info = new ModelImportInfo();
        for (int i2 = 0; i2 < atts.getLength(); ++i2) {
            String name = atts.getLocalName(i2);
            String value = atts.getValue(i2);
            if (name.equalsIgnoreCase(IMPORT_PATH_ATTRIBUTE_NAME)) {
                info.setPath(value);
                continue;
            }
            if (name.equalsIgnoreCase(IMPORT_LOC_ATTRIBUTE_NAME)) {
                info.setLocation(value);
                continue;
            }
            if (name.equalsIgnoreCase("uuid")) {
                info.setUUID(value);
                continue;
            }
            if (name.equalsIgnoreCase(IMPORT_NAME_ATTRIBUTE_NAME)) {
                info.setName(value);
                continue;
            }
            if (name.equalsIgnoreCase("modelType")) {
                info.setModelType(value);
                continue;
            }
            if (!name.equalsIgnoreCase("primaryMetamodelUri")) continue;
            info.setPrimaryMetamodelURI(value);
        }
        this.getXmiHeader().addModelImportInfo(info);
    }
}

