/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml.xmi;

import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.xml.xmi.ModelImportInfo;

public final class XMIHeader {
    private ObjectVector namespaceURIs = new ObjectVector();
    private ObjectVector modelImportInfos = new ObjectVector();
    private String primaryMetamodelURI;
    private String uuid;
    private String description;
    private String modelType;
    private String modelNamespaceUri;
    private boolean visible = true;
    private String producerName;
    private String producerVersion;
    private String xmiVersion;

    public String[] getNamespaceURIs() {
        Object[] result = new String[this.namespaceURIs.size];
        this.namespaceURIs.copyInto(result);
        return result;
    }

    public String[] getModelImportPaths() {
        String[] result = new String[this.modelImportInfos.size];
        for (int i2 = 0; i2 < this.modelImportInfos.size(); ++i2) {
            ModelImportInfo info = (ModelImportInfo)this.modelImportInfos.elementAt(i2);
            result[i2] = info.getPath();
        }
        return result;
    }

    public String[] getModelImportLocations() {
        String[] result = new String[this.modelImportInfos.size];
        for (int i2 = 0; i2 < this.modelImportInfos.size(); ++i2) {
            ModelImportInfo info = (ModelImportInfo)this.modelImportInfos.elementAt(i2);
            result[i2] = info.getLocation();
        }
        return result;
    }

    public ModelImportInfo[] getModelImportInfos() {
        Object[] result = new ModelImportInfo[this.modelImportInfos.size];
        this.modelImportInfos.copyInto(result);
        return result;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public String getProducerVersion() {
        return this.producerVersion;
    }

    public String getPrimaryMetamodelURI() {
        return this.primaryMetamodelURI;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelNamespaceUri() {
        return this.modelNamespaceUri;
    }

    public String getXmiVersion() {
        return this.xmiVersion;
    }

    public void addNamespaceURI(String uri) {
        if (!StringUtil.isEmpty(uri) && !this.namespaceURIs.contains(uri)) {
            this.namespaceURIs.add(uri);
        }
    }

    public void addModelImportInfo(ModelImportInfo modelImportInfo) {
        if (modelImportInfo != null && !this.modelImportInfos.contains(modelImportInfo)) {
            this.modelImportInfos.add(modelImportInfo);
        }
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public void setProducerVersion(String producerVersion) {
        this.producerVersion = producerVersion;
    }

    public void setPrimaryMetamodelURI(String uri) {
        this.primaryMetamodelURI = uri;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public void setModelNamespaceUri(String theNamespaceUri) {
        this.modelNamespaceUri = theNamespaceUri;
    }

    public void setXmiVersion(String xmiVersion) {
        this.xmiVersion = xmiVersion;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(String isVisible) {
        this.visible = true;
        if (isVisible.toUpperCase().startsWith("F")) {
            this.visible = false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("XMI Header:");
        sb.append("\n  XMI version:           ");
        sb.append(this.getXmiVersion());
        sb.append("\n  UUID:                  ");
        sb.append(this.getUUID());
        sb.append("\n  Producer:              ");
        sb.append(this.getProducerName());
        sb.append(" ");
        sb.append(this.getProducerVersion());
        sb.append("\n  Description:           ");
        sb.append(this.getDescription());
        sb.append("\n  Model type:            ");
        sb.append(this.getModelType());
        sb.append("\n  Model namespace URI:            ");
        sb.append(this.getModelNamespaceUri());
        sb.append("\n  isVisible:             ");
        sb.append(this.isVisible());
        sb.append("\n  Primary Metamodel URI: ");
        sb.append(this.getPrimaryMetamodelURI());
        sb.append("\n  Namespace URIs:");
        String[] uris = this.getNamespaceURIs();
        for (int i2 = 0; i2 < uris.length; ++i2) {
            sb.append("\n    ");
            sb.append(uris[i2]);
        }
        sb.append("\n  ModelImportInfos:");
        ModelImportInfo[] infos = this.getModelImportInfos();
        for (int i3 = 0; i3 < infos.length; ++i3) {
            sb.append("\n    ");
            sb.append(infos[i3]);
        }
        return sb.toString();
    }
}

