/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.dqp.application.ClientConnectionListener;
import com.metamatrix.dqp.config.DQPConfigSource;
import com.metamatrix.dqp.embedded.DQPListener;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.jdbc.ConnectionListener;
import com.metamatrix.jdbc.EmbeddedConnection;
import com.metamatrix.jdbc.EmbeddedConnectionFactory;
import com.metamatrix.jdbc.EmbeddedSQLException;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.transport.LocalTransportHandler;
import com.metamatrix.license.LicenseChecker;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class EmbeddedConnectionFactoryImpl
implements EmbeddedConnectionFactory {
    private static final String MAGIC_CONTEXT_PROPERTY = "EmbeddedContext";
    private static final int ACTIVE = 3;
    private boolean initialized = false;
    LocalTransportHandler handler = null;
    private boolean shutdownInProgress = false;
    ArrayList connectionListeners = new ArrayList();
    EmbeddedConnectionListener listener = new EmbeddedConnectionListener();
    static /* synthetic */ Class class$com$metamatrix$jdbc$EmbeddedConnectionFactoryImpl;

    static EmbeddedConnectionFactoryImpl newInstance() {
        if (AOP.useproxy()) {
            return (EmbeddedConnectionFactoryImpl)ProxyFactory.extend((Class)(class$com$metamatrix$jdbc$EmbeddedConnectionFactoryImpl == null ? (class$com$metamatrix$jdbc$EmbeddedConnectionFactoryImpl = EmbeddedConnectionFactoryImpl.class$("com.metamatrix.jdbc.EmbeddedConnectionFactoryImpl")) : class$com$metamatrix$jdbc$EmbeddedConnectionFactoryImpl));
        }
        return new EmbeddedConnectionFactoryImpl();
    }

    public Connection createConnection(Properties props) throws SQLException {
        this.initialize(props);
        if (!LicenseChecker.hasValidProductLicense("Integration API/JDBC", "5.0", this.listener.getNumConnections() + 1)) {
            throw new EmbeddedSQLException(JDBCPlugin.Util.getString("EmbeddedConnectionFactoryImpl.connection_limit", this.listener.getNumConnections()));
        }
        try {
            ServerConnection serverConn = this.handler.createConnection(props);
            boolean reconnect = props.get("vdbVersion").equals("useLatestVDBVersion");
            try {
                this.checkConnectionProperties(props);
            }
            catch (SQLException e2) {
                serverConn.shutdown();
                throw e2;
            }
            if (reconnect) {
                ServerConnection correctConn = this.handler.createConnection(props);
                serverConn.shutdown();
                serverConn = correctConn;
            }
            return EmbeddedConnection.newInstance(this.handler.getManager(), serverConn, props, this.listener);
        }
        catch (ConnectionException e3) {
            throw new EmbeddedSQLException((Throwable)e3);
        }
        catch (CommunicationException e4) {
            throw new EmbeddedSQLException((Throwable)e4);
        }
    }

    private void initialize(Properties props) throws SQLException {
        if (!this.initialized || !this.handler.isAlive()) {
            String magicVal;
            String string = magicVal = props == null ? null : props.getProperty(MAGIC_CONTEXT_PROPERTY);
            if (!(LicenseChecker.hasValidProductLicense("MetaMatrix Query", "5.0") || LicenseChecker.hasValidProductLicense("Query Engine", "5.0") && magicVal != null && (magicVal.equals("Designer") || magicVal.equals("WebServicesWAR")))) {
                throw new EmbeddedSQLException(JDBCPlugin.Util.getString("EmbeddedConnectionFactoryImpl.no_product_license"));
            }
            DQPListener dqpListener = new DQPListener(){

                public void onStart() {
                }

                public void onShutdown() {
                    try {
                        EmbeddedConnectionFactoryImpl.this.shutdown();
                    }
                    catch (SQLException e2) {
                        DriverManager.println(e2.getMessage());
                    }
                }
            };
            ClientConnectionListener connectionListener = new ClientConnectionListener(){

                public void connectionAdded(ClientConnection connection) {
                }

                public void connectionRemoved(ClientConnection connection) {
                }

                public void connectionTerminated(ClientConnection connection) {
                    String id = (String)connection.getConnectionProperty("connectionID");
                    EmbeddedConnectionFactoryImpl.this.listener.connectionTerminated(id);
                }
            };
            this.handler = new LocalTransportHandler(dqpListener, connectionListener);
            this.initialized = true;
        }
    }

    public void registerConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void shutdown() throws SQLException {
        if (!this.shutdownInProgress) {
            this.shutdownInProgress = true;
            this.listener.closeConnections();
            this.handler.shutdown();
        }
    }

    private void checkConnectionProperties(Properties props) throws SQLException {
        String vdbName = props.getProperty("VirtualDatabaseName");
        String vdbVersion = props.getProperty("version", "useLatestVDBVersion");
        try {
            int status;
            DQPConfigSource configuration = this.handler.getManager().getDQPConfig();
            VDBService service = (VDBService)configuration.getService("dqp.vdb");
            List vdbs = service.getAvailableVDBs();
            if (vdbVersion.equals("useLatestVDBVersion")) {
                vdbVersion = this.findLatestVersion(vdbName, vdbs);
                props.setProperty("version", vdbVersion);
                props.setProperty("VirtualDatabaseVersion", vdbVersion);
            }
            if ((status = service.getVDBStatus(vdbName, vdbVersion)) != 3) {
                throw new EmbeddedSQLException(JDBCPlugin.Util.getString("EmbeddedConnectionFactory.vdb_notactive", new Object[]{vdbName, vdbVersion}));
            }
        }
        catch (MetaMatrixComponentException e2) {
            throw new EmbeddedSQLException((Throwable)e2, JDBCPlugin.Util.getString("EmbeddedConnectionFactory.vdb_notavailable", new Object[]{vdbName, vdbVersion}));
        }
        catch (ApplicationInitializationException e3) {
            throw new EmbeddedSQLException((Throwable)e3, JDBCPlugin.Util.getString("EmbeddedConnectionFactory.vdb_notavailable", new Object[]{vdbName, vdbVersion}));
        }
    }

    String findLatestVersion(String vdbName, List vdbs) throws EmbeddedSQLException {
        VDBDefn vdb = null;
        int latestVersion = 0;
        Iterator i2 = vdbs.iterator();
        while (i2.hasNext()) {
            vdb = (VDBDefn)i2.next();
            if (!vdb.getName().equalsIgnoreCase(vdbName)) continue;
            latestVersion = Math.max(latestVersion, Integer.parseInt(vdb.getVersion()));
        }
        if (latestVersion != 0) {
            return String.valueOf(latestVersion);
        }
        throw new EmbeddedSQLException(JDBCPlugin.Util.getString("EmbeddedConnectionFactory.vdb_notavailable", new Object[]{vdbName, "useLatestVDBVersion"}));
    }

    void notifyConnectionAdded(String id, Connection connection) {
        Iterator i2 = this.connectionListeners.iterator();
        while (i2.hasNext()) {
            ConnectionListener listner = (ConnectionListener)i2.next();
            listner.connectionAdded(id, connection);
        }
    }

    void notifyConnectionRemoved(String id, Connection connection) {
        Iterator i2 = this.connectionListeners.iterator();
        while (i2.hasNext()) {
            ConnectionListener listner = (ConnectionListener)i2.next();
            listner.connectionRemoved(id, connection);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EmbeddedConnectionListener
    implements ConnectionListener {
        HashMap connections = new HashMap();

        private EmbeddedConnectionListener() {
        }

        public void connectionAdded(String id, Connection connection) {
            this.connections.put(id, connection);
            EmbeddedConnectionFactoryImpl.this.notifyConnectionAdded(id, connection);
        }

        public void connectionRemoved(String id, Connection connection) {
            this.connections.remove(id);
            EmbeddedConnectionFactoryImpl.this.notifyConnectionRemoved(id, connection);
        }

        private void closeConnections() throws SQLException {
            Exception firstException = null;
            while (this.connections.size() != 0) {
                try {
                    Iterator i2 = this.connections.keySet().iterator();
                    if (!i2.hasNext()) continue;
                    Connection connection = (Connection)this.connections.get(i2.next());
                    connection.close();
                }
                catch (Exception ex) {
                    if (firstException != null) continue;
                    firstException = ex;
                }
            }
            if (firstException != null) {
                throw new EmbeddedSQLException(firstException);
            }
        }

        private void connectionTerminated(String id) {
            Connection connection = (Connection)this.connections.remove(id);
            EmbeddedConnectionFactoryImpl.this.notifyConnectionRemoved(id, connection);
        }

        private int getNumConnections() {
            return this.connections.size();
        }
    }
}

