/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.core;

import com.metamatrix.metamodels.core.CoreMetamodelPlugin;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class ModelType
extends AbstractEnumerator {
    public static final String copyright = "Copyright (c) 2000-2005 MetaMatrix Corporation.  All rights reserved.";
    public static final int PHYSICAL = 0;
    public static final int VIRTUAL = 1;
    public static final int TYPE = 2;
    public static final int VDB_ARCHIVE = 3;
    public static final int UNKNOWN = 4;
    public static final int FUNCTION = 5;
    public static final int CONFIGURATION = 6;
    public static final int METAMODEL = 7;
    public static final int EXTENSION = 8;
    public static final int LOGICAL = 9;
    public static final int MATERIALIZATION = 10;
    public static final ModelType PHYSICAL_LITERAL = new ModelType(0, "PHYSICAL");
    public static final ModelType VIRTUAL_LITERAL = new ModelType(1, "VIRTUAL");
    public static final ModelType TYPE_LITERAL = new ModelType(2, "TYPE");
    public static final ModelType VDB_ARCHIVE_LITERAL = new ModelType(3, "VDB_ARCHIVE");
    public static final ModelType UNKNOWN_LITERAL = new ModelType(4, "UNKNOWN");
    public static final ModelType FUNCTION_LITERAL = new ModelType(5, "FUNCTION");
    public static final ModelType CONFIGURATION_LITERAL = new ModelType(6, "CONFIGURATION");
    public static final ModelType METAMODEL_LITERAL = new ModelType(7, "METAMODEL");
    public static final ModelType EXTENSION_LITERAL = new ModelType(8, "EXTENSION");
    public static final ModelType LOGICAL_LITERAL = new ModelType(9, "LOGICAL");
    public static final ModelType MATERIALIZATION_LITERAL = new ModelType(10, "MATERIALIZATION");
    private static final ModelType[] VALUES_ARRAY = new ModelType[]{PHYSICAL_LITERAL, VIRTUAL_LITERAL, TYPE_LITERAL, VDB_ARCHIVE_LITERAL, UNKNOWN_LITERAL, FUNCTION_LITERAL, CONFIGURATION_LITERAL, METAMODEL_LITERAL, EXTENSION_LITERAL, LOGICAL_LITERAL, MATERIALIZATION_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static ModelType get(String name) {
        for (int i2 = 0; i2 < VALUES_ARRAY.length; ++i2) {
            ModelType result = VALUES_ARRAY[i2];
            if (!result.toString().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ModelType get(int value) {
        switch (value) {
            case 0: {
                return PHYSICAL_LITERAL;
            }
            case 1: {
                return VIRTUAL_LITERAL;
            }
            case 2: {
                return TYPE_LITERAL;
            }
            case 3: {
                return VDB_ARCHIVE_LITERAL;
            }
            case 4: {
                return UNKNOWN_LITERAL;
            }
            case 5: {
                return FUNCTION_LITERAL;
            }
            case 6: {
                return CONFIGURATION_LITERAL;
            }
            case 7: {
                return METAMODEL_LITERAL;
            }
            case 8: {
                return EXTENSION_LITERAL;
            }
            case 9: {
                return LOGICAL_LITERAL;
            }
            case 10: {
                return MATERIALIZATION_LITERAL;
            }
        }
        return null;
    }

    private ModelType(int value, String name) {
        super(value, name);
    }

    public final String getDisplayName() {
        String label = CoreMetamodelPlugin.getPluginResourceLocator().getString("_UI_ModelType_" + this.getName());
        return label == null || label.length() == 0 ? this.getName() : label;
    }
}

