/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.relational.aspects.validation.rules;

import com.metamatrix.metamodels.relational.AccessPattern;
import com.metamatrix.metamodels.relational.Catalog;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.ForeignKey;
import com.metamatrix.metamodels.relational.Index;
import com.metamatrix.metamodels.relational.LogicalRelationship;
import com.metamatrix.metamodels.relational.Procedure;
import com.metamatrix.metamodels.relational.ProcedureParameter;
import com.metamatrix.metamodels.relational.Schema;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.relational.UniqueKey;
import com.metamatrix.metamodels.relational.util.RelationalUtil;
import com.metamatrix.modeler.core.validation.rules.StringNameRule;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;

public class RelationalStringNameRule
extends StringNameRule {
    public RelationalStringNameRule(char[] invalidChars, int featureID) {
        super(invalidChars, featureID);
    }

    public RelationalStringNameRule(int featureID) {
        super(featureID);
    }

    public List getSiblingsForUniquenessCheck(EObject eObject) {
        Notifier parent = eObject.eContainer();
        if (parent == null) {
            parent = eObject.eResource();
        }
        if (eObject instanceof Table) {
            return RelationalUtil.findTables(parent, 1);
        }
        if (eObject instanceof Procedure) {
            return RelationalUtil.findProcedures(parent, 1);
        }
        if (eObject instanceof ProcedureParameter) {
            return RelationalUtil.findProcedureParameters(parent, 1);
        }
        if (eObject instanceof Index) {
            return RelationalUtil.findIndexes(parent, 1);
        }
        if (eObject instanceof ForeignKey || eObject instanceof UniqueKey) {
            return RelationalUtil.findKeys(parent, 1);
        }
        if (eObject instanceof Column) {
            return RelationalUtil.findColumns(parent, 1);
        }
        if (eObject instanceof AccessPattern) {
            if (parent instanceof Table) {
                return ((Table)parent).getAccessPatterns();
            }
            return new LinkedList();
        }
        if (eObject instanceof LogicalRelationship) {
            return RelationalUtil.findLogicalRelationships(parent, 1);
        }
        if (eObject instanceof Schema) {
            return RelationalUtil.findSchemas(parent, 1);
        }
        if (eObject instanceof Catalog) {
            return RelationalUtil.findCatalogs(parent, 1);
        }
        return super.getSiblingsForUniquenessCheck(eObject);
    }
}

