/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.wsdl.io;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.internal.core.xml.JdomHelper;
import com.metamatrix.metamodels.wsdl.Attribute;
import com.metamatrix.metamodels.wsdl.Binding;
import com.metamatrix.metamodels.wsdl.BindingFault;
import com.metamatrix.metamodels.wsdl.BindingInput;
import com.metamatrix.metamodels.wsdl.BindingOperation;
import com.metamatrix.metamodels.wsdl.BindingOutput;
import com.metamatrix.metamodels.wsdl.BindingParam;
import com.metamatrix.metamodels.wsdl.Definitions;
import com.metamatrix.metamodels.wsdl.Documentation;
import com.metamatrix.metamodels.wsdl.Documented;
import com.metamatrix.metamodels.wsdl.Element;
import com.metamatrix.metamodels.wsdl.ExtensibleAttributesDocumented;
import com.metamatrix.metamodels.wsdl.ExtensibleDocumented;
import com.metamatrix.metamodels.wsdl.Fault;
import com.metamatrix.metamodels.wsdl.Import;
import com.metamatrix.metamodels.wsdl.Input;
import com.metamatrix.metamodels.wsdl.Message;
import com.metamatrix.metamodels.wsdl.MessagePart;
import com.metamatrix.metamodels.wsdl.NamespaceDeclaration;
import com.metamatrix.metamodels.wsdl.NamespaceDeclarationOwner;
import com.metamatrix.metamodels.wsdl.Operation;
import com.metamatrix.metamodels.wsdl.Output;
import com.metamatrix.metamodels.wsdl.Port;
import com.metamatrix.metamodels.wsdl.PortType;
import com.metamatrix.metamodels.wsdl.Service;
import com.metamatrix.metamodels.wsdl.Types;
import com.metamatrix.metamodels.wsdl.WsdlFactory;
import com.metamatrix.metamodels.wsdl.WsdlMetamodelPlugin;
import com.metamatrix.metamodels.wsdl.http.HttpAddress;
import com.metamatrix.metamodels.wsdl.http.HttpBinding;
import com.metamatrix.metamodels.wsdl.http.HttpFactory;
import com.metamatrix.metamodels.wsdl.http.HttpOperation;
import com.metamatrix.metamodels.wsdl.io.WsdlConstants;
import com.metamatrix.metamodels.wsdl.io.WsdlDiagnostic;
import com.metamatrix.metamodels.wsdl.soap.SoapAddress;
import com.metamatrix.metamodels.wsdl.soap.SoapBinding;
import com.metamatrix.metamodels.wsdl.soap.SoapBody;
import com.metamatrix.metamodels.wsdl.soap.SoapFactory;
import com.metamatrix.metamodels.wsdl.soap.SoapFault;
import com.metamatrix.metamodels.wsdl.soap.SoapHeader;
import com.metamatrix.metamodels.wsdl.soap.SoapHeaderFault;
import com.metamatrix.metamodels.wsdl.soap.SoapOperation;
import com.metamatrix.metamodels.wsdl.soap.SoapStyleType;
import com.metamatrix.metamodels.wsdl.soap.SoapUseType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.adapters.XercesDOMAdapter;
import org.jdom.input.DOMBuilder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WsdlLoader
implements XMLLoad,
WsdlConstants {
    private WsdlFactory wsdlFactory = WsdlFactory.eINSTANCE;
    private SoapFactory soapFactory = SoapFactory.eINSTANCE;
    private HttpFactory httpFactory = HttpFactory.eINSTANCE;
    private boolean loadXsdObjects;

    protected void init(XMLResource resource, Map options) {
        this.loadXsdObjects = true;
    }

    public void load(XMLResource resource, InputStream inputStream, Map loadOptions) throws IOException {
        ArgCheck.isNotNull(resource);
        ArgCheck.isNotNull(inputStream);
        this.init(resource, loadOptions);
        Document doc = null;
        org.w3c.dom.Document domDoc = null;
        if (this.loadXsdObjects) {
            domDoc = this.doOpenDom(inputStream);
            doc = this.doBuildFromDom(domDoc);
        } else {
            doc = this.doOpen(inputStream);
        }
        org.jdom.Element root = doc.getRootElement();
        Definitions definitions = this.doLoad(root, resource);
        if (definitions != null && this.loadXsdObjects) {
            this.doLoadXsds(domDoc, definitions);
        }
    }

    public void load(XMLResource resource, Node node, Map options) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Document doOpen(InputStream inputStream) throws IOException {
        Document doc = null;
        try {
            doc = JdomHelper.buildDocument(inputStream);
        }
        catch (JDOMException err) {
            throw new Resource.IOWrappedException(err);
        }
        return doc;
    }

    protected org.w3c.dom.Document doOpenDom(InputStream inputStream) throws IOException {
        org.w3c.dom.Document doc = null;
        try {
            XercesDOMAdapter adapter = new XercesDOMAdapter();
            doc = adapter.getDocument(inputStream, false);
        }
        catch (IOException err) {
            throw err;
        }
        catch (Exception err) {
            throw new Resource.IOWrappedException(err);
        }
        return doc;
    }

    protected Document doBuildFromDom(org.w3c.dom.Document domDocument) throws IOException {
        DOMBuilder builder = new DOMBuilder();
        Document doc = builder.build(domDocument);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List doLoadXsds(org.w3c.dom.Document domDoc, Definitions defns) {
        Types types = defns.getTypes();
        if (types == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<org.w3c.dom.Element> schemaElements = new ArrayList<org.w3c.dom.Element>();
        org.w3c.dom.Element docElement = domDoc.getDocumentElement();
        NodeList typesList = docElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "types");
        if (typesList != null && typesList.getLength() != 0) {
            org.w3c.dom.Element typesElement = (org.w3c.dom.Element)typesList.item(0);
            String[] schemaNS = new String[]{"http://www.w3.org/2001/XMLSchema", "http://www.w3.org/2000/10/XMLSchema", "http://www.w3.org/1999/XMLSchema"};
            for (int i2 = 0; i2 != schemaNS.length; ++i2) {
                NodeList typesChildren = typesElement.getElementsByTagNameNS(schemaNS[i2], "schema");
                if (typesChildren == null) continue;
                for (int j2 = 0; j2 != typesChildren.getLength(); ++j2) {
                    org.w3c.dom.Element schemaElement = (org.w3c.dom.Element)typesChildren.item(j2);
                    if (schemaElement == null) continue;
                    schemaElements.add(schemaElement);
                }
            }
        }
        ArrayList<XSDSchema> xsdSchemas = new ArrayList<XSDSchema>();
        if (domDoc != null && schemaElements.size() != 0) {
            Iterator iter = schemaElements.iterator();
            while (iter.hasNext()) {
                org.w3c.dom.Element schemaElement = (org.w3c.dom.Element)iter.next();
                String key = XSDResourceImpl.XSD_PROGRESS_MONITOR;
                ResourceSet globalResourceSet = XSDSchemaImpl.getGlobalResourceSet();
                Object oldMonitor = globalResourceSet.getLoadOptions().get(key);
                XSDSchema xsdSchema = null;
                try {
                    XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put(key, null);
                    xsdSchema = XSDSchemaImpl.createSchema(schemaElement);
                }
                finally {
                    XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put(key, oldMonitor);
                }
                if (xsdSchema == null) continue;
                types.getSchemas().add(xsdSchema);
                xsdSchemas.add(xsdSchema);
            }
        }
        return xsdSchemas;
    }

    protected Definitions doLoad(org.jdom.Element root, XMLResource resource) {
        String rootName = root.getName();
        String rootNsUri = root.getNamespaceURI();
        if (!"definitions".equals(rootName) || !"http://schemas.xmlsoap.org/wsdl/".equals(rootNsUri)) {
            Object[] params = new Object[]{"wsdl", "definitions"};
            String msg = WsdlMetamodelPlugin.Util.getString("WsdlLoader.RootXmlElementWasNotWsdlDefinitions", params);
            this.addError(resource, msg);
            return null;
        }
        Definitions defns = this.wsdlFactory.createDefinitions();
        this.doProcess(defns, root);
        resource.getContents().add(defns);
        return defns;
    }

    protected void doProcess(Definitions defns, org.jdom.Element element) {
        String name = element.getAttributeValue("name");
        defns.setName(name);
        String tns = element.getAttributeValue("targetNamespace");
        defns.setTargetNamespace(tns);
        List children = element.getChildren();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            org.jdom.Element child = (org.jdom.Element)iter.next();
            String nsUri = child.getNamespaceURI();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(nsUri)) {
                String childName = child.getName();
                if ("message".equals(childName)) {
                    Message message = this.wsdlFactory.createMessage();
                    this.doProcess(message, child);
                    defns.getMessages().add(message);
                    continue;
                }
                if ("portType".equals(childName)) {
                    PortType portType = this.wsdlFactory.createPortType();
                    this.doProcess(portType, child);
                    defns.getPortTypes().add(portType);
                    continue;
                }
                if ("binding".equals(childName)) {
                    Binding binding = this.wsdlFactory.createBinding();
                    this.doProcess(binding, child);
                    defns.getBindings().add(binding);
                    continue;
                }
                if ("service".equals(childName)) {
                    Service service = this.wsdlFactory.createService();
                    this.doProcess(service, child);
                    defns.getServices().add(service);
                    continue;
                }
                if ("types".equals(childName)) {
                    Types types = this.wsdlFactory.createTypes();
                    this.doProcess(types, child);
                    defns.setTypes(types);
                    continue;
                }
                if (!"import".equals(childName)) continue;
                Import importObj = this.wsdlFactory.createImport();
                this.doProcess(importObj, child);
                defns.getImports().add(importObj);
                continue;
            }
            Element elementObj = this.wsdlFactory.createElement();
            this.doProcess(elementObj, child);
            defns.getElements().add(elementObj);
        }
        this.doProcessNamespaceDeclarationOwner(defns, element);
        this.doProcessDocumented(defns, element);
        this.doProcessAdditionalElements(defns, element);
    }

    protected void doProcess(Message message, org.jdom.Element element) {
        String name = element.getAttributeValue("name");
        message.setName(name);
        List children = element.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            org.jdom.Element child = (org.jdom.Element)childIter.next();
            String childName = child.getName();
            if (!"part".equals(childName)) continue;
            MessagePart part = this.wsdlFactory.createMessagePart();
            this.doProcess(part, child);
            message.getParts().add(part);
        }
        this.doProcessDocumented(message, element);
        this.doProcessAdditionalElements(message, element);
    }

    protected void doProcess(PortType portType, org.jdom.Element element) {
        String name = element.getAttributeValue("name");
        portType.setName(name);
        List children = element.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            org.jdom.Element child = (org.jdom.Element)childIter.next();
            String childName = child.getName();
            if (!"operation".equals(childName)) continue;
            Operation operation = this.wsdlFactory.createOperation();
            this.doProcess(operation, child);
            portType.getOperations().add(operation);
        }
        this.doProcessDocumented(portType, element);
        this.doProcessAdditionalAttributes(portType, element);
    }

    protected void doProcess(Binding binding, org.jdom.Element element) {
        String name = element.getAttributeValue("name");
        binding.setName(name);
        String type = element.getAttributeValue("type");
        binding.setType(type);
        List children = element.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            String childName;
            org.jdom.Element child = (org.jdom.Element)childIter.next();
            String nsUri = child.getNamespaceURI();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(nsUri)) {
                childName = child.getName();
                if (!"operation".equals(childName)) continue;
                BindingOperation operation = this.wsdlFactory.createBindingOperation();
                this.doProcess(operation, child);
                binding.getBindingOperations().add(operation);
                continue;
            }
            if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(nsUri)) {
                childName = child.getName();
                if (!"binding".equals(childName)) continue;
                SoapBinding soapBinding = this.soapFactory.createSoapBinding();
                this.doProcess(soapBinding, child);
                binding.setSoapBinding(soapBinding);
                continue;
            }
            if ("http://schemas.xmlsoap.org/wsdl/http/".equals(nsUri)) {
                childName = child.getName();
                if (!"binding".equals(childName)) continue;
                HttpBinding httpBinding = this.httpFactory.createHttpBinding();
                this.doProcess(httpBinding, child);
                binding.setHttpBinding(httpBinding);
                continue;
            }
            Element elementObj = this.wsdlFactory.createElement();
            this.doProcess(elementObj, child);
            binding.getElements().add(elementObj);
        }
        this.doProcessNamespaceDeclarationOwner(binding, element);
        this.doProcessDocumented(binding, element);
        this.doProcessAdditionalElements(binding, element);
    }

    protected void doProcess(Service service, org.jdom.Element element) {
        String name = element.getAttributeValue("name");
        service.setName(name);
        List children = element.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            org.jdom.Element child = (org.jdom.Element)childIter.next();
            String nsUri = child.getNamespaceURI();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(nsUri)) {
                String childName = child.getName();
                if (!"port".equals(childName)) continue;
                Port port = this.wsdlFactory.createPort();
                this.doProcess(port, child);
                service.getPorts().add(port);
                continue;
            }
            Element elementObj = this.wsdlFactory.createElement();
            this.doProcess(elementObj, child);
            service.getElements().add(elementObj);
        }
        this.doProcessNamespaceDeclarationOwner(service, element);
        this.doProcessDocumented(service, element);
        this.doProcessAdditionalElements(service, element);
    }

    protected void doProcess(Types types, org.jdom.Element element) {
        List children = element.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            org.jdom.Element child = (org.jdom.Element)childIter.next();
            String childName = child.getName();
            String childNsUri = child.getNamespaceURI();
            if ("schema".equals(childName) && ("http://www.w3.org/2001/XMLSchema".equals(childNsUri) || "http://www.w3.org/2000/10/XMLSchema".equals(childNsUri) || "http://www.w3.org/1999/XMLSchema".equals(childNsUri))) continue;
            Element elementObj = this.wsdlFactory.createElement();
            this.doProcess(elementObj, child);
            types.getElements().add(elementObj);
        }
        this.doProcessNamespaceDeclarationOwner(types, element);
        this.doProcessDocumented(types, element);
        this.doProcessAdditionalElements(types, element);
    }

    protected void doProcess(Import wsdlImport, org.jdom.Element element) {
        String namespace = element.getAttributeValue("namespace");
        String location = element.getAttributeValue("location");
        wsdlImport.setNamespace(namespace);
        wsdlImport.setLocation(location);
        this.doProcessDocumented(wsdlImport, element);
        this.doProcessAdditionalAttributes(wsdlImport, element);
    }

    protected void doProcess(MessagePart part, org.jdom.Element element) {
        String name = element.getAttributeValue("name");
        part.setName(name);
        String type = element.getAttributeValue("type");
        part.setType(type);
        String partElement = element.getAttributeValue("element");
        part.setElement(partElement);
        this.doProcessNamespaceDeclarationOwner(part, element);
        this.doProcessDocumented(part, element);
        this.doProcessAdditionalAttributes(part, element);
    }

    protected void doProcess(Operation operation, org.jdom.Element element) {
        String name = element.getAttributeValue("name");
        operation.setName(name);
        String paramOrder = element.getAttributeValue("parameterOrder");
        operation.setParameterOrder(paramOrder);
        List children = element.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            org.jdom.Element child = (org.jdom.Element)childIter.next();
            String nsUri = child.getNamespaceURI();
            if (!"http://schemas.xmlsoap.org/wsdl/".equals(nsUri)) continue;
            String childName = child.getName();
            if ("input".equals(childName)) {
                Input input = this.wsdlFactory.createInput();
                this.doProcess(input, child);
                operation.setInput(input);
                continue;
            }
            if ("output".equals(childName)) {
                Output output = this.wsdlFactory.createOutput();
                this.doProcess(output, child);
                operation.setOutput(output);
                continue;
            }
            if (!"fault".equals(childName)) continue;
            Fault fault = this.wsdlFactory.createFault();
            this.doProcess(fault, child);
            operation.getFaults().add(fault);
        }
        this.doProcessDocumented(operation, element);
        this.doProcessAdditionalElements(operation, element);
    }

    protected void doProcess(BindingOperation operation, org.jdom.Element element) {
        String name = element.getAttributeValue("name");
        operation.setName(name);
        List children = element.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            String childName;
            org.jdom.Element child = (org.jdom.Element)childIter.next();
            String nsUri = child.getNamespaceURI();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(nsUri)) {
                childName = child.getName();
                if ("input".equals(childName)) {
                    BindingInput input = this.wsdlFactory.createBindingInput();
                    this.doProcess(input, child);
                    operation.setBindingInput(input);
                    continue;
                }
                if ("output".equals(childName)) {
                    BindingOutput output = this.wsdlFactory.createBindingOutput();
                    this.doProcess(output, child);
                    operation.setBindingOutput(output);
                    continue;
                }
                if (!"fault".equals(childName)) continue;
                BindingFault fault = this.wsdlFactory.createBindingFault();
                this.doProcess(fault, child);
                operation.getBindingFaults().add(fault);
                continue;
            }
            if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(nsUri)) {
                childName = child.getName();
                if (!"operation".equals(childName)) continue;
                SoapOperation soapOp = this.soapFactory.createSoapOperation();
                this.doProcess(soapOp, child);
                operation.setSoapOperation(soapOp);
                continue;
            }
            if (!"http://schemas.xmlsoap.org/wsdl/http/".equals(nsUri) || !"operation".equals(childName = child.getName())) continue;
            HttpOperation httpOp = this.httpFactory.createHttpOperation();
            this.doProcess(httpOp, child);
            operation.setHttpOperation(httpOp);
        }
        this.doProcessNamespaceDeclarationOwner(operation, element);
        this.doProcessDocumented(operation, element);
        this.doProcessAdditionalElements(operation, element);
    }

    protected void doProcess(Port port, org.jdom.Element element) {
        String name = element.getAttributeValue("name");
        port.setName(name);
        String binding = element.getAttributeValue("binding");
        port.setBinding(binding);
        List children = element.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            EObject address;
            String childName;
            org.jdom.Element child = (org.jdom.Element)childIter.next();
            String nsUri = child.getNamespaceURI();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(nsUri)) continue;
            if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(nsUri)) {
                childName = child.getName();
                if (!"address".equals(childName)) continue;
                address = this.soapFactory.createSoapAddress();
                this.doProcess((SoapAddress)address, child);
                port.setSoapAddress((SoapAddress)address);
                continue;
            }
            if ("http://schemas.xmlsoap.org/wsdl/http/".equals(nsUri)) {
                childName = child.getName();
                if (!"address".equals(childName)) continue;
                address = this.httpFactory.createHttpAddress();
                this.doProcess((HttpAddress)address, child);
                port.setHttpAddress((HttpAddress)address);
                continue;
            }
            Element elementObj = this.wsdlFactory.createElement();
            this.doProcess(elementObj, child);
            port.getElements().add(elementObj);
        }
        this.doProcessNamespaceDeclarationOwner(port, element);
        this.doProcessDocumented(port, element);
        this.doProcessAdditionalElements(port, element);
    }

    protected void doProcess(Input input, org.jdom.Element element) {
        String name = element.getAttributeValue("name");
        input.setName(name);
        String message = element.getAttributeValue("message");
        input.setMessage(message);
        this.doProcessDocumented(input, element);
    }

    protected void doProcess(Output output, org.jdom.Element element) {
        String name = element.getAttributeValue("name");
        output.setName(name);
        String message = element.getAttributeValue("message");
        output.setMessage(message);
        this.doProcessDocumented(output, element);
        this.doProcessAdditionalAttributes(output, element);
    }

    protected void doProcess(Fault fault, org.jdom.Element element) {
        String name = element.getAttributeValue("name");
        fault.setName(name);
        String message = element.getAttributeValue("message");
        fault.setMessage(message);
        this.doProcessDocumented(fault, element);
        this.doProcessAdditionalAttributes(fault, element);
    }

    protected void doProcess(BindingParam inputOrOutput, org.jdom.Element element) {
        List children = element.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            org.jdom.Element child = (org.jdom.Element)childIter.next();
            String nsUri = child.getNamespaceURI();
            if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(nsUri)) {
                String childName = child.getName();
                if ("body".equals(childName)) {
                    SoapBody soapBody = this.soapFactory.createSoapBody();
                    this.doProcess(soapBody, child);
                    inputOrOutput.setSoapBody(soapBody);
                    continue;
                }
                if (!"body".equals(childName)) continue;
                SoapHeader soapHeader = this.soapFactory.createSoapHeader();
                this.doProcess(soapHeader, child);
                inputOrOutput.setSoapHeader(soapHeader);
                continue;
            }
            if ("http://schemas.xmlsoap.org/wsdl/".equals(nsUri) || "http://schemas.xmlsoap.org/wsdl/http/".equals(nsUri) || "http://schemas.xmlsoap.org/wsdl/mime/".equals(nsUri)) continue;
            Element elementObj = this.wsdlFactory.createElement();
            this.doProcess(elementObj, child);
            inputOrOutput.getElements().add(elementObj);
        }
        this.doProcessNamespaceDeclarationOwner(inputOrOutput, element);
        this.doProcessDocumented(inputOrOutput, element);
        this.doProcessAdditionalElements(inputOrOutput, element);
    }

    protected void doProcess(BindingFault fault, org.jdom.Element element) {
        String name = element.getAttributeValue("name");
        fault.setName(name);
        List children = element.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            org.jdom.Element child = (org.jdom.Element)childIter.next();
            String nsUri = child.getNamespaceURI();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(nsUri)) continue;
            if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(nsUri)) {
                String childName = child.getName();
                if (!"fault".equals(childName)) continue;
                SoapFault soapFault = this.soapFactory.createSoapFault();
                this.doProcess(soapFault, child);
                fault.setSoapFault(soapFault);
                continue;
            }
            if ("http://schemas.xmlsoap.org/wsdl/http/".equals(nsUri) || "http://schemas.xmlsoap.org/wsdl/mime/".equals(nsUri)) continue;
            Element elementObj = this.wsdlFactory.createElement();
            this.doProcess(elementObj, child);
            fault.getElements().add(elementObj);
        }
        this.doProcessNamespaceDeclarationOwner(fault, element);
        this.doProcessDocumented(fault, element);
        this.doProcessAdditionalElements(fault, element);
    }

    protected void doProcess(Element wsdlElement, org.jdom.Element element) {
        String name = element.getName();
        String prefix = element.getNamespacePrefix();
        String textContext = element.getTextTrim();
        String nsUri = element.getNamespaceURI();
        wsdlElement.setName(name);
        wsdlElement.setPrefix(prefix);
        wsdlElement.setNamespaceUri(nsUri);
        wsdlElement.setTextContent(textContext);
        List attribs = element.getAttributes();
        Iterator iter = attribs.iterator();
        while (iter.hasNext()) {
            org.jdom.Attribute attribute = (org.jdom.Attribute)iter.next();
            Attribute wsdlAttribute = this.wsdlFactory.createAttribute();
            this.doProcess(wsdlAttribute, attribute);
            wsdlElement.getAttributes().add(wsdlAttribute);
        }
        List children = element.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            org.jdom.Element child = (org.jdom.Element)childIter.next();
            Element wsdlChild = this.wsdlFactory.createElement();
            this.doProcess(wsdlChild, child);
            wsdlElement.getElements().add(wsdlChild);
        }
        this.doProcessNamespaceDeclarationOwner(wsdlElement, element);
    }

    protected void doProcess(Attribute wsdlAttribute, org.jdom.Attribute attribute) {
        String name = attribute.getName();
        String prefix = attribute.getNamespacePrefix();
        String textContext = attribute.getValue();
        String nsUri = attribute.getNamespaceURI();
        wsdlAttribute.setName(name);
        wsdlAttribute.setPrefix(prefix);
        wsdlAttribute.setNamespaceUri(nsUri);
        wsdlAttribute.setValue(textContext);
    }

    protected void doProcessNamespaceDeclarationOwner(NamespaceDeclarationOwner owner, org.jdom.Element element) {
        List namespaces = element.getAdditionalNamespaces();
        Iterator iter = namespaces.iterator();
        while (iter.hasNext()) {
            Namespace namespace = (Namespace)iter.next();
            String prefix = namespace.getPrefix();
            String uri = namespace.getURI();
            NamespaceDeclaration decl = this.wsdlFactory.createNamespaceDeclaration();
            decl.setPrefix(prefix);
            decl.setUri(uri);
            decl.setOwner(owner);
        }
    }

    protected void doProcessDocumented(Documented documented, org.jdom.Element documentedElement) {
        org.jdom.Element doc = documentedElement.getChild("documentation");
        if (doc != null) {
            Documentation wsdlDoc = this.wsdlFactory.createDocumentation();
            String text = doc.getTextTrim();
            wsdlDoc.setTextContent(text);
            List children = doc.getChildren();
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                org.jdom.Element child = (org.jdom.Element)childIter.next();
                Element wsdlChild = this.wsdlFactory.createElement();
                this.doProcess(wsdlChild, child);
                wsdlDoc.getElements().add(wsdlChild);
            }
        }
    }

    protected void doProcessAdditionalAttributes(ExtensibleAttributesDocumented openAtts, org.jdom.Element element) {
        List attribs = element.getAttributes();
        Iterator iter = attribs.iterator();
        while (iter.hasNext()) {
            org.jdom.Attribute attribute = (org.jdom.Attribute)iter.next();
            String nsUri = attribute.getNamespaceURI();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(nsUri) || "http://schemas.xmlsoap.org/wsdl/soap/".equals(nsUri) || "http://schemas.xmlsoap.org/wsdl/http/".equals(nsUri) || "http://schemas.xmlsoap.org/wsdl/mime/".equals(nsUri)) continue;
            Attribute wsdlAttribute = this.wsdlFactory.createAttribute();
            this.doProcess(wsdlAttribute, attribute);
            openAtts.getAttributes().add(wsdlAttribute);
        }
    }

    protected void doProcessAdditionalElements(ExtensibleDocumented extensibleDocumented, org.jdom.Element element) {
        List elements = element.getChildren();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            org.jdom.Element child = (org.jdom.Element)iter.next();
            String nsUri = child.getNamespaceURI();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(nsUri) || "http://schemas.xmlsoap.org/wsdl/soap/".equals(nsUri) || "http://schemas.xmlsoap.org/wsdl/http/".equals(nsUri) || "http://schemas.xmlsoap.org/wsdl/mime/".equals(nsUri) || "schema".equals(child.getName()) && ("http://www.w3.org/2001/XMLSchema".equals(nsUri) || "http://www.w3.org/2000/10/XMLSchema".equals(nsUri) || "http://www.w3.org/1999/XMLSchema".equals(nsUri))) continue;
            Element wsdlChild = this.wsdlFactory.createElement();
            this.doProcess(wsdlChild, child);
            extensibleDocumented.getElements().add(wsdlChild);
        }
    }

    protected void doProcess(SoapBinding binding, org.jdom.Element element) {
        String transport = element.getAttributeValue("transport");
        binding.setTransport(transport);
        String style = element.getAttributeValue("style");
        if ("rpc".equals(style)) {
            binding.setStyle(SoapStyleType.RPC_LITERAL);
        } else if ("document".equals(style)) {
            binding.setStyle(SoapStyleType.DOCUMENT_LITERAL);
        }
    }

    protected void doProcess(SoapBody body, org.jdom.Element element) {
        String use;
        String styles;
        String namespace = element.getAttributeValue("namespace");
        body.setNamespace(namespace);
        String parts = element.getAttributeValue("parts");
        if (parts != null && parts.trim().length() != 0) {
            EList partList = body.getParts();
            StringTokenizer tokenizer = new StringTokenizer(parts, " ");
            while (tokenizer.hasMoreElements()) {
                String token = (String)tokenizer.nextElement();
                if (token == null || token.length() == 0) continue;
                partList.add(token);
            }
        }
        if ((styles = element.getAttributeValue("encodingStyle")) != null && styles.trim().length() != 0) {
            EList styleList = body.getEncodingStyles();
            StringTokenizer tokenizer2 = new StringTokenizer(styles, " ");
            while (tokenizer2.hasMoreElements()) {
                String token = (String)tokenizer2.nextElement();
                if (token == null || token.length() == 0) continue;
                styleList.add(token);
            }
        }
        if ("encoded".equals(use = element.getAttributeValue("use"))) {
            body.setUse(SoapUseType.ENCODED_LITERAL);
        } else if ("literal".equals(use)) {
            body.setUse(SoapUseType.LITERAL_LITERAL);
        }
    }

    protected void doProcess(SoapHeader header, org.jdom.Element element) {
        String use;
        String styles;
        String namespace = element.getAttributeValue("namespace");
        header.setNamespace(namespace);
        String message = element.getAttributeValue("message");
        header.setMessage(message);
        String parts = element.getAttributeValue("parts");
        if (parts != null && parts.trim().length() != 0) {
            EList partList = header.getParts();
            StringTokenizer tokenizer = new StringTokenizer(parts, " ");
            while (tokenizer.hasMoreElements()) {
                String token = (String)tokenizer.nextElement();
                if (token == null || token.length() == 0) continue;
                partList.add(token);
            }
        }
        if ((styles = element.getAttributeValue("encodingStyle")) != null && styles.trim().length() != 0) {
            EList styleList = header.getEncodingStyles();
            StringTokenizer tokenizer2 = new StringTokenizer(styles, " ");
            while (tokenizer2.hasMoreElements()) {
                String token = (String)tokenizer2.nextElement();
                if (token == null || token.length() == 0) continue;
                styleList.add(token);
            }
        }
        if ("encoded".equals(use = element.getAttributeValue("use"))) {
            header.setUse(SoapUseType.ENCODED_LITERAL);
        } else if ("literal".equals(use)) {
            header.setUse(SoapUseType.LITERAL_LITERAL);
        }
        org.jdom.Element headerFaultElement = element.getChild("headerfault");
        if (headerFaultElement != null) {
            SoapHeaderFault headerFault = this.soapFactory.createSoapHeaderFault();
            this.doProcess(headerFault, headerFaultElement);
            header.setHeaderFault(headerFault);
        }
    }

    protected void doProcess(SoapAddress address, org.jdom.Element element) {
        String location = element.getAttributeValue("location");
        address.setLocation(location);
    }

    protected void doProcess(SoapOperation operation, org.jdom.Element element) {
        String action = element.getAttributeValue("soapAction");
        operation.setAction(action);
        String style = element.getAttributeValue("style");
        if ("rpc".equals(style)) {
            operation.setStyle(SoapStyleType.RPC_LITERAL);
        } else if ("document".equals(style)) {
            operation.setStyle(SoapStyleType.DOCUMENT_LITERAL);
        }
    }

    protected void doProcess(SoapFault fault, org.jdom.Element element) {
        String use;
        String namespace = element.getAttributeValue("namespace");
        fault.setNamespace(namespace);
        String styles = element.getAttributeValue("encodingStyle");
        if (styles != null && styles.trim().length() != 0) {
            EList styleList = fault.getEncodingStyles();
            StringTokenizer tokenizer2 = new StringTokenizer(styles, " ");
            while (tokenizer2.hasMoreElements()) {
                String token = (String)tokenizer2.nextElement();
                if (token == null || token.length() == 0) continue;
                styleList.add(token);
            }
        }
        if ("encoded".equals(use = element.getAttributeValue("use"))) {
            fault.setUse(SoapUseType.ENCODED_LITERAL);
        } else if ("literal".equals(use)) {
            fault.setUse(SoapUseType.LITERAL_LITERAL);
        }
    }

    protected void doProcess(SoapHeaderFault headerFault, org.jdom.Element element) {
        this.doProcess((SoapFault)headerFault, element);
        String message = element.getAttributeValue("message");
        headerFault.setMessage(message);
        String parts = element.getAttributeValue("parts");
        if (parts != null && parts.trim().length() != 0) {
            EList partList = headerFault.getParts();
            StringTokenizer tokenizer = new StringTokenizer(parts, " ");
            while (tokenizer.hasMoreElements()) {
                String token = (String)tokenizer.nextElement();
                if (token == null || token.length() == 0) continue;
                partList.add(token);
            }
        }
    }

    protected void doProcess(HttpBinding binding, org.jdom.Element element) {
        String verb = element.getAttributeValue("verb");
        binding.setVerb(verb);
    }

    protected void doProcess(HttpAddress address, org.jdom.Element element) {
        String location = element.getAttributeValue("location");
        address.setLocation(location);
    }

    protected void doProcess(HttpOperation operation, org.jdom.Element element) {
        String location = element.getAttributeValue("location");
        operation.setLocation(location);
    }

    protected void addError(XMLResource resource, String msg) {
        EList errors = resource.getErrors();
        WsdlDiagnostic diag = new WsdlDiagnostic(msg);
        errors.add(diag);
    }

    protected void addWarning(XMLResource resource, String msg) {
        EList warnings = resource.getWarnings();
        WsdlDiagnostic diag = new WsdlDiagnostic(msg);
        warnings.add(diag);
    }
}

