/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core;

import com.metamatrix.core.plugin.PluginUtilities;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.reader.StreamReader;
import com.metamatrix.modeler.core.writer.StreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;

public class MetabaseToolKitPlugin {
    private static Map streamReaderExtensions;
    private static Map streamWriterExtensions;

    public static StreamReader createStreamReaderService(String uniqueID) throws ModelerCoreException {
        if (uniqueID == null) {
            ArgCheck.isNotNull(uniqueID, ModelerCore.Util.getString("MetabaseToolKitPlugin.The_unique_identifier_for_the_Service_may_not_be_null_24"));
        }
        if (streamReaderExtensions == null) {
            streamReaderExtensions = new HashMap();
            String extensionID = "com.metamatrix.modeler.core.streamReader";
            MetabaseToolKitPlugin.loadExtensionMap("com.metamatrix.modeler.core.streamReader", streamReaderExtensions);
        }
        return (StreamReader)MetabaseToolKitPlugin.createExtensionInstance(uniqueID, streamReaderExtensions);
    }

    public static StreamWriter createStreamWriterService(String uniqueID) throws ModelerCoreException {
        if (uniqueID == null) {
            ArgCheck.isNotNull(uniqueID, ModelerCore.Util.getString("MetabaseToolKitPlugin.The_unique_identifier_for_the_Service_may_not_be_null_26"));
        }
        if (streamWriterExtensions == null) {
            streamWriterExtensions = new HashMap();
            String extensionID = "com.metamatrix.modeler.core.streamWriter";
            MetabaseToolKitPlugin.loadExtensionMap("com.metamatrix.modeler.core.streamWriter", streamWriterExtensions);
        }
        return (StreamWriter)MetabaseToolKitPlugin.createExtensionInstance(uniqueID, streamWriterExtensions);
    }

    private static void loadExtensionMap(String extensionPointID, Map extensionMap) {
        if (extensionPointID == null) {
            ArgCheck.isNotNull(extensionPointID, ModelerCore.Util.getString("MetabaseToolKitPlugin.The_extension_ID_may_not_be_null_28"));
        }
        if (extensionMap == null) {
            ArgCheck.isNotNull(extensionMap, ModelerCore.Util.getString("MetabaseToolKitPlugin.The_Map_reference_may_not_be_null_29"));
        }
        IExtension[] extensions = PluginUtilities.getExtensions(extensionPointID);
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IExtension extension = extensions[i2];
            String uniqueID = extension.getUniqueIdentifier();
            extensionMap.put(uniqueID, extension);
        }
    }

    private static Object createExtensionInstance(String uniqueID, Map extensionMap) throws ModelerCoreException {
        IExtension extension;
        if (uniqueID == null) {
            ArgCheck.isNotNull(uniqueID, ModelerCore.Util.getString("MetabaseToolKitPlugin.The_extension_uniqueID_may_not_be_null_30"));
        }
        if (extensionMap == null) {
            ArgCheck.isNotNull(extensionMap, ModelerCore.Util.getString("MetabaseToolKitPlugin.The_Map_reference_may_not_be_null_31"));
        }
        if ((extension = (IExtension)extensionMap.get(uniqueID)) == null) {
            throw new ModelerCoreException(ModelerCore.Util.getString("MetabaseToolKitPlugin.Unable_to_find_an_extension_with_unique_ID___32") + uniqueID + "\"");
        }
        return MetabaseToolKitPlugin.createExecutableExtension(extension);
    }

    private static Object createExecutableExtension(IExtension extension) throws ModelerCoreException {
        if (extension == null) {
            ArgCheck.isNotNull(extension, ModelerCore.Util.getString("MetabaseToolKitPlugin.The_IExtension_reference_may_not_be_null_34"));
        }
        try {
            return PluginUtilities.createExecutableExtension(extension, "class", "name");
        }
        catch (CoreException e2) {
            throw new ModelerCoreException((Throwable)e2, ModelerCore.Util.getString("MetabaseToolKitPlugin.Error_creating_instance_of_extension_with_ID___37") + extension.getUniqueIdentifier() + "\"");
        }
    }
}

