/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.compare;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.compare.EObjectMatcher;
import com.metamatrix.modeler.core.compare.EObjectMatcherCache;
import com.metamatrix.modeler.core.compare.TwoPhaseEObjectMatcher;
import com.metamatrix.modeler.core.util.ModelVisitor;
import com.metamatrix.modeler.core.util.ModelVisitorProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingFactory;

public class MappingProducer {
    private final EObjectMatcherCache matchers = new EObjectMatcherCache();
    private final LinkedList unmappedObjects = new LinkedList();
    private final Map inputsToOutputs;

    public MappingProducer() {
        this(new HashMap());
    }

    public MappingProducer(HashMap inputsToOutputs) {
        this.inputsToOutputs = inputsToOutputs;
    }

    public EObjectMatcherCache getEObjectMatcherCache() {
        return this.matchers;
    }

    public Map getInputsToOutputs() {
        return this.inputsToOutputs;
    }

    public Mapping createMappings(List inputs, List outputs, boolean recursive, MappingFactory factory, IProgressMonitor monitor) {
        ArgCheck.isNotNull(inputs);
        ArgCheck.isNotNull(outputs);
        ArgCheck.isNotNull(factory);
        this.unmappedObjects.clear();
        Mapping mappingRoot = factory.createMapping();
        LinkedList inputCopies = new LinkedList(inputs);
        LinkedList outputCopies = new LinkedList(outputs);
        mappingRoot.getInputs().addAll(inputs);
        mappingRoot.getOutputs().addAll(outputs);
        List matchers = this.matchers.getEObjectMatchersForRoots();
        Iterator iter = matchers.iterator();
        while (iter.hasNext()) {
            EObjectMatcher matcher = (EObjectMatcher)iter.next();
            matcher.addMappingsForRoots(inputCopies, outputCopies, mappingRoot, factory);
            if (!inputCopies.isEmpty() && !outputCopies.isEmpty()) continue;
            break;
        }
        this.enqueueUnmappedMappings(null, inputCopies, outputCopies, mappingRoot, factory);
        this.doProcessNestedMappings(factory, mappingRoot);
        this.initializeInputToOutputMapping(mappingRoot, this.inputsToOutputs);
        while (this.unmappedObjects.size() != 0) {
            EList nested;
            TwoPhaseEObjectMatcher tpMatcher;
            EObjectMatcher matcher;
            Iterator matcherIter;
            List theMatchers;
            UnmappedObjects uo = (UnmappedObjects)this.unmappedObjects.removeFirst();
            Mapping parentMapping = uo.parentMapping;
            ArrayList existingNested = new ArrayList(parentMapping.getNested());
            EReference ref = uo.reference;
            if (ref == null) {
                theMatchers = this.matchers.getEObjectMatchersForRoots();
                matcherIter = theMatchers.iterator();
                while (matcherIter.hasNext()) {
                    matcher = (EObjectMatcher)matcherIter.next();
                    if (!(matcher instanceof TwoPhaseEObjectMatcher)) continue;
                    tpMatcher = (TwoPhaseEObjectMatcher)matcher;
                    tpMatcher.addMappingsForRoots(uo.unmappedInputs, uo.unmappedOutputs, this.inputsToOutputs, parentMapping, factory);
                    if (!uo.unmappedInputs.isEmpty() && !uo.unmappedOutputs.isEmpty()) continue;
                    break;
                }
            } else {
                theMatchers = this.matchers.getEObjectMatchers(ref);
                matcherIter = theMatchers.iterator();
                while (matcherIter.hasNext()) {
                    matcher = (EObjectMatcher)matcherIter.next();
                    if (!(matcher instanceof TwoPhaseEObjectMatcher)) continue;
                    tpMatcher = (TwoPhaseEObjectMatcher)matcher;
                    tpMatcher.addMappings(ref, uo.unmappedInputs, uo.unmappedOutputs, this.inputsToOutputs, parentMapping, factory);
                    if (!uo.unmappedInputs.isEmpty() && !uo.unmappedOutputs.isEmpty()) continue;
                    break;
                }
            }
            if ((nested = parentMapping.getNested()).size() != existingNested.size()) {
                ArrayList newNestedMappings = new ArrayList(parentMapping.getNested());
                newNestedMappings.removeAll(existingNested);
                Iterator newNestedIter = newNestedMappings.iterator();
                while (newNestedIter.hasNext()) {
                    Mapping newNested = (Mapping)newNestedIter.next();
                    this.doProcessMapping(factory, newNested);
                }
            }
            this.addUnmappedMappings(uo.unmappedInputs, uo.unmappedOutputs, parentMapping, factory);
        }
        return mappingRoot;
    }

    protected void doProcessNestedMappings(MappingFactory factory, Mapping mappingRoot) {
        Iterator nestedIter = mappingRoot.getNested().iterator();
        while (nestedIter.hasNext()) {
            Mapping nestedMapping = (Mapping)nestedIter.next();
            this.doProcessMapping(factory, nestedMapping);
        }
    }

    protected void doProcessMapping(MappingFactory factory, Mapping mapping) {
        EList nestedInputs = mapping.getInputs();
        EList nestedOutputs = mapping.getOutputs();
        if (nestedInputs.size() == 1 && nestedOutputs.size() == 1) {
            EClass outputEClass;
            EObject inputObj = (EObject)nestedInputs.get(0);
            EObject outputObj = (EObject)nestedOutputs.get(0);
            EClass inputEClass = inputObj.eClass();
            if (inputEClass.equals(outputEClass = outputObj.eClass())) {
                EList refs = inputEClass.getEAllContainments();
                Iterator refIter = refs.iterator();
                while (refIter.hasNext()) {
                    EReference ref = (EReference)refIter.next();
                    LinkedList<Object> inputValues = new LinkedList<Object>();
                    LinkedList<Object> outputValues = new LinkedList<Object>();
                    if (ref.isMany()) {
                        inputValues.addAll((List)inputObj.eGet(ref));
                        outputValues.addAll((List)outputObj.eGet(ref));
                    } else {
                        Object inputValue = inputObj.eGet(ref);
                        Object outputValue = outputObj.eGet(ref);
                        if (inputValue != null) {
                            inputValues.add(inputValue);
                        }
                        if (outputValue != null) {
                            outputValues.add(outputValue);
                        }
                    }
                    if (inputValues.size() != 0 && outputValues.size() != 0) {
                        List refMatchers = this.matchers.getEObjectMatchers(ref);
                        Iterator refMatcherIter = refMatchers.iterator();
                        while (refMatcherIter.hasNext()) {
                            EObjectMatcher refMatcher = (EObjectMatcher)refMatcherIter.next();
                            refMatcher.addMappings(ref, inputValues, outputValues, mapping, factory);
                            if (!inputValues.isEmpty() && !outputValues.isEmpty()) continue;
                            break;
                        }
                    }
                    if (inputValues.size() == 0 && outputValues.size() == 0) continue;
                    this.enqueueUnmappedMappings(ref, inputValues, outputValues, mapping, factory);
                }
            }
        }
        this.doProcessNestedMappings(factory, mapping);
    }

    protected void enqueueUnmappedMappings(EReference reference, List inputs, List outputs, Mapping mapping, MappingFactory factory) {
        if (inputs.size() != 0 || outputs.size() != 0) {
            UnmappedObjects uo = new UnmappedObjects(reference, inputs, outputs, mapping);
            this.unmappedObjects.add(uo);
        }
    }

    protected void addUnmappedMappings(List inputs, List outputs, Mapping mapping, MappingFactory factory) {
        Iterator inputIter = inputs.iterator();
        while (inputIter.hasNext()) {
            Object input = inputIter.next();
            Mapping deletionMapping = factory.createMapping();
            deletionMapping.getInputs().add(input);
            mapping.getNested().add(deletionMapping);
        }
        Iterator outputIter = outputs.iterator();
        while (outputIter.hasNext()) {
            Object output = outputIter.next();
            Mapping additionMapping = factory.createMapping();
            additionMapping.getOutputs().add(output);
            mapping.getNested().add(additionMapping);
        }
    }

    protected void initializeInputToOutputMapping(Mapping mapping, final Map inputsToOutputsMap) {
        ModelVisitor visitor = new ModelVisitor(){

            public boolean visit(EObject object) throws ModelerCoreException {
                if (object instanceof Mapping) {
                    Mapping mapping = (Mapping)object;
                    EList inputs = mapping.getInputs();
                    EList outputs = mapping.getOutputs();
                    if (inputs.size() == 1 && outputs.size() == 1) {
                        EObject input = (EObject)inputs.get(0);
                        EObject output = (EObject)outputs.get(0);
                        inputsToOutputsMap.put(input, output);
                    }
                    return true;
                }
                return false;
            }

            public boolean visit(Resource resource) throws ModelerCoreException {
                return true;
            }
        };
        ModelVisitorProcessor visitorProcessor = new ModelVisitorProcessor(visitor);
        try {
            visitorProcessor.walk(mapping, 2);
        }
        catch (ModelerCoreException e2) {
            ModelerCore.Util.log(e2);
        }
    }

    protected class UnmappedObjects {
        protected final List unmappedInputs;
        protected final List unmappedOutputs;
        protected final Mapping parentMapping;
        protected final EReference reference;

        public UnmappedObjects(EReference reference, List unmappedInputs, List unmappedOutputs, Mapping parentMapping) {
            this.unmappedInputs = unmappedInputs;
            this.unmappedOutputs = unmappedOutputs;
            this.parentMapping = parentMapping;
            this.reference = reference;
        }
    }
}

