/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.metamodel;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.Multiplicity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class RangeMultiplicity
extends Multiplicity {
    private List intervals = new ArrayList();
    private Multiplicity first;
    private Multiplicity last;

    RangeMultiplicity(List intervals, boolean isOrdered, boolean isUnique) {
        super(isOrdered, isUnique);
        this.intervals = intervals;
        if (this.intervals == null || this.intervals.size() == 0) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("Multiplicity.Unable_to_create_a_RangeMultiplicity_with_zero-length_or_null_list_of_intervals"));
        }
        this.first = (Multiplicity)this.intervals.get(0);
        this.last = (Multiplicity)this.intervals.get(this.intervals.size() - 1);
    }

    public List getIntervals() {
        return this.intervals;
    }

    public int getMaximum() {
        return this.last.getMaximum();
    }

    public int getMinimum() {
        return this.first.getMinimum();
    }

    public boolean isUnlimited() {
        return this.last.isUnlimited();
    }

    public boolean isIncluded(int cardinality) {
        boolean result = false;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Multiplicity m2 = (Multiplicity)iter.next();
            if (!m2.isIncluded(cardinality)) continue;
            result = true;
            break;
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.intervals.iterator();
        if (iter.hasNext()) {
            sb.append(iter.next().toString());
        }
        while (iter.hasNext()) {
            sb.append(',');
            sb.append(iter.next().toString());
        }
        return sb.toString();
    }

    public int compareTo(Object obj) {
        Assertion.isNotNull(obj);
        Multiplicity that = (Multiplicity)obj;
        return Multiplicity.compare(this, that);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Multiplicity) {
            Multiplicity that = (Multiplicity)obj;
            return Multiplicity.compare(this, that) == 0;
        }
        return false;
    }
}

