/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.refactor;

import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.metamodels.core.CorePackage;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.refactor.ResourceRefactorCommand;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public final class ResourceRenameNamespaceUriCommand
extends ResourceRefactorCommand {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(class$com$metamatrix$modeler$core$refactor$ResourceRenameNamespaceUriCommand == null ? (class$com$metamatrix$modeler$core$refactor$ResourceRenameNamespaceUriCommand = ResourceRenameNamespaceUriCommand.class$("com.metamatrix.modeler.core.refactor.ResourceRenameNamespaceUriCommand")) : class$com$metamatrix$modeler$core$refactor$ResourceRenameNamespaceUriCommand);
    private String currentValue = null;
    private String newValue = null;
    static /* synthetic */ Class class$com$metamatrix$modeler$core$refactor$ResourceRenameNamespaceUriCommand;

    private static final String getString(String theKey) {
        return ModelerCore.Util.getStringOrKey(PREFIX + theKey);
    }

    private static final String getString(String theKey, Object theParam) {
        return ModelerCore.Util.getString(PREFIX + theKey, theParam);
    }

    public ResourceRenameNamespaceUriCommand(IResource theModel) {
        super(ResourceRenameNamespaceUriCommand.getString("initLabel"));
        this.setResource(theModel);
    }

    public ResourceRenameNamespaceUriCommand(IResource theModel, String theNewNamespaceUri) {
        this(theModel);
        this.newValue = theNewNamespaceUri;
    }

    protected IStatus getCanExecuteStatus() {
        Status result = null;
        int code = -1;
        ModelWorkspaceException exception = null;
        IResource resource = this.getResource();
        String msg = null;
        if (!ModelUtil.isModelFile(resource)) {
            msg = ResourceRenameNamespaceUriCommand.getString("errorMsg.fileNotModel");
            code = 20;
        }
        if (!resource.getProject().isOpen()) {
            msg = ResourceRenameNamespaceUriCommand.getString("errorMsg.projectNotOpen");
            code = 30;
        }
        try {
            ModelResource modelResource = ModelUtil.getModel(resource);
            if (modelResource == null) {
                msg = ResourceRenameNamespaceUriCommand.getString("errorMsg.modelResourceProblem", resource);
                code = 40;
            } else {
                this.currentValue = modelResource.getModelAnnotation().getNamespaceUri();
                boolean different = false;
                if (this.currentValue == null) {
                    different = this.newValue != null;
                } else {
                    boolean bl = different = this.newValue == null || !this.currentValue.equals(this.newValue);
                }
                if (!different) {
                    msg = ResourceRenameNamespaceUriCommand.getString("errorMsg.valueNotChanged");
                    code = 10;
                }
            }
        }
        catch (ModelWorkspaceException theException) {
            msg = ResourceRenameNamespaceUriCommand.getString("errorMsg.modelResourceProblem", resource);
            code = 40;
            exception = theException;
        }
        if (msg != null) {
            result = new Status(4, "com.metamatrix.modeler.core", code, msg, exception);
        }
        return result;
    }

    public String getDescription() {
        return ResourceRenameNamespaceUriCommand.getString("description", this.getResource().getProjectRelativePath());
    }

    public String getLabel() {
        return ResourceRenameNamespaceUriCommand.getString("label", this.getResource().getProjectRelativePath());
    }

    protected Map getMovedResourcePathMap(boolean theIsUndo) {
        return null;
    }

    protected IStatus modifyResource(IResource theResource, IProgressMonitor theMonitor) {
        return this.modifyResource(theResource, theMonitor, this.newValue);
    }

    private IStatus modifyResource(IResource theResource, IProgressMonitor theMonitor, String theUri) {
        Status result = null;
        try {
            ModelResource model = ModelUtil.getModel(theResource);
            if (model == null) {
                result = new Status(4, "com.metamatrix.modeler.core", 40, ResourceRenameNamespaceUriCommand.getString("errorMsg.modelResourceProblem", theResource), null);
            } else {
                ModelAnnotation annotation = model.getModelAnnotation();
                ModelerCore.getModelEditor().setPropertyValue((EObject)annotation, (Object)theUri, CorePackage.eINSTANCE.getModelAnnotation_NamespaceUri());
                this.setModifiedResource(theResource);
            }
        }
        catch (ModelWorkspaceException theException) {
            result = new Status(4, "com.metamatrix.modeler.core", 40, ResourceRenameNamespaceUriCommand.getString("errorMsg.modelResourceProblem", theResource), theException);
        }
        return result;
    }

    protected int checkDependentResources(boolean theIsUndo) {
        return 0;
    }

    protected IStatus redoResourceModification(IProgressMonitor theMonitor) {
        return this.modifyResource(super.getModifiedResource(), theMonitor, this.newValue);
    }

    public void setNamespaceUri(String theNewUri) {
        this.newValue = theNewUri;
    }

    protected boolean shouldRebuildImports() {
        return false;
    }

    protected IStatus undoResourceModification(IProgressMonitor theMonitor) {
        return this.modifyResource(super.getModifiedResource(), theMonitor, this.currentValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface StatusCodes {
        public static final int NO_CHANGE = 10;
        public static final int NOT_MODEL = 20;
        public static final int PROJECT_CLOSED = 30;
        public static final int MODEL_PROBLEM = 40;
    }
}

