/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.core.AnnotationContainer;
import com.metamatrix.metamodels.core.CoreFactory;
import com.metamatrix.metamodels.core.CorePackage;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.core.custom.impl.XsdModelAnnotationImpl;
import com.metamatrix.metamodels.core.extension.XPackage;
import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.metamodels.diagram.DiagramContainer;
import com.metamatrix.metamodels.diagram.DiagramFactory;
import com.metamatrix.metamodels.diagram.DiagramPackage;
import com.metamatrix.metamodels.transformation.FragmentMappingRoot;
import com.metamatrix.metamodels.transformation.MappingClassSet;
import com.metamatrix.metamodels.transformation.MappingClassSetContainer;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TransformationContainer;
import com.metamatrix.metamodels.transformation.TransformationFactory;
import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TransformationPackage;
import com.metamatrix.metamodels.transformation.TreeMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelResourceContainerFactory;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.XsdObjectExtension;
import com.metamatrix.modeler.internal.core.workspace.ModelBufferImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelResourceImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.xsd.util.XSDResourceImpl;

public class ModelContents {
    protected static final int DEFAULT_DIAGRAM_SIZE = 8;
    protected static final int DEFAULT_TRANSFORMATION_SIZE = 3;
    private final Resource resource;
    private final List transientDiagrams;
    private final boolean isXsd;
    private DiagramFactory diagramFactory;
    private TransformationFactory transformationFactory;
    private CoreFactory coreFactory;
    private DiagramContainer persistentDiagramContainer;
    private TransformationContainer persistentTransformationsContainer;
    private AnnotationContainer persistentAnnotationsContainer;
    private MappingClassSetContainer persistentMappingClassSetContainer;
    private final Object persistentDiagramLock = new Object();
    private final Object persistentTransformationLock = new Object();
    private final Object persistentAnnotationLock = new Object();
    private final Object modelAnnotationLock = new Object();
    private final Object persistentMappingClassContainerLock = new Object();
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$core$workspace$ModelResourceImpl;

    public static ModelContents getModelContents(ModelResource modelResource) throws ModelWorkspaceException {
        ArgCheck.isNotNull(modelResource);
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$internal$core$workspace$ModelResourceImpl == null ? (class$com$metamatrix$modeler$internal$core$workspace$ModelResourceImpl = ModelContents.class$("com.metamatrix.modeler.internal.core.workspace.ModelResourceImpl")) : class$com$metamatrix$modeler$internal$core$workspace$ModelResourceImpl, modelResource);
        ModelBufferImpl buffer = (ModelBufferImpl)((ModelResourceImpl)modelResource).getBuffer();
        return buffer.getModelContents();
    }

    public ModelContents(Resource resource) {
        Assertion.isNotNull(resource);
        this.resource = resource;
        this.transientDiagrams = new LinkedList();
        this.diagramFactory = null;
        this.transformationFactory = null;
        this.coreFactory = null;
        this.isXsd = ModelUtil.isXsdFile(resource);
    }

    protected ModelContents() {
        this.resource = null;
        this.transientDiagrams = new LinkedList();
        this.diagramFactory = null;
        this.transformationFactory = null;
        this.coreFactory = null;
        this.isXsd = this.resource != null ? ModelUtil.isXsdFile(this.resource) : false;
    }

    protected DiagramFactory getDiagramFactory() {
        if (this.diagramFactory == null) {
            this.diagramFactory = DiagramPackage.eINSTANCE.getDiagramFactory();
        }
        return this.diagramFactory;
    }

    protected TransformationFactory getTransformationFactory() {
        if (this.transformationFactory == null) {
            this.transformationFactory = TransformationPackage.eINSTANCE.getTransformationFactory();
        }
        return this.transformationFactory;
    }

    protected CoreFactory getCoreFactory() {
        if (this.coreFactory == null) {
            this.coreFactory = CorePackage.eINSTANCE.getCoreFactory();
        }
        return this.coreFactory;
    }

    public Resource getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Diagram createNewDiagram(EObject target, boolean persistent) {
        if (this.isXsd) {
            return null;
        }
        Diagram diagram = null;
        boolean startedTxn = ModelerCore.startTxn(false, null, this);
        boolean succeeded = false;
        try {
            diagram = this.getDiagramFactory().createDiagram();
            if (target != null) {
                diagram.setTarget(target);
            } else {
                diagram.setTarget(this.getModelAnnotation());
            }
            this.doSetPersistent(diagram, persistent);
            succeeded = true;
        }
        finally {
            if (startedTxn) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return diagram;
    }

    public boolean delete(Diagram diagram) {
        if (diagram == null) {
            return false;
        }
        if (!this.transientDiagrams.remove(diagram)) {
            return ModelResourceContainerFactory.deleteDiagram(diagram);
        }
        return true;
    }

    public boolean isPersistent(Diagram diagram) {
        return diagram.eContainer() != null;
    }

    public void setPersistent(Diagram diagram, boolean persistent) {
        if (persistent == this.isPersistent(diagram)) {
            return;
        }
        this.doSetPersistent(diagram, persistent);
    }

    protected void doSetPersistent(Diagram diagram, boolean persistent) {
        if (persistent) {
            DiagramContainer container = this.getDiagramContainer(true);
            try {
                ModelerCore.getModelEditor().addValue(container, diagram, container.getDiagram());
            }
            catch (ModelerCoreException err) {
                ModelerCore.Util.log(4, err, err.getMessage());
                diagram.setDiagramContainer(container);
            }
        } else {
            this.transientDiagrams.add(diagram);
        }
    }

    public void addTransientDiagram(Diagram diagram) {
        this.transientDiagrams.add(diagram);
    }

    public void removeTransientDiagram(Diagram diagram) {
        this.transientDiagrams.remove(diagram);
    }

    public List getDiagrams() {
        if (this.isXsd) {
            return Collections.EMPTY_LIST;
        }
        List results = this.createDiagramList();
        List persistentDiags = this.getPersistentDiagrams(false);
        results.addAll(persistentDiags);
        results.addAll(this.transientDiagrams);
        return results;
    }

    public List getDiagrams(EObject target) {
        if (this.isXsd) {
            return Collections.EMPTY_LIST;
        }
        List results = this.createDiagramList();
        EObject actualTarget = target == null ? this.getModelAnnotation() : target;
        List persistentDiags = this.getPersistentDiagrams(false);
        if (persistentDiags.size() != 0) {
            this.addDiagramsForTarget(persistentDiags, actualTarget, results);
        }
        if (this.transientDiagrams.size() != 0) {
            this.addDiagramsForTarget(this.transientDiagrams, actualTarget, results);
        }
        return results;
    }

    protected List createDiagramList() {
        return new ArrayList(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagramContainer getDiagramContainer(boolean createIfNeeded) {
        if (this.isXsd) {
            return null;
        }
        if (this.persistentDiagramContainer == null) {
            Object object = this.persistentDiagramLock;
            synchronized (object) {
                if (this.persistentDiagramContainer == null) {
                    this.persistentDiagramContainer = ModelResourceContainerFactory.getDiagramContainer(this.getAllRootEObjects());
                    if (this.persistentDiagramContainer == null && this.resource != null) {
                        this.persistentDiagramContainer = ModelResourceContainerFactory.getDiagramContainer(this.resource, createIfNeeded);
                    }
                }
            }
        }
        return this.persistentDiagramContainer;
    }

    protected List getPersistentDiagrams(boolean createIfNeeded) {
        if (this.isXsd) {
            return Collections.EMPTY_LIST;
        }
        DiagramContainer container = this.getDiagramContainer(createIfNeeded);
        if (container == null) {
            return Collections.EMPTY_LIST;
        }
        return container.getDiagram();
    }

    protected void addDiagramsForTarget(List diagrams, EObject target, List results) {
        Assertion.isNotNull(diagrams);
        Assertion.isNotNull(results);
        Iterator diagIter = diagrams.iterator();
        while (diagIter.hasNext()) {
            Diagram diagram = (Diagram)diagIter.next();
            if (diagram == null || !this.isDiagramForTarget(diagram, target)) continue;
            results.add(diagram);
        }
    }

    protected boolean isDiagramForTarget(Diagram diagram, EObject target) {
        Assertion.isNotNull(diagram);
        EObject actualTarget = diagram.getTarget();
        if (actualTarget == null) {
            return target == null;
        }
        return diagram.getTarget().equals(target);
    }

    protected List createTransformationList() {
        return new ArrayList(3);
    }

    public SqlTransformationMappingRoot createSqlTransformation(EObject target) {
        ArgCheck.isNotNull(target);
        SqlTransformationMappingRoot t2 = this.getTransformationFactory().createSqlTransformationMappingRoot();
        t2.getOutputs().add(target);
        return (SqlTransformationMappingRoot)this.addNewTransformation(target, t2);
    }

    public FragmentMappingRoot createFragmentMapping(EObject target) {
        ArgCheck.isNotNull(target);
        FragmentMappingRoot t2 = this.getTransformationFactory().createFragmentMappingRoot();
        return (FragmentMappingRoot)this.addNewTransformation(target, t2);
    }

    public TreeMappingRoot createTreeMapping(EObject target) {
        ArgCheck.isNotNull(target);
        TreeMappingRoot t2 = this.getTransformationFactory().createTreeMappingRoot();
        return (TreeMappingRoot)this.addNewTransformation(target, t2);
    }

    public TransformationMappingRoot addNewTransformation(EObject target, TransformationMappingRoot newMappingRoot) {
        ArgCheck.isNotNull(target);
        newMappingRoot.setTarget(target);
        this.getTransformationContainer(true).getTransformationMappings().add(newMappingRoot);
        this.setModified(true);
        return newMappingRoot;
    }

    public List getTransformationsForOutput(EObject output) {
        List results = this.createTransformationList();
        List transformations = this.getTransformations();
        if (transformations.size() != 0) {
            this.addTransformationsForOutput(transformations, output, results);
        }
        return results;
    }

    public List getTransformationsForInput(EObject input) {
        List results = this.createTransformationList();
        List transformations = this.getTransformations();
        if (transformations.size() != 0) {
            this.addTransformationsForInput(transformations, input, results);
        }
        return results;
    }

    public List getTransformations(EObject target) {
        List results = this.createTransformationList();
        List transformations = this.getTransformations();
        if (transformations.size() != 0) {
            this.addTransformationsForTarget(transformations, target, results);
        }
        return results;
    }

    public List getTransformations() {
        TransformationContainer container = this.getTransformationContainer(false);
        if (container == null) {
            return new ArrayList();
        }
        return container.getTransformationMappings();
    }

    public boolean delete(TransformationMappingRoot transformation) {
        if (ModelResourceContainerFactory.deleteTransformation(transformation)) {
            this.setModified(true);
            return true;
        }
        return false;
    }

    protected void setModified(boolean modified) {
        this.resource.setModified(modified);
    }

    protected URI getUri() {
        return this.resource.getURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformationContainer getTransformationContainer(boolean createIfNeeded) {
        if (this.persistentTransformationsContainer == null) {
            Object object = this.persistentTransformationLock;
            synchronized (object) {
                if (this.persistentTransformationsContainer == null) {
                    this.persistentTransformationsContainer = ModelResourceContainerFactory.getTransformationContainer(this.getAllRootEObjects());
                    if (this.persistentTransformationsContainer == null && this.resource != null) {
                        this.persistentTransformationsContainer = ModelResourceContainerFactory.getTransformationContainer(this.resource, createIfNeeded);
                    }
                }
            }
        }
        return this.persistentTransformationsContainer;
    }

    protected void addTransformationsForOutput(List transformations, EObject output, List results) {
        Assertion.isNotNull(transformations);
        Assertion.isNotNull(results);
        Iterator diagIter = transformations.iterator();
        while (diagIter.hasNext()) {
            MappingRoot mappingRoot = (MappingRoot)diagIter.next();
            if (mappingRoot == null || !this.isOutputOfTransformation(mappingRoot, output)) continue;
            results.add(mappingRoot);
        }
    }

    protected void addTransformationsForInput(List transformations, EObject input, List results) {
        Assertion.isNotNull(transformations);
        Assertion.isNotNull(results);
        Iterator diagIter = transformations.iterator();
        while (diagIter.hasNext()) {
            MappingRoot mappingRoot = (MappingRoot)diagIter.next();
            if (mappingRoot == null || !this.isInputOfTransformation(mappingRoot, input)) continue;
            results.add(mappingRoot);
        }
    }

    protected void addTransformationsForTarget(List transformations, EObject target, List results) {
        Assertion.isNotNull(transformations);
        Assertion.isNotNull(results);
        Iterator diagIter = transformations.iterator();
        while (diagIter.hasNext()) {
            MappingRoot mappingRoot = (MappingRoot)diagIter.next();
            if (mappingRoot == null || !(mappingRoot instanceof TransformationMappingRoot)) continue;
            TransformationMappingRoot tmr = (TransformationMappingRoot)mappingRoot;
            if (tmr.getTarget() == null) {
                if (target != null) break;
                results.add(tmr);
                break;
            }
            if (!tmr.getTarget().equals(target)) continue;
            results.add(mappingRoot);
        }
    }

    protected boolean isOutputOfTransformation(MappingRoot mappingRoot, EObject output) {
        Assertion.isNotNull(mappingRoot);
        return mappingRoot.getOutputs().contains(output);
    }

    protected boolean isInputOfTransformation(MappingRoot mappingRoot, EObject input) {
        Assertion.isNotNull(mappingRoot);
        return mappingRoot.getInputs().contains(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAnnotation getModelAnnotation() {
        ArrayList rootObjs = new ArrayList(this.getAllRootEObjects());
        Iterator iter = rootObjs.iterator();
        while (iter.hasNext()) {
            EObject rootObj = (EObject)iter.next();
            if (!(rootObj instanceof ModelAnnotation)) continue;
            return (ModelAnnotation)rootObj;
        }
        ModelAnnotation newModelAnnotation = null;
        Object object = this.modelAnnotationLock;
        synchronized (object) {
            if (this.isXsd) {
                newModelAnnotation = new XsdModelAnnotationImpl(this.resource);
                newModelAnnotation.setPrimaryMetamodelUri("http://www.eclipse.org/xsd/2002/XSD");
                newModelAnnotation.setModelType(ModelType.TYPE_LITERAL);
                newModelAnnotation.setMaxSetSize(0);
                newModelAnnotation.setSupportsDistinct(false);
                newModelAnnotation.setSupportsJoin(false);
                newModelAnnotation.setSupportsOrderBy(false);
                newModelAnnotation.setSupportsOuterJoin(false);
                newModelAnnotation.setSupportsWhereAll(false);
                newModelAnnotation.setVisible(false);
                if (this.resource instanceof XSDResourceImpl) {
                    try {
                        XPackage extPackage;
                        XSDResourceImpl xsdResource = (XSDResourceImpl)this.resource;
                        if (xsdResource.getSchema() != null && (extPackage = XsdObjectExtension.getExtensionPackage(xsdResource)) != null) {
                            newModelAnnotation.setExtensionPackage(extPackage);
                        }
                    }
                    catch (ModelerCoreException err) {
                        ModelerCore.Util.log(4, err, err.getMessage());
                    }
                }
            } else if (newModelAnnotation == null) {
                newModelAnnotation = this.getCoreFactory().createModelAnnotation();
                this.getAllRootEObjects().add(0, newModelAnnotation);
                this.setModified(true);
            }
        }
        return newModelAnnotation;
    }

    public Annotation createNewAnnotation(EObject annotatedObject) {
        return ModelResourceContainerFactory.createNewAnnotation(annotatedObject, this.getAnnotationContainer(true));
    }

    public Annotation getAnnotation(EObject annotatedObject) {
        if (annotatedObject == null) {
            return null;
        }
        AnnotationContainer container = this.getAnnotationContainer(false);
        if (container == null) {
            return null;
        }
        Annotation existing = container.findAnnotation(annotatedObject);
        if (existing != null) {
            return existing;
        }
        return null;
    }

    public List getAnnotations() {
        AnnotationContainer container = this.getAnnotationContainer(false);
        if (container == null) {
            return Collections.EMPTY_LIST;
        }
        return container.getAnnotations();
    }

    public boolean delete(Annotation annotation) {
        return ModelResourceContainerFactory.deleteAnnotation(annotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationContainer getAnnotationContainer(boolean createIfNeeded) {
        if (this.isXsd) {
            return null;
        }
        if (this.persistentAnnotationsContainer == null) {
            Object object = this.persistentAnnotationLock;
            synchronized (object) {
                if (this.persistentAnnotationsContainer == null) {
                    this.persistentAnnotationsContainer = ModelResourceContainerFactory.getAnnotationContainer(this.getAllRootEObjects());
                    if (this.persistentAnnotationsContainer == null && this.resource != null) {
                        this.persistentAnnotationsContainer = ModelResourceContainerFactory.getAnnotationContainer(this.resource, createIfNeeded);
                    }
                }
            }
        }
        return this.persistentAnnotationsContainer;
    }

    public MappingClassSet createNewMappingClassSet(EObject target) {
        ArgCheck.isNotNull(target);
        MappingClassSet mcSet = this.getTransformationFactory().createMappingClassSet();
        mcSet.setTarget(target);
        this.getMappingClassSetContainer(true).getMappingClassSets().add(mcSet);
        return mcSet;
    }

    public List getMappingClassSets(EObject target) {
        ArrayList<MappingClassSet> result = new ArrayList<MappingClassSet>();
        Iterator iter = new ArrayList(this.getMappingClassSets()).iterator();
        while (iter.hasNext()) {
            MappingClassSet mcSet = (MappingClassSet)iter.next();
            if (mcSet.getTarget() == null || !mcSet.getTarget().equals(target)) continue;
            result.add(mcSet);
        }
        return result;
    }

    public List getMappingClassSets() {
        MappingClassSetContainer container = this.getMappingClassSetContainer(false);
        if (container == null) {
            return Collections.EMPTY_LIST;
        }
        return container.getMappingClassSets();
    }

    public boolean delete(MappingClassSet mappingClassSet) {
        return ModelResourceContainerFactory.deleteMappingClassSet(mappingClassSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingClassSetContainer getMappingClassSetContainer(boolean createIfNeeded) {
        if (this.persistentMappingClassSetContainer == null) {
            Object object = this.persistentMappingClassContainerLock;
            synchronized (object) {
                if (this.persistentMappingClassSetContainer == null) {
                    this.persistentMappingClassSetContainer = ModelResourceContainerFactory.getMappingClassSetContainer(this.getAllRootEObjects());
                    if (this.persistentMappingClassSetContainer == null && this.resource != null) {
                        this.persistentMappingClassSetContainer = ModelResourceContainerFactory.getMappingClassSetContainer(this.resource, createIfNeeded);
                    }
                }
            }
        }
        return this.persistentMappingClassSetContainer;
    }

    public List getAllRootEObjects() {
        return this.resource.getContents();
    }

    public List getEObjects() {
        List allRoots = this.getAllRootEObjects();
        LinkedList roots = new LinkedList();
        Iterator iter = allRoots.iterator();
        while (iter.hasNext()) {
            Object rootObj = iter.next();
            if (rootObj instanceof DiagramContainer || rootObj instanceof TransformationContainer || rootObj instanceof AnnotationContainer || rootObj instanceof ModelAnnotation || rootObj instanceof MappingClassSetContainer) continue;
            roots.add(rootObj);
        }
        return roots;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

