/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.core.AnnotationContainer;
import com.metamatrix.metamodels.core.CoreFactory;
import com.metamatrix.metamodels.core.CorePackage;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.metamodels.diagram.DiagramContainer;
import com.metamatrix.metamodels.diagram.DiagramFactory;
import com.metamatrix.metamodels.transformation.FragmentMappingRoot;
import com.metamatrix.metamodels.transformation.MappingClassSet;
import com.metamatrix.metamodels.transformation.MappingClassSetContainer;
import com.metamatrix.metamodels.transformation.SqlTransformation;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TransformationContainer;
import com.metamatrix.metamodels.transformation.TransformationFactory;
import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TreeMappingRoot;
import com.metamatrix.metamodels.transformation.XQueryTransformationMappingRoot;
import com.metamatrix.modeler.core.MetamodelDescriptor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspectHelper;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mapping.MappingHelper;

public class ModelResourceContainerFactory {
    private static final String ADD_VALUE_ERROR = "ModelResourceContainerFactory.addValueError";
    private static final String REMOVE_VALUE_ERROR = "ModelResourceContainerFactory.removeValueError";
    private static final String DIAGRAM_CONTAINER = "ModelResourceContainerFactory.diagramContainerText";
    private static final String GET_METAMODEL_DESCRIPTOR_ERROR_KEY = "ModelResourceContainerFactory.getMetamodelDescriptorError";
    private static final String NO_ANNOTATION_CONTAINER_ERROR = "ModelResourceContainerFactory.noAnnotationContainerError";
    private static final String NO_MAPPING_CLASS_SET_CONTAINER_ERROR = "ModelResourceContainerFactory.noMappingClassSetContainerError";
    private static final String SQL_ROOT_TARGET_NOT_VALID_KEY = "ModelResourceContainerFactory.sqlRootTargetInvalid";
    private static final String TREE_ROOT_TARGET_NOT_VALID_KEY = "ModelResourceContainerFactory.treeRootTargetInvalid";
    private static final String FRAGMENT_ROOT_TARGET_NOT_VALID_KEY = "ModelResourceContainerFactory.fragmentRootTargetInvalid";
    private static final String XML_DOCUCUMENT_TARGET_NOT_VALID_KEY = "ModelResourceContainerFactory.xmlDocumentTargetInvalid";
    private static final String DIAGRAMS_NOT_SUPPORTED_KEY = "ModelResourceContainerFactory.diagramsNotSupportedWarning";
    private static final TransformationFactory transformationFactory = TransformationFactory.eINSTANCE;
    private static final DiagramFactory diagramFactory = DiagramFactory.eINSTANCE;
    private static final CoreFactory coreFactory = CorePackage.eINSTANCE.getCoreFactory();
    private static final String XML_URI = "http://www.metamatrix.com/metamodels/XmlDocument";
    private static boolean isTransactionable = ModelerCore.getPlugin() != null;

    private static String getString(String key, Object value) {
        return ModelerCore.Util.getString(key, value);
    }

    private static String getString(String key, Object value, Object value2) {
        return ModelerCore.Util.getString(key, value, value2);
    }

    private static void addValue(Object owner, Object value, EList feature) {
        try {
            if (isTransactionable) {
                ModelerCore.getModelEditor().addValue(owner, value, feature);
            } else {
                feature.add(value);
            }
        }
        catch (ModelerCoreException err) {
            String message = ModelResourceContainerFactory.getString(ADD_VALUE_ERROR, value, owner);
            ModelerCore.Util.log(4, message);
        }
    }

    private static boolean removeValue(Object owner, Object value, EList feature) {
        boolean successful = false;
        try {
            if (isTransactionable) {
                ModelerCore.getModelEditor().removeValue(owner, value, feature);
            } else {
                feature.remove(value);
            }
            successful = true;
        }
        catch (ModelerCoreException err) {
            String message = ModelResourceContainerFactory.getString(REMOVE_VALUE_ERROR, value, owner);
            ModelerCore.Util.log(4, message);
        }
        return successful;
    }

    public static Collection getAllContainers(Resource resource, boolean forceCreate) {
        ArgCheck.isNotNull(resource);
        if (!(resource instanceof EmfResource)) {
            return Collections.EMPTY_LIST;
        }
        EmfResource emfResource = (EmfResource)resource;
        ArrayList<EObject> allContainers = new ArrayList<EObject>();
        ModelContents contents = ModelerCore.getModelEditor().getModelContents(emfResource);
        if (ModelResourceContainerFactory.supportsAnnotations(emfResource)) {
            allContainers.add(ModelResourceContainerFactory.getAnnotationContainer(resource, forceCreate));
            contents.getAnnotationContainer(forceCreate);
        }
        if (ModelResourceContainerFactory.supportsDiagrams(emfResource)) {
            allContainers.add(ModelResourceContainerFactory.getDiagramContainer(resource, forceCreate));
            contents.getDiagramContainer(forceCreate);
        }
        if (ModelResourceContainerFactory.supportsTransformations(emfResource)) {
            allContainers.add(ModelResourceContainerFactory.getTransformationContainer(resource, forceCreate));
            contents.getTransformationContainer(forceCreate);
        }
        if (ModelResourceContainerFactory.supportsMappingClassSets(emfResource)) {
            allContainers.add(ModelResourceContainerFactory.getMappingClassSetContainer(resource, forceCreate));
            contents.getMappingClassSetContainer(forceCreate);
        }
        if (allContainers.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return allContainers;
    }

    public static MappingClassSetContainer createMappingClassSetContainer(Resource resource) {
        ArgCheck.isNotNull(resource);
        if (!(resource instanceof EmfResource) || !ModelResourceContainerFactory.supportsMappingClassSets(resource)) {
            return null;
        }
        MappingClassSetContainer container = ModelResourceContainerFactory.getMappingClassSetContainer(resource);
        if (container == null) {
            EmfResource emfResource = (EmfResource)resource;
            container = transformationFactory.createMappingClassSetContainer();
            ModelResourceContainerFactory.addValue(emfResource, container, emfResource.getContents());
        }
        return container;
    }

    public static MappingClassSetContainer getMappingClassSetContainer(Resource resource, boolean forceCreate) {
        ArgCheck.isNotNull(resource);
        if (!(resource instanceof EmfResource) || !ModelResourceContainerFactory.supportsMappingClassSets(resource)) {
            return null;
        }
        MappingClassSetContainer container = ModelResourceContainerFactory.getMappingClassSetContainer(resource);
        if (container == null && forceCreate) {
            container = ModelResourceContainerFactory.createMappingClassSetContainer(resource);
        }
        return container;
    }

    public static MappingClassSetContainer getMappingClassSetContainer(List rootEObjects) {
        ArgCheck.isNotNull(rootEObjects);
        if (rootEObjects.isEmpty()) {
            return null;
        }
        ArrayList rootObjs = new ArrayList(rootEObjects);
        Iterator iter = rootObjs.iterator();
        while (iter.hasNext()) {
            EObject rootObj = (EObject)iter.next();
            if (!(rootObj instanceof MappingClassSetContainer)) continue;
            return (MappingClassSetContainer)rootObj;
        }
        return null;
    }

    public static MappingClassSetContainer getMappingClassSetContainer(Resource resource) {
        ArgCheck.isNotNull(resource);
        if (!(resource instanceof EmfResource)) {
            return null;
        }
        return ModelResourceContainerFactory.getMappingClassSetContainer(((EmfResource)resource).getContents());
    }

    public static TransformationContainer createTransformationContainer(Resource resource) {
        ArgCheck.isNotNull(resource);
        if (!(resource instanceof EmfResource) || !ModelResourceContainerFactory.supportsTransformations(resource)) {
            return null;
        }
        TransformationContainer container = ModelResourceContainerFactory.getTransformationContainer(resource);
        if (container == null) {
            EmfResource emfResource = (EmfResource)resource;
            container = transformationFactory.createTransformationContainer();
            ModelResourceContainerFactory.addValue(emfResource, container, emfResource.getContents());
        }
        return container;
    }

    public static TransformationContainer getTransformationContainer(Resource resource, boolean forceCreate) {
        ArgCheck.isNotNull(resource);
        if (!(resource instanceof EmfResource) || !ModelResourceContainerFactory.supportsTransformations(resource)) {
            return null;
        }
        TransformationContainer container = ModelResourceContainerFactory.getTransformationContainer(resource);
        if (container == null && forceCreate) {
            container = ModelResourceContainerFactory.createTransformationContainer(resource);
        }
        return container;
    }

    public static TransformationContainer getTransformationContainer(List rootEObjects) {
        ArgCheck.isNotNull(rootEObjects);
        if (rootEObjects.isEmpty()) {
            return null;
        }
        ArrayList rootObjs = new ArrayList(rootEObjects);
        Iterator iter = rootObjs.iterator();
        while (iter.hasNext()) {
            EObject rootObj = (EObject)iter.next();
            if (!(rootObj instanceof TransformationContainer)) continue;
            return (TransformationContainer)rootObj;
        }
        return null;
    }

    public static TransformationContainer getTransformationContainer(Resource resource) {
        ArgCheck.isNotNull(resource);
        if (!(resource instanceof EmfResource)) {
            return null;
        }
        return ModelResourceContainerFactory.getTransformationContainer(((EmfResource)resource).getContents());
    }

    public static DiagramContainer createDiagramContainer(Resource resource) {
        ArgCheck.isNotNull(resource);
        if (!(resource instanceof EmfResource) || !ModelResourceContainerFactory.supportsDiagrams(resource)) {
            return null;
        }
        DiagramContainer container = ModelResourceContainerFactory.getDiagramContainer(resource);
        if (container == null) {
            EmfResource emfResource = (EmfResource)resource;
            container = diagramFactory.createDiagramContainer();
            ModelResourceContainerFactory.addValue(emfResource, container, emfResource.getContents());
        }
        return container;
    }

    public static DiagramContainer getDiagramContainer(Resource resource, boolean forceCreate) {
        ArgCheck.isNotNull(resource);
        if (!(resource instanceof EmfResource) || !ModelResourceContainerFactory.supportsDiagrams(resource)) {
            return null;
        }
        DiagramContainer container = ModelResourceContainerFactory.getDiagramContainer(resource);
        if (container == null && forceCreate) {
            container = ModelResourceContainerFactory.createDiagramContainer(resource);
        }
        return container;
    }

    public static DiagramContainer getDiagramContainer(List rootEObjects) {
        ArgCheck.isNotNull(rootEObjects);
        if (rootEObjects.isEmpty()) {
            return null;
        }
        ArrayList rootObjs = new ArrayList(rootEObjects);
        Iterator iter = rootObjs.iterator();
        while (iter.hasNext()) {
            EObject rootObj = (EObject)iter.next();
            if (!(rootObj instanceof DiagramContainer)) continue;
            return (DiagramContainer)rootObj;
        }
        return null;
    }

    public static DiagramContainer getDiagramContainer(Resource resource) {
        ArgCheck.isNotNull(resource);
        if (!(resource instanceof EmfResource)) {
            return null;
        }
        return ModelResourceContainerFactory.getDiagramContainer(((EmfResource)resource).getContents());
    }

    public static AnnotationContainer createAnnotationContainer(Resource resource) {
        ArgCheck.isNotNull(resource);
        if (!(resource instanceof EmfResource) || !ModelResourceContainerFactory.supportsAnnotations(resource)) {
            return null;
        }
        AnnotationContainer container = ModelResourceContainerFactory.getAnnotationContainer(resource);
        if (container == null) {
            EmfResource emfResource = (EmfResource)resource;
            container = coreFactory.createAnnotationContainer();
            ModelResourceContainerFactory.addValue(emfResource, container, emfResource.getContents());
        }
        return container;
    }

    public static AnnotationContainer getAnnotationContainer(Resource resource, boolean forceCreate) {
        ArgCheck.isNotNull(resource);
        if (!(resource instanceof EmfResource) || !ModelResourceContainerFactory.supportsAnnotations(resource)) {
            return null;
        }
        AnnotationContainer container = ModelResourceContainerFactory.getAnnotationContainer(resource);
        if (container == null && forceCreate) {
            container = ModelResourceContainerFactory.createAnnotationContainer(resource);
        }
        return container;
    }

    public static AnnotationContainer getAnnotationContainer(List rootEObjects) {
        ArgCheck.isNotNull(rootEObjects);
        if (rootEObjects.isEmpty()) {
            return null;
        }
        ArrayList rootObjs = new ArrayList(rootEObjects);
        Iterator iter = rootObjs.iterator();
        while (iter.hasNext()) {
            EObject rootObj = (EObject)iter.next();
            if (!(rootObj instanceof AnnotationContainer)) continue;
            return (AnnotationContainer)rootObj;
        }
        return null;
    }

    public static AnnotationContainer getAnnotationContainer(Resource resource) {
        ArgCheck.isNotNull(resource);
        if (!(resource instanceof EmfResource)) {
            return null;
        }
        return ModelResourceContainerFactory.getAnnotationContainer(((EmfResource)resource).getContents());
    }

    public static boolean supportsDiagrams(Resource resource) {
        if (resource == null || !(resource instanceof EmfResource)) {
            return false;
        }
        EmfResource emfResource = (EmfResource)resource;
        boolean supportsDiagrams = false;
        try {
            if (emfResource.getModelAnnotation() != null) {
                MetamodelDescriptor descriptor;
                String stringURI = emfResource.getModelAnnotation().getPrimaryMetamodelUri();
                URI uri = ModelerCore.getMetamodelRegistry().getURI(stringURI);
                if (uri != null && (descriptor = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(uri)) != null) {
                    supportsDiagrams = descriptor.supportsDiagrams();
                }
            }
        }
        catch (ModelerCoreException err) {
            String message = ModelResourceContainerFactory.getString(GET_METAMODEL_DESCRIPTOR_ERROR_KEY, DIAGRAM_CONTAINER, resource);
            ModelerCore.Util.log(4, message);
        }
        return supportsDiagrams;
    }

    public static boolean supportsTransformations(Resource resource) {
        if (resource == null || !(resource instanceof EmfResource)) {
            return false;
        }
        EmfResource emfResource = (EmfResource)resource;
        boolean supportsTransformations = false;
        if (emfResource.getModelAnnotation() != null) {
            String stringURI;
            ModelType type = emfResource.getModelAnnotation().getModelType();
            if (type.equals(ModelType.VIRTUAL_LITERAL)) {
                supportsTransformations = true;
            } else if (type.equals(ModelType.LOGICAL_LITERAL) && XML_URI.equals(stringURI = emfResource.getModelAnnotation().getPrimaryMetamodelUri())) {
                supportsTransformations = true;
            }
        }
        return supportsTransformations;
    }

    public static boolean supportsMappingClassSets(Resource resource) {
        if (resource == null || !(resource instanceof EmfResource)) {
            return false;
        }
        EmfResource emfResource = (EmfResource)resource;
        boolean supportsMappingClassSets = false;
        if (emfResource.getModelAnnotation() != null) {
            ModelType type = emfResource.getModelAnnotation().getModelType();
            String stringURI = emfResource.getModelAnnotation().getPrimaryMetamodelUri();
            if (type.equals(ModelType.VIRTUAL_LITERAL)) {
                if (XML_URI.equals(stringURI)) {
                    supportsMappingClassSets = true;
                }
            } else if (type.equals(ModelType.LOGICAL_LITERAL) && XML_URI.equals(stringURI)) {
                supportsMappingClassSets = true;
            }
        }
        return supportsMappingClassSets;
    }

    public static boolean supportsAnnotations(Resource resource) {
        if (resource == null || !(resource instanceof EmfResource)) {
            return false;
        }
        EmfResource emfResource = (EmfResource)resource;
        boolean supportsAnnotations = false;
        if (emfResource.getModelAnnotation() != null) {
            ModelType type = emfResource.getModelAnnotation().getModelType();
            if (type.equals(ModelType.VIRTUAL_LITERAL)) {
                supportsAnnotations = true;
            } else if (type.equals(ModelType.PHYSICAL_LITERAL)) {
                supportsAnnotations = true;
            } else if (type.equals(ModelType.FUNCTION_LITERAL)) {
                supportsAnnotations = true;
            } else if (type.equals(ModelType.LOGICAL_LITERAL)) {
                supportsAnnotations = true;
            } else if (type.equals(ModelType.EXTENSION_LITERAL)) {
                supportsAnnotations = true;
            }
        }
        return supportsAnnotations;
    }

    public static Annotation createNewAnnotation() {
        return CoreFactory.eINSTANCE.createAnnotation();
    }

    public static Annotation createNewAnnotation(EObject target) {
        ArgCheck.isNotNull(target);
        Annotation newAnnotation = ModelResourceContainerFactory.createNewAnnotation();
        newAnnotation.setAnnotatedObject(target);
        return newAnnotation;
    }

    public static Annotation createNewAnnotation(EObject target, AnnotationContainer container) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(container);
        Annotation newAnnotation = ModelResourceContainerFactory.createNewAnnotation(target);
        ModelResourceContainerFactory.addValue(container, newAnnotation, container.getAnnotations());
        return newAnnotation;
    }

    public static Annotation createNewAnnotation(EObject target, Resource resource) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(resource);
        Annotation annotation = null;
        if (ModelResourceContainerFactory.supportsAnnotations(resource)) {
            AnnotationContainer container = ModelResourceContainerFactory.getAnnotationContainer(resource, true);
            if (container != null) {
                annotation = ModelResourceContainerFactory.createNewAnnotation(target, container);
            } else {
                String message = ModelResourceContainerFactory.getString(NO_ANNOTATION_CONTAINER_ERROR, resource, target);
                ModelerCore.Util.log(4, message);
            }
        }
        return annotation;
    }

    public static boolean deleteAnnotation(Annotation annotation) {
        ArgCheck.isNotNull(annotation);
        AnnotationContainer ac2 = (AnnotationContainer)annotation.eContainer();
        boolean successful = false;
        if (ac2 != null) {
            successful = ModelResourceContainerFactory.removeValue(ac2, annotation, ac2.getAnnotations());
        }
        return successful;
    }

    public static Diagram createNewDiagram() {
        return diagramFactory.createDiagram();
    }

    public static Diagram createNewDiagram(EObject target) {
        ArgCheck.isNotNull(target);
        Diagram newDiagram = ModelResourceContainerFactory.createNewDiagram();
        newDiagram.setTarget(target);
        return newDiagram;
    }

    public static Diagram createNewDiagram(EObject target, DiagramContainer container) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(container);
        Diagram newDiagram = ModelResourceContainerFactory.createNewDiagram(target);
        ModelResourceContainerFactory.addValue(container, newDiagram, container.getDiagram());
        return newDiagram;
    }

    public static Diagram createNewDiagram(EObject target, Resource resource) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(resource);
        if (ModelResourceContainerFactory.supportsDiagrams(resource)) {
            return ModelResourceContainerFactory.createNewDiagram(target, ModelResourceContainerFactory.getDiagramContainer(resource, true));
        }
        String message = ModelResourceContainerFactory.getString(DIAGRAMS_NOT_SUPPORTED_KEY, resource);
        ModelerCore.Util.log(2, message);
        return null;
    }

    public static Diagram createNewDiagram(EObject target, Resource resource, boolean persistent) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(resource);
        if (ModelResourceContainerFactory.supportsDiagrams(resource)) {
            if (persistent) {
                return ModelResourceContainerFactory.createNewDiagram(target, resource);
            }
            ModelContents contents = ModelerCore.getModelEditor().getModelContents(target);
            Diagram newDiagram = ModelResourceContainerFactory.createNewDiagram(target);
            contents.addTransientDiagram(newDiagram);
            return newDiagram;
        }
        String message = ModelResourceContainerFactory.getString(DIAGRAMS_NOT_SUPPORTED_KEY, resource);
        ModelerCore.Util.log(2, message);
        return null;
    }

    public static boolean deleteDiagram(Diagram diagram) {
        ArgCheck.isNotNull(diagram);
        DiagramContainer dc = (DiagramContainer)diagram.eContainer();
        boolean successful = false;
        if (dc != null) {
            successful = ModelResourceContainerFactory.removeValue(dc, diagram, dc.getDiagram());
        }
        return successful;
    }

    public static void setDiagramPersistence(Diagram diagram, Resource resource, boolean persistent) throws ModelWorkspaceException {
        ArgCheck.isNotNull(diagram);
        ArgCheck.isNotNull(resource);
        if (persistent == ModelResourceContainerFactory.isPersistent(diagram)) {
            return;
        }
        DiagramContainer container = ModelResourceContainerFactory.getDiagramContainer(resource, true);
        if (persistent) {
            if (container != null && !container.getDiagram().contains(diagram)) {
                ModelContents contents = ModelerCore.getModelEditor().getModelContents(container);
                contents.removeTransientDiagram(diagram);
                diagram.setDiagramContainer(container);
            }
        } else if (container != null && container.getDiagram().contains(diagram)) {
            ModelResourceContainerFactory.removeValue(container, diagram, container.getDiagram());
            ModelContents contents = ModelerCore.getModelEditor().getModelContents(container);
            contents.addTransientDiagram(diagram);
        }
    }

    public static boolean isPersistent(Diagram diagram) {
        ArgCheck.isNotNull(diagram);
        return diagram.eContainer() != null;
    }

    public static boolean deleteTransformation(TransformationMappingRoot transformation) {
        ArgCheck.isNotNull(transformation);
        TransformationContainer tc = (TransformationContainer)transformation.eContainer();
        boolean successful = false;
        if (tc != null) {
            successful = ModelResourceContainerFactory.removeValue(tc, transformation, tc.getTransformationMappings());
        }
        return successful;
    }

    public static SqlTransformationMappingRoot createNewSqlTransformationMappingRoot() {
        return transformationFactory.createSqlTransformationMappingRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlTransformationMappingRoot createNewSqlTransformationMappingRoot(EObject target, boolean isSignificant, Object txnSource) {
        ArgCheck.isNotNull(target);
        if (!SqlAspectHelper.isValidSqlTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(SQL_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        SqlTransformationMappingRoot transMappingRoot = null;
        Object source = txnSource;
        if (source == null) {
            source = target;
        }
        boolean requiresStart = ModelerCore.startTxn(isSignificant, true, "Create Sql Transformation Mapping Root", source);
        boolean succeeded = false;
        try {
            transMappingRoot = ModelResourceContainerFactory.createNewSqlTransformationMappingRoot(target, target.eResource());
            if (transMappingRoot != null) {
                succeeded = true;
            }
        }
        finally {
            if (requiresStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return transMappingRoot;
    }

    public static SqlTransformationMappingRoot createNewSqlTransformationMappingRoot(EObject target) {
        ArgCheck.isNotNull(target);
        if (!SqlAspectHelper.isValidSqlTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(SQL_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        SqlTransformationMappingRoot transMappingRoot = null;
        transMappingRoot = ModelResourceContainerFactory.createNewSqlTransformationMappingRoot();
        ModelResourceContainerFactory.addValue(transMappingRoot, target, transMappingRoot.getOutputs());
        transMappingRoot.setTarget(target);
        return transMappingRoot;
    }

    public static SqlTransformationMappingRoot createNewSqlTransformationMappingRoot(EObject target, TransformationContainer container) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(container);
        if (!SqlAspectHelper.isValidSqlTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(SQL_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        SqlTransformationMappingRoot transMappingRoot = ModelResourceContainerFactory.createNewSqlTransformationMappingRoot(target);
        ModelResourceContainerFactory.addValue(container, transMappingRoot, container.getTransformationMappings());
        return transMappingRoot;
    }

    public static SqlTransformationMappingRoot createNewSqlTransformationMappingRoot(EObject target, Resource resource) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(resource);
        if (!SqlAspectHelper.isValidSqlTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(SQL_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        return ModelResourceContainerFactory.createNewSqlTransformationMappingRoot(target, ModelResourceContainerFactory.getTransformationContainer(resource, true));
    }

    public static boolean isSqlTransformationMappingRoot(Object target) {
        return target instanceof SqlTransformationMappingRoot;
    }

    public static XQueryTransformationMappingRoot createNewXQueryTransformationMappingRoot() {
        return transformationFactory.createXQueryTransformationMappingRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XQueryTransformationMappingRoot createNewXQueryTransformationMappingRoot(EObject target, boolean isSignificant, Object txnSource) {
        ArgCheck.isNotNull(target);
        if (!SqlAspectHelper.isValidSqlTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(SQL_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        XQueryTransformationMappingRoot transMappingRoot = null;
        Object source = txnSource;
        if (source == null) {
            source = target;
        }
        boolean requiresStart = ModelerCore.startTxn(isSignificant, true, "Create XQuery Transformation Mapping Root", source);
        boolean succeeded = false;
        try {
            transMappingRoot = ModelResourceContainerFactory.createNewXQueryTransformationMappingRoot(target, target.eResource());
            if (transMappingRoot != null) {
                succeeded = true;
            }
        }
        finally {
            if (requiresStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return transMappingRoot;
    }

    public static XQueryTransformationMappingRoot createNewXQueryTransformationMappingRoot(EObject target) {
        ArgCheck.isNotNull(target);
        if (!SqlAspectHelper.isValidSqlTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(SQL_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        XQueryTransformationMappingRoot transMappingRoot = null;
        transMappingRoot = ModelResourceContainerFactory.createNewXQueryTransformationMappingRoot();
        ModelResourceContainerFactory.addValue(transMappingRoot, target, transMappingRoot.getOutputs());
        transMappingRoot.setTarget(target);
        return transMappingRoot;
    }

    public static XQueryTransformationMappingRoot createNewXQueryTransformationMappingRoot(EObject target, TransformationContainer container) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(container);
        if (!SqlAspectHelper.isValidSqlTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(SQL_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        XQueryTransformationMappingRoot transMappingRoot = ModelResourceContainerFactory.createNewXQueryTransformationMappingRoot(target);
        ModelResourceContainerFactory.addValue(container, transMappingRoot, container.getTransformationMappings());
        return transMappingRoot;
    }

    public static XQueryTransformationMappingRoot createNewXQueryTransformationMappingRoot(EObject target, Resource resource) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(resource);
        if (!SqlAspectHelper.isValidSqlTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(SQL_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        return ModelResourceContainerFactory.createNewXQueryTransformationMappingRoot(target, ModelResourceContainerFactory.getTransformationContainer(resource, true));
    }

    public static boolean isXQueryTransformationMappingRoot(Object target) {
        return target instanceof XQueryTransformationMappingRoot;
    }

    public static MappingHelper addMappingHelper(Object transMappingRoot) {
        XQueryTransformationMappingRoot xqueryTransMappingRoot;
        SqlTransformationMappingRoot sqlTransMappingRoot;
        ArgCheck.isNotNull(transMappingRoot);
        MappingHelper helper = null;
        if (ModelResourceContainerFactory.isSqlTransformationMappingRoot(transMappingRoot) && (helper = (sqlTransMappingRoot = (SqlTransformationMappingRoot)transMappingRoot).getHelper()) == null) {
            helper = transformationFactory.createSqlTransformation();
            sqlTransMappingRoot.setHelper(helper);
            ModelResourceContainerFactory.createNestedUserSqlTransformation(helper);
        }
        if (ModelResourceContainerFactory.isXQueryTransformationMappingRoot(transMappingRoot) && (helper = (xqueryTransMappingRoot = (XQueryTransformationMappingRoot)transMappingRoot).getHelper()) == null) {
            helper = transformationFactory.createXQueryTransformation();
            xqueryTransMappingRoot.setHelper(helper);
        }
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MappingHelper addMappingHelper(Object transMappingRoot, boolean isSignificant, Object txnSource) {
        SqlTransformationMappingRoot sqlTransMappingRoot;
        ArgCheck.isNotNull(transMappingRoot);
        MappingHelper helper = null;
        if (transMappingRoot != null && ModelResourceContainerFactory.isSqlTransformationMappingRoot(transMappingRoot) && (helper = (sqlTransMappingRoot = (SqlTransformationMappingRoot)transMappingRoot).getHelper()) == null) {
            Object source = txnSource;
            if (source == null) {
                source = transMappingRoot;
            }
            boolean requiresStart = ModelerCore.startTxn(false, true, "Create Transformation Mapping Helper", source);
            boolean succeeded = false;
            try {
                ModelResourceContainerFactory.addMappingHelper(transMappingRoot);
                succeeded = true;
            }
            finally {
                if (requiresStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return helper;
    }

    public static SqlTransformation createNestedUserSqlTransformation(MappingHelper sqlTransformation) {
        ArgCheck.isNotNull(sqlTransformation);
        SqlTransformation userSqlTrans = transformationFactory.createSqlTransformation();
        userSqlTrans.setNestedIn(sqlTransformation);
        return userSqlTrans;
    }

    public static TreeMappingRoot createNewTreeMappingRoot() {
        return transformationFactory.createTreeMappingRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeMappingRoot createNewTreeMappingRoot(EObject target, boolean isSignificant, Object txnSource) {
        ArgCheck.isNotNull(target);
        if (!SqlAspectHelper.isValidTreeTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(TREE_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        TreeMappingRoot treeMappingRoot = null;
        Object source = txnSource;
        if (source == null) {
            source = target;
        }
        boolean requiresStart = ModelerCore.startTxn(false, true, "Create Tree Mapping Root", source);
        boolean succeeded = false;
        try {
            treeMappingRoot = ModelResourceContainerFactory.createNewTreeMappingRoot(target, target.eResource());
            if (treeMappingRoot != null) {
                succeeded = true;
            }
        }
        finally {
            if (requiresStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return treeMappingRoot;
    }

    public static TreeMappingRoot createNewTreeMappingRoot(EObject target) {
        ArgCheck.isNotNull(target);
        if (!SqlAspectHelper.isValidTreeTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(TREE_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        TreeMappingRoot treeMappingRoot = ModelResourceContainerFactory.createNewTreeMappingRoot();
        treeMappingRoot.setTarget(target);
        return treeMappingRoot;
    }

    public static TreeMappingRoot createNewTreeMappingRoot(EObject target, TransformationContainer container) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(container);
        if (!SqlAspectHelper.isValidTreeTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(TREE_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        TreeMappingRoot transMappingRoot = ModelResourceContainerFactory.createNewTreeMappingRoot(target);
        ModelResourceContainerFactory.addValue(container, transMappingRoot, container.getTransformationMappings());
        return transMappingRoot;
    }

    public static TreeMappingRoot createNewTreeMappingRoot(EObject target, Resource resource) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(resource);
        if (!SqlAspectHelper.isValidTreeTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(TREE_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        return ModelResourceContainerFactory.createNewTreeMappingRoot(target, ModelResourceContainerFactory.getTransformationContainer(resource, true));
    }

    public static boolean isTreeMappingRoot(Object target) {
        return target instanceof TreeMappingRoot;
    }

    public static FragmentMappingRoot createNewFragmentMappingRoot() {
        return transformationFactory.createFragmentMappingRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FragmentMappingRoot createNewFragmentMappingRoot(EObject target, boolean isSignificant, Object txnSource) {
        ArgCheck.isNotNull(target);
        if (!SqlAspectHelper.isValidTreeTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(FRAGMENT_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        FragmentMappingRoot fragmentMappingRoot = null;
        Object source = txnSource;
        if (source == null) {
            source = target;
        }
        boolean requiresStart = ModelerCore.startTxn(false, true, "Create Fragment Mapping Root", source);
        boolean succeeded = false;
        try {
            fragmentMappingRoot = ModelResourceContainerFactory.createNewFragmentMappingRoot(target, target.eResource());
            if (fragmentMappingRoot != null) {
                succeeded = true;
            }
        }
        finally {
            if (requiresStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return fragmentMappingRoot;
    }

    public static FragmentMappingRoot createNewFragmentMappingRoot(EObject target) {
        ArgCheck.isNotNull(target);
        if (!SqlAspectHelper.isValidTreeTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(FRAGMENT_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        FragmentMappingRoot fragmentMappingRoot = transformationFactory.createFragmentMappingRoot();
        fragmentMappingRoot.setTarget(target);
        return fragmentMappingRoot;
    }

    public static FragmentMappingRoot createNewFragmentMappingRoot(EObject target, TransformationContainer container) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(container);
        if (!SqlAspectHelper.isValidTreeTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(FRAGMENT_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        FragmentMappingRoot fragmentMappingRoot = ModelResourceContainerFactory.createNewFragmentMappingRoot(target);
        ModelResourceContainerFactory.addValue(container, fragmentMappingRoot, container.getTransformationMappings());
        return fragmentMappingRoot;
    }

    public static FragmentMappingRoot createNewFragmentMappingRoot(EObject target, Resource resource) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(resource);
        if (!SqlAspectHelper.isValidTreeTransformationTarget(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(FRAGMENT_ROOT_TARGET_NOT_VALID_KEY, target));
        }
        return ModelResourceContainerFactory.createNewFragmentMappingRoot(target, ModelResourceContainerFactory.getTransformationContainer(resource, true));
    }

    public static boolean isFragmentMappingRoot(Object target) {
        return target instanceof FragmentMappingRoot;
    }

    public static MappingClassSet createNewMappingClassSet() {
        return TransformationFactory.eINSTANCE.createMappingClassSet();
    }

    public static MappingClassSet createNewMappingClassSet(EObject target) {
        ArgCheck.isNotNull(target);
        if (!SqlAspectHelper.isXmlDocument(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(XML_DOCUCUMENT_TARGET_NOT_VALID_KEY, target));
        }
        MappingClassSet newMappingClassSet = ModelResourceContainerFactory.createNewMappingClassSet();
        newMappingClassSet.setTarget(target);
        return newMappingClassSet;
    }

    public static MappingClassSet createNewMappingClassSet(EObject target, MappingClassSetContainer container) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(container);
        if (!SqlAspectHelper.isXmlDocument(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(XML_DOCUCUMENT_TARGET_NOT_VALID_KEY, target));
        }
        MappingClassSet mappingClassSet = ModelResourceContainerFactory.createNewMappingClassSet(target);
        mappingClassSet.setTarget(target);
        ModelResourceContainerFactory.addValue(container, mappingClassSet, container.getMappingClassSets());
        return mappingClassSet;
    }

    public static MappingClassSet createNewMappingClassSet(EObject target, Resource resource) {
        ArgCheck.isNotNull(target);
        ArgCheck.isNotNull(resource);
        MappingClassSet mappingClassSet = null;
        if (ModelResourceContainerFactory.supportsAnnotations(resource)) {
            MappingClassSetContainer container = ModelResourceContainerFactory.getMappingClassSetContainer(resource, true);
            if (container != null) {
                mappingClassSet = ModelResourceContainerFactory.createNewMappingClassSet(target, container);
            } else {
                String message = ModelResourceContainerFactory.getString(NO_MAPPING_CLASS_SET_CONTAINER_ERROR, resource, target);
                ModelerCore.Util.log(4, message);
            }
        }
        return mappingClassSet;
    }

    public static boolean deleteMappingClassSet(MappingClassSet mappingClassSet) {
        ArgCheck.isNotNull(mappingClassSet);
        MappingClassSetContainer mcsc = (MappingClassSetContainer)mappingClassSet.eContainer();
        boolean successful = false;
        if (mcsc != null) {
            successful = ModelResourceContainerFactory.removeValue(mcsc, mappingClassSet, mcsc.getMappingClassSets());
        }
        return successful;
    }

    public static MappingClassSet getMappingClassSet(EObject target, boolean forceCreate) {
        ArgCheck.isNotNull(target);
        if (!SqlAspectHelper.isXmlDocument(target)) {
            throw new IllegalArgumentException(ModelResourceContainerFactory.getString(XML_DOCUCUMENT_TARGET_NOT_VALID_KEY, target));
        }
        MappingClassSet mappingClassSet = null;
        Resource resource = target.eResource();
        if (resource != null) {
            MappingClassSetContainer container = ModelResourceContainerFactory.getMappingClassSetContainer(resource, true);
            List setList = ModelResourceContainerFactory.getMappingClassSets(resource, target);
            if (setList == null || setList.isEmpty()) {
                if (forceCreate) {
                    mappingClassSet = ModelResourceContainerFactory.createNewMappingClassSet(target, container);
                }
            } else {
                mappingClassSet = (MappingClassSet)setList.get(0);
            }
        }
        return mappingClassSet;
    }

    public static List getMappingClassSets(Resource resource, EObject target) {
        MappingClassSetContainer container = ModelResourceContainerFactory.getMappingClassSetContainer(resource, true);
        if (container != null) {
            ArrayList<MappingClassSet> result = new ArrayList<MappingClassSet>();
            Iterator iter = new ArrayList(container.eContents()).iterator();
            while (iter.hasNext()) {
                MappingClassSet mcSet = (MappingClassSet)iter.next();
                if (mcSet.getTarget() == null || !mcSet.getTarget().equals(target)) continue;
                result.add(mcSet);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }
}

