/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;

public class ModelStatistics {
    private int numResources;
    private final Map statsByMetaclass = new HashMap();
    private String desc;

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public Set getEClasses() {
        return this.statsByMetaclass.keySet();
    }

    public int getCount(EClass metaclass) {
        EClass key = metaclass;
        MetaclassStats stats = (MetaclassStats)this.statsByMetaclass.get(key);
        return stats != null ? stats.numInstances : 0;
    }

    public int getResourceCount() {
        return this.numResources;
    }

    public void set(EClass metaclass, int count) {
        ArgCheck.isNotNull(metaclass);
        if (count == 0) {
            this.statsByMetaclass.remove(metaclass);
            return;
        }
        MetaclassStats stats = (MetaclassStats)this.statsByMetaclass.get(metaclass);
        if (stats == null) {
            stats = new MetaclassStats(metaclass);
            this.statsByMetaclass.put(metaclass, stats);
        }
        stats.numInstances = count;
    }

    public void add(EClass metaclass, int increment) {
        ArgCheck.isNotNull(metaclass);
        if (increment == 0) {
            return;
        }
        MetaclassStats stats = (MetaclassStats)this.statsByMetaclass.get(metaclass);
        if (stats == null) {
            stats = new MetaclassStats(metaclass);
            this.statsByMetaclass.put(metaclass, stats);
        }
        stats.numInstances += increment;
    }

    public void setResourceCount(int count) {
        this.numResources = count;
    }

    public void addResourceCount(int increment) {
        this.numResources += increment;
    }

    public void clear() {
        this.statsByMetaclass.clear();
        this.numResources = 0;
    }

    public IStatus compare(ModelStatistics that) {
        ArgCheck.isNotNull(that);
        ArrayList<Status> problems = new ArrayList<Status>();
        if (this != that) {
            String thisDesc = this.getDescription();
            String thatDesc = that.getDescription();
            if (thisDesc == null || thisDesc.trim().length() == 0) {
                thisDesc = ModelerCore.Util.getString("ModelStatistics.DefaultDescriptionForThis");
            }
            if (thatDesc == null || thatDesc.trim().length() == 0) {
                thatDesc = ModelerCore.Util.getString("ModelStatistics.DefaultDescriptionForThat");
            }
            HashSet thatEClasses = new HashSet(that.getEClasses());
            HashSet thisEClasses = new HashSet(this.getEClasses());
            Iterator iter = thisEClasses.iterator();
            while (iter.hasNext()) {
                int thatCount;
                EClass metaclass = (EClass)iter.next();
                int thisCount = this.getCount(metaclass);
                if (thisCount != (thatCount = that.getCount(metaclass))) {
                    Object[] params = new Object[]{metaclass.getName(), thisDesc, new Integer(thisCount), thatDesc, new Integer(thatCount)};
                    String msg = ModelerCore.Util.getString("ModelStatistics.The_count_of_{0}_differed__{1}_{2},_{3}_{4}_3", params);
                    Status status = new Status(4, "com.metamatrix.modeler.core", 0, msg, null);
                    problems.add(status);
                }
                iter.remove();
                thatEClasses.remove(metaclass);
            }
            Iterator remainingThatIter = thatEClasses.iterator();
            while (remainingThatIter.hasNext()) {
                EClass metaclass = (EClass)remainingThatIter.next();
                int thisCount = this.getCount(metaclass);
                int thatCount = that.getCount(metaclass);
                Object[] params = new Object[]{metaclass.getName(), thisDesc, new Integer(thisCount), thatDesc, new Integer(thatCount)};
                String msg = ModelerCore.Util.getString("ModelStatistics.The_count_of_{0}_differed__{1}_{2},_{3}_{4}_4", params);
                Status status = new Status(4, "com.metamatrix.modeler.core", 0, msg, null);
                problems.add(status);
            }
        }
        if (problems.isEmpty()) {
            String msg = ModelerCore.Util.getString("ModelStatistics.Stats_were_same");
            return new Status(0, "com.metamatrix.modeler.core", 0, msg, null);
        }
        if (problems.size() == 1) {
            return (IStatus)problems.get(0);
        }
        IStatus[] children = problems.toArray(new IStatus[problems.size()]);
        String msg = ModelerCore.Util.getString("ModelStatistics.Multiple_differences_stats");
        MultiStatus result = new MultiStatus("com.metamatrix.modeler.core", 0, children, msg, null);
        return result;
    }

    protected class MetaclassStats {
        final EClassifier metaclass;
        int numInstances;

        MetaclassStats(EClassifier classifier) {
            this.metaclass = classifier;
        }
    }
}

