/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.util;

import com.metamatrix.core.util.ArgCheck;
import java.io.File;
import org.eclipse.emf.common.util.URI;

public class UriHelper {
    private UriHelper() {
    }

    public static URI makeAbsoluteUri(URI baseUri, URI theImportUri) {
        ArgCheck.isNotNull(baseUri);
        ArgCheck.isNotNull(theImportUri);
        String importUriString = URI.decode(theImportUri.toString());
        if (importUriString.startsWith("http:")) {
            return theImportUri;
        }
        URI importUri = theImportUri;
        if (baseUri.isHierarchical() && !baseUri.isRelative() && importUri.isRelative()) {
            importUri = importUri.resolve(baseUri);
        }
        return importUri;
    }

    public static URI makeAbsoluteUri(URI baseUri, String theImportUriString) {
        ArgCheck.isNotNull(baseUri);
        ArgCheck.isNotNull(theImportUriString);
        String importUriString = URI.decode(theImportUriString);
        if (importUriString.startsWith("http:")) {
            return URI.createURI(importUriString);
        }
        if (importUriString.startsWith("file:")) {
            return URI.createURI(importUriString);
        }
        return UriHelper.makeAbsoluteUri(baseUri, URI.createFileURI(importUriString));
    }

    public static String makeAbsolutePath(URI baseUri, URI theImportUri) {
        ArgCheck.isNotNull(baseUri);
        ArgCheck.isNotNull(theImportUri);
        String importUriString = URI.decode(theImportUri.toString());
        if (importUriString.startsWith("http:")) {
            return importUriString;
        }
        URI importUri = UriHelper.makeAbsoluteUri(baseUri, theImportUri);
        File f2 = new File(importUri.toFileString());
        return f2.getAbsolutePath();
    }

    public static String makeAbsolutePath(URI baseUri, String theImportUriString) {
        ArgCheck.isNotNull(baseUri);
        ArgCheck.isNotNull(theImportUriString);
        return UriHelper.makeAbsolutePath(baseUri.toFileString(), theImportUriString);
    }

    public static String makeAbsolutePath(String theBaseUriString, String theImportUriString) {
        ArgCheck.isNotNull(theBaseUriString);
        ArgCheck.isNotNull(theImportUriString);
        String baseUriString = URI.decode(theBaseUriString);
        String importUriString = URI.decode(theImportUriString);
        URI baseUri = URI.createFileURI(baseUriString);
        if (importUriString.startsWith("http:")) {
            return importUriString;
        }
        if (importUriString.startsWith("file:")) {
            return URI.createURI(importUriString).toFileString();
        }
        URI importUri = URI.createFileURI(importUriString);
        if (baseUri.isHierarchical() && !baseUri.isRelative() && importUri.isRelative()) {
            importUri = importUri.resolve(baseUri);
        }
        File f2 = new File(importUri.toFileString());
        return f2.getAbsolutePath();
    }

    public static URI makeRelativeUri(URI baseUri, URI theImportUri) {
        ArgCheck.isNotNull(baseUri);
        ArgCheck.isNotNull(theImportUri);
        String importUriString = URI.decode(theImportUri.toString());
        if (importUriString.startsWith("http:")) {
            return theImportUri;
        }
        URI importUri = theImportUri;
        if (importUri.isFile() && !importUri.isRelative()) {
            URI deresolvedURI;
            if (baseUri != null && !baseUri.isRelative() && baseUri.isHierarchical() && (deresolvedURI = importUri.deresolve(baseUri, true, true, false)).hasRelativePath()) {
                importUri = deresolvedURI;
            }
        } else {
            importUri = URI.createURI(importUriString);
        }
        return importUri;
    }

    public static URI makeRelativeUri(URI baseUri, String theImportUriString) {
        ArgCheck.isNotNull(baseUri);
        ArgCheck.isNotNull(theImportUriString);
        String importUriString = URI.decode(theImportUriString);
        if (importUriString.startsWith("http:")) {
            return URI.createURI(importUriString);
        }
        URI importUri = null;
        importUri = importUriString.startsWith("file:") ? URI.createURI(importUriString) : URI.createFileURI(importUriString);
        return UriHelper.makeRelativeUri(baseUri, importUri);
    }

    public static String makeRelativePath(URI baseUri, URI theImportUri) {
        ArgCheck.isNotNull(baseUri);
        ArgCheck.isNotNull(theImportUri);
        String importUriString = URI.decode(theImportUri.toString());
        if (importUriString.startsWith("http:")) {
            return importUriString;
        }
        URI importUri = UriHelper.makeRelativeUri(baseUri, theImportUri);
        return URI.decode(importUri.toString());
    }

    public static String makeRelativePath(URI baseUri, String theImportUriString) {
        ArgCheck.isNotNull(baseUri);
        ArgCheck.isNotNull(theImportUriString);
        return UriHelper.makeRelativePath(baseUri.toFileString(), theImportUriString);
    }

    public static String makeRelativePath(String theBaseUriString, String theImportUriString) {
        URI deresolvedURI;
        ArgCheck.isNotNull(theBaseUriString);
        ArgCheck.isNotNull(theImportUriString);
        String baseUriString = URI.decode(theBaseUriString);
        String importUriString = URI.decode(theImportUriString);
        URI baseUri = URI.createFileURI(baseUriString);
        if (importUriString.startsWith("http:")) {
            return importUriString;
        }
        URI importUri = null;
        importUri = importUriString.startsWith("file:") ? URI.createURI(importUriString) : URI.createFileURI(importUriString);
        if (importUri.isFile() && !importUri.isRelative() && baseUri != null && !baseUri.isRelative() && baseUri.isHierarchical() && (deresolvedURI = importUri.deresolve(baseUri, true, true, false)).hasRelativePath()) {
            importUri = deresolvedURI;
        }
        return URI.decode(importUri.toString());
    }
}

