/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.workspace;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceFilter;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;

public class ModelWorkspaceView {
    public static final boolean DEFAULT_RESTRICT_TO_MODEL_RESOURCES_ONLY = true;
    public static final ModelWorkspaceFilter SHOW_ALL_FILTER = new ModelWorkspaceFilter(){

        public boolean select(Object parentElement, Object element) {
            return true;
        }
    };
    private static final Object[] EMPTY_CHILDREN = new Object[0];
    final List filters = new LinkedList();
    final ModelWorkspace workspace = ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace();
    private boolean restrictedToModelResourcesOnly;

    public ModelWorkspaceView() {
        Assertion.isNotNull(this.workspace);
        this.restrictedToModelResourcesOnly = true;
    }

    public boolean isRestrictedToModelWorkspaceItemsOnly() {
        return this.restrictedToModelResourcesOnly;
    }

    public void setRestrictedToModelWorkspaceItemsOnly(boolean b2) {
        this.restrictedToModelResourcesOnly = b2;
    }

    public List getModelWorkspaceFilters() {
        return this.filters;
    }

    protected boolean isVisible(Object parent, Object object) {
        Iterator iter = this.filters.iterator();
        while (iter.hasNext()) {
            ModelWorkspaceFilter filter = (ModelWorkspaceFilter)iter.next();
            if (!filter.select(parent, object)) continue;
            return true;
        }
        return false;
    }

    public IPath getPath(Object object) {
        if (object instanceof ModelWorkspaceItem) {
            return ((ModelWorkspaceItem)object).getPath();
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            ModelEditor editor = ModelerCore.getModelEditor();
            ModelResource resource = editor.findModelResource(eObject);
            IPath modelPath = resource.getPath();
            IPath pathInModel = editor.getModelRelativePath(eObject);
            return modelPath.append(pathInModel);
        }
        return null;
    }

    public Object findObject(IPath path) throws ModelWorkspaceException {
        ArgCheck.isNotNull(path);
        String[] segments = path.segments();
        ModelWorkspaceItem object = this.workspace;
        for (int i2 = 0; i2 < segments.length; ++i2) {
            String segment = segments[i2];
            if (object instanceof ModelResource) {
                ModelResource modelResource = (ModelResource)object;
                IPath pathInModel = path.removeFirstSegments(i2);
                ModelEditor editor = ModelerCore.getModelEditor();
                return editor.findObjectByPath(modelResource, pathInModel);
            }
            if (!(object instanceof ModelWorkspaceItem)) continue;
            ModelWorkspaceItem item = object;
            object = item.getChild(segment);
        }
        return object;
    }

    public ModelResource findModelResourceForObject(IPath path) throws ModelWorkspaceException {
        ArgCheck.isNotNull(path);
        String[] segments = path.segments();
        ModelWorkspaceItem object = this.workspace;
        for (int i2 = 0; i2 < segments.length; ++i2) {
            String segment = segments[i2];
            if (object instanceof ModelResource) {
                return (ModelResource)object;
            }
            if (!(object instanceof ModelWorkspaceItem)) continue;
            ModelWorkspaceItem item = object;
            object = item.getChild(segment);
        }
        return null;
    }

    public Object[] getChildren(Object parent) throws ModelWorkspaceException {
        ArgCheck.isNotNull(parent);
        Object children = this.doGetChildren(parent);
        if (children == null) {
            return EMPTY_CHILDREN;
        }
        LinkedList<Object> results = new LinkedList<Object>();
        if (children instanceof Object[]) {
            Object[] childObjects = (Object[])children;
            boolean allChildren = true;
            for (int i2 = 0; i2 < childObjects.length; ++i2) {
                Object child = childObjects[i2];
                if (this.isVisible(parent, child)) {
                    results.add(child);
                    continue;
                }
                allChildren = false;
            }
            if (allChildren) {
                return childObjects;
            }
        } else if (children instanceof Collection) {
            Collection childrenList = (Collection)children;
            Iterator iter = childrenList.iterator();
            while (iter.hasNext()) {
                Object child = iter.next();
                if (!this.isVisible(parent, child)) continue;
                results.add(child);
            }
        }
        return results.toArray();
    }

    protected Object doGetChildren(Object parent) throws ModelWorkspaceException {
        if (parent instanceof EObject) {
            return ((EObject)parent).eContents();
        }
        if (parent instanceof ModelResource) {
            return ((ModelResource)parent).getEObjects();
        }
        if (parent instanceof ModelWorkspaceItem) {
            ModelWorkspaceItem mwsItem = (ModelWorkspaceItem)parent;
            ModelWorkspaceItem[] children = mwsItem.getChildren();
            if (this.restrictedToModelResourcesOnly) {
                return children;
            }
            HashSet<IResource> modelResources = new HashSet<IResource>();
            ArrayList<IAdaptable> results = new ArrayList<IAdaptable>();
            for (int i2 = 0; i2 < children.length; ++i2) {
                ModelWorkspaceItem item = children[i2];
                results.add(item);
                IResource iresource = item.getCorrespondingResource();
                if (iresource == null) continue;
                modelResources.add(iresource);
            }
            try {
                IResource iresource = mwsItem.getCorrespondingResource();
                if (iresource != null && iresource instanceof IContainer) {
                    IContainer container = (IContainer)iresource;
                    IResource[] resourceChildren = container.members();
                    for (int i3 = 0; i3 < resourceChildren.length; ++i3) {
                        IResource resource = resourceChildren[i3];
                        if (modelResources.contains(resource)) continue;
                        results.add(resource);
                    }
                }
            }
            catch (ModelWorkspaceException e2) {
                ModelerCore.Util.log(e2);
            }
            catch (CoreException e3) {
                ModelerCore.Util.log(e3);
            }
            return results;
        }
        return null;
    }

    public boolean hasChildren(Object element) throws ModelWorkspaceException {
        Object children = this.doGetChildren(element);
        if (children == EMPTY_CHILDREN) {
            return false;
        }
        if (children instanceof Object[]) {
            Object[] childObjects = (Object[])children;
            for (int i2 = 0; i2 < childObjects.length; ++i2) {
                Object child = childObjects[i2];
                if (!this.isVisible(element, child)) continue;
                return true;
            }
            return false;
        }
        if (children instanceof Collection) {
            Collection childrenList = (Collection)children;
            Iterator iter = childrenList.iterator();
            while (iter.hasNext()) {
                Object child = iter.next();
                if (!this.isVisible(element, child)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Object getParent(Object element) throws ModelWorkspaceException {
        ArgCheck.isNotNull(element);
        if (element instanceof EObject) {
            EObject obj = (EObject)element;
            EObject parentObject = obj.eContainer();
            if (parentObject != null) {
                return parentObject;
            }
            return this.workspace.findModelResource(obj);
        }
        if (element instanceof ModelWorkspaceItem) {
            return ((ModelWorkspaceItem)element).getParent();
        }
        return null;
    }
}

