/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.ExternalResourceDescriptor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.internal.core.ExternalResourceDescriptorImpl;
import com.metamatrix.modeler.internal.core.container.ContainerImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ExternalResourceLoader {
    protected static final String EXTENSION_CHAR = ".";
    protected static final String SUFFIX_JAR = ".JAR";
    protected static final String SUFFIX_ZIP = ".ZIP";
    protected static final String SUFFIX_VDB = ".VDB";
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$core$ExternalResourceDescriptorImpl;

    public Resource load(ExternalResourceDescriptor descriptor, Container container) throws ModelerCoreException {
        if (descriptor == null) {
            ArgCheck.isNotNull(descriptor, ModelerCore.Util.getString("ExternalResourceLoader.The_ExternalResourceDescriptor_reference_may_not_be_null_1"));
        }
        if (container == null) {
            ArgCheck.isNotNull(container, ModelerCore.Util.getString("ExternalResourceLoader.The_Container_reference_may_not_be_null_2"));
        }
        this.validateDescriptor(descriptor);
        String resourceUrl = descriptor.getResourceUrl();
        String resourceName = descriptor.getResourceName();
        String internalUri = descriptor.getInternalUri();
        String tempDirPath = this.getTempDirectoryPath(descriptor);
        File resourceFile = this.retrieveResourceFile(new File(resourceUrl), resourceName, tempDirPath);
        if (resourceFile == null) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.An_existing_resource_with_the_name_cannot_retrieved_from_{1}._7", resourceName, resourceUrl));
        }
        if (!ModelUtil.isModelFile(resourceFile)) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.The_external_resource_with_the_name_is_not_a_MetaMatrix_model_resource._8", resourceName));
        }
        return this.loadResource(container, resourceFile, internalUri);
    }

    public void validateDescriptor(ExternalResourceDescriptor descriptor) throws ModelerCoreException {
        if (descriptor == null) {
            ArgCheck.isNotNull(descriptor, ModelerCore.Util.getString("ExternalResourceLoader.The_ExternalResourceDescriptor_reference_may_not_be_null_1"));
        }
        if (descriptor.getResourceUrl() == null || descriptor.getResourceUrl().length() == 0) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.The_ExternalResourceDescriptor_may_not_have_a_null_or_empty_resource_URL_string_3"));
        }
        if (descriptor.getResourceName() == null || descriptor.getResourceName().length() == 0) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.The_ExternalResourceDescriptor_may_not_have_a_null_or_empty_resource_name_string_4"));
        }
        String resourceUrl = descriptor.getResourceUrl();
        String resourceName = descriptor.getResourceName();
        File f2 = new File(resourceUrl);
        if (!f2.exists()) {
            URL url = ClassLoader.getSystemResource(resourceUrl);
            if (url == null) {
                throw new IllegalArgumentException(ModelerCore.Util.getString("ExternalResourceLoader.The_resource_with_name_and_location_cannot_be_found_on_the_file_system._2", resourceName, resourceUrl));
            }
            String loc = url.getPath();
            ((ExternalResourceDescriptorImpl)descriptor).setResourceUrl(loc);
            f2 = new File(loc);
        }
        if (!(this.isArchiveFileName(resourceUrl) || f2.isDirectory() || f2.isFile() && f2.getName().equalsIgnoreCase(resourceName))) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.The_resource_with_name_and_location_cannot_be_processed_by_the_loader._6", resourceName, resourceUrl));
        }
    }

    protected File retrieveResourceFile(File resourceLocation, String resourceName, String tempDirectoryPath) throws ModelerCoreException {
        String resourceUrl;
        if (resourceLocation == null) {
            ArgCheck.isNotNull(resourceLocation, ModelerCore.Util.getString("ExternalResourceLoader.The_resource_location_string_may_not_be_null_9"));
        }
        if (resourceName == null) {
            ArgCheck.isNotNull(resourceName, ModelerCore.Util.getString("ExternalResourceLoader.The_resource_name_string_may_not_be_null_10"));
        }
        if (this.isArchiveFileName(resourceUrl = resourceLocation.getAbsolutePath())) {
            return this.retrieveResourceFromZip(resourceLocation, resourceName, tempDirectoryPath);
        }
        if (resourceLocation.isDirectory()) {
            return this.retrieveResourceFromFolder(resourceLocation, resourceName);
        }
        return resourceLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource loadResource(Container container, File resourceFile, String internalUri) throws ModelerCoreException {
        if (resourceFile == null) {
            ArgCheck.isNotNull(resourceFile, ModelerCore.Util.getString("ExternalResourceLoader.The_java.io.File_reference_may_not_be_null_11"));
        }
        if (!resourceFile.exists()) {
            ArgCheck.isTrue(resourceFile.exists(), ModelerCore.Util.getString("ExternalResourceLoader.The_java.io.File_reference_must_exist_12"));
        }
        try {
            ResourceSet resourceSet;
            Resource.Factory resourceFactory;
            URI physicalURI = URI.createFileURI(resourceFile.getAbsolutePath());
            URI logicalURI = null;
            if (internalUri != null && internalUri.length() > 0) {
                logicalURI = URI.createURI(internalUri);
            }
            Resource externalResource = null;
            if (logicalURI != null && container instanceof ContainerImpl && (resourceFactory = (resourceSet = ((ContainerImpl)container).getResourceSet()).getResourceFactoryRegistry().getFactory(physicalURI)) != null) {
                FileInputStream fis;
                block13: {
                    externalResource = resourceFactory.createResource(logicalURI);
                    resourceSet.getResources().add(externalResource);
                    fis = null;
                    InputStream bis = null;
                    try {
                        fis = new FileInputStream(resourceFile);
                        bis = new BufferedInputStream(fis);
                        Map options = externalResource.getResourceSet() != null ? externalResource.getResourceSet().getLoadOptions() : Collections.EMPTY_MAP;
                        externalResource.load(bis, options);
                        Object var13_13 = null;
                        if (bis == null) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        if (bis != null) {
                            bis.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                        throw throwable;
                    }
                    bis.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            if (externalResource == null) {
                externalResource = container.getResource(physicalURI, true);
                if (logicalURI != null) {
                    container.getURIConverter().getURIMap().put(logicalURI, physicalURI);
                }
            }
            return externalResource;
        }
        catch (Throwable e2) {
            throw new ModelerCoreException(e2, ModelerCore.Util.getString("ExternalResourceLoader.Error_loading_the_external_resource_into_the_container._13", resourceFile));
        }
    }

    protected File retrieveResourceFromFolder(File folder, String fileName) throws ModelerCoreException {
        File[] files = folder.listFiles();
        for (int i2 = 0; i2 < files.length; ++i2) {
            File f2 = files[i2];
            if (!f2.isFile() || !f2.exists() || !f2.getName().equalsIgnoreCase(fileName)) continue;
            return f2;
        }
        throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.An_existing_file_with_the_name_cannot_be_found_under_the_directory._14", fileName, folder));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File retrieveResourceFromZip(File zip, String zipEntryName, String tempDirectoryLocation) throws ModelerCoreException {
        ZipFile zipFile = null;
        try {
            try {
                byte[] buffer;
                ZipEntry entry;
                zipFile = new ZipFile(zip);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                do {
                    if (!entries.hasMoreElements()) throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.An_existing_entry_with_the_name_cannot_be_found_in_the_archive._15", zipEntryName, zip));
                    entry = entries.nextElement();
                    if (entry != null) continue;
                    throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.An_existing_entry_with_the_name_cannot_be_found_in_the_archive._15", zipEntryName, zip));
                } while (!entry.getName().equalsIgnoreCase(zipEntryName));
                InputStream inputStream = zipFile.getInputStream(entry);
                int length = (int)entry.getSize();
                if (length >= 0) {
                    int n2;
                    buffer = new byte[length];
                    int offset = 0;
                    do {
                        n2 = inputStream.read(buffer, offset, length);
                        offset += n2;
                    } while ((length -= n2) > 0);
                } else {
                    int n3;
                    buffer = new byte[1024];
                    while ((n3 = inputStream.read(buffer, 0, 1024)) >= 0) {
                    }
                }
                File extractDirectory = new File(tempDirectoryLocation);
                if (!extractDirectory.exists()) {
                    extractDirectory.mkdir();
                }
                String entryName = new Path(entry.getName()).lastSegment();
                File entryFile = new File(extractDirectory + File.separator + entryName);
                entryFile.createNewFile();
                entryFile.deleteOnExit();
                FileOutputStream outputStream = new FileOutputStream(entryFile);
                outputStream.write(buffer);
                outputStream.flush();
                outputStream.close();
                File file = entryFile;
                Object var16_18 = null;
                try {
                    if (zipFile == null) return file;
                    zipFile.close();
                    return file;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return file;
            }
            catch (Throwable e3) {
                throw new ModelerCoreException(e3, ModelerCore.Util.getString("ExternalResourceLoader.An_existing_entry_with_the_name_cannot_be_found_in_the_archive._16", zipEntryName, zip));
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            try {}
            catch (IOException e2) {
                throw throwable;
            }
            if (zipFile == null) throw throwable;
            zipFile.close();
            throw throwable;
        }
    }

    protected String getTempDirectoryPath(ExternalResourceDescriptor descriptor) {
        if (descriptor == null) {
            ArgCheck.isNotNull(descriptor, ModelerCore.Util.getString("ExternalResourceLoader.The_ExternalResourceDescriptor_reference_may_not_be_null_1"));
        }
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$internal$core$ExternalResourceDescriptorImpl == null ? (class$com$metamatrix$modeler$internal$core$ExternalResourceDescriptorImpl = ExternalResourceLoader.class$("com.metamatrix.modeler.internal.core.ExternalResourceDescriptorImpl")) : class$com$metamatrix$modeler$internal$core$ExternalResourceDescriptorImpl, descriptor, ModelerCore.Util.getString("ExternalResourceLoader.The_ExternalResourceDescriptor_must_be_an_instanceof_ExternalResourceDescriptorImpl_1"));
        ExternalResourceDescriptorImpl descriptorImpl = (ExternalResourceDescriptorImpl)descriptor;
        String tempDirPath = descriptorImpl.getTempDirectoryPath();
        if (tempDirPath == null || tempDirPath.length() == 0) {
            try {
                tempDirPath = File.createTempFile("temp", null).getParent();
            }
            catch (IOException err) {
                tempDirPath = System.getProperty("user.dir");
            }
        }
        return tempDirPath;
    }

    protected boolean isArchiveFileName(String name) {
        if (StringUtil.isEmpty(name)) {
            return false;
        }
        String upperCaseName = name.toUpperCase();
        return upperCaseName.endsWith(SUFFIX_JAR) || upperCaseName.endsWith(SUFFIX_ZIP) || upperCaseName.endsWith(SUFFIX_VDB);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

