/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.association;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.association.AssociationDescriptor;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractAssociationDescriptor
implements AssociationDescriptor {
    protected static final AssociationDescriptor[] EMPTY_ARRAY = new AssociationDescriptor[0];
    private static final String PLUGIN_ID = "com.metamatrix.modeler.core";
    private EObject newAssociation;
    private List eObjects;
    private IStatus status;
    private ObjectVector children;
    private boolean ambiguous;
    private boolean creationComplete;

    protected AbstractAssociationDescriptor(List eObjects) {
        ArgCheck.isNotNull(eObjects);
        this.eObjects = eObjects;
        this.status = new Status(0, PLUGIN_ID, -1, "", null);
        this.children = null;
        this.ambiguous = false;
    }

    public abstract Object getImage();

    public abstract String getText();

    public abstract boolean isComplete();

    public boolean creationComplete() {
        return this.creationComplete;
    }

    public void setCreationComplete(boolean complete) {
        this.creationComplete = complete;
    }

    public abstract String getType();

    public AssociationDescriptor[] getChildren() {
        if (this.children == null || this.children.size() == 0) {
            return EMPTY_ARRAY;
        }
        Object[] result = new AssociationDescriptor[this.children.size()];
        this.children.copyInto(result);
        return result;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public boolean isAmbiguous() {
        return this.ambiguous;
    }

    public abstract EObject create() throws ModelerCoreException;

    public abstract boolean canCreate();

    public List getEObjects() {
        return this.eObjects;
    }

    public void setAmbiguous(boolean b2) {
        this.ambiguous = b2;
    }

    public void updateStatus(IStatus s2) {
        if (s2 != null) {
            if (this.status.isMultiStatus()) {
                MultiStatus multiStatus = (MultiStatus)this.status;
                if (s2.isMultiStatus()) {
                    multiStatus.addAll(s2);
                } else {
                    multiStatus.add(s2);
                }
            } else {
                this.status = s2;
            }
        }
    }

    public void updateStatus(int severity, int code, String msg, Throwable e2) {
        ArgCheck.isNotNull(msg);
        this.updateStatus(new Status(severity, PLUGIN_ID, code, msg, e2));
    }

    public void addDescriptor(AssociationDescriptor descriptor) {
        if (this.children == null) {
            this.children = new ObjectVector();
        }
        if (!this.children.contains(descriptor)) {
            this.children.add(descriptor);
        }
    }

    public EObject getNewAssociation() {
        return this.newAssociation;
    }

    public void setAssociation(EObject association) {
        this.newAssociation = association;
    }
}

