/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.core.index.IDocument;
import com.metamatrix.core.index.IIndexerOutput;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.internal.core.index.WordEntry;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.DuplicateResourceException;
import com.metamatrix.modeler.core.index.ModelDocument;
import com.metamatrix.modeler.core.index.ResourceIndexer;
import com.metamatrix.modeler.core.util.ModelObjectCollector;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.index.ModelDocumentImpl;
import com.metamatrix.modeler.internal.core.index.ResourceDocumentImpl;
import com.metamatrix.modeler.internal.core.index.WordEntryComparator;
import com.metamatrix.modeler.internal.core.metadata.runtime.RuntimeAdapter;
import com.metamatrix.modeler.internal.core.workspace.WorkspaceResourceFinderUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelIndexer
implements ResourceIndexer {
    public static boolean PRINT_INDEX_CONTENTS = false;
    private static final String[] FILE_TYPES = new String[]{"model"};
    private static String INDEX_TYPES = ModelerCore.Util.getString("ModelIndexer.Metadata_Indexes_1");

    public String getIndexType() {
        return INDEX_TYPES;
    }

    public String[] getFileTypes() {
        return FILE_TYPES;
    }

    public void setFileTypes(String[] fileTypes) {
    }

    public boolean shouldIndex(IDocument document) {
        return document instanceof ModelDocument;
    }

    public final void index(IDocument document, IIndexerOutput output) throws IOException {
        ArgCheck.isNotNull(document);
        ArgCheck.isNotNull(output);
        if (!this.shouldIndex(document)) {
            return;
        }
        ArrayList indexWords = new ArrayList();
        this.addResourceWordEntries(document, indexWords);
        if (document instanceof ModelDocument) {
            ModelDocument modelDocument = (ModelDocument)document;
            String modelPath = ((Object)modelDocument.getIResource().getFullPath()).toString();
            Resource emfResource = modelDocument.getResource();
            ModelObjectCollector moc = new ModelObjectCollector(emfResource);
            List eObjects = moc.getEObjects();
            Iterator iter = eObjects.iterator();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                this.addIndexWord(eObject, modelPath, indexWords);
            }
        }
        this.sortWordEntries(indexWords);
        output.addDocument(document);
        this.addEntries(output, indexWords);
        if (PRINT_INDEX_CONTENTS) {
            this.printWordEntryList(indexWords, System.out);
        }
        indexWords = null;
    }

    public void indexResource(IResource resource, boolean reuseExistingFile, boolean addResource) throws ModelerCoreException {
        Resource emfResource;
        ModelResource mResource;
        block11: {
            ArgCheck.isNotNull(resource);
            ModelWorkspace workspace = ModelerCore.getModelWorkspace();
            mResource = workspace.findModelResource(resource);
            emfResource = null;
            if (mResource != null) {
                try {
                    emfResource = mResource.getEmfResource();
                }
                catch (ModelWorkspaceException err) {
                    Throwable wrapped = err.getException();
                    if (wrapped instanceof DuplicateResourceException) break block11;
                    throw err;
                }
            }
        }
        IPath path = resource.getFullPath();
        try {
            String fileName = this.getIndexFileName(path);
            String indexFilePath = IndexUtil.getIndexFilePath(IndexUtil.INDEX_PATH, fileName);
            if (ModelerCore.DEBUG || ModelerCore.DEBUG_PROJECT_BUILDER) {
                Object[] params = new Object[]{fileName, path};
                String msg = ModelerCore.Util.getString("IndexUtil.DEBUG.Creating_index_file_0_for_resource_1_1", params);
                ModelerCore.Util.log(1, msg);
            }
            ResourceDocumentImpl document = null;
            if (emfResource != null) {
                document = mResource != null ? new ModelDocumentImpl(path.toFile(), resource, emfResource) : new ResourceDocumentImpl(path.toFile(), resource);
            }
            if (document != null) {
                Index runtimeIndex = new Index(indexFilePath, reuseExistingFile);
                if (addResource) {
                    runtimeIndex.add(document, this);
                } else {
                    runtimeIndex.remove(document.getName());
                }
                runtimeIndex.save();
            }
            if (mResource != null) {
                this.setIndexType(mResource);
            }
        }
        catch (Exception e2) {
            Status status = new Status(4, "com.metamatrix.modeler.core", 0, ModelerCore.Util.getString("ModelBuilder.IO_Error_trying_to_index_an_EmfResource_2"), e2);
            throw new ModelerCoreException(status);
        }
    }

    public void indexResource(IPath path, boolean reuseExistingFile, boolean addResource) throws ModelerCoreException {
        ArgCheck.isNotNull(path);
        IResource resource = WorkspaceResourceFinderUtil.findIResourceByPath(path);
        this.indexResource(resource, reuseExistingFile, addResource);
    }

    protected void setIndexType(ModelResource resource) {
        ArgCheck.isNotNull(resource);
        if (resource.getIndexType() == 0) {
            resource.setIndexType(1);
        } else if (resource.getIndexType() == 2) {
            resource.setIndexType(3);
        }
    }

    protected String getIndexFileName(IPath path) {
        return IndexUtil.getIndexFileName(((Object)path).toString(), "INDEX");
    }

    protected void addIndexWord(EObject eObject, String modelPath, List wordEntries) {
        RuntimeAdapter.addIndexWord(eObject, null, modelPath, wordEntries, false);
    }

    protected void sortWordEntries(List wordEntries) {
        WordEntryComparator wComparator = new WordEntryComparator();
        Collections.sort(wordEntries, wComparator);
    }

    protected void addResourceWordEntries(IDocument document, List wordEntries) {
    }

    private void addEntries(IIndexerOutput output, List entries) {
        Iterator entryIter = entries.iterator();
        while (entryIter.hasNext()) {
            WordEntry entry = (WordEntry)entryIter.next();
            output.addRef(entry.getWord());
        }
    }

    private void printWordEntryList(List wordEntries, PrintStream stream) {
        Iterator iter = wordEntries.iterator();
        while (iter.hasNext()) {
            WordEntry entry = (WordEntry)iter.next();
            stream.println(entry.toString());
        }
    }
}

