/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.internal.core.index.Index;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.TransactionRunnable;
import com.metamatrix.modeler.core.transaction.UnitOfWork;
import com.metamatrix.modeler.internal.core.builder.ModelBuildUtil;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.index.TargetLocationIndexSelector;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class ModelWorkspaceIndexSelector
extends TargetLocationIndexSelector {
    public ModelWorkspaceIndexSelector() {
        super(IndexUtil.INDEX_PATH);
    }

    public Index[] getIndexes() throws IOException {
        boolean indexesUpdated = this.updateIndexes();
        if (indexesUpdated) {
            this.setIndexes(null);
        }
        return super.getIndexes();
    }

    private boolean updateIndexes() {
        try {
            final Collection nonIndexedResources = ModelWorkspaceManager.getModelWorkspaceManager().getNonIndexedResources(1);
            if (nonIndexedResources != null && !nonIndexedResources.isEmpty()) {
                TransactionRunnable runnable = new TransactionRunnable(){

                    public Object run(UnitOfWork uow) throws ModelerCoreException {
                        ModelBuildUtil.createModelIndexes(null, nonIndexedResources);
                        return null;
                    }
                };
                ModelerCore.getModelEditor().executeAsTransaction(runnable, "Updating ModelIndexes", false, false, (Object)this);
                return true;
            }
        }
        catch (CoreException e2) {
            ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ModelWorkspaceIndexSelector.0"));
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ModelWorkspaceIndexSelector [");
        Index[] indexes = EMPTY_INDEX_ARRAY;
        try {
            indexes = this.getIndexes();
        }
        catch (IOException e2) {
            // empty catch block
        }
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(indexes[i2].getIndexFile());
        }
        sb.append("]");
        return sb.toString();
    }

    protected FilenameFilter getIndexFileFilter() {
        return IndexFilter.FILTER_INSTANCE;
    }

    public static class IndexFilter
    implements FilenameFilter {
        public static IndexFilter FILTER_INSTANCE = new IndexFilter();

        public boolean accept(File dir, String name) {
            Path path = new Path(name);
            String extension = path.getFileExtension();
            return extension != null && extension.equals("INDEX");
        }
    }
}

