/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.TempDirectory;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.internal.core.index.AbstractIndexSelector;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.metadata.runtime.FileRecordImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RuntimeIndexSelector
extends AbstractIndexSelector {
    private static final Random random = new Random(System.currentTimeMillis());
    protected Index[] indexes;
    private Object indexesLock = new Object();
    protected File vdbFile;
    protected String indexDirectoryPath;
    private long fileSize;
    private TempDirectory tempDirectory;

    public RuntimeIndexSelector(String filePath) {
        boolean isvalid;
        ArgCheck.isNotNull(filePath);
        this.vdbFile = new File(filePath);
        if (!this.vdbFile.exists()) {
            ArgCheck.isTrue(this.vdbFile.exists(), ModelerCore.Util.getString("RuntimeIndexSelector.No_file/directory_exists_at_the_given_location__1") + filePath);
        }
        if (this.vdbFile.isFile() && !(isvalid = this.checkValidType(this.vdbFile))) {
            ArgCheck.isTrue(isvalid, ModelerCore.Util.getString("RuntimeIndexSelector.Invalid_file_type,_expected_an_archive_file_or_an_index_file__2") + filePath);
        }
    }

    public RuntimeIndexSelector(String vdbName, byte[] contents) throws IOException {
        ArgCheck.isNotNull(vdbName);
        ArgCheck.isNotNull(contents);
        try {
            boolean isvalid;
            this.save(vdbName, contents);
            if (this.vdbFile.isFile() && !(isvalid = this.checkValidType(this.vdbFile))) {
                ArgCheck.isTrue(isvalid, ModelerCore.Util.getString("RuntimeIndexSelector.Invalid_file_type,_expected_an_archive_file_or_an_index_file__2") + this.vdbFile);
            }
        }
        catch (IOException e2) {
            this.clearVDB();
            throw e2;
        }
    }

    public RuntimeIndexSelector(URL vdbUrl) throws IOException {
        ArgCheck.isNotNull(vdbUrl);
        try {
            boolean isvalid;
            this.save(vdbUrl);
            if (this.vdbFile.isFile() && !(isvalid = this.checkValidType(this.vdbFile))) {
                ArgCheck.isTrue(isvalid, ModelerCore.Util.getString("RuntimeIndexSelector.Invalid_file_type,_expected_an_archive_file_or_an_index_file__2") + this.vdbFile);
            }
        }
        catch (IOException e2) {
            this.clearVDB();
            throw e2;
        }
    }

    private void save(String vdbName, byte[] contents) throws IOException {
        String vdbFilePath = this.getIndexDirectoryPath() + '/' + vdbName;
        this.vdbFile = new File(vdbFilePath);
        FileUtils.write(contents, this.vdbFile);
    }

    private void save(URL vdbUrl) throws IOException {
        String vdbPath = vdbUrl.getPath();
        int index = vdbPath.lastIndexOf(47);
        String vdbName = vdbPath.substring(index + 1);
        InputStream vdbStream = vdbUrl.openStream();
        String vdbFilePath = this.getIndexDirectoryPath() + '/' + vdbName;
        this.vdbFile = new File(vdbFilePath);
        FileUtils.write(vdbStream, this.vdbFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index[] getIndexes() throws IOException {
        if (this.indexes == null) {
            Object object = this.indexesLock;
            synchronized (object) {
                if (this.indexes == null) {
                    this.init();
                }
            }
        }
        return this.indexes;
    }

    public void clearVDB() {
        if (this.tempDirectory != null) {
            this.tempDirectory.remove();
            this.tempDirectory = null;
            this.indexDirectoryPath = null;
        }
        if (this.indexDirectoryPath != null) {
            File indexDirectory = new File(this.indexDirectoryPath);
            RuntimeIndexSelector.clear(indexDirectory);
            this.indexDirectoryPath = null;
        }
        this.setValid(false);
    }

    private static void clear(File file) {
        if (file.exists()) {
            File[] indexFiles;
            if (file.isDirectory() && (indexFiles = file.listFiles()) != null) {
                for (int i2 = 0; i2 < indexFiles.length; ++i2) {
                    File indexFile = indexFiles[i2];
                    RuntimeIndexSelector.clear(indexFile);
                }
            }
            if (!file.delete()) {
                RuntimeIndexSelector.clearOnExit(file);
            }
        }
    }

    private static void clearOnExit(File file) {
        if (file.exists()) {
            File[] indexFiles;
            if (file.isDirectory() && (indexFiles = file.listFiles()) != null) {
                for (int i2 = 0; i2 < indexFiles.length; ++i2) {
                    File indexFile = indexFiles[i2];
                    RuntimeIndexSelector.clearOnExit(indexFile);
                }
            }
            file.deleteOnExit();
        }
    }

    protected void init() throws IOException {
        this.indexes = this.isArchive(this.vdbFile) ? this.loadIndexesFromZip(this.vdbFile) : (this.vdbFile.isDirectory() ? this.loadIndexesFromFolder(this.vdbFile) : this.loadIndexesFromFile(this.vdbFile));
    }

    protected Index[] loadIndexesFromFile(File file) throws IOException {
        ObjectVector tmp = new ObjectVector();
        if (IndexUtil.indexFileExists(file.getAbsolutePath())) {
            tmp.add(new Index(file.getAbsolutePath(), true));
        }
        Object[] result = new Index[tmp.size()];
        tmp.copyInto(result);
        return result;
    }

    protected Index[] loadIndexesFromFolder(File folder) throws IOException {
        ObjectVector tmp = new ObjectVector();
        File[] files = folder.listFiles();
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (!IndexUtil.indexFileExists(files[i2].getAbsolutePath())) continue;
            tmp.add(new Index(files[i2].getAbsolutePath(), true));
        }
        Object[] result = new Index[tmp.size()];
        tmp.copyInto(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Index[] loadIndexesFromZip(File zip) throws IOException {
        Object[] objectArray;
        InputStream zipInputStream;
        block5: {
            ZipFile zipFile = null;
            zipInputStream = null;
            try {
                zipFile = new ZipFile(zip);
                ObjectVector tmp = new ObjectVector();
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!this.shouldExtract(entry)) continue;
                    zipInputStream = zipFile.getInputStream(entry);
                    int length = entry.getSize() >= 0L ? (int)entry.getSize() : FileUtils.DEFAULT_BUFFER_SIZE;
                    File entryFile = new File(this.getIndexDirectoryPath(), entry.getName());
                    FileUtils.write(zipInputStream, entryFile, length);
                    if (!IndexUtil.indexFileExists(entryFile)) continue;
                    tmp.add(new Index(entryFile.getAbsolutePath(), true));
                }
                Object[] result = new Index[tmp.size()];
                tmp.copyInto(result);
                objectArray = result;
                Object var10_9 = null;
                if (zipFile == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var10_10 = null;
                    if (zipFile != null) {
                        zipFile.close();
                    }
                    if (zipInputStream == null) break block6;
                    zipInputStream.close();
                }
                throw throwable;
            }
            zipFile.close();
        }
        if (zipInputStream != null) {
            zipInputStream.close();
        }
        return objectArray;
    }

    private boolean shouldExtract(ZipEntry entry) {
        return true;
    }

    public String[] getFilePaths() {
        try {
            ZipFile zipFile = new ZipFile(this.vdbFile);
            ArrayList<String> filePaths = new ArrayList<String>();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                char firstChar = entryName.charAt(0);
                if (firstChar != '/') {
                    entryName = '/' + entryName;
                }
                filePaths.add(entryName);
            }
            Collections.sort(filePaths);
            return filePaths.toArray(new String[filePaths.size()]);
        }
        catch (IOException e2) {
            ModelerCore.Util.log(e2);
            return super.getFilePaths();
        }
    }

    public List getFileContentsAsString(List paths) {
        ArgCheck.isNotEmpty(paths);
        ArrayList<String> contents = new ArrayList<String>(paths.size());
        Iterator pathIter = paths.iterator();
        while (pathIter.hasNext()) {
            String relativePath = (String)pathIter.next();
            String fileContent = this.getFileContentAsString(relativePath);
            if (fileContent == null) continue;
            contents.add(fileContent);
        }
        return contents;
    }

    public InputStream getFileContent(String path) {
        ArgCheck.isNotNull(path);
        File file = new File(this.getIndexDirectoryPath(), path);
        if (file.exists()) {
            this.fileSize = file.length();
            try {
                return new FileInputStream(file);
            }
            catch (IOException e2) {
                ModelerCore.Util.log(e2);
            }
        }
        return null;
    }

    public File getFile(String path) {
        ArgCheck.isNotNull(path);
        File file = new File(this.getIndexDirectoryPath(), path);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public String getFileContentAsString(String path) {
        ArgCheck.isNotNull(path);
        File file = new File(this.getIndexDirectoryPath(), path);
        if (file.exists()) {
            FileUtil fileUtil = new FileUtil(file.getPath());
            try {
                String fileContent = fileUtil.readSafe();
                this.fileSize = fileContent.length();
                return fileContent;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return null;
    }

    public InputStream getFileContent(String path, String[] tokens, String[] tokenReplacements) {
        ArgCheck.isNotNull(tokens);
        ArgCheck.isNotNull(tokenReplacements);
        Assertion.isEqual(tokens.length, tokenReplacements.length);
        String fileContents = this.getFileContentAsString(path);
        if (fileContents != null) {
            for (int i2 = 0; i2 < tokens.length; ++i2) {
                String token = tokens[i2];
                String tokenReplacement = tokenReplacements[i2];
                fileContents = StringUtil.replaceAll(fileContents, token, tokenReplacement);
            }
            this.fileSize = fileContents.length();
            return new ByteArrayInputStream(fileContents.getBytes());
        }
        return null;
    }

    public long getFileSize(String path) {
        return this.fileSize;
    }

    public Collection getFileRecords(String filePath) {
        HashSet<FileRecordImpl> fileRecords = new HashSet<FileRecordImpl>();
        File directory = new File(this.getIndexDirectoryPath());
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i2 = 0; i2 < files.length; ++i2) {
                String currentPath;
                File file = files[i2];
                if (filePath != null) {
                    currentPath = file.getAbsolutePath();
                    if (!StringUtil.endsWithIgnoreCase(currentPath, filePath)) continue;
                    FileRecordImpl record = new FileRecordImpl();
                    record.setPathInVdb(filePath);
                    record.setIndexSelector(this);
                    fileRecords.add(record);
                    break;
                }
                currentPath = file.getAbsolutePath();
                String directoryPath = this.getIndexDirectoryPath();
                int index = currentPath.indexOf(directoryPath);
                String vdbRelativePath = currentPath.substring(index);
                FileRecordImpl record = new FileRecordImpl();
                record.setPathInVdb(vdbRelativePath);
                record.setIndexSelector(this);
                fileRecords.add(record);
            }
        }
        return fileRecords;
    }

    protected String getIndexDirectoryPath() {
        if (this.indexDirectoryPath == null) {
            this.tempDirectory = new TempDirectory(System.currentTimeMillis(), random.nextLong());
            this.indexDirectoryPath = this.tempDirectory.getPath();
        }
        return this.indexDirectoryPath;
    }

    protected void setIndexDirectoryPath(String path) {
        this.indexDirectoryPath = path;
        this.tempDirectory = null;
    }

    protected boolean checkValidType(File file) {
        String fileName = file.getName();
        return this.isArchive(file) || IndexUtil.isIndexFile(fileName);
    }

    protected boolean isArchive(File file) {
        if (file != null && file.isFile() && file.exists()) {
            String fileName = file.getName();
            String fileExtension = ModelUtil.getFileExtension(file);
            if ("vdb".equalsIgnoreCase(fileExtension) || FileUtils.isArchiveFileName(fileName)) {
                return true;
            }
        }
        return false;
    }

    public void finalize() {
        this.clearVDB();
    }
}

