/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.metamodel;

import com.metamatrix.core.util.AssertionException;
import com.metamatrix.modeler.core.MetamodelDescriptor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.internal.core.MetamodelDescriptorImpl;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelContentProvider;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class MetamodelResourceImpl
extends XMIResourceImpl {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String EFACTORY_GET_PACKAGE_METHOD_NAME = "getPackage";
    private final MetamodelRegistry registry;

    public MetamodelResourceImpl(MetamodelRegistry registry, URI uri) {
        super(uri);
        if (registry == null) {
            String msg = ModelerCore.Util.getString("MetamodelResourceImpl.The_MetamodelRegistry_reference_may_not_be_null_1");
            throw new IllegalArgumentException(msg);
        }
        if (uri == null) {
            String msg = ModelerCore.Util.getString("MetamodelResourceImpl.The_URI_reference_may_not_be_null_2");
            throw new IllegalArgumentException(msg);
        }
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Map options) throws IOException {
        EPackage ePackage;
        String msg;
        boolean hasGeneratedClasses;
        URI uri;
        if (ModelerCore.DEBUG_METAMODEL) {
            String msg2 = ModelerCore.Util.getString("MetamodelResourceImpl.DEBUG.Entering_MetamodelResourceImpl.load(Map)_1");
            ModelerCore.Util.log(1, msg2);
        }
        if (!this.registry.containsURI(uri = super.getURI())) {
            String msg3 = ModelerCore.Util.getString("MetamodelResourceImpl.The_MetamodelRegistry_must_contain_the_URI__3", new Object[]{uri});
            throw new AssertionException(msg3);
        }
        MetamodelDescriptorImpl descriptor = (MetamodelDescriptorImpl)this.registry.getMetamodelDescriptor(uri);
        boolean hasEcoreFile = descriptor.getResourceURL() != null;
        boolean bl = hasGeneratedClasses = descriptor.getFactoryClass() != null;
        if (hasEcoreFile) {
            InputStream inputStream;
            if (ModelerCore.DEBUG_METAMODEL) {
                msg = ModelerCore.Util.getString("MetamodelResourceImpl.DEBUG.The_metamodel_for_URI_is_defined_by_an_ecore_file_2", new Object[]{uri});
                ModelerCore.Util.log(1, msg);
            }
            if ((inputStream = descriptor.getInputStream()) != null) {
                try {
                    if (ModelerCore.DEBUG_METAMODEL) {
                        String msg4 = ModelerCore.Util.getString("MetamodelResourceImpl.DEBUG.Loading_ecore_file_for_for_URI_3", new Object[]{uri});
                        ModelerCore.Util.log(1, msg4);
                    }
                    this.load(inputStream, options);
                    ePackage = (EPackage)super.getContents().get(0);
                    Class factoryClass = descriptor.getFactoryClass();
                    if (factoryClass != null) {
                        EFactory factoryInstance = (EFactory)this.createInstance(factoryClass);
                        this.registerEFactory(uri, ePackage, factoryInstance);
                    }
                    this.registerEFactory(uri, ePackage, ePackage.getEFactoryInstance());
                }
                finally {
                    inputStream.close();
                }
            } else {
                ModelerCore.Util.log(4, ModelerCore.Util.getString("MetamodelResourceImpl.Unable_to_create_InputStream_to_the_ecore_file__URI_4", new Object[]{uri}));
            }
        }
        if (hasGeneratedClasses) {
            String msg5;
            if (ModelerCore.DEBUG_METAMODEL) {
                msg = ModelerCore.Util.getString("MetamodelResourceImpl.DEBUG.The_metamodel_for_URI_is_defined_by_generated_class_files_4", new Object[]{uri});
                ModelerCore.Util.log(1, msg);
            }
            EFactory eFactory = null;
            ePackage = null;
            EPackage obj = EPackage.Registry.INSTANCE.getEPackage(uri.toString());
            if (obj != null && obj instanceof EPackage) {
                ePackage = obj;
                eFactory = ePackage.getEFactoryInstance();
            } else {
                eFactory = descriptor.getFactoryClassInstance();
                if (ModelerCore.DEBUG_METAMODEL) {
                    msg5 = ModelerCore.Util.getString("MetamodelResourceImpl.DEBUG.Created_instance_of_EFactory_for_URI_5", new Object[]{eFactory, uri});
                    ModelerCore.Util.log(1, msg5);
                }
                Thread.currentThread().setContextClassLoader(descriptor.getFactoryClassLoader());
                Method getPackageMethod = MetamodelResourceImpl.getMethod(eFactory.getClass(), EFACTORY_GET_PACKAGE_METHOD_NAME, EMPTY_CLASS_ARRAY);
                ePackage = (EPackage)MetamodelResourceImpl.invokeMethod(getPackageMethod, eFactory, EMPTY_OBJECT_ARRAY);
            }
            if (ePackage != null) {
                Notification notification;
                if (ModelerCore.DEBUG_METAMODEL) {
                    msg5 = ModelerCore.Util.getString("MetamodelResourceImpl.DEBUG.Created_instance_of_EPackage_for_URI_6", new Object[]{ePackage, uri});
                    ModelerCore.Util.log(1, msg5);
                }
                this.registerEFactory(uri, ePackage, eFactory);
                if (!hasEcoreFile && super.getContents().size() == 0) {
                    super.getContents().add(ePackage);
                    if (ModelerCore.DEBUG_METAMODEL) {
                        msg5 = ModelerCore.Util.getString("MetamodelResourceImpl.DEBUG.Added_EPackage_to_the_contents_of_7", new Object[]{ePackage, this});
                        ModelerCore.Util.log(1, msg5);
                    }
                }
                if ((notification = super.setLoaded(true)) != null) {
                    this.eNotify(notification);
                }
                this.updateEmfAdapterFactory();
            } else {
                ModelerCore.Util.log(4, ModelerCore.Util.getString("MetamodelResourceImpl.Unable_to_create_an_EPackage_instance_from_the_EFactory_5", new Object[]{eFactory}));
            }
        }
        if (super.getContents().isEmpty()) {
            ModelerCore.Util.log(4, ModelerCore.Util.getString("MetamodelResourceImpl.Resource_was_not_successfully_loaded_6", new Object[]{this}));
        }
        if (ModelerCore.DEBUG_METAMODEL) {
            String msg1 = ModelerCore.Util.getString("MetamodelResourceImpl.DEBUG.Resource,_isLoaded()_1", new Object[]{this, new Boolean(super.isLoaded())});
            ModelerCore.Util.log(1, msg1);
            String msg2 = ModelerCore.Util.getString("MetamodelResourceImpl.DEBUG.Returning_from_MetamodelResourceImpl.load(Map)_8");
            ModelerCore.Util.log(1, msg2);
        }
    }

    private Object createInstance(Class theClass) {
        if (theClass != null) {
            try {
                Object instance = theClass.newInstance();
                if (ModelerCore.DEBUG_METAMODEL) {
                    String msg = ModelerCore.Util.getString("MetamodelResourceImpl.DEBUG.Creating_an_instance_of_for_URI_9", new Object[]{theClass, this.uri});
                    ModelerCore.Util.log(1, msg);
                }
                return instance;
            }
            catch (InstantiationException e2) {
                ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("MetamodelResourceImpl.Creating_an_instance_of_7", new Object[]{theClass, e2.getMessage()}));
            }
            catch (IllegalAccessException e3) {
                ModelerCore.Util.log(4, e3, ModelerCore.Util.getString("MetamodelResourceImpl.Creating_an_instance_of_8", new Object[]{theClass, e3.getMessage()}));
            }
        }
        return null;
    }

    private void registerEFactory(URI uri, EPackage ePackage, EFactory eFactory) {
        if (!this.registry.containsURI(uri)) {
            String msg = ModelerCore.Util.getString("MetamodelResourceImpl.MetamodelRegistry_must_contain_URI_9", new Object[]{uri});
            throw new AssertionException(msg);
        }
        MetamodelDescriptor descriptor = this.registry.getMetamodelDescriptor(uri);
        String nsPrefix = descriptor.getNamespacePrefix();
        String nsURI = descriptor.getURI();
        try {
            ePackage.setNsPrefix(nsPrefix);
            ePackage.setNsURI(nsURI);
            this.registry.setEFactory(uri, eFactory);
        }
        catch (Throwable t2) {
            Object[] params = new Object[]{uri, ePackage, eFactory};
            ModelerCore.Util.log(4, t2, ModelerCore.Util.getString("MetamodelResourceImpl.Error_in_MetamodelResourceImpl.registerEFactory()_1", params));
        }
        if (ModelerCore.DEBUG_METAMODEL) {
            String msg = ModelerCore.Util.getString("MetamodelResourceImpl.DEBUG.Registered_EFactory_for_URI_10", new Object[]{eFactory, uri});
            ModelerCore.Util.log(1, msg);
        }
    }

    private void updateEmfAdapterFactory() {
        MetamodelContentProvider.getEmfAdapterFactory();
    }

    private static Object invokeMethod(Method m2, Object obj, Object[] args) {
        Object[] methodArgs = args;
        if (args == null) {
            methodArgs = EMPTY_OBJECT_ARRAY;
        }
        Object result = null;
        try {
            result = m2.invoke(obj, methodArgs);
        }
        catch (Throwable t2) {
            Object[] params = new Object[]{m2, obj};
            ModelerCore.Util.log(4, t2, ModelerCore.Util.getString("MetamodelResourceImpl.Error_invoking_Method,_on_object_1", params));
        }
        return result;
    }

    public static Method getMethod(Class c2, String name, Class[] parameterTypes) {
        Class[] paramTypes = parameterTypes;
        if (parameterTypes == null) {
            paramTypes = EMPTY_CLASS_ARRAY;
        }
        try {
            Method m2 = c2.getMethod(name, paramTypes);
            return m2;
        }
        catch (Throwable t2) {
            Object[] params = new Object[]{name, c2};
            ModelerCore.Util.log(4, t2, ModelerCore.Util.getString("MetamodelResourceImpl.Error_getting_Method,_on_Class_2", params));
            return null;
        }
    }
}

