/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.metamodel;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.ResourceDescriptor;
import com.metamatrix.modeler.internal.core.MetamodelDescriptorImpl;
import com.metamatrix.modeler.internal.core.container.ResourceDescriptorImpl;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelRegistry;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelResourceFactory;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class MetamodelResourceSetImpl
extends ResourceSetImpl
implements ResourceSet {
    public static final String MTK_PLUGIN_PROTOCOL = "mtkplugin";
    private final MetamodelRegistry metamodelRegistry;
    private static MultiStatus status;

    public MetamodelResourceSetImpl(MetamodelRegistry metamodelRegistry) {
        if (metamodelRegistry == null) {
            String msg = ModelerCore.Util.getString("MetamodelResourceSetImpl.The_MetamodelRegistry_reference_may_not_be_null_2");
            throw new IllegalArgumentException(msg);
        }
        if (ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelResourceSetImpl.DEBUG.Created_new_instance_of_MetamodelResourceSetImpl_1"));
        }
        this.metamodelRegistry = metamodelRegistry;
        MetamodelResourceSetImpl.initializeResourceSet(this, metamodelRegistry);
    }

    public Resource createResource(URI uri) {
        return this.createResource(uri, true);
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        if (ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelResourceSetImpl.DEBUG.>>_MetamodelResourceSetImpl.getResource_for_URI,_loadOnDemand", new Object[]{uri, new Boolean(loadOnDemand)}));
        }
        return super.getResource(uri, loadOnDemand);
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        return null;
    }

    public static IStatus getStatus() {
        return status;
    }

    public void register(List resourceDescriptors) throws ModelerCoreException {
        if (resourceDescriptors != null) {
            Iterator iter = resourceDescriptors.iterator();
            while (iter.hasNext()) {
                ResourceDescriptor descriptor = (ResourceDescriptor)iter.next();
                ResourceDescriptorImpl.register(descriptor, this);
            }
        }
        Resource.Factory.Registry registry = this.getResourceFactoryRegistry();
        Map protocolToFactoryMap = registry.getProtocolToFactoryMap();
        MetamodelResourceFactory mtkpluginFactory = new MetamodelResourceFactory(this.metamodelRegistry);
        protocolToFactoryMap.put(MTK_PLUGIN_PROTOCOL, mtkpluginFactory);
    }

    private static void initializeResourceSet(ResourceSet resourceSet, MetamodelRegistry metamodelRegistry) {
        if (ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelResourceSetImpl.DEBUG.initializeResourceSet()__Initializing_resource_set_factory_registry_4"));
        }
        resourceSet.setURIConverter(new URIConverterImpl());
        Resource.Factory.Registry registry = resourceSet.getResourceFactoryRegistry();
        Map protocolToFactoryMap = registry.getProtocolToFactoryMap();
        MetamodelResourceFactory mtkpluginFactory = new MetamodelResourceFactory(metamodelRegistry);
        protocolToFactoryMap.put(MTK_PLUGIN_PROTOCOL, mtkpluginFactory);
    }

    private URI getPhysicalURI(MetamodelDescriptorImpl descriptor) {
        Assertion.isNotNull(descriptor);
        String logicalURI = descriptor.getURI();
        String internalURI = descriptor.getInternalURI();
        String resourceURL = descriptor.getResourceURL();
        if (internalURI != null) {
            URI physicalURI = MetamodelResourceSetImpl.createURI(internalURI);
            if (ModelerCore.DEBUG_METAMODEL) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelResourceSetImpl.DEBUG.>>_Returning_internalURI_for_URI", new Object[]{physicalURI, logicalURI}));
            }
            return physicalURI;
        }
        if (resourceURL != null) {
            URI physicalURI = MetamodelResourceSetImpl.createURI(resourceURL);
            if (ModelerCore.DEBUG_METAMODEL) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelResourceSetImpl.DEBUG.>>_Returning_resourceURL_for_URI", new Object[]{physicalURI, logicalURI}));
            }
            return physicalURI;
        }
        if (logicalURI != null) {
            URI physicalURI = MetamodelResourceSetImpl.createURI(logicalURI);
            if (ModelerCore.DEBUG_METAMODEL) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelResourceSetImpl.DEBUG.>>_Returning_logicalURI_for_URI", new Object[]{physicalURI, logicalURI}));
            }
            return physicalURI;
        }
        if (ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelResourceSetImpl.DEBUG.>>_ERROR_determining_physicalURI", new Object[]{logicalURI}));
        }
        return null;
    }

    private static URI createURI(String uri) {
        Assertion.isNotNull(uri);
        File file = new File(uri);
        if (file.exists()) {
            return URI.createFileURI(uri);
        }
        return URI.createURI(uri);
    }

    private Resource createResource(URI uri, boolean checkExistence) {
        String extension;
        Resource resource;
        if (ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelResourceSetImpl.DEBUG.>>_MetamodelResourceSetImpl.createResource__URI___3") + uri);
        }
        if (checkExistence && (resource = this.getResource(uri, false)) != null) {
            if (ModelerCore.DEBUG_METAMODEL) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelResourceSetImpl.DEBUG.createResource(URI)__Found_existing_Resource_for_URI", new Object[]{uri}));
            }
            return resource;
        }
        MetamodelDescriptorImpl descriptor = (MetamodelDescriptorImpl)this.metamodelRegistry.getMetamodelDescriptor(uri);
        Assertion.isNotNull(descriptor);
        URI physicalURI = this.getPhysicalURI(descriptor);
        Resource.Factory.Registry registry = super.getResourceFactoryRegistry();
        Map protocolToFactoryMap = registry.getProtocolToFactoryMap();
        Map extensionToFactoryMap = registry.getExtensionToFactoryMap();
        Resource.Factory resourceFactory = null;
        String protocol = physicalURI.scheme();
        resourceFactory = (Resource.Factory)protocolToFactoryMap.get(protocol);
        if (resourceFactory == null && (resourceFactory = (Resource.Factory)extensionToFactoryMap.get(extension = physicalURI.fileExtension())) == null) {
            resourceFactory = registry.getFactory(uri);
        }
        Resource resource2 = null;
        if (resourceFactory != null) {
            resource2 = resourceFactory.createResource(uri);
            Assertion.isNotNull(resource2);
            if (ModelerCore.DEBUG_METAMODEL) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelResourceSetImpl.DEBUG.>>_Created_resource", new Object[]{resource2}));
            }
            super.getResources().add(resource2);
            return resource2;
        }
        if (ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelResourceSetImpl.DEBUG.createResource(URI)__Unable_to_create_Resource_for_URI", new Object[]{uri}));
        }
        return null;
    }
}

