/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.resource.xmi;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.AssertionException;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.metamodels.core.Identifiable;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.core.MetamodelDescriptor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.ModelerCoreRuntimeException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.container.ObjectManager;
import com.metamatrix.modeler.core.transaction.UnitOfWork;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.util.ModelObjectCollector;
import com.metamatrix.modeler.internal.core.container.ContainerImpl;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelRegistry;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.resource.EmfResourceSet;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiHelper;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceLoader;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiSaveImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.edit.provider.INotifyChangedListener;

public class MtkXmiResourceImpl
extends XMIResourceImpl
implements EmfResource {
    public static final char UUID_PROTOCOL_DELIMITER = '/';
    public static final boolean CHECK_ANY_PROTOCOLS = true;
    private final Map uuidToEObjectMap;
    private Container container;
    private MetamodelRegistry registry;
    private ObjectManager objectManager;
    private List prefixesToURIs;
    private ModelContents modelContents;

    public MtkXmiResourceImpl(URI uri) {
        super(uri);
        if (uri == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MtkXmiResourceImpl.The_URI_reference_may_not_be_null_1"));
        }
        this.modelContents = new ModelContents(this);
        this.uuidToEObjectMap = new HashMap();
        this.prefixesToURIs = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Map options) throws IOException {
        XMIHeader header;
        File f2;
        if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.MtkXMIResourceImpl.load(Map)_1"));
        }
        this.modelContents = new ModelContents(this);
        if (this.uri != null && this.uri.isFile() && (f2 = new File(this.uri.toFileString())).exists() && (header = ModelUtil.getXmiHeader(f2)) != null && header.getXmiVersion() != null && header.getXmiVersion().startsWith("1.")) {
            Object[] params = new Object[]{this.uri};
            String msg = ModelerCore.Util.getString("MtkXmiResourceImpl.The_file,_0,_is_an_older_model_format_that_must_be_converted._1", params);
            ModelerCore.Util.log(4, msg);
            return;
        }
        UnitOfWork txn = null;
        boolean selfStarted = false;
        if (this.container != null && !(txn = this.container.getEmfTransactionProvider().getCurrent()).isStarted()) {
            try {
                txn.begin();
            }
            catch (ModelerCoreException e2) {
                ModelerCore.Util.log(4, e2, e2.getMessage());
            }
            selfStarted = true;
        }
        URI uri = super.getURI();
        MetamodelRegistry registry = this.getMetamodelRegistry();
        if (registry != null && registry.containsURI(uri)) {
            MetamodelDescriptor descriptor = this.registry.getMetamodelDescriptor(uri);
            InputStream inputStream = descriptor.getInputStream();
            if (inputStream != null) {
                try {
                    if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.Loading_metamodel_extension_for_URI_2", new Object[]{uri}));
                    }
                    this.load(inputStream, options);
                }
                finally {
                    inputStream.close();
                }
                return;
            }
            throw new IOException(ModelerCore.Util.getString("MtkXmiResourceImpl.Unable_to_create_an_InputStream_to_URI_2", new Object[]{uri}));
        }
        if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.Loading_model_using_URI_3", new Object[]{uri}));
        }
        super.load(options);
        if (selfStarted) {
            try {
                txn.commit();
            }
            catch (ModelerCoreException e3) {
                ModelerCore.Util.log(4, e3, e3.getMessage());
            }
        }
        if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.Returning_from_MtkXMIResourceImpl.load(Map)_1"));
        }
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MtkXmiResourceImpl.The_InputStream_reference_may_not_be_null_3"));
        }
        if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.MtkXMIResourceImpl.doLoad(InputStream,Map)_4"));
        }
        this.modelContents = new ModelContents(this);
        UnitOfWork txn = null;
        boolean selfStarted = false;
        if (this.container != null && !(txn = this.container.getEmfTransactionProvider().getCurrent()).isStarted()) {
            try {
                txn.begin();
            }
            catch (ModelerCoreException e2) {
                ModelerCore.Util.log(4, e2, e2.getMessage());
            }
            selfStarted = true;
        }
        XMLHelper xmiHelper = this.createXMLHelper();
        MtkXmiResourceLoader loader = new MtkXmiResourceLoader(xmiHelper, this.getContainer());
        loader.load((XMLResource)this, inputStream, options);
        if (xmiHelper instanceof MtkXmiHelper) {
            this.prefixesToURIs = ((MtkXmiHelper)xmiHelper).getPrefixesToURIs();
        }
        if (selfStarted) {
            try {
                txn.commit();
            }
            catch (ModelerCoreException e3) {
                ModelerCore.Util.log(4, e3, e3.getMessage());
            }
        }
        if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.Returning_from_MtkXMIResourceImpl.doLoad(InputStream,Map)_2"));
        }
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        Resource resource;
        ModelAnnotation modelAnnotation = null;
        if (this.modelContents != null && this.modelContents.getModelAnnotation() != null && (resource = (modelAnnotation = this.modelContents.getModelAnnotation()).eResource()) == null) {
            this.getContents().add(0, modelAnnotation);
        }
        if (modelAnnotation != null && !(this.getContents().get(0) instanceof ModelAnnotation)) {
            this.getContents().move(0, modelAnnotation);
        }
        if (modelAnnotation != null) {
            modelAnnotation.setProducerName("MetaMatrix");
            modelAnnotation.setProducerVersion("5.0");
        }
        if (this.uuidToEObjectMap != null) {
            this.uuidToEObjectMap.clear();
        }
        HashMap<String, String> saveOptions = options == null ? new HashMap<String, String>() : new HashMap(options);
        saveOptions.put("PROCESS_DANGLING_HREF", "RECORD");
        super.doSave(outputStream, saveOptions);
    }

    protected XMLHelper createXMLHelper() {
        return new MtkXmiHelper();
    }

    protected void doUnload() {
        super.doUnload();
        if (this.uuidToEObjectMap != null) {
            this.uuidToEObjectMap.clear();
        }
        this.setModified(false);
        this.modelContents = null;
    }

    public void detached(EObject eObject) {
        this.clearUUID(eObject, true);
        super.detached(eObject);
    }

    public void attached(EObject eObject) {
        this.recordUUID(eObject, true);
        super.attached(eObject);
    }

    protected XMLSave createXMLSave() {
        return new MtkXmiSaveImpl(super.createXMLHelper(), this);
    }

    public EList getContents() {
        if (this.contents == null) {
            this.contents = new MtkContentsEList(this);
        }
        return this.contents;
    }

    public String getDescription() {
        String description = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            description = this.getModelContents().getModelAnnotation().getDescription();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                description = header.getDescription();
            }
        }
        return description;
    }

    public ModelType getModelType() {
        ModelType type = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            type = this.getModelContents().getModelAnnotation().getModelType();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                type = ModelType.get(header.getModelType());
            }
        }
        return type;
    }

    public URI getPrimaryMetamodelUri() {
        String primaryMetamodelUri = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            primaryMetamodelUri = this.getModelContents().getModelAnnotation().getPrimaryMetamodelUri();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                primaryMetamodelUri = header.getPrimaryMetamodelURI();
            }
        }
        if (StringUtil.isEmpty(primaryMetamodelUri)) {
            return null;
        }
        return URI.createURI(primaryMetamodelUri);
    }

    public boolean isVisible() {
        boolean isVisible = true;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            isVisible = this.getModelContents().getModelAnnotation().isVisible();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                isVisible = header.isVisible();
            }
        }
        return isVisible;
    }

    public ObjectID getUuid() {
        ObjectID uuid = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            uuid = this.getModelContents().getModelAnnotation().getObjectId();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null && header.getUUID() != null) {
                uuid = this.getObjectIDFromString(header.getUUID());
            }
        }
        return uuid;
    }

    protected XMIHeader doGetXmiHeader() {
        File f2;
        XMIHeader header = null;
        if (this.getURI().isFile() && (f2 = new File(this.getURI().toFileString())).exists()) {
            header = ModelUtil.getXmiHeader(f2);
        }
        return header;
    }

    public ModelAnnotation getModelAnnotation() {
        if (this.modelContents != null) {
            return this.modelContents.getModelAnnotation();
        }
        return null;
    }

    public ModelContents getModelContents() {
        if (this.modelContents == null) {
            this.modelContents = new ModelContents(this);
        }
        return this.modelContents;
    }

    public List getNamespacePrefixToUris() {
        return this.prefixesToURIs;
    }

    public String getURIFragment(EObject eObject) {
        ObjectID id = this.getUUID(eObject);
        if (id != null) {
            return id.toString('/');
        }
        return super.getURIFragment(eObject);
    }

    protected EObject getEObjectForURIFragmentRootSegment(String uriFragmentRootSegment) {
        EObject result;
        ObjectID id = this.getObjectIDFromString(uriFragmentRootSegment);
        if (id != null && (result = this.getEObject(id)) != null) {
            return result;
        }
        return super.getEObjectForURIFragmentRootSegment(uriFragmentRootSegment);
    }

    public EObject getEObject(String uriFragment) {
        if (uriFragment != null) {
            ObjectID id = this.getObjectIDFromString(uriFragment);
            if (id != null) {
                return this.getEObject(id);
            }
            return super.getEObject(uriFragment);
        }
        return null;
    }

    protected EObject getEObjectByID(String id) {
        EObject eObject;
        if (this.idToEObjectMap != null && (eObject = (EObject)this.idToEObjectMap.get(id)) != null) {
            return eObject;
        }
        if (StringUtil.startsWithIgnoreCase(id, "mmuuid")) {
            return null;
        }
        ModelObjectCollector moc = new ModelObjectCollector(this);
        List eObjects = moc.getEObjects();
        Iterator iter = eObjects.iterator();
        while (iter.hasNext()) {
            EObject eObject2 = (EObject)iter.next();
            if (!id.equals(EcoreUtil.getID(eObject2))) continue;
            return eObject2;
        }
        return null;
    }

    public Container getContainer() {
        if (this.container == null) {
            ResourceSet resourceSet = this.resourceSet;
            if (resourceSet == null) {
                String msg = ModelerCore.Util.getString("MtkXmiResourceImpl.The_ResourceSet_reference_may_not_be_null_4");
                throw new AssertionException(msg);
            }
            if (resourceSet instanceof EmfResourceSet) {
                this.container = ((EmfResourceSet)((Object)resourceSet)).getContainer();
                if (this.container == null) {
                    String msg = ModelerCore.Util.getString("MtkXmiResourceImpl.MtkXmiResourceImpl.The_Container_reference_may_not_be_null_5");
                    throw new AssertionException(msg);
                }
            }
            if (this.container == null && (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL)) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.The_Container_reference_is_null_for_this_MtkXmiResourceImpl_6"));
            }
        }
        return this.container;
    }

    public ObjectManager getObjectManager() {
        if (this.objectManager == null) {
            Container ctnr = this.getContainer();
            this.objectManager = ctnr instanceof ContainerImpl ? ((ContainerImpl)ctnr).getObjectManager() : this.doGetDefaultObjectManager();
        }
        return this.objectManager;
    }

    protected ObjectManager doGetDefaultObjectManager() {
        return new ObjectManager(){

            public EObject findEObject(Object key) {
                return null;
            }

            public void clear() {
            }

            public int size() {
                return 0;
            }

            public void addEObject(EObject eObject) {
            }

            public void removeEObject(EObject eObject) {
            }

            public void processResourceChange(Object eObject, Resource newResource, Resource oldResource) {
            }

            public void processMassAdd(Collection newObjects) {
            }

            public void processMassRemove(Collection objects) {
            }

            public INotifyChangedListener getObjectChangeListner() {
                return null;
            }
        };
    }

    public ResourceSet getResourceSet() {
        return this.getContainer();
    }

    public EObject getEObject(Object object) {
        if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.MtkXmiResourceImpl.getEObject()_7", new Object[]{object}));
        }
        if (object instanceof URI) {
            return this.getResourceSet().getEObject(this.uri, true);
        }
        if (object instanceof ObjectID) {
            return this.getEObject((ObjectID)object);
        }
        throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("MtkXmiResourceImpl.MtkXmiResourceImpl.getEObject()_invalid_param.__Key_must_be_a_Proxy,_a_URI,_or_an_ObjectID_6", new Object[]{object}));
    }

    public void addMany(Collection newRoots) {
        ArrayList newRootsToAdd = new ArrayList(newRoots);
        ArrayList allRoots = new ArrayList(this.getContents());
        allRoots.addAll(newRootsToAdd);
        Object[] rootArray = allRoots.toArray();
        ((BasicEList)this.getContents()).setData(rootArray.length, rootArray);
        Iterator iter = newRootsToAdd.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            ((MtkContentsEList)this.contents).attachToResource(object);
            if (!(object instanceof EObjectImpl)) continue;
            ((EObjectImpl)object).eSetResource(this, null);
        }
    }

    public void removeMany(Collection roots) {
        ArrayList allRoots = new ArrayList(this.getContents());
        allRoots.removeAll(roots);
        Object[] rootArray = allRoots.toArray();
        ((BasicEList)this.getContents()).setData(rootArray.length, rootArray);
        Iterator iter = roots.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            ((MtkContentsEList)this.contents).detachFromResource(object);
            if (!(object instanceof EObjectImpl)) continue;
            ((EObjectImpl)object).eSetResource(null, null);
        }
    }

    public MetamodelRegistry getMetamodelRegistry() {
        if (this.registry == null) {
            Container emfContainer = this.getContainer();
            if (this.container != null) {
                this.registry = emfContainer.getMetamodelRegistry();
                if (this.registry == null) {
                    String msg = ModelerCore.Util.getString("MtkXmiResourceImpl.The_MetamodelRegistry_reference_may_not_be_null_7");
                    throw new AssertionException(msg);
                }
            }
            if (this.registry == null && (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL)) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.The_MetamodelRegistry_reference_is_null_for_this_MtkXmiResourceImpl_8"));
            }
        }
        return this.registry;
    }

    public void recordUUID(EObject eObject, boolean recursive) {
        if (eObject == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MtkXmiResourceImpl.The_EObject_reference_may_not_be_null"));
        }
        ObjectID id = eObject.getObjectId();
        if (id == null) {
            ModelerCore.Util.log(2, ModelerCore.Util.getString("MtkXmiResourceImpl.0", eObject.eClass()));
            id = IDGenerator.getInstance().create("mmuuid");
            eObject.setObjectId(id);
        }
        this.uuidToEObjectMap.put(id, eObject);
        if (recursive) {
            Iterator iter = eObject.eContents().iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (!(next instanceof EObject)) continue;
                EObject nextEObj = (EObject)next;
                this.recordUUID(nextEObj, recursive);
            }
        }
    }

    public void clearUUID(EObject eObject, boolean recursive) {
        if (eObject == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MtkXmiResourceImpl.The_EObject_reference_may_not_be_null"));
        }
        ObjectID id = eObject.getObjectId();
        if (id == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MtkXmiResourceImpl.The_ObjectID_reference_may_not_be_null"));
        }
        this.uuidToEObjectMap.remove(id);
        if (recursive) {
            Iterator iter = eObject.eContents().iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (!(next instanceof EObject)) continue;
                EObject nextEObj = (EObject)next;
                this.clearUUID(nextEObj, recursive);
            }
        }
    }

    private EObject getEObject(ObjectID id) {
        if (id == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MtkXmiResourceImpl.The_ObjectID_reference_may_not_be_null"));
        }
        if (this.uuidToEObjectMap == null) {
            return null;
        }
        return (EObject)this.uuidToEObjectMap.get(id);
    }

    protected EObject resolveEObject(ObjectID id) {
        if (id == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MtkXmiResourceImpl.The_ObjectID_reference_may_not_be_null"));
        }
        if (this.uuidToEObjectMap == null) {
            return null;
        }
        return (EObject)this.uuidToEObjectMap.get(id);
    }

    public ObjectID getUUID(EObject eObject) {
        if (eObject == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MtkXmiResourceImpl.The_EObject_reference_may_not_be_null"));
        }
        ObjectID uuid = eObject.getObjectId();
        if (uuid != null) {
            return uuid;
        }
        if (eObject instanceof Identifiable) {
            String uuidString = ((Identifiable)eObject).getUuid();
            uuid = this.getObjectIDFromString(uuidString);
        }
        return uuid;
    }

    private ObjectID getObjectIDFromString(String uuidString) {
        if (uuidString == null || uuidString.length() == 0) {
            return null;
        }
        try {
            return IDGenerator.getInstance().stringToObject(uuidString);
        }
        catch (InvalidIDException invalidIDException) {
            return null;
        }
    }

    public void testUuidToEObjectMap(String description) {
        int missingMapEntryCount = 0;
        int eObjectCount = 0;
        Iterator iter = this.getContents().iterator();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (eObject == null) continue;
            ++eObjectCount;
            ObjectID id = eObject.getObjectId();
            if (this.uuidToEObjectMap.get(id) == null) {
                ++missingMapEntryCount;
            }
            TreeIterator iter2 = eObject.eAllContents();
            while (iter2.hasNext()) {
                EObject eObj = (EObject)iter2.next();
                if (eObj == null) continue;
                ++eObjectCount;
                id = eObj.getObjectId();
                if (this.uuidToEObjectMap.get(id) != null) continue;
                ++missingMapEntryCount;
            }
        }
        ModelerCore.Util.log(1, description);
        ModelerCore.Util.log(1, "Number of EObject instances in model           = " + eObjectCount);
        ModelerCore.Util.log(1, "Number of entries in the map                   = " + this.uuidToEObjectMap.size());
        int severity = missingMapEntryCount == 0 ? 1 : 4;
        ModelerCore.Util.log(severity, "Number of EObject instances missing in the map = " + missingMapEntryCount);
    }

    protected class MtkContentsEList
    extends ResourceImpl.ContentsEList {
        private final MtkXmiResourceImpl owner;

        public MtkContentsEList(MtkXmiResourceImpl owner) {
            this.owner = owner;
        }

        protected void didChange() {
            MtkXmiResourceImpl.this.setModified(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection c2) {
            if (c2 == null || c2.isEmpty()) {
                return false;
            }
            boolean startTxn = this.getTxn();
            try {
                BasicEList vals = new BasicEList(c2);
                int[] removedIndexes = this.getIndexes(vals);
                this.owner.removeMany(c2);
                if (vals.size() == 1) {
                    MtkXmiResourceImpl.this.eNotify(this.createNotification(4, vals.get(0), null, removedIndexes[0]));
                } else {
                    MtkXmiResourceImpl.this.eNotify(this.createNotification(6, vals, removedIndexes, removedIndexes[0]));
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        private int[] getIndexes(Collection vals) {
            BasicEList tmp = new BasicEList(this);
            int[] result = new int[vals.size()];
            Iterator it = tmp.iterator();
            int count = 0;
            int index = 0;
            while (it.hasNext()) {
                Object next = it.next();
                if (vals.contains(next)) {
                    result[count++] = index;
                }
                ++index;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection c2) {
            if (c2 == null || c2.isEmpty()) {
                return false;
            }
            boolean startTxn = this.getTxn();
            try {
                int index = this.size;
                this.owner.addMany(c2);
                BasicEList vals = new BasicEList(c2);
                MtkXmiResourceImpl.this.eNotify(this.createNotification(5, null, vals, index, true));
                boolean bl = true;
                return bl;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, Object element) {
            boolean startTxn = this.getTxn();
            try {
                super.add(index, element);
                this.attachToResource(element);
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object o2) {
            boolean startTxn = this.getTxn();
            try {
                boolean result = super.add(o2);
                this.attachToResource(o2);
                boolean bl = result;
                return bl;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection c2) {
            boolean startTxn = this.getTxn();
            try {
                boolean result = super.addAll(index, c2);
                this.attachToResource(c2);
                boolean bl = result;
                return bl;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o2) {
            boolean startTxn = this.getTxn();
            try {
                boolean result = super.remove(o2);
                this.detachFromResource(o2);
                boolean bl = result;
                return bl;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NotificationChain inverseAdd(Object object, NotificationChain notifications) {
            if (object == null) {
                return notifications;
            }
            boolean startTxn = this.getTxn();
            try {
                NotificationChain result = super.inverseAdd(object, notifications);
                this.attachToResource(object);
                NotificationChain notificationChain = result;
                return notificationChain;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NotificationChain inverseRemove(Object object, NotificationChain notifications) {
            if (object == null) {
                return notifications;
            }
            boolean startTxn = this.getTxn();
            try {
                NotificationChain result = super.inverseRemove(object, notifications);
                this.detachFromResource(object);
                NotificationChain notificationChain = result;
                return notificationChain;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAllUnique(Collection collection) {
            boolean startTxn = this.getTxn();
            try {
                boolean result = super.addAllUnique(collection);
                this.attachToResource(collection);
                boolean bl = result;
                return bl;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAllUnique(int index, Collection collection) {
            boolean startTxn = this.getTxn();
            try {
                boolean result = super.addAllUnique(index, collection);
                this.attachToResource(collection);
                boolean bl = result;
                return bl;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUnique(int index, Object object) {
            boolean startTxn = this.getTxn();
            try {
                super.addUnique(index, object);
                this.attachToResource(object);
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUnique(Object object) {
            boolean startTxn = this.getTxn();
            try {
                super.addUnique(object);
                this.attachToResource(object);
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NotificationChain basicAdd(Object object, NotificationChain notifications) {
            boolean startTxn = this.getTxn();
            try {
                NotificationChain result = super.basicAdd(object, notifications);
                this.attachToResource(object);
                NotificationChain notificationChain = result;
                return notificationChain;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NotificationChain basicRemove(Object object, NotificationChain notifications) {
            boolean startTxn = this.getTxn();
            try {
                NotificationChain result = super.basicRemove(object, notifications);
                this.detachFromResource(object);
                NotificationChain notificationChain = result;
                return notificationChain;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        private void attachToResource(Object object) {
            if (object instanceof Identifiable) {
                String uuidString = ((Identifiable)object).getUuid();
                ObjectID uuid = MtkXmiResourceImpl.this.getObjectIDFromString(uuidString);
                if (uuid != null && object instanceof EObject) {
                    EObject eObject = (EObject)object;
                    eObject.setObjectId(uuid);
                    MtkXmiResourceImpl.this.recordUUID(eObject, true);
                    MtkXmiResourceImpl.this.getObjectManager().addEObject((EObject)object);
                }
            } else if (object instanceof EObject) {
                EObject eObj = (EObject)object;
                MtkXmiResourceImpl.this.recordUUID(eObj, true);
                MtkXmiResourceImpl.this.getObjectManager().addEObject(eObj);
            } else if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.Attaching_non-proxy_object_5", new Object[]{object}));
            }
        }

        private void detachFromResource(Object object) {
            if (object instanceof EObject) {
                EObject eObj = (EObject)object;
                MtkXmiResourceImpl.this.getObjectManager().removeEObject(eObj);
                MtkXmiResourceImpl.this.clearUUID(eObj, true);
            }
        }

        private boolean getTxn() {
            return ModelerCore.startTxn(null, this);
        }

        private void commitTxn() {
            ModelerCore.commitTxn();
        }
    }
}

