/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.search;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.IPathComparator;
import com.metamatrix.metamodels.core.CorePackage;
import com.metamatrix.metamodels.diagram.DiagramPackage;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.index.IndexSelectorFactory;
import com.metamatrix.modeler.core.search.MetadataSearch;
import com.metamatrix.modeler.core.search.runtime.AnnotatedObjectRecord;
import com.metamatrix.modeler.core.search.runtime.ResourceObjectRecord;
import com.metamatrix.modeler.core.search.runtime.SearchRecord;
import com.metamatrix.modeler.core.search.runtime.TypedObjectRecord;
import com.metamatrix.modeler.core.types.DatatypeConstants;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.internal.core.index.ModelWorkspaceSearchIndexSelector;
import com.metamatrix.modeler.internal.core.search.commands.FindObjectCommandImpl;
import com.metamatrix.modeler.internal.core.search.commands.FindTypedObjectCommandImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class MetadataSearchImpl
implements MetadataSearch {
    private static final EObject[] EMPTY_EOBJECT_ARRAY = new EObject[0];
    private static final String[] RUNTIME_TYPE_NAMES;
    private static final Set TYPED_META_CLASS_NAMES;
    private static final Map EXCLUDED_OBJECT_NS_URIS;
    private EClass metaClass;
    private EObject datatype;
    private boolean includeSubtypes;
    private String runtimeType;
    private String featureName;
    private String textPattern;
    private boolean containsPattern;
    private final List modelScope;
    private final List readOnlyModelScope;
    private final List results;
    private final List readOnlyResults;
    private final ModelWorkspace workspace;

    public MetadataSearchImpl(ModelWorkspace workspace, IndexSelectorFactory selector) {
        ArgCheck.isNotNull(workspace);
        ArgCheck.isNotNull(selector);
        this.workspace = workspace;
        this.results = new LinkedList();
        this.readOnlyResults = Collections.unmodifiableList(this.results);
        this.modelScope = new LinkedList();
        this.readOnlyModelScope = Collections.unmodifiableList(this.modelScope);
        this.includeSubtypes = false;
        this.containsPattern = true;
    }

    public ModelWorkspace getModelWorkspace() {
        return this.workspace;
    }

    public EClass getMetaClass() {
        return null;
    }

    public void setMetaClass(EClass metaClass) {
        this.metaClass = metaClass;
    }

    public EObject getDatatype() {
        return this.datatype;
    }

    public EObject[] getDatatypes() {
        try {
            return ModelerCore.getWorkspaceDatatypeManager().getAllDatatypes();
        }
        catch (Throwable t2) {
            String msg = ModelerCore.Util.getString("MetadataSearchImpl.Error_retrieving_types_from_DatatypeManager");
            ModelerCore.Util.log(4, t2, msg);
            return EMPTY_EOBJECT_ARRAY;
        }
    }

    public List getModelScope() {
        return this.readOnlyModelScope;
    }

    public String getFeatureCriteria() {
        return this.textPattern;
    }

    public String getRuntimeType() {
        return this.runtimeType;
    }

    public String[] getRuntimeTypes() {
        return RUNTIME_TYPE_NAMES;
    }

    public String[] getFeaturesNames() {
        return MetadataSearch.ALLOWABLE_SEARCH_FEATURES;
    }

    public String getSelectedFeatureName() {
        return null;
    }

    public boolean isIncludeSubtypes() {
        return this.includeSubtypes;
    }

    public boolean isTypedMetaClass(EClass metaClass) {
        if (metaClass == null) {
            return true;
        }
        return TYPED_META_CLASS_NAMES.contains(metaClass.getInstanceClassName());
    }

    public void setDatatype(EObject datatype, boolean includeSubtypes) {
        this.datatype = datatype;
        this.includeSubtypes = includeSubtypes;
    }

    public void setModelScope(List modelWorkspaceItems) {
        ArgCheck.isNotNull(modelWorkspaceItems);
        HashSet hsSet = new HashSet();
        this.modelScope.clear();
        int numItems = modelWorkspaceItems.size();
        block6: for (int i2 = 0; i2 < numItems; ++i2) {
            Object item = modelWorkspaceItems.get(i2);
            if (!(item instanceof ModelWorkspaceItem)) continue;
            int type = ((ModelWorkspaceItem)item).getItemType();
            switch (type) {
                case 5: {
                    hsSet.add(item);
                    continue block6;
                }
                case 2: {
                    LinkedList resourceList = new LinkedList();
                    this.getChildResources((ModelWorkspaceItem)item, resourceList);
                    hsSet.addAll(resourceList);
                    continue block6;
                }
                case 1: {
                    LinkedList resourceList = new LinkedList();
                    this.getChildResources((ModelWorkspaceItem)item, resourceList);
                    hsSet.addAll(resourceList);
                    continue block6;
                }
                case 4: {
                    LinkedList resourceList = new LinkedList();
                    this.getChildResources((ModelWorkspaceItem)item, resourceList);
                    hsSet.addAll(resourceList);
                    continue block6;
                }
            }
        }
        this.modelScope.addAll(hsSet);
    }

    public void setFeatureCriteria(String featureName, String textPattern, boolean containsPattern) {
        this.featureName = featureName;
        this.textPattern = textPattern;
        this.containsPattern = containsPattern;
    }

    public void setRuntimeType(String runtimeType) {
        this.runtimeType = runtimeType;
    }

    public IStatus canExecute() {
        boolean invalidFeatureSearch;
        boolean invalidMetaclassSearch = this.metaClass == null;
        boolean invalidDatatypeSearch = this.datatype == null && this.runtimeType == null;
        boolean bl = invalidFeatureSearch = this.featureName == null || this.textPattern == null || this.textPattern.length() == 0;
        if (invalidMetaclassSearch && invalidDatatypeSearch && invalidFeatureSearch) {
            boolean code = false;
            String msg = ModelerCore.Util.getString("MetadataSearchImpl.Missing_search_criteria");
            return new Status(4, "com.metamatrix.modeler.core", 0, msg, null);
        }
        if (this.featureName != null && (this.textPattern == null || this.textPattern.length() == 0)) {
            boolean code = false;
            String msg = ModelerCore.Util.getString("MetadataSearchImpl.Missing_search_criteria");
            return new Status(4, "com.metamatrix.modeler.core", 0, msg, null);
        }
        boolean code = false;
        String msg = ModelerCore.Util.getString("MetadataSearchImpl.Search_may_be_executed");
        return new Status(0, "com.metamatrix.modeler.core", 0, msg, null);
    }

    public IStatus execute(IProgressMonitor progressMonitor) {
        IStatus canStatus = this.canExecute();
        if (!canStatus.isOK()) {
            return canStatus;
        }
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        this.results.clear();
        IStatus status = null;
        try {
            ModelWorkspaceSearchIndexSelector scopeSelector = new ModelWorkspaceSearchIndexSelector(this.readOnlyModelScope);
            if (this.datatype != null || this.runtimeType != null) {
                EObject[] otherTypes = this.includeSubtypes ? MetadataSearchImpl.getSubtypes(this.datatype) : EMPTY_EOBJECT_ARRAY;
                status = this.doExecute((IndexSelector)scopeSelector, monitor, this.metaClass, this.datatype, otherTypes, this.runtimeType, this.results);
                if (status.isOK() && (this.metaClass != null || this.textPattern != null)) {
                    ArrayList featureSearchResults = new ArrayList();
                    status = this.doExecute((IndexSelector)scopeSelector, monitor, this.metaClass, this.featureName, this.textPattern, this.containsPattern, featureSearchResults);
                    this.intersetResultLists(featureSearchResults, this.results);
                    this.results.clear();
                    this.results.addAll(featureSearchResults);
                }
            } else if (this.metaClass != null || this.textPattern != null) {
                status = this.doExecute((IndexSelector)scopeSelector, monitor, this.metaClass, this.featureName, this.textPattern, this.containsPattern, this.results);
            }
            this.filterRecords(this.results);
        }
        catch (CoreException e2) {
            int code = e2.getStatus() != null ? e2.getStatus().getCode() : 0;
            String msg = e2.getLocalizedMessage();
            return new Status(0, "com.metamatrix.modeler.core", code, msg, e2);
        }
        catch (Throwable e3) {
            boolean code = false;
            String msg = e3.getLocalizedMessage();
            return new Status(0, "com.metamatrix.modeler.core", 0, msg, e3);
        }
        if (status == null) {
            boolean code = false;
            String msg = ModelerCore.Util.getString("MetadataSearchImpl.Search_completed_successfully");
            status = new Status(0, "com.metamatrix.modeler.core", 0, msg, null);
        }
        return status;
    }

    protected void intersetResultLists(List firstResult, List secondResult) {
        String id;
        SearchRecord record;
        HashSet<String> ids = new HashSet<String>(secondResult.size());
        Iterator iter = secondResult.iterator();
        while (iter.hasNext()) {
            record = (SearchRecord)iter.next();
            id = this.getIdentifier(record);
            if (id == null) continue;
            ids.add(id);
        }
        iter = firstResult.iterator();
        while (iter.hasNext()) {
            record = (SearchRecord)iter.next();
            id = this.getIdentifier(record);
            if (id != null && ids.contains(id)) continue;
            iter.remove();
        }
    }

    protected IStatus doExecute(IndexSelector scopeSelector, IProgressMonitor monitor, EClass metaClass, String featureName, String textPattern, boolean containsPattern, List results) throws CoreException {
        FindObjectCommandImpl command = new FindObjectCommandImpl();
        command.setIndexSelector(scopeSelector);
        command.setMetaClass(metaClass);
        command.setFeatureCriteria(featureName, textPattern, containsPattern);
        if (!command.canExecute()) {
            return null;
        }
        IStatus status = command.execute();
        Collection recordInfo = command.getRecordInfo();
        results.addAll(recordInfo);
        return status;
    }

    protected IStatus doExecute(IndexSelector scopeSelector, IProgressMonitor monitor, EClass metaClass, EObject datatype, EObject[] subtypes, String runtimeType, List results) throws CoreException {
        FindTypedObjectCommandImpl command = new FindTypedObjectCommandImpl();
        command.setIndexSelector(scopeSelector);
        command.setMetaClass(metaClass);
        command.setDatatype(datatype);
        command.setSubTypes(subtypes);
        command.setRuntimeType(runtimeType);
        if (!command.canExecute()) {
            return null;
        }
        IStatus status = command.execute();
        Collection recordInfo = command.getRecordInfo();
        results.addAll(recordInfo);
        return status;
    }

    protected List getPaths(List modelWorkspaceItems) {
        LinkedList<IPath> paths = new LinkedList<IPath>();
        Iterator iter = modelWorkspaceItems.iterator();
        while (iter.hasNext()) {
            ModelWorkspaceItem item = (ModelWorkspaceItem)iter.next();
            IPath path = item.getPath();
            paths.add(path);
        }
        if (paths.isEmpty()) {
            return paths;
        }
        IPathComparator comparator = new IPathComparator();
        Collections.sort(paths, comparator);
        LinkedList<IPath> validPaths = new LinkedList<IPath>();
        IPath next = (IPath)paths.removeFirst();
        while (next != null) {
            boolean skip = false;
            ListIterator existingPathIter = validPaths.listIterator(validPaths.size());
            while (existingPathIter.hasPrevious()) {
                IPath existingPath = (IPath)existingPathIter.previous();
                if (!existingPath.isPrefixOf(next)) continue;
                skip = true;
                break;
            }
            if (!skip) {
                validPaths.add(next);
            }
            if (paths.size() == 0) {
                next = null;
                continue;
            }
            next = (IPath)paths.removeFirst();
        }
        return validPaths;
    }

    public List getResults() {
        return this.readOnlyResults;
    }

    private String getIdentifier(SearchRecord record) {
        if (record != null) {
            String id = record.getUUID();
            if (id != null) {
                return id;
            }
            if (record instanceof ResourceObjectRecord) {
                id = ((ResourceObjectRecord)record).getObjectURI();
                return id;
            }
            if (record instanceof TypedObjectRecord) {
                id = ((TypedObjectRecord)record).getObjectURI();
                return id;
            }
            if (record instanceof AnnotatedObjectRecord) {
                id = ((AnnotatedObjectRecord)record).getObjectURI();
                return id;
            }
        }
        return null;
    }

    private static EObject[] getSubtypes(EObject startingDatatype) {
        EObject[] otherTypes = EMPTY_EOBJECT_ARRAY;
        if (startingDatatype != null) {
            HashSet tmp = new HashSet();
            MetadataSearchImpl.addSubtypesToCollection(startingDatatype, tmp);
            otherTypes = tmp.toArray(new EObject[tmp.size()]);
        }
        return otherTypes;
    }

    private static void addSubtypesToCollection(EObject datatype, Collection subTypes) {
        DatatypeManager mgr = ModelerCore.getWorkspaceDatatypeManager();
        if (mgr.isSimpleDatatype(datatype)) {
            try {
                EObject[] eObjects = mgr.getSubtypes(datatype);
                for (int i2 = 0; i2 < eObjects.length; ++i2) {
                    EObject eObject = eObjects[i2];
                    if (eObject == null) continue;
                    subTypes.add(eObject);
                    MetadataSearchImpl.addSubtypesToCollection(eObject, subTypes);
                }
            }
            catch (ModelerCoreException err) {
                ModelerCore.Util.log(4, err, err.getMessage());
            }
        }
    }

    private static String[] getRuntimeTypeNames() {
        Collection runtimeTypeNames = DatatypeConstants.getRuntimeTypeNames();
        return new ArrayList(runtimeTypeNames).toArray(new String[runtimeTypeNames.size()]);
    }

    private List getChildResources(ModelWorkspaceItem modelWorkspaceItem, List resourceList) {
        try {
            ModelWorkspaceItem[] childItems = modelWorkspaceItem.getChildren();
            int type = 0;
            block7: for (int i2 = 0; i2 < childItems.length; ++i2) {
                ModelWorkspaceItem item = childItems[i2];
                type = item.getItemType();
                switch (type) {
                    case 5: {
                        resourceList.add(item);
                        continue block7;
                    }
                    case 2: {
                        this.getChildResources(item, resourceList);
                        continue block7;
                    }
                    case 4: {
                        this.getChildResources(item, resourceList);
                        continue block7;
                    }
                }
            }
        }
        catch (ModelWorkspaceException e2) {
            e2.printStackTrace();
        }
        return resourceList;
    }

    private void filterRecords(List records) {
        Iterator it = records.iterator();
        while (it.hasNext()) {
            String metaclassURI;
            Object o2 = it.next();
            if (!(o2 instanceof ResourceObjectRecord) || !this.isMetaclassURIExcluded(metaclassURI = ((ResourceObjectRecord)o2).getMetaclassURI())) continue;
            it.remove();
        }
    }

    private boolean isMetaclassURIExcluded(String metaclassURI) {
        boolean success = false;
        if (metaclassURI != null && metaclassURI.length() > 0) {
            Iterator it = EXCLUDED_OBJECT_NS_URIS.keySet().iterator();
            block0: while (it.hasNext()) {
                String excludedMetaclassURI = (String)it.next();
                if (!metaclassURI.startsWith(excludedMetaclassURI)) continue;
                success = true;
                String[] includedMetaObjects = (String[])EXCLUDED_OBJECT_NS_URIS.get(excludedMetaclassURI);
                if (includedMetaObjects == null || includedMetaObjects.length <= 0) continue;
                for (int i2 = 0; i2 < includedMetaObjects.length; ++i2) {
                    String metaObjectName = includedMetaObjects[i2];
                    if (!metaclassURI.equals(metaObjectName)) continue;
                    success = false;
                    continue block0;
                }
            }
        }
        return success;
    }

    static {
        TYPED_META_CLASS_NAMES = new HashSet(11);
        EXCLUDED_OBJECT_NS_URIS = new HashMap(3);
        RUNTIME_TYPE_NAMES = MetadataSearchImpl.getRuntimeTypeNames();
        TYPED_META_CLASS_NAMES.add("com.metamatrix.metamodels.relational.Column");
        TYPED_META_CLASS_NAMES.add("com.metamatrix.metamodels.relational.ProcedureParameter");
        TYPED_META_CLASS_NAMES.add("com.metamatrix.metamodels.sdt.SimpleDatatype");
        TYPED_META_CLASS_NAMES.add("org.eclipse.xsd.XSDSimpleTypeDefinition");
        TYPED_META_CLASS_NAMES.add("com.metamatrix.metamodels.transformation.InputParameter");
        TYPED_META_CLASS_NAMES.add("com.metamatrix.metamodels.transformation.MappingClassColumn");
        TYPED_META_CLASS_NAMES.add("com.metamatrix.metamodels.dataaccess.Element");
        TYPED_META_CLASS_NAMES.add("com.metamatrix.metamodels.dataaccess.ProcedureParameter");
        EXCLUDED_OBJECT_NS_URIS.put("http://www.metamatrix.com/metamodels/Core", new String[]{ModelerCore.getModelEditor().getUri(CorePackage.eINSTANCE.getModelAnnotation()).toString()});
        EXCLUDED_OBJECT_NS_URIS.put("http://www.metamatrix.com/metamodels/Transformation", null);
        EXCLUDED_OBJECT_NS_URIS.put("http://www.metamatrix.com/metamodels/Diagram", new String[]{ModelerCore.getModelEditor().getUri(DiagramPackage.eINSTANCE.getDiagram()).toString()});
        EXCLUDED_OBJECT_NS_URIS.put("http://www.eclipse.org/emf/2002/Ecore", null);
    }
}

