/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.search.commands;

import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.index.IndexConstants;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlDatatypeAspect;
import com.metamatrix.modeler.core.search.commands.FindTypedObjectCommand;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.index.ModelWorkspaceSearchIndexSelector;
import com.metamatrix.modeler.internal.core.search.runtime.SearchRuntimeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class FindTypedObjectCommandImpl
implements FindTypedObjectCommand {
    private static final EObject[] EMPTY_EOBJECT_ARRAY = new EObject[0];
    private EClass metaClass = null;
    private EObject datatype = null;
    private EObject[] subtypes;
    private String runtimeType = null;
    private Collection recordInfos = Collections.EMPTY_LIST;
    private IndexSelector selector = null;

    public FindTypedObjectCommandImpl() {
        this.subtypes = EMPTY_EOBJECT_ARRAY;
    }

    public Collection getRecordInfo() {
        return this.recordInfos;
    }

    public void setMetaClass(EClass metaClass) {
        this.metaClass = metaClass;
    }

    public void setDatatype(EObject datatype) {
        this.datatype = datatype;
    }

    public void setRuntimeType(String runtimeType) {
        this.runtimeType = runtimeType;
    }

    public void setSubTypes(EObject[] subTypes) {
        this.subtypes = subTypes;
    }

    public void setIndexSelector(IndexSelector selector) {
        this.selector = selector;
    }

    public boolean canExecute() {
        return this.datatype != null || this.runtimeType != null;
    }

    public IStatus execute() {
        if (!this.canExecute()) {
            return null;
        }
        try {
            String typeName = FindTypedObjectCommandImpl.getDatatypeName(this.datatype);
            String runtimeTypeName = this.runtimeType;
            String metaclassUri = FindTypedObjectCommandImpl.getMetaclassUri(this.metaClass);
            String matchPattern = this.getMatchPattern(typeName, runtimeTypeName, metaclassUri);
            IEntryResult[] results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), matchPattern.toCharArray(), '\u00a0');
            this.recordInfos = new ArrayList(results.length);
            for (int i2 = 0; i2 < results.length; ++i2) {
                IEntryResult result = results[i2];
                this.recordInfos.add(SearchRuntimeAdapter.getSearchRecord(result.getWord()));
            }
            if (this.subtypes != null && this.subtypes.length > 0) {
                for (int j2 = 0; j2 != this.subtypes.length; ++j2) {
                    typeName = FindTypedObjectCommandImpl.getDatatypeName(this.subtypes[j2]);
                    matchPattern = this.getMatchPattern(typeName, runtimeTypeName, metaclassUri);
                    results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), matchPattern.toCharArray(), '\u00a0');
                    for (int i3 = 0; i3 < results.length; ++i3) {
                        IEntryResult result = results[i3];
                        this.recordInfos.add(SearchRuntimeAdapter.getSearchRecord(result.getWord()));
                    }
                }
            }
        }
        catch (Exception e2) {
            ModelerCore.Util.log(e2);
            String msg = ModelerCore.Util.getString("FindTypedObjectCommandImpl.Error_trying_to_execute_command");
            return new Status(4, "com.metamatrix.modeler.core", 0, msg, e2);
        }
        return new Status(0, "com.metamatrix.modeler.core", 0, "", null);
    }

    private String getMatchPattern(String typeName, String runtimeTypeName, String metaClassUri) {
        String pattern = null;
        String datatypeCriteria = typeName != null && typeName.length() != 0 ? typeName : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
        String runtimeTypeCriteria = runtimeTypeName != null && runtimeTypeName.length() != 0 ? runtimeTypeName : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
        String metaclassCriteria = metaClassUri != null && metaClassUri.length() != 0 ? metaClassUri : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
        pattern = "I\u00a0" + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + datatypeCriteria + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + runtimeTypeCriteria + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + metaclassCriteria + '\u00a0';
        return pattern;
    }

    private IndexSelector getIndexSelector() {
        this.selector = this.selector != null ? this.selector : new ModelWorkspaceSearchIndexSelector();
        return this.selector;
    }

    private static String getDatatypeName(EObject type) {
        SqlDatatypeAspect sqlAspect = FindTypedObjectCommandImpl.getSqlAspect(type);
        if (sqlAspect != null) {
            return sqlAspect.getName(type);
        }
        return null;
    }

    private static String getMetaclassUri(EClass eClass) {
        if (eClass != null) {
            return ModelerCore.getModelEditor().getUri(eClass).toString();
        }
        return null;
    }

    private static SqlDatatypeAspect getSqlAspect(EObject obj) {
        if (obj != null && obj instanceof XSDSimpleTypeDefinition) {
            return (SqlDatatypeAspect)ModelerCore.getMetamodels().getMetamodelAspect(obj, "sqlAspect");
        }
        return null;
    }
}

