/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.ChecksumUtil;
import com.metamatrix.core.util.StreamPipe;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.extension.XPackage;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.ModelerCoreRuntimeException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.container.DuplicateResourceException;
import com.metamatrix.modeler.core.transaction.UnitOfWork;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.workspace.ModelBuffer;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.Openable;
import com.metamatrix.modeler.internal.core.XsdObjectExtension;
import com.metamatrix.modeler.internal.core.container.ContainerImpl;
import com.metamatrix.modeler.internal.core.container.ResourceAction;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.workspace.OpenableImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Checksum;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.util.XSDResourceImpl;

public class ModelBufferImpl
implements ModelBuffer {
    private final IFile file;
    private final Openable owner;
    private final ResourceSet emfResourceSet;
    private Resource emfResource;
    private ModelContents contents;
    private boolean readonly;
    private Map options;
    private long lastModificationStamp;
    private long lastChecksum;
    private long lastFileSize;
    private String errorMessage;
    private boolean inProcessOfSavingContents;

    public ModelBufferImpl(IFile file, Openable owner, ResourceSet emfResourceSet, boolean readonly) {
        this.file = file;
        this.owner = owner;
        if (file == null) {
            this.setReadOnly(readonly);
        }
        this.updateCachedFileInformation();
        this.emfResourceSet = emfResourceSet;
        this.emfResource = null;
        this.options = new HashMap();
        this.contents = null;
        this.inProcessOfSavingContents = false;
        this.errorMessage = null;
    }

    public Resource getEmfResource() {
        return this.emfResource;
    }

    protected ResourceSet getEmfResourceSet() {
        return this.emfResourceSet;
    }

    public ModelContents getModelContents() {
        if (this.contents == null && this.emfResource != null) {
            this.contents = new ModelContents(this.emfResource);
        }
        return this.contents;
    }

    public Openable getOwner() {
        return this.owner;
    }

    public IResource getUnderlyingResource() {
        return this.file;
    }

    public boolean hasUnsavedChanges() {
        if (this.emfResource != null) {
            return this.emfResource.isModified();
        }
        return false;
    }

    public boolean isClosed() {
        return this.emfResource == null || !this.emfResource.isLoaded();
    }

    public boolean isReadOnly() {
        if (this.file == null) {
            return this.readonly;
        }
        return this.file.isReadOnly();
    }

    protected void setReadOnly(boolean readOnly) {
        this.readonly = readOnly;
    }

    public void unload() {
        if (!this.isClosed()) {
            this.emfResource.unload();
            this.contents = null;
            this.updateCachedFileInformation();
            this.errorMessage = null;
        }
    }

    protected void refresh(IProgressMonitor progress) {
        if (this.file != null) {
            try {
                this.file.refreshLocal(2, progress);
                this.updateCachedFileInformation();
                this.errorMessage = null;
            }
            catch (CoreException err) {
                Object[] params = new Object[]{((Object)this.file.getFullPath()).toString()};
                String msg = ModelerCore.Util.getString("ModelBufferImpl.Error_while_refreshing", params);
                throw new ModelerCoreRuntimeException(err, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open(IProgressMonitor progress) {
        block32: {
            block31: {
                block30: {
                    if (this.emfResourceSet == null || this.file == null) break block31;
                    IPath path = this.file.getLocation();
                    URI uri = URI.createFileURI(((Object)path).toString());
                    if (ModelerCore.DEBUG_MODEL_WORKSPACE) {
                        String pathInProj = this.file.getProject().getName() + '/' + this.file.getProjectRelativePath();
                        Object[] params = new Object[]{pathInProj};
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("ModelBufferImpl.DEBUG.Opening_model", params));
                    }
                    boolean startedTxn = false;
                    UnitOfWork txn = null;
                    try {
                        Container cntr;
                        if (this.emfResourceSet instanceof Container && !(txn = (cntr = (Container)this.emfResourceSet).getEmfTransactionProvider().getCurrent()).isStarted()) {
                            try {
                                txn.begin();
                                txn.setSignificant(false);
                                txn.setUndoable(false);
                                txn.setSource(cntr);
                            }
                            catch (ModelerCoreException e2) {
                                ModelerCore.Util.log(4, e2, e2.getMessage());
                            }
                            startedTxn = true;
                        }
                        ResourceAction action = null;
                        Resource duplicateOfResource = null;
                        this.errorMessage = null;
                        boolean justLoaded = false;
                        try {
                            action = ContainerImpl.getOrCreateResource(this.emfResourceSet, uri);
                            this.emfResource = action.getResource();
                            File file = this.file.getLocation().toFile();
                            if (file.canRead() && file.exists() && file.length() != 0L && !this.emfResource.isLoaded()) {
                                this.emfResource.load(this.emfResourceSet.getLoadOptions());
                                justLoaded = true;
                            }
                        }
                        catch (DuplicateResourceException e3) {
                            duplicateOfResource = e3.getDuplicateOfModel();
                            this.errorMessage = e3.getMessage();
                        }
                        catch (Throwable t2) {
                            Object[] params = new Object[]{uri};
                            String msg = ModelerCore.Util.getString("ModelBufferImpl.Error_creating_resource_for_URI", params);
                            throw new ModelerCoreRuntimeException(t2, msg);
                        }
                        if (this.emfResource != null) {
                            if (this.emfResource instanceof EmfResource) {
                                this.contents = ((EmfResource)this.emfResource).getModelContents();
                                Assertion.isNotNull(this.contents);
                            }
                            if (this.contents == null) {
                                this.contents = new ModelContents(this.emfResource);
                            }
                            OpenableImpl modelResource = (OpenableImpl)this.getOwner();
                            modelResource.getBufferManager().registerEmfResource(this.emfResource, modelResource);
                            if (justLoaded) {
                                this.getModelContents().getModelAnnotation();
                                try {
                                    this.updateCachedFileInformation();
                                }
                                catch (Exception e4) {
                                    Object[] params = new Object[]{uri};
                                    String msg = ModelerCore.Util.getString("ModelBufferImpl.Unable_to_initialize_new_model_URI", params);
                                    throw new ModelerCoreRuntimeException(e4, msg);
                                }
                            }
                            if (this.file.exists()) {
                                try {
                                    this.file.setSessionProperty(ModelerCore.DUPLICATE_MODEL_OF_IPATH_KEY, null);
                                }
                                catch (CoreException e5) {
                                    ModelerCore.Util.log(e5);
                                }
                            }
                        } else {
                            if (duplicateOfResource != null) {
                                ModelResource duplicateOfModelResource = ModelerCore.getModelWorkspace().findModelResource(duplicateOfResource);
                                if (duplicateOfModelResource == null) {
                                    throw new DuplicateResourceException(duplicateOfResource, null, this.errorMessage);
                                }
                                IPath duplicateOfModelPath = duplicateOfModelResource.getPath();
                                try {
                                    this.file.setSessionProperty(ModelerCore.DUPLICATE_MODEL_OF_IPATH_KEY, ((Object)duplicateOfModelPath).toString());
                                }
                                catch (CoreException err) {
                                    Object[] params = new Object[]{uri, duplicateOfModelPath};
                                    String msg = ModelerCore.Util.getString("ModelBufferImpl.Unable_to_mark_resource_as_duplicate", params);
                                    throw new ModelerCoreRuntimeException(err, msg);
                                }
                                throw new DuplicateResourceException(duplicateOfResource, duplicateOfModelPath, this.errorMessage);
                            }
                            throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("ModelBufferImpl.Could_not_resolve_local_resource_for_{0}_1", uri));
                        }
                        Object var15_24 = null;
                        if (!startedTxn || txn == null) break block30;
                    }
                    catch (Throwable throwable) {
                        Object var15_25 = null;
                        if (startedTxn && txn != null) {
                            try {
                                txn.commit();
                            }
                            catch (ModelerCoreException e6) {
                                ModelerCore.Util.log(4, e6, e6.getMessage());
                            }
                        }
                        if (this.emfResource != null) {
                            this.emfResource.setModified(false);
                        }
                        throw throwable;
                    }
                    try {
                        txn.commit();
                    }
                    catch (ModelerCoreException e6) {
                        ModelerCore.Util.log(4, e6, e6.getMessage());
                    }
                }
                if (this.emfResource != null) {
                    this.emfResource.setModified(false);
                }
                break block32;
            }
            throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("ModelBufferImpl.Can_not_open_Model_Buffer_with_both_a_null_ResourceSet_and_null_IFile_1"));
        }
    }

    protected void updateCachedFileInformation() {
        block9: {
            if (this.file == null) {
                this.lastModificationStamp = -1L;
                this.lastFileSize = 0L;
                this.lastChecksum = 0L;
            } else {
                this.lastModificationStamp = this.file.getModificationStamp();
                if (!this.file.exists()) {
                    this.lastFileSize = 0L;
                    this.lastChecksum = 0L;
                } else {
                    File rawFile;
                    IPath rawLocation = this.file.getRawLocation();
                    if (rawLocation != null && (rawFile = new File(((Object)rawLocation).toString())) != null && rawFile.exists()) {
                        this.lastFileSize = rawFile.length();
                        FileInputStream stream = null;
                        try {
                            stream = new FileInputStream(rawFile);
                            BufferedInputStream buffer = new BufferedInputStream(stream);
                            Checksum checksum = ChecksumUtil.computeChecksum(buffer);
                            this.lastChecksum = checksum.getValue();
                        }
                        catch (IOException err) {
                            if (stream == null) break block9;
                            try {
                                ((InputStream)stream).close();
                            }
                            catch (IOException err1) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
    }

    public IStatus getErrors() {
        if (this.hasErrors()) {
            String msg = this.errorMessage != null ? this.errorMessage : "";
            return new Status(4, "com.metamatrix.modeler.core", 0, msg, null);
        }
        return new Status(0, "com.metamatrix.modeler.core", 0, "", null);
    }

    public boolean hasErrors() {
        if (this.file == null) {
            return false;
        }
        Object duplicateOfModel = null;
        try {
            duplicateOfModel = this.file.getSessionProperty(ModelerCore.DUPLICATE_MODEL_OF_IPATH_KEY);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return duplicateOfModel != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void close() {
        block16: {
            if (this.emfResource != null) {
                if (this.file != null && ModelerCore.DEBUG_MODEL_WORKSPACE) {
                    pathInProj = this.file.getProject().getName() + '/' + this.file.getProjectRelativePath();
                    params = new Object[]{pathInProj};
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("ModelBufferImpl.DEBUG.Closing_model", params));
                }
                startedTxn = false;
                txn = null;
                try {
                    cntr = ModelerCore.getModelContainer();
                    txn = cntr.getEmfTransactionProvider().getCurrent();
                    if (!txn.isStarted()) {
                        try {
                            txn.begin();
                            txn.setSignificant(false);
                            txn.setUndoable(false);
                        }
                        catch (ModelerCoreException e) {
                            ModelerCore.Util.log(4, e, e.getMessage());
                        }
                        startedTxn = true;
                    }
                    modelResource = (OpenableImpl)this.getOwner();
                    modelResource.getBufferManager().unregisterEmfResource(this.emfResource);
                    this.emfResource.unload();
                    this.contents = null;
                    var6_8 = null;
                    ** if (!startedTxn || txn == null) goto lbl-1000
                }
                catch (Throwable var5_14) {
                    var6_10 = null;
                    if (startedTxn && txn != null) {
                        try {
                            txn.commit();
                        }
                        catch (ModelerCoreException e) {
                            ModelerCore.Util.log(4, e, e.getMessage());
                        }
                    }
                    throw var5_14;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        txn.commit();
                    }
                    catch (ModelerCoreException e) {
                        ModelerCore.Util.log(4, e, e.getMessage());
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block16;
                    catch (CoreException theException) {
                        ModelerCore.Util.log(4, theException, theException.getMessage());
                        var6_9 = null;
                        if (startedTxn && txn != null) {
                            try {
                                txn.commit();
                            }
                            catch (ModelerCoreException e) {
                                ModelerCore.Util.log(4, e, e.getMessage());
                            }
                        }
                    }
                }
            }
        }
        this.updateCachedFileInformation();
    }

    public void save(IProgressMonitor progress, boolean force) throws ModelWorkspaceException {
        if (this.file == null) {
            return;
        }
        if (this.file.isReadOnly()) {
            String pathInProj = this.file.getProject().getName() + '/' + this.file.getProjectRelativePath();
            Object[] params = new Object[]{pathInProj};
            throw new ModelWorkspaceException(ModelerCore.Util.getString("ModelBufferImpl.Model_is_readonly", params));
        }
        try {
            StreamPipe pipe = new StreamPipe();
            InputStream istream = pipe.getInputStream();
            final OutputStream ostream = pipe.getOutputStream();
            if (ModelerCore.DEBUG_MODEL_WORKSPACE) {
                String pathInProj = this.file.getProject().getName() + '/' + this.file.getProjectRelativePath();
                Object[] params = new Object[]{pathInProj};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("ModelBufferImpl.DEBUG.Saving_model", params));
            }
            final Map theOptions = this.options;
            new Thread("ModelBuffer.Save"){

                public void run() {
                    ModelBufferImpl.this.saveInTransaction(ostream, theOptions);
                }
            }.start();
            if (this.file.exists()) {
                this.file.refreshLocal(0, null);
                this.inProcessOfSavingContents = true;
                this.file.setContents(istream, force ? 3 : 2, progress);
            } else {
                this.inProcessOfSavingContents = true;
                this.file.create(istream, force ? 3 : 2, progress);
            }
            this.updateCachedFileInformation();
            this.inProcessOfSavingContents = false;
        }
        catch (CoreException e2) {
            throw new ModelWorkspaceException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveInTransaction(OutputStream ostream, Map theOptions) {
        UnitOfWork txn;
        boolean startedTxn;
        block24: {
            startedTxn = false;
            txn = null;
            Container cntr = ModelerCore.getModelContainer();
            txn = cntr.getEmfTransactionProvider().getCurrent();
            if (!txn.isStarted()) {
                try {
                    txn.begin();
                    txn.setSignificant(false);
                    txn.setUndoable(false);
                }
                catch (ModelerCoreException e2) {
                    ModelerCore.Util.log(4, e2, e2.getMessage());
                }
                startedTxn = true;
            }
            Resource resource = this.emfResource;
            if (resource instanceof XSDResourceImpl) {
                ModelAnnotation annotation = this.contents.getModelAnnotation();
                XPackage extPackage = annotation.getExtensionPackage();
                try {
                    if (extPackage != null) {
                        XsdObjectExtension.setExtensionPackage((XSDResourceImpl)resource, extPackage);
                    } else {
                        XsdObjectExtension.removeExtensionPackage((XSDResourceImpl)resource);
                    }
                }
                catch (ModelerCoreException err) {
                    ModelerCore.Util.log(4, err.getMessage());
                }
            }
            this.emfResource.save(ostream, theOptions);
            Object var11_13 = null;
            try {
                ostream.close();
            }
            catch (IOException e1) {
                String pathInProj = this.file.getProject().getName() + '/' + this.file.getProjectRelativePath();
                Object[] params = new Object[]{pathInProj, e1.getMessage()};
                ModelerCore.Util.log(1, e1, ModelerCore.Util.getString("ModelBufferImpl.Error_closing_stream", params));
            }
            break block24;
            {
                catch (IOException e3) {
                    Object var11_14 = null;
                    try {
                        ostream.close();
                    }
                    catch (IOException e1) {
                        String pathInProj = this.file.getProject().getName() + '/' + this.file.getProjectRelativePath();
                        Object[] params = new Object[]{pathInProj, e1.getMessage()};
                        ModelerCore.Util.log(1, e1, ModelerCore.Util.getString("ModelBufferImpl.Error_closing_stream", params));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                try {
                    ostream.close();
                    throw throwable;
                }
                catch (IOException e1) {
                    String pathInProj = this.file.getProject().getName() + '/' + this.file.getProjectRelativePath();
                    Object[] params = new Object[]{pathInProj, e1.getMessage()};
                    ModelerCore.Util.log(1, e1, ModelerCore.Util.getString("ModelBufferImpl.Error_closing_stream", params));
                }
                throw throwable;
            }
        }
        Object var16_26 = null;
        if (!startedTxn || txn == null) return;
        try {
            txn.commit();
            return;
        }
        catch (ModelerCoreException e4) {
            ModelerCore.Util.log(4, e4, e4.getMessage());
        }
        return;
        {
            catch (CoreException theException) {
                ModelerCore.Util.log(4, theException, theException.getMessage());
                Object var16_27 = null;
                if (!startedTxn) return;
                if (txn == null) return;
                try {
                    txn.commit();
                    return;
                }
                catch (ModelerCoreException e4) {
                    ModelerCore.Util.log(4, e4, e4.getMessage());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var16_28 = null;
            if (!startedTxn || txn == null) throw throwable;
            try {
                txn.commit();
                throw throwable;
            }
            catch (ModelerCoreException e4) {
                ModelerCore.Util.log(4, e4, e4.getMessage());
            }
            throw throwable;
        }
    }

    public Map getOptions() {
        return this.options;
    }

    public void setOptions(Map map) {
        this.options = map;
    }

    public long getLastModificationStamp() {
        return this.lastModificationStamp;
    }

    public long getLastFileSize() {
        return this.lastFileSize;
    }

    public long getLastChecksum() {
        return this.lastChecksum;
    }

    public boolean isInProcessOfSaving() {
        return this.inProcessOfSavingContents;
    }
}

