/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.util.ModelResourceContainerFactory;
import com.metamatrix.modeler.core.workspace.ModelDiagrams;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.core.workspace.Openable;
import com.metamatrix.modeler.internal.core.workspace.ModelBufferImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelResourceImpl;
import com.metamatrix.modeler.internal.core.workspace.NonOpenableModelWorkspaceItemImpl;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;

public class ModelDiagramsImpl
extends NonOpenableModelWorkspaceItemImpl
implements ModelDiagrams {
    protected static final String DEFAULT_NAME = ModelerCore.Util.getString("ModelDiagramsImpl.defaultName");

    ModelDiagramsImpl() {
        super(8, null, DEFAULT_NAME);
    }

    public ModelDiagramsImpl(ModelWorkspaceItem parent) {
        super(8, parent, DEFAULT_NAME);
    }

    public ModelResource getModelResource() {
        return (ModelResource)this.getParent();
    }

    public IResource getResource() {
        return this.getModelResource().getResource();
    }

    public IResource getUnderlyingResource() throws ModelWorkspaceException {
        return this.getResource();
    }

    public IPath getPath() {
        return this.getModelResource().getPath();
    }

    protected ModelBufferImpl getModelBuffer() throws ModelWorkspaceException {
        ModelResourceImpl modelResourceImpl = (ModelResourceImpl)this.getModelResource();
        return (ModelBufferImpl)modelResourceImpl.getBuffer();
    }

    public List getDiagrams(EObject target) throws ModelWorkspaceException {
        ModelBufferImpl buffer = this.getModelBuffer();
        ModelContents contents = buffer.getModelContents();
        if (contents == null) {
            Object[] params = new Object[]{this.getParent().getPath()};
            String msg = ModelerCore.Util.getString("ModelDiagramsImpl.No_ModelContents_found_for_resource", params);
            Assertion.assertTrue(false, msg);
        }
        return contents.getDiagrams(target);
    }

    public List getDiagrams() throws ModelWorkspaceException {
        return this.getModelBuffer().getModelContents().getDiagrams();
    }

    public Diagram createNewDiagram(EObject target, boolean persistent) throws ModelWorkspaceException {
        EObject finalTarget = target;
        if (finalTarget == null) {
            finalTarget = this.getModelBuffer().getModelContents().getModelAnnotation();
        }
        return ModelResourceContainerFactory.createNewDiagram(finalTarget, this.getModelResource().getEmfResource(), persistent);
    }

    public boolean delete(Diagram diagram) throws ModelWorkspaceException {
        return ModelResourceContainerFactory.deleteDiagram(diagram);
    }

    public boolean isPersistent(Diagram diagram) throws ModelWorkspaceException {
        return ModelResourceContainerFactory.isPersistent(diagram);
    }

    public void setPersistent(Diagram diagram, boolean persistent) throws ModelWorkspaceException {
        if (persistent == this.isPersistent(diagram)) {
            return;
        }
        ModelResourceContainerFactory.setDiagramPersistence(diagram, this.getModelResource().getEmfResource(), persistent);
    }

    public Openable getOpenable() {
        return this.getOpenableParent();
    }
}

