/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelFolder;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.internal.core.workspace.ModelFolderInfo;
import com.metamatrix.modeler.internal.core.workspace.ModelResourceImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.core.workspace.OpenableImpl;
import com.metamatrix.modeler.internal.core.workspace.OpenableModelWorkspaceItemInfo;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ModelFolderImpl
extends OpenableImpl
implements ModelFolder {
    protected IFolder ifolder;
    protected IPath path;

    public ModelFolderImpl(IFolder folder, ModelWorkspaceItem parent) {
        super(4, parent, folder.getName());
        this.ifolder = folder;
    }

    public Object[] getNonModelingResources() throws ModelWorkspaceException {
        return ((ModelFolderInfo)this.getItemInfo()).getNonModelResources(this);
    }

    public IPath getPath() {
        if (this.path == null) {
            return this.getFolder().getFullPath();
        }
        return this.path;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public IFolder getFolder() {
        return this.ifolder;
    }

    public IResource getResource() {
        return this.getFolder();
    }

    public IResource getUnderlyingResource() throws ModelWorkspaceException {
        return this.getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean generateInfos(OpenableModelWorkspaceItemInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelWorkspaceException {
        boolean validInfo = false;
        try {
            ModelWorkspaceManager.getModelWorkspaceManager().putInfo(this, info);
            this.updateFolderContents();
            validInfo = true;
        }
        finally {
            if (!validInfo) {
                ModelWorkspaceManager.getModelWorkspaceManager().removeInfo(this);
            }
        }
        return validInfo;
    }

    protected ModelFolderInfo getModelFolderInfo() throws ModelWorkspaceException {
        return (ModelFolderInfo)this.getItemInfo();
    }

    public void updateFolderContents() throws ModelWorkspaceException {
        if (this.isOpen()) {
            boolean failed = false;
            try {
                ModelFolderInfo info = this.getModelFolderInfo();
                info.setNonModelResources(null);
                info.setChildren(this.computeModelFolderChildren());
            }
            catch (ModelWorkspaceException e2) {
                failed = true;
                throw e2;
            }
            catch (RuntimeException e3) {
                failed = true;
                throw e3;
            }
            finally {
                if (failed) {
                    try {
                        this.close();
                    }
                    catch (ModelWorkspaceException ex) {}
                }
            }
        }
    }

    public ModelWorkspaceItem[] computeModelFolderChildren() throws ModelWorkspaceException {
        ObjectVector accumulatedModelResources = new ObjectVector();
        this.computeModelFolderResources(this.getFolder(), accumulatedModelResources);
        Object[] results = new ModelWorkspaceItem[accumulatedModelResources.size()];
        accumulatedModelResources.copyInto(results);
        return results;
    }

    public void computeModelFolderResources(IContainer container, ObjectVector accumulatedModelResources) throws ModelWorkspaceException {
        if (container.exists()) {
            try {
                IResource[] children = container.members();
                for (int i2 = 0; i2 < children.length; ++i2) {
                    IResource child = children[i2];
                    if (1 == child.getType()) {
                        if (ModelUtil.isModelFile(child)) {
                            ModelResource mdlResource = this.createModelResource((IFile)child);
                            accumulatedModelResources.add(mdlResource);
                            continue;
                        }
                        if (ModelUtil.isModelFileExtension(child.getFileExtension(), true) || !ModelUtil.isModelFileExtension(child.getFileExtension(), false)) continue;
                        String actualFileName = child.getName();
                        String actualExtension = child.getFileExtension();
                        int endIndex = actualFileName.length() - actualExtension.length();
                        String expectedFileName = actualFileName.substring(0, endIndex) + actualExtension.toLowerCase();
                        Object[] params = new Object[]{actualFileName, expectedFileName};
                        String msg = ModelerCore.Util.getString("ModelerCore.file_extension_not_correct_case_please_rename_file", params);
                        ModelerCore.Util.log(4, msg);
                        continue;
                    }
                    if (2 != child.getType()) continue;
                    ModelFolder mdlFolder = this.createModelFolder((IFolder)child);
                    accumulatedModelResources.add(mdlFolder);
                }
            }
            catch (CoreException e2) {
                ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ModelFolderImpl.Error_while_computing_ModelWorkspaceItem_instances_for_ModelFolder", this));
            }
        }
    }

    protected OpenableModelWorkspaceItemInfo createItemInfo() {
        return new ModelFolderInfo();
    }

    protected ModelResource createModelResource(IFile resource) {
        return new ModelResourceImpl(this, resource.getName());
    }

    protected ModelFolder createModelFolder(IFolder folder) {
        return new ModelFolderImpl(folder, this);
    }

    public ModelWorkspaceItem getModelWorkspaceItem(IResource resource) throws ModelWorkspaceException {
        ArgCheck.isNotNull(resource);
        ModelWorkspaceItem[] children = this.getChildren();
        for (int i2 = 0; i2 < children.length; ++i2) {
            ModelWorkspaceItem child = children[i2];
            IResource thatResource = child.getCorrespondingResource();
            if (!((Object)resource).equals(thatResource)) continue;
            return child;
        }
        return null;
    }
}

