/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelFolder;
import com.metamatrix.modeler.core.workspace.ModelProject;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.internal.core.workspace.ModelFolderImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelProjectInfo;
import com.metamatrix.modeler.internal.core.workspace.ModelResourceImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.core.workspace.OpenableImpl;
import com.metamatrix.modeler.internal.core.workspace.OpenableModelWorkspaceItemInfo;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ModelProjectImpl
extends OpenableImpl
implements IProjectNature,
ModelProject {
    protected static final boolean IS_CASE_SENSITIVE = !new File("Temp").equals(new File("temp"));
    public static final String PREF_FILENAME = ".mprefs";
    protected IProject fProject;
    protected IPath path;

    public ModelProjectImpl() {
        super(2, null, null);
    }

    public ModelProjectImpl(IProject project, ModelWorkspaceItem parent) {
        super(2, parent, project.getName());
        this.fProject = project;
    }

    public static IPath canonicalizedPath(IPath externalPath) {
        IPath result;
        if (externalPath == null) {
            return null;
        }
        if (IS_CASE_SENSITIVE) {
            return externalPath;
        }
        IWorkspace workspace = ModelerCore.getWorkspace();
        if (workspace == null) {
            return externalPath;
        }
        if (workspace.getRoot().findMember(externalPath) != null) {
            return externalPath;
        }
        Path canonicalPath = null;
        try {
            canonicalPath = new Path(new File(externalPath.toOSString()).getCanonicalPath());
        }
        catch (IOException e2) {
            return externalPath;
        }
        int canonicalLength = canonicalPath.segmentCount();
        if (canonicalLength == 0) {
            return externalPath;
        }
        if (externalPath.isAbsolute()) {
            result = canonicalPath;
        } else {
            int externalLength = externalPath.segmentCount();
            if (canonicalLength >= externalLength) {
                result = canonicalPath.removeFirstSegments(canonicalLength - externalLength);
            } else {
                return externalPath;
            }
        }
        if (externalPath.getDevice() == null) {
            result = result.setDevice(null);
        }
        return result;
    }

    private void addToBuildSpec(String builderId) throws CoreException {
        IProject project = this.getProject();
        IProjectDescription desc = project.getDescription();
        ICommand cmd = this.getBuilderCommand(desc, builderId);
        if (cmd == null) {
            cmd = desc.newCommand();
            cmd.setBuilderName(builderId);
            ICommand[] cmds = desc.getBuildSpec();
            ICommand[] newCmds = new ICommand[cmds.length + 1];
            System.arraycopy(cmds, 0, newCmds, 1, cmds.length);
            newCmds[0] = cmd;
            desc.setBuildSpec(newCmds);
            project.setDescription(desc, null);
        }
    }

    public void configure() throws CoreException {
        this.addToBuildSpec("com.metamatrix.modeler.core.modelBuilder");
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec("com.metamatrix.modeler.core.modelBuilder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean generateInfos(OpenableModelWorkspaceItemInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelWorkspaceException {
        boolean validInfo = false;
        try {
            if (this.getProject().isOpen()) {
                ModelWorkspaceManager.getModelWorkspaceManager().putInfo(this, info);
                this.updatePackageFragmentRoots();
                validInfo = true;
            }
        }
        finally {
            if (!validInfo) {
                ModelWorkspaceManager.getModelWorkspaceManager().removeInfo(this);
            }
        }
        return validInfo;
    }

    private ICommand getBuilderCommand(IProjectDescription description, String builderId) throws CoreException {
        ICommand[] cmds = description.getBuildSpec();
        int ndx = cmds.length;
        while (--ndx >= 0) {
            ICommand cmd = cmds[ndx];
            if (!cmd.getBuilderName().equals(builderId)) continue;
            return cmd;
        }
        return null;
    }

    public Object[] getNonModelingResources() throws ModelWorkspaceException {
        return ((ModelProjectInfo)this.getItemInfo()).getNonModelResources(this);
    }

    public IPath getPath() {
        if (this.path == null) {
            return this.getProject().getFullPath();
        }
        return this.path;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public IResource getResource() {
        return this.getProject();
    }

    private void removeFromBuildSpec(String builderId) throws CoreException {
        IProject project = this.getProject();
        IProjectDescription desc = project.getDescription();
        ICommand[] cmds = desc.getBuildSpec();
        int ndx = cmds.length;
        while (--ndx >= 0) {
            ICommand cmd = cmds[ndx];
            if (!cmd.getBuilderName().equals(builderId)) continue;
            ICommand[] newCmds = new ICommand[cmds.length - 1];
            System.arraycopy(cmds, 0, newCmds, 0, ndx);
            System.arraycopy(cmds, ndx + 1, newCmds, ndx, cmds.length - ndx - 1);
            desc.setBuildSpec(newCmds);
            project.setDescription(desc, null);
            return;
        }
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    protected ModelProjectInfo getModelProjectInfo() throws ModelWorkspaceException {
        return (ModelProjectInfo)this.getItemInfo();
    }

    public void updatePackageFragmentRoots() throws ModelWorkspaceException {
        if (this.isOpen()) {
            boolean failed = false;
            try {
                ModelProjectInfo info = this.getModelProjectInfo();
                info.setNonModelResources(null);
                info.setChildren(this.computeModelResources());
            }
            catch (ModelWorkspaceException e2) {
                failed = true;
                throw e2;
            }
            catch (RuntimeException e3) {
                failed = true;
                throw e3;
            }
            finally {
                if (failed) {
                    try {
                        this.close();
                    }
                    catch (ModelWorkspaceException ex) {}
                }
            }
        }
    }

    public ModelWorkspaceItem findModelWorkspaceItem(IResource resource) throws ModelWorkspaceException {
        ArgCheck.isNotNull(resource);
        return ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(resource);
    }

    protected ModelResource createModelResource(IFile resource) {
        ModelWorkspaceItem parent = this.findParent(resource);
        return new ModelResourceImpl(parent, resource.getName());
    }

    protected ModelFolder createModelFolder(IFolder folder) {
        ModelWorkspaceItem parent = this.findParent(folder);
        return new ModelFolderImpl(folder, parent);
    }

    private ModelWorkspaceItem findParent(IResource resource) {
        IContainer iParent = resource.getParent();
        if (iParent instanceof IProject) {
            return this;
        }
        ModelWorkspaceItem parent = this.getModelWorkspace().getParent(resource);
        return parent;
    }

    public ModelWorkspaceItem[] computeModelResources() throws ModelWorkspaceException {
        ObjectVector accumulatedModelResources = new ObjectVector();
        this.computeModelResources(this.getProject(), accumulatedModelResources);
        Object[] results = new ModelWorkspaceItem[accumulatedModelResources.size()];
        accumulatedModelResources.copyInto(results);
        return results;
    }

    public void computeModelResources(IContainer container, ObjectVector accumulatedModelResources) throws ModelWorkspaceException {
        try {
            IResource[] children = container.members();
            for (int i2 = 0; i2 < children.length; ++i2) {
                IResource child = children[i2];
                if (1 == child.getType()) {
                    if (ModelUtil.isModelFile(child)) {
                        ModelResource mdlResource = this.createModelResource((IFile)child);
                        accumulatedModelResources.add(mdlResource);
                        continue;
                    }
                    if (ModelUtil.isModelFileExtension(child.getFileExtension(), true) || !ModelUtil.isModelFileExtension(child.getFileExtension(), false)) continue;
                    String actualFileName = child.getName();
                    String actualExtension = child.getFileExtension();
                    int endIndex = actualFileName.length() - actualExtension.length();
                    String expectedFileName = actualFileName.substring(0, endIndex) + actualExtension.toLowerCase();
                    Object[] params = new Object[]{actualFileName, expectedFileName};
                    String msg = ModelerCore.Util.getString("ModelerCore.file_extension_not_correct_case_please_rename_file", params);
                    ModelerCore.Util.log(4, msg);
                    continue;
                }
                if (2 != child.getType()) continue;
                ModelFolder mdlFolder = this.createModelFolder((IFolder)child);
                accumulatedModelResources.add(mdlFolder);
            }
        }
        catch (CoreException e2) {
            ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ModelProjectImpl.Error_while_computing_ModelResource_instances_for_ModelProject", this));
        }
    }

    protected OpenableModelWorkspaceItemInfo createItemInfo() {
        return new ModelProjectInfo();
    }
}

