/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.ChecksumUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.xml.xmi.ModelImportInfo;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.internal.core.xml.xmi.XMIHeaderReader;
import com.metamatrix.internal.core.xml.xsd.XsdHeader;
import com.metamatrix.internal.core.xml.xsd.XsdHeaderReader;
import com.metamatrix.metamodels.core.CoreFactory;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.core.MetamodelDescriptor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.container.DuplicateResourceException;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.workspace.ModelBuffer;
import com.metamatrix.modeler.core.workspace.ModelDiagrams;
import com.metamatrix.modeler.core.workspace.ModelMappingClassSets;
import com.metamatrix.modeler.core.workspace.ModelObjectAnnotations;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelTransformations;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceNotification;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.workspace.ModelBufferImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelBufferManager;
import com.metamatrix.modeler.internal.core.workspace.ModelDiagramsImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelMappingClassSetsImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelObjectAnnotationsImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelResourceInfo;
import com.metamatrix.modeler.internal.core.workspace.ModelTransformationsImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.core.workspace.OpenableImpl;
import com.metamatrix.modeler.internal.core.workspace.OpenableModelWorkspaceItemInfo;
import com.metamatrix.modeler.internal.core.workspace.WorkspaceResourceFinderUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;

public class ModelResourceImpl
extends OpenableImpl
implements ModelResource {
    private int indexType;
    private XMIHeader xmiHeader;
    private XsdHeader xsdHeader;
    private ModelType mdlType = null;
    private IStatus errors = null;
    private long checkSumForIndexType = 0L;
    private long fileSizeForIndexType = 0L;

    ModelResourceImpl() {
        super(5, null, null);
        this.xmiHeader = null;
        this.xsdHeader = null;
        this.setIndexType(0);
        ModelWorkspaceManager.getModelWorkspaceManager().setIndexType(0);
    }

    public ModelResourceImpl(ModelWorkspaceItem parent, String name) {
        this(parent, name, true);
    }

    ModelResourceImpl(ModelWorkspaceItem parent, String name, boolean createEmfResource) {
        super(5, parent, name);
        if (createEmfResource) {
            try {
                IResource iResource = this.getResource();
                IPath path = iResource.getLocation();
                URI uri = URI.createFileURI(path.toOSString());
                ResourceSet resourceSet = super.getBufferManager().getResourceSetFinder().getResourceSet(iResource);
                if (resourceSet.getResource(uri, false) == null) {
                    resourceSet.createResource(uri);
                }
            }
            catch (DuplicateResourceException dre) {
                ModelerCore.Util.log(dre);
            }
            catch (ModelWorkspaceException mwe) {
                ModelerCore.Util.log(mwe);
            }
        }
    }

    protected OpenableModelWorkspaceItemInfo createItemInfo() {
        return new ModelResourceInfo();
    }

    public boolean isLoaded() {
        return this.getBufferManager().getOpenBuffer(this) != null;
    }

    public boolean hasErrors() {
        block3: {
            if (this.errors == null) {
                try {
                    this.getBuffer();
                }
                catch (ModelWorkspaceException err) {
                    Throwable nested = err.getException();
                    if (nested instanceof DuplicateResourceException) break block3;
                    ModelerCore.Util.log(err);
                }
            }
        }
        return this.errors != null && !this.errors.isOK();
    }

    public IStatus getErrors() {
        try {
            ModelBuffer buffer = this.getBuffer();
            if (buffer != null) {
                return buffer.getErrors();
            }
        }
        catch (ModelWorkspaceException err) {
            Throwable nested = err.getException();
            if (nested instanceof DuplicateResourceException) {
                return this.errors;
            }
            ModelerCore.Util.log(err);
        }
        return new Status(0, "com.metamatrix.modeler.core", 0, "", null);
    }

    public boolean isXsd() {
        return ModelUtil.isXsdFile(this.getResource());
    }

    public String getTargetNamespace() throws ModelWorkspaceException {
        String targetNamespace = null;
        if (!this.isResourceOpenAndLoaded()) {
            XsdHeader header = this.getXsdHeader();
            if (header != null) {
                targetNamespace = header.getTargetNamespaceURI();
            }
        } else {
            XSDSchema xsdSchema;
            Resource resource = this.getEmfResource();
            if (resource instanceof XSDResourceImpl && (xsdSchema = ((XSDResourceImpl)resource).getSchema()) != null) {
                targetNamespace = xsdSchema.getTargetNamespace();
            }
        }
        return targetNamespace;
    }

    public void unload() {
        ModelBuffer modelBuffer = this.getBufferManager().getOpenBuffer(this);
        if (modelBuffer != null) {
            this.closeBuffer(null);
            ModelWorkspaceManager.getModelWorkspaceManager().removeInfo(this);
            this.xmiHeader = null;
            this.xsdHeader = null;
            this.mdlType = null;
        }
    }

    public int getIndexType() {
        return this.indexType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void refreshIndexType() {
        block16: {
            try {
                block18: {
                    buf = this.getBuffer();
                    if (buf == null || !((iResource = this.getResource()) instanceof IFile)) break block16;
                    if (this.indexType == 0) {
                        return;
                    }
                    fileSizeDifference = false;
                    rawLocation = iResource.getRawLocation();
                    if (rawLocation != null && (rawFile = new File(rawLocation.toString())) != null && rawFile.exists() && (fileSize = rawFile.length()) != this.fileSizeForIndexType) {
                        this.fileSizeForIndexType = fileSize;
                        fileSizeDifference = true;
                    }
                    checksumDifference = false;
                    stream = null;
                    try {
                        block17: {
                            stream = ((IFile)iResource).getContents();
                            checksum = ChecksumUtil.computeChecksum(stream);
                            checksumValue = checksum.getValue();
                            if (checksumValue == this.checkSumForIndexType) break block17;
                            this.checkSumForIndexType = checksumValue;
                            checksumDifference = true;
                        }
                        var11_13 = null;
                        ** if (stream == null) goto lbl-1000
                    }
                    catch (Throwable var10_19) {
                        var11_15 = null;
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException ignore) {
                                // empty catch block
                            }
                        }
                        throw var10_19;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            stream.close();
                        }
                        catch (IOException ignore) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block18;
                        catch (Exception e) {
                            this.indexType = 0;
                            var11_14 = null;
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException ignore) {}
                            }
                        }
                    }
                }
                if (fileSizeDifference || checksumDifference) {
                    this.indexType = 0;
                }
            }
            catch (ModelWorkspaceException var1_2) {
                // empty catch block
            }
        }
    }

    public void setIndexType(int indexType) {
        this.indexType = indexType;
    }

    public boolean isReadOnly() {
        if (this.isLoaded() && this.hasErrors()) {
            return true;
        }
        return ModelUtil.isIResourceReadOnly(this.getResource());
    }

    protected boolean isSourceElement() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean generateInfos(OpenableModelWorkspaceItemInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelWorkspaceException {
        boolean validInfo = false;
        try {
            ModelWorkspaceManager.getModelWorkspaceManager().putInfo(this, info);
            validInfo = this.updateModelContents();
        }
        finally {
            if (!validInfo) {
                ModelWorkspaceManager.getModelWorkspaceManager().removeInfo(this);
            }
        }
        return validInfo;
    }

    public List getEObjects() throws ModelWorkspaceException {
        ModelBufferImpl buffer = (ModelBufferImpl)super.getBuffer();
        return buffer.getModelContents() != null ? buffer.getModelContents().getEObjects() : Collections.EMPTY_LIST;
    }

    public List getAllRootEObjects() throws ModelWorkspaceException {
        ModelBufferImpl buffer = (ModelBufferImpl)super.getBuffer();
        return buffer.getModelContents() != null ? buffer.getModelContents().getAllRootEObjects() : Collections.EMPTY_LIST;
    }

    public synchronized Resource getEmfResource() throws ModelWorkspaceException {
        Resource resource = super.getBuffer().getEmfResource();
        Assertion.isNotNull(resource);
        return resource;
    }

    public IResource getResource() {
        ModelWorkspaceItem parent = this.getParent();
        if (parent == null) {
            return null;
        }
        IContainer parentResource = (IContainer)parent.getResource();
        Path path = new Path(this.getItemName());
        return parentResource.getFile(path);
    }

    public IPath getPath() {
        ModelWorkspaceItem parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getPath().append(this.getItemName());
    }

    protected boolean hasBuffer() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelBuffer openBuffer(IProgressMonitor pm) throws ModelWorkspaceException {
        this.opening = true;
        ModelBuffer buffer = null;
        try {
            ModelBufferManager bufManager = this.getBufferManager();
            buffer = bufManager.createBuffer(this);
            if (buffer == null) {
                ModelBuffer modelBuffer = null;
                return modelBuffer;
            }
            if (buffer instanceof ModelBufferImpl) {
                ModelBufferImpl theBuffer = (ModelBufferImpl)buffer;
                try {
                    theBuffer.open(pm);
                }
                catch (DuplicateResourceException err) {
                    throw new ModelWorkspaceException((Throwable)err, err.getMessage());
                }
                finally {
                    this.errors = theBuffer.getErrors();
                }
            }
            bufManager.addBuffer(buffer);
        }
        finally {
            this.opening = false;
        }
        return buffer;
    }

    public IResource getCorrespondingResource() throws ModelWorkspaceException {
        return this.getUnderlyingResource();
    }

    public IResource getUnderlyingResource() throws ModelWorkspaceException {
        return this.getResource();
    }

    public ModelDiagrams getModelDiagrams() throws ModelWorkspaceException {
        return (ModelDiagrams)this.getFirstChildrenOfType(8);
    }

    public ModelTransformations getModelTransformations() throws ModelWorkspaceException {
        return (ModelTransformations)this.getFirstChildrenOfType(9);
    }

    public ModelObjectAnnotations getAnnotations() throws ModelWorkspaceException {
        return (ModelObjectAnnotations)this.getFirstChildrenOfType(10);
    }

    public ModelMappingClassSets getModelMappingClassSets() throws ModelWorkspaceException {
        return (ModelMappingClassSets)this.getFirstChildrenOfType(11);
    }

    public ModelType getModelType() throws ModelWorkspaceException {
        if (this.mdlType != null) {
            return this.mdlType;
        }
        if (!this.isResourceOpenAndLoaded()) {
            XMIHeader header = this.getXmiHeader();
            if (header != null && header.getModelType() != null) {
                this.mdlType = ModelType.get(header.getModelType());
            }
        } else {
            ModelAnnotation annotation = this.getModelAnnotation();
            ModelType modelType = this.mdlType = annotation != null ? annotation.getModelType() : null;
            if (this.mdlType == ModelType.UNKNOWN_LITERAL) {
                this.mdlType = null;
            }
        }
        if (this.mdlType == null && this.isXsd()) {
            this.mdlType = ModelType.TYPE_LITERAL;
        }
        return this.mdlType != null ? this.mdlType : ModelType.PHYSICAL_LITERAL;
    }

    public void setModelType(ModelType type) throws ModelWorkspaceException {
        this.mdlType = type;
    }

    public String getDescription() throws ModelWorkspaceException {
        String description = null;
        if (!this.isResourceOpenAndLoaded()) {
            XMIHeader header = this.getXmiHeader();
            if (header != null) {
                description = header.getDescription();
            }
        } else {
            ModelAnnotation annotation = this.getModelAnnotation();
            description = annotation != null ? annotation.getDescription() : null;
        }
        return description;
    }

    public String getUuid() throws ModelWorkspaceException {
        String uuidString = null;
        if (!this.isResourceOpenAndLoaded()) {
            XMIHeader header = this.getXmiHeader();
            if (header != null) {
                uuidString = header.getUUID();
            }
        } else {
            ObjectID uuid;
            ModelAnnotation annotation = this.getModelAnnotation();
            if (annotation != null && (uuid = annotation.getObjectId()) != null) {
                return ((Object)uuid).toString();
            }
        }
        return uuidString;
    }

    public String getPrimaryMetamodelUri() throws ModelWorkspaceException {
        String uriString = null;
        if (!this.isResourceOpenAndLoaded()) {
            XMIHeader header = this.getXmiHeader();
            if (header != null) {
                uriString = header.getPrimaryMetamodelURI();
            }
        } else {
            ModelAnnotation annotation = this.getModelAnnotation();
            if (annotation != null) {
                uriString = annotation.getPrimaryMetamodelUri();
            }
        }
        return uriString;
    }

    public synchronized ModelAnnotation getModelAnnotation() throws ModelWorkspaceException {
        ModelBufferImpl buffer = (ModelBufferImpl)this.getBufferHack();
        ModelContents contents = buffer.getModelContents();
        return contents != null ? contents.getModelAnnotation() : null;
    }

    protected ModelResourceInfo getModelResourceInfo() throws ModelWorkspaceException {
        return (ModelResourceInfo)this.getItemInfo();
    }

    public boolean updateModelContents() throws ModelWorkspaceException {
        if (this.isOpen()) {
            boolean failed = false;
            try {
                ModelResourceInfo info = this.getModelResourceInfo();
                info.setChildren(this.computeModelContents());
                boolean bl = true;
                return bl;
            }
            catch (ModelWorkspaceException e2) {
                failed = true;
                throw e2;
            }
            catch (RuntimeException e3) {
                failed = true;
                throw e3;
            }
            finally {
                if (failed) {
                    try {
                        this.close();
                    }
                    catch (ModelWorkspaceException ex) {}
                }
            }
        }
        return false;
    }

    public ModelWorkspaceItem[] computeModelContents() throws ModelWorkspaceException {
        if (ModelUtil.isXsdFile(this.getCorrespondingResource())) {
            return new ModelWorkspaceItem[0];
        }
        ModelDiagramsImpl diagramContainer = new ModelDiagramsImpl(this);
        ModelTransformationsImpl transformationContainer = new ModelTransformationsImpl(this);
        ModelObjectAnnotationsImpl annotationContainer = new ModelObjectAnnotationsImpl(this);
        ModelMappingClassSetsImpl mcSets = new ModelMappingClassSetsImpl(this);
        return new ModelWorkspaceItem[]{diagramContainer, transformationContainer, annotationContainer, mcSets};
    }

    public MetamodelDescriptor getPrimaryMetamodelDescriptor() throws ModelWorkspaceException {
        String primaryMetamodelUri = null;
        if (ModelUtil.isXsdFile(this.getResource())) {
            primaryMetamodelUri = "http://www.eclipse.org/xsd/2002/XSD";
        } else if (!this.isResourceOpenAndLoaded()) {
            XMIHeader header = this.getXmiHeader();
            if (header != null) {
                primaryMetamodelUri = header.getPrimaryMetamodelURI();
            }
        } else {
            ModelAnnotation annotation = this.getModelAnnotation();
            String string = primaryMetamodelUri = annotation != null ? annotation.getPrimaryMetamodelUri() : null;
        }
        if (primaryMetamodelUri == null) {
            return null;
        }
        MetamodelDescriptor descriptor = ModelerCore.getMetamodels().getMetamodelDescriptor(primaryMetamodelUri);
        if (descriptor == null) {
            StringBuffer sb = new StringBuffer();
            Collection descriptors = ModelerCore.getMetamodels().getMetamodelDescriptors();
            Iterator iter = descriptors.iterator();
            while (iter.hasNext()) {
                MetamodelDescriptor mmd = (MetamodelDescriptor)iter.next();
                if (!mmd.isPrimaryMetamodel() || StringUtil.isEmpty(mmd.getURI())) continue;
                sb.append(mmd.getURI());
                sb.append(StringUtil.Constants.SPACE);
            }
            Object[] params = new Object[]{primaryMetamodelUri, sb.toString()};
            String msg = ModelerCore.Util.getString("ModelResourceImpl.no_metamodel_found_for_primary_metamodel_URI", params);
            ModelerCore.Util.log(4, msg);
        }
        return descriptor;
    }

    public List getAllMetamodelDescriptors() throws ModelWorkspaceException {
        if (!this.isResourceOpenAndLoaded()) {
            XMIHeader header = this.getXmiHeader();
            if (header != null) {
                String primaryMetamodelUri = header.getPrimaryMetamodelURI();
                String[] namespaceURIs = header.getNamespaceURIs();
                ArrayList<MetamodelDescriptor> result = new ArrayList<MetamodelDescriptor>(namespaceURIs.length);
                for (int i2 = 0; i2 < namespaceURIs.length; ++i2) {
                    String nsUri = namespaceURIs[i2];
                    MetamodelDescriptor desc = ModelerCore.getMetamodels().getMetamodelDescriptor(nsUri);
                    if (desc == null) continue;
                    if (nsUri.equals(primaryMetamodelUri)) {
                        result.add(0, desc);
                        continue;
                    }
                    result.add(desc);
                }
                return result;
            }
        } else {
            Resource resource = this.getEmfResource();
            if (resource instanceof EmfResource) {
                ModelAnnotation annotation = this.getModelAnnotation();
                String primaryMetamodelUri = annotation != null ? annotation.getPrimaryMetamodelUri() : null;
                ArrayList<MetamodelDescriptor> result = new ArrayList<MetamodelDescriptor>(9);
                List nsPrefixToUri = ((EmfResource)resource).getNamespacePrefixToUris();
                Iterator iter = nsPrefixToUri.iterator();
                while (iter.hasNext()) {
                    String nsUri = (String)iter.next();
                    MetamodelDescriptor desc = ModelerCore.getMetamodels().getMetamodelDescriptor(nsUri);
                    if (desc == null) continue;
                    if (nsUri.equals(primaryMetamodelUri)) {
                        result.add(0, desc);
                        continue;
                    }
                    result.add(desc);
                }
                return result;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public List getModelImports() throws ModelWorkspaceException {
        if (!this.isResourceOpenAndLoaded()) {
            XMIHeader header = this.getXmiHeader();
            if (header != null) {
                ModelImportInfo[] infos = header.getModelImportInfos();
                ArrayList<ModelImport> result = new ArrayList<ModelImport>(infos.length);
                for (int i2 = 0; i2 < infos.length; ++i2) {
                    ModelImport modelImport = CoreFactory.eINSTANCE.createModelImport();
                    modelImport.setModelType(ModelType.get(infos[i2].getModelType()));
                    modelImport.setName(infos[i2].getName());
                    modelImport.setPrimaryMetamodelUri(infos[i2].getPrimaryMetamodelURI());
                    modelImport.setUuid(infos[i2].getUUID());
                    String location = infos[i2].getLocation();
                    String path = infos[i2].getPath();
                    if (!StringUtil.isEmpty(location)) {
                        modelImport.setModelLocation(location);
                    } else if (!StringUtil.isEmpty(path)) {
                        if (WorkspaceResourceFinderUtil.isGlobalResource(path)) {
                            modelImport.setModelLocation(location);
                        } else {
                            IResource iResource = WorkspaceResourceFinderUtil.findIResource(path);
                            if (iResource != null) {
                                URI importURI = URI.createFileURI(iResource.getLocation().toFile().getAbsolutePath());
                                URI modelURI = URI.createFileURI(this.getUnderlyingResource().getLocation().toFile().getAbsolutePath());
                                if (importURI.isFile()) {
                                    URI deresolvedURI;
                                    boolean deresolve;
                                    boolean bl = deresolve = modelURI != null && !modelURI.isRelative() && modelURI.isHierarchical();
                                    if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(modelURI, true, true, false)).hasRelativePath()) {
                                        importURI = deresolvedURI;
                                    }
                                    modelImport.setModelLocation(URI.decode(importURI.toString()));
                                }
                            }
                        }
                    }
                    result.add(modelImport);
                }
                return result;
            }
        } else {
            Resource resource = this.getEmfResource();
            if (resource instanceof EmfResource) {
                ModelAnnotation annotation = this.getModelAnnotation();
                return annotation.getModelImports();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean hasChildren() throws ModelWorkspaceException {
        return true;
    }

    private XMIHeader getXmiHeader() throws ModelWorkspaceException {
        if (this.xmiHeader == null) {
            try {
                IPath modelPath = this.getUnderlyingResource().getLocation();
                File modelFile = new File(modelPath.toOSString());
                if (modelFile.exists()) {
                    this.xmiHeader = XMIHeaderReader.readHeader(modelFile);
                }
            }
            catch (MetaMatrixCoreException e2) {
            }
            catch (Throwable e3) {
                throw new ModelWorkspaceException(e3, ModelerCore.Util.getString("ModelResourceImpl.Error_reading_XMI_header_from_resource_1", this.getUnderlyingResource()));
            }
        }
        return this.xmiHeader;
    }

    private XsdHeader getXsdHeader() throws ModelWorkspaceException {
        if (this.xsdHeader == null) {
            try {
                IPath modelPath = this.getUnderlyingResource().getLocation();
                File modelFile = new File(modelPath.toOSString());
                if (modelFile.exists() && ModelUtil.isXsdFile(modelFile)) {
                    this.xsdHeader = XsdHeaderReader.readHeader(modelFile);
                }
            }
            catch (MetaMatrixCoreException e2) {
            }
            catch (Throwable e3) {
                throw new ModelWorkspaceException(e3, ModelerCore.Util.getString("ModelResourceImpl.Error_reading_Xsd_header_from_resource_1", this.getUnderlyingResource()));
            }
        }
        return this.xsdHeader;
    }

    private boolean isResourceOpenAndLoaded() {
        return !this.isOpening() && this.isOpen() && this.isLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean processContentsChange(ModelWorkspaceNotification notification) {
        block20: {
            reloaded = false;
            try {
                block22: {
                    buf = this.getBuffer();
                    if (buf == null || buf.isClosed() || !((resource = (delta = notification.getDelta()).getResource()) instanceof IFile)) break block20;
                    newModStamp = resource.getModificationStamp();
                    lastModStamp = buf.getLastModificationStamp();
                    bufferIsInProcessOfSaving = buf.isInProcessOfSaving();
                    if (newModStamp == -1L || newModStamp == lastModStamp || bufferIsInProcessOfSaving) break block20;
                    rawLocation = resource.getRawLocation();
                    fileSize = 0L;
                    if (rawLocation != null && (rawFile = new File(rawLocation.toString())) != null && rawFile.exists()) {
                        fileSize = rawFile.length();
                    }
                    askToReload = true;
                    if (fileSize == buf.getLastFileSize()) {
                        stream = null;
                        try {
                            block21: {
                                stream = ((IFile)resource).getContents();
                                checksum = ChecksumUtil.computeChecksum(stream);
                                checksumValue = checksum.getValue();
                                if (checksumValue != buf.getLastChecksum()) break block21;
                                askToReload = false;
                            }
                            var20_20 = null;
                            ** if (stream == null) goto lbl-1000
                        }
                        catch (Throwable var19_28) {
                            var20_23 = null;
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException ignore) {
                                    // empty catch block
                                }
                            }
                            throw var19_28;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                stream.close();
                            }
                            catch (IOException ignore) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block22;
                            catch (CoreException err1) {
                                askToReload = true;
                                var20_21 = null;
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException ignore) {}
                                }
                                break block22;
                            }
                            catch (IOException err1) {
                                askToReload = true;
                                var20_22 = null;
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException ignore) {}
                                }
                            }
                        }
                    }
                }
                if (askToReload) {
                    this.setIndexType(0);
                    reload = ModelWorkspaceManager.getModelWorkspaceManager().canReload(this);
                    if (reload) {
                        this.unload();
                        this.getBufferHack();
                        reloaded = true;
                    }
                }
            }
            catch (ModelWorkspaceException var3_4) {
                // empty catch block
            }
        }
        return reloaded;
    }

    public void save(IProgressMonitor pm, boolean force) throws ModelWorkspaceException {
        super.save(pm, force);
        this.refreshIndexType();
    }

    public synchronized void close() throws ModelWorkspaceException {
        super.close();
        if (this.getModelProject().isClosing()) {
            this.removeEmfResource();
        }
    }

    public synchronized void removeEmfResource() throws ModelWorkspaceException {
        IPath path;
        IResource iResource = this.getResource();
        if (iResource != null && (path = iResource.getLocation()) != null) {
            URI uri = URI.createFileURI(((Object)path).toString());
            try {
                Container resourceSet = ModelerCore.getModelContainer();
                Resource resource = resourceSet.getResource(uri, false);
                if (resource != null) {
                    if (resource.isLoaded()) {
                        resource.unload();
                    }
                    resourceSet.getResources().remove(resource);
                }
            }
            catch (CoreException err) {
                ModelerCore.Util.log(err);
            }
        }
    }
}

