/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.internal.core.xml.vdb.VdbHeader;
import com.metamatrix.internal.core.xml.vdb.VdbHeaderReader;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.internal.core.xml.xmi.XMIHeaderReader;
import com.metamatrix.internal.core.xml.xsd.XsdHeader;
import com.metamatrix.internal.core.xml.xsd.XsdHeaderReader;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.resource.vdb.VdbResourceImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelStatusImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.util.XSDResourceImpl;

public class ModelUtil {
    public static final String MANIFEST_MODEL_NAME = "MetaMatrix-VdbManifestModel.xmi";
    public static final String DOT_PROJECT = ".project";
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(class$com$metamatrix$modeler$internal$core$workspace$ModelUtil == null ? (class$com$metamatrix$modeler$internal$core$workspace$ModelUtil = ModelUtil.class$("com.metamatrix.modeler.internal.core.workspace.ModelUtil")) : class$com$metamatrix$modeler$internal$core$workspace$ModelUtil);
    public static final String EXTENSION_XML = "xml";
    public static final String EXTENSION_XMI = "xmi";
    public static final String EXTENSION_XSD = "xsd";
    public static final String EXTENSION_VDB = "vdb";
    private static final String EMPTY_STRING = "";
    private static final String[] EXTENSIONS = new String[]{"xml", "xmi"};
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$core$workspace$ModelUtil;

    public static IContainer getContainer(Object object) {
        ModelResource resource;
        ArgCheck.isNotNull(object);
        Object obj = object;
        if (obj instanceof EObject && (resource = ModelerCore.getModelEditor().findModelResource((EObject)obj)) != null) {
            obj = resource.getResource();
        }
        if (obj instanceof IResource && !(obj instanceof IContainer)) {
            obj = ((IResource)obj).getParent();
        }
        if (obj instanceof IContainer) {
            IContainer ctnr = (IContainer)obj;
            return ctnr.isAccessible() ? ctnr : null;
        }
        return null;
    }

    public static ModelResource getModel(Object object) throws ModelWorkspaceException {
        ArgCheck.isNotNull(object);
        if (object instanceof ModelResource) {
            return (ModelResource)object;
        }
        if (object instanceof EObject) {
            return ModelerCore.getModelEditor().findModelResource((EObject)object);
        }
        if (object instanceof IFile) {
            return ModelerCore.getModelEditor().findModelResource((IFile)object);
        }
        return null;
    }

    public static ModelResource getModifiableModel(Object object) throws ModelWorkspaceException {
        ModelResource model = ModelUtil.getModel(object);
        if (model != null && !model.isReadOnly()) {
            return model;
        }
        return null;
    }

    public static boolean isModelFile(IResource resource) {
        return ModelUtil.isModelFile(resource, true);
    }

    public static boolean isModelFile(IPath path) {
        String extension = path.getFileExtension();
        return ModelUtil.isModelFileExtension(extension, true);
    }

    public static boolean isModelFile(IResource resource, boolean projectCheck) {
        IPath path;
        if (projectCheck && !ModelUtil.isModelProjectResource(resource)) {
            return false;
        }
        if (resource.getType() == 1 && (path = ((IFile)resource).getLocation()) != null) {
            return ModelUtil.isModelFile(path.toFile());
        }
        return false;
    }

    public static boolean isModelFile(File resource) {
        if (resource == null) {
            return false;
        }
        if (resource != null && !resource.exists()) {
            Path path = new Path(resource.getAbsolutePath());
            return ModelUtil.isModelFile(path);
        }
        if (ModelUtil.isXsdFile(resource)) {
            return true;
        }
        if (ModelUtil.isVdbArchiveFile(resource)) {
            return false;
        }
        if (!EXTENSION_XMI.equals(ModelUtil.getFileExtension(resource))) {
            return false;
        }
        XMIHeader header = ModelUtil.getXmiHeader(resource);
        if (header != null) {
            if (header.getXmiVersion() != null && header.getXmiVersion().startsWith("1.")) {
                return false;
            }
            if (header.getUUID() != null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isModelFile(Resource resource) {
        if (resource == null) {
            return false;
        }
        String extension = resource.getURI().fileExtension();
        return ModelUtil.isModelFileExtension(extension, true);
    }

    public static boolean isModelFileExtension(String extension, boolean caseSensitive) {
        String exten;
        if (extension == null) {
            return false;
        }
        String string = exten = caseSensitive ? extension : extension.toLowerCase();
        if (EXTENSION_XMI.equals(exten)) {
            return true;
        }
        if (EXTENSION_XSD.equals(exten)) {
            return true;
        }
        if (EXTENSION_VDB.equals(exten)) {
            return false;
        }
        return false;
    }

    public static boolean isIResourceReadOnly(IResource iResource) {
        ResourceAttributes attributes = iResource.getResourceAttributes();
        return attributes == null ? false : attributes.isReadOnly();
    }

    public static XMIHeader getXmiHeader(InputStream resourceStream) {
        if (resourceStream != null) {
            try {
                return XMIHeaderReader.readHeader(resourceStream);
            }
            catch (MetaMatrixCoreException e2) {
                ModelerCore.Util.log(e2);
            }
        }
        return null;
    }

    public static XMIHeader getXmiHeader(File resource) {
        if (resource != null && resource.isFile() && resource.exists() && resource.canRead()) {
            if (ModelUtil.isVdbArchiveFile(resource)) {
                return ModelUtil.getXmiHeaderForVdbArchive(resource);
            }
            try {
                return XMIHeaderReader.readHeader(resource);
            }
            catch (MetaMatrixCoreException e2) {
                ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ModelUtil.Error_reading_XMIHeader_for_file_1", resource));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static XMIHeader getXmiHeader(IResource resource) {
        IPath path;
        if (resource != null && resource.getType() == 1 && (path = ((IFile)resource).getLocation()) != null) {
            return ModelUtil.getXmiHeader(path.toFile());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XMIHeader getXmiHeaderForVdbArchive(File vdbArchiveJar) {
        if (!ModelUtil.isVdbArchiveFile(vdbArchiveJar)) return null;
        XMIHeader header = null;
        InputStream manifestStream = null;
        try {
            manifestStream = ModelUtil.getManifestModelContentsFromVdbArchive(vdbArchiveJar);
            header = ModelUtil.getXmiHeader(manifestStream);
            Object var4_3 = null;
            if (manifestStream == null) return header;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (manifestStream == null) throw throwable;
            try {
                manifestStream.close();
                throw throwable;
            }
            catch (IOException err) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            manifestStream.close();
            return header;
        }
        catch (IOException err) {}
        return header;
    }

    public static VdbHeader getVdbHeader(File resource) {
        if (resource != null && resource.isFile() && resource.exists() && ModelUtil.isVdbArchiveFile(resource)) {
            try {
                return VdbHeaderReader.readHeader(resource);
            }
            catch (MetaMatrixCoreException e2) {
                ModelerCore.Util.log(e2);
            }
        }
        return null;
    }

    public static XsdHeader getXsdHeader(File resource) {
        if (resource != null && resource.isFile() && resource.exists() && ModelUtil.isXsdFile(resource)) {
            try {
                return XsdHeaderReader.readHeader(resource);
            }
            catch (MetaMatrixCoreException e2) {
                ModelerCore.Util.log(e2);
            }
        }
        return null;
    }

    public static XsdHeader getXsdHeader(IResource resource) {
        IPath path;
        if (resource != null && resource.getType() == 1 && (path = ((IFile)resource).getLocation()) != null) {
            return ModelUtil.getXsdHeader(path.toFile());
        }
        return null;
    }

    public static boolean isValidFolderNameForPackage(String name) {
        return ModelUtil.validateFolderName(name).getSeverity() != 4;
    }

    public static boolean isValidModelFileName(String name) {
        return ModelUtil.validateModelFileName(name).getSeverity() != 4;
    }

    public static boolean isXsdFile(File resource) {
        return EXTENSION_XSD.equals(ModelUtil.getFileExtension(resource));
    }

    public static boolean isXsdFile(Resource resource) {
        if (resource != null) {
            String fileName;
            if (resource instanceof XSDResourceImpl) {
                return true;
            }
            URI uri = resource.getURI();
            if (uri != null && (fileName = uri.lastSegment()).endsWith(EXTENSION_XSD)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isXsdFile(IResource resource) {
        return EXTENSION_XSD.equals(resource.getFileExtension());
    }

    public static boolean isXsdFile(IPath path) {
        return EXTENSION_XSD.equals(path.getFileExtension());
    }

    public static boolean isXmiFile(File resource) {
        if (EXTENSION_XMI.equals(ModelUtil.getFileExtension(resource))) {
            if (resource != null && !resource.exists()) {
                return true;
            }
            XMIHeader header = ModelUtil.getXmiHeader(resource);
            if (header != null) {
                if (header.getXmiVersion() != null && header.getXmiVersion().startsWith("1.")) {
                    return false;
                }
                if (header.getUUID() != null) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isXmiFile(Resource resource) {
        return resource != null && resource instanceof EmfResource;
    }

    public static boolean isXmiFile(IResource resource) {
        XMIHeader header;
        if (EXTENSION_XMI.equals(resource.getFileExtension()) && (header = ModelUtil.getXmiHeader(resource)) != null) {
            if (header.getXmiVersion() != null && header.getXmiVersion().startsWith("1.")) {
                return false;
            }
            if (header.getUUID() != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isModelProjectResource(IResource resource) {
        IProject proj;
        return resource != null && (proj = resource.getProject()) != null && ModelerCore.hasModelNature(proj);
    }

    public static boolean isVdbArchiveFile(IResource resource) {
        return EXTENSION_VDB.equals(resource.getFileExtension());
    }

    public static boolean isVdbArchiveFile(IPath path) {
        return path != null && path.getFileExtension() != null && EXTENSION_VDB.equals(path.getFileExtension());
    }

    public static boolean isVdbArchiveFile(File resource) {
        return EXTENSION_VDB.equals(ModelUtil.getFileExtension(resource));
    }

    public static boolean isVdbArchiveFile(Resource resource) {
        if (resource != null) {
            String fileName;
            if (resource instanceof VdbResourceImpl) {
                return true;
            }
            URI uri = resource.getURI();
            if (uri != null && (fileName = uri.lastSegment()).endsWith(EXTENSION_VDB)) {
                return true;
            }
        }
        return false;
    }

    public static String getFileExtension(File resource) {
        String fileName;
        int beginIndex;
        if (resource != null && (beginIndex = (fileName = resource.getName()).lastIndexOf(46) + 1) > 0 && beginIndex < fileName.length()) {
            return fileName.substring(beginIndex);
        }
        return EMPTY_STRING;
    }

    public static InputStream getManifestModelContentsFromVdbArchive(File vdbArchiveJar) {
        if (ModelUtil.isVdbArchiveFile(vdbArchiveJar)) {
            return ModelUtil.getFileContentsFromArchive(vdbArchiveJar, MANIFEST_MODEL_NAME);
        }
        return null;
    }

    public static InputStream getFileContentsFromArchive(File zip, String zipEntryName) {
        ArgCheck.isNotNull(zip);
        ArgCheck.isNotEmpty(zipEntryName);
        if (zip.length() == 0L) {
            return null;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry == null || !entry.getName().equalsIgnoreCase(zipEntryName)) continue;
                return zipFile.getInputStream(entry);
            }
        }
        catch (IOException e2) {
            ModelerCore.Util.log(e2);
        }
        return null;
    }

    private static IStatus newErrorStatus(String msg) {
        return new Status(4, "com.metamatrix.modeler.core", -1, msg, null);
    }

    public static IStatus validateFolderName(String name) {
        if (name == null) {
            return ModelUtil.newErrorStatus(ModelerCore.Util.getString("ModelUtil.folder_must_have_a_non-null_name"));
        }
        if (name.trim().length() == 0) {
            return ModelUtil.newErrorStatus(ModelerCore.Util.getString("ModelUtil.folder_must_have_a_non-empty_name"));
        }
        return ModelUtil.validateName(name, 2);
    }

    public static IStatus validateModelFileName(String name) {
        if (name == null) {
            return ModelUtil.newErrorStatus(ModelerCore.Util.getString("ModelUtil.model_file_name_may_not_be_null"));
        }
        if (name.trim().length() == 0) {
            return ModelUtil.newErrorStatus(ModelerCore.Util.getString("ModelUtil.model_file_name_may_not_be_zero_length"));
        }
        boolean validExtension = false;
        for (int i2 = 0; i2 < EXTENSIONS.length; ++i2) {
            if (!name.endsWith(EXTENSIONS[i2])) continue;
            validExtension = true;
            break;
        }
        if (!validExtension) {
            return ModelUtil.newErrorStatus(ModelerCore.Util.getString("ModelUtil.model_file_name_does_not_have_a_valid_extension"));
        }
        return ModelUtil.validateName(name, 1);
    }

    private static IStatus validateName(String segment, int type) {
        if (Character.isWhitespace(segment.charAt(0)) || Character.isWhitespace(segment.charAt(segment.length() - 1))) {
            String message = ModelerCore.Util.getString("ModelUtil.resources.invalidWhitespace", segment);
            return ModelUtil.newErrorStatus(message);
        }
        if (segment.endsWith(".")) {
            String message = ModelerCore.Util.getString("ModelUtil.resources.invalidDot", segment);
            return ModelUtil.newErrorStatus(message);
        }
        return ModelStatusImpl.VERIFIED_OK;
    }

    public static ModelResource getModelResource(IFile modelFile, boolean forceOpen) throws ModelWorkspaceException {
        if (modelFile == null) {
            return null;
        }
        return ModelerCore.getModelEditor().findModelResource(modelFile);
    }

    public static boolean requiresValidation(IFile file) {
        ModelResource mr = null;
        try {
            mr = ModelUtil.getModelResource(file, false);
        }
        catch (ModelWorkspaceException err) {
            String message = ModelUtil.getString("modelResourceNotFoundMessageKey", file.toString());
            ModelerCore.Util.log(4, err, message);
        }
        if (mr != null) {
            return ModelUtil.requiresValidation(mr);
        }
        return false;
    }

    public static boolean requiresValidation(ModelResource targetModelResource) {
        if (targetModelResource == null) {
            return false;
        }
        if (ModelUtil.isXsdFile(targetModelResource.getResource())) {
            return false;
        }
        boolean isIndexModified = ModelUtil.isIndexFileLastModifiedAfterResourceFile(targetModelResource);
        return targetModelResource.getIndexType() == 0 || isIndexModified;
    }

    private static boolean isIndexFileLastModifiedAfterResourceFile(ModelResource targetModelResource) {
        File rsrcIndexFile = new File(IndexUtil.INDEX_PATH, IndexUtil.getRuntimeIndexFileName(targetModelResource));
        if (!rsrcIndexFile.exists()) {
            return false;
        }
        IPath path = ((IFile)targetModelResource.getResource()).getLocation();
        long resourceLastModified = path.toFile().lastModified();
        long indexLastModified = rsrcIndexFile.lastModified();
        return indexLastModified < resourceLastModified;
    }

    private static String getString(String id) {
        return ModelerCore.Util.getString(I18N_PREFIX + id);
    }

    private static String getString(String id, String arg) {
        return ModelerCore.Util.getString(I18N_PREFIX + id, arg);
    }

    private ModelUtil() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String access$000(String x0) {
        return ModelUtil.getString(x0);
    }

    public static interface Constants {
        public static final String MODEL_NOT_PHYSICAL_MESSAGE = ModelUtil.access$000("modelNotPhysicalMessage");
        public static final String MODEL_RESOURCE_NOT_FOUND_MSG_KEY = "modelResourceNotFoundMessageKey";
    }
}

