/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;

public class ModelWorkspaceItemInfo {
    protected ModelWorkspaceItem[] fChildren = fgEmptyChildren;
    protected static ModelWorkspaceItem[] fgEmptyChildren = new ModelWorkspaceItem[0];
    protected boolean fIsStructureKnown = false;
    static Object[] NO_NON_MODEL_RESOURCES = new Object[0];

    protected ModelWorkspaceItemInfo() {
    }

    public void addChild(ModelWorkspaceItem child) {
        if (child != null) {
            if (this.fChildren == fgEmptyChildren) {
                this.setChildren(new ModelWorkspaceItem[]{child});
            } else if (!this.includesChild(child)) {
                this.setChildren(this.growAndAddToArray(this.fChildren, child));
            }
        }
    }

    public ModelWorkspaceItem[] getChildren() {
        return this.fChildren;
    }

    protected ModelWorkspaceItem[] growAndAddToArray(ModelWorkspaceItem[] array, ModelWorkspaceItem addition) {
        ModelWorkspaceItem[] old = array;
        array = new ModelWorkspaceItem[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected boolean includesChild(ModelWorkspaceItem child) {
        for (int i2 = 0; i2 < this.fChildren.length; ++i2) {
            if (!this.fChildren[i2].equals(child)) continue;
            return true;
        }
        return false;
    }

    public boolean isStructureKnown() {
        return this.fIsStructureKnown;
    }

    protected ModelWorkspaceItem[] removeAndShrinkArray(ModelWorkspaceItem[] array, ModelWorkspaceItem deletion) {
        ModelWorkspaceItem[] old = array;
        array = new ModelWorkspaceItem[old.length - 1];
        int j2 = 0;
        for (int i2 = 0; i2 < old.length; ++i2) {
            if (old[i2].equals(deletion)) {
                System.arraycopy(old, i2 + 1, array, j2, old.length - (i2 + 1));
                return array;
            }
            array[j2] = old[i2];
            ++j2;
        }
        return array;
    }

    public void removeChild(ModelWorkspaceItem child) {
        if (this.includesChild(child)) {
            this.setChildren(this.removeAndShrinkArray(this.fChildren, child));
        }
    }

    public void setChildren(ModelWorkspaceItem[] children) {
        this.fChildren = children;
    }

    public void setIsStructureKnown(boolean newIsStructureKnown) {
        this.fIsStructureKnown = newIsStructureKnown;
    }
}

