/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class SearchIndexResourceVisitor
implements IResourceVisitor {
    private Collection indexNames = new HashSet();
    private List resources = new ArrayList();

    public File[] getIndexFiles() {
        File[] result = null;
        File[] files = new File(IndexUtil.INDEX_PATH).listFiles();
        if (files.length != 0) {
            ArrayList<File> temp = new ArrayList<File>(files.length);
            int ndx = files.length;
            while (--ndx >= 0) {
                File file = files[ndx];
                if (!IndexUtil.isIndexFile(file) || !this.indexNames.contains(file.getName())) continue;
                temp.add(file);
            }
            if (!temp.isEmpty()) {
                result = new File[temp.size()];
                temp.toArray(result);
            } else {
                result = new File[]{};
            }
        } else {
            result = new File[]{};
        }
        return result;
    }

    public Collection getIndexNames() {
        return this.indexNames;
    }

    public List getResources() {
        return this.resources;
    }

    private boolean isIncludedResource(IResource theResource) {
        if (theResource == null || !theResource.exists()) {
            return false;
        }
        return ModelUtil.isModelFile(theResource) || ModelUtil.isXsdFile(theResource) || ModelUtil.isVdbArchiveFile(theResource);
    }

    public boolean visit(IResource theResource) throws CoreException {
        if (this.isIncludedResource(theResource)) {
            this.resources.add(theResource);
            this.indexNames.add(IndexUtil.getRuntimeIndexFileName(theResource));
            this.indexNames.add(IndexUtil.getSearchIndexFileName(theResource));
        }
        return true;
    }
}

