/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.metadata;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.ModelerCoreRuntimeException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.core.metadata.runtime.TransformationRecord;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAnnotationAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnSetAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlDatatypeAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlForeignKeyAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlModelAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTransformationAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlVdbAspect;
import com.metamatrix.modeler.core.metamodel.util.AbstractNameFinder;
import com.metamatrix.modeler.core.metamodel.util.ColumnNameFinder;
import com.metamatrix.modeler.core.metamodel.util.DatatypeNameFinder;
import com.metamatrix.modeler.core.metamodel.util.ModelNameFinder;
import com.metamatrix.modeler.core.metamodel.util.ProcedureNameFinder;
import com.metamatrix.modeler.core.metamodel.util.TableNameFinder;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.util.ModelVisitor;
import com.metamatrix.modeler.core.util.ModelVisitorProcessor;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.core.index.ModelResourceIndexSelector;
import com.metamatrix.modeler.internal.core.index.ModelWorkspaceIndexSelector;
import com.metamatrix.modeler.internal.core.metadata.runtime.AnnotationRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.ColumnRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.ColumnSetRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.DatatypeRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.ForeignKeyRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.ModelRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.ProcedureParameterRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.ProcedureRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.RuntimeAdapter;
import com.metamatrix.modeler.internal.core.metadata.runtime.TableRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.TransformationRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.VdbRecordImpl;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.metadata.QueryMetadataContext;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ModelerMetadata
extends TransformationMetadata {
    private static Map systemModelByNameMap = Collections.EMPTY_MAP;
    static /* synthetic */ Class class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord;

    ModelerMetadata(QueryMetadataContext context) {
        super(context);
    }

    public Properties getExtensionProperties(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        EmfResource emfResource;
        ModelContents contents;
        Annotation annotation;
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord = ModelerMetadata.class$("com.metamatrix.modeler.core.metadata.runtime.MetadataRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord, metadataID);
        MetadataRecord metadataRecord = (MetadataRecord)metadataID;
        String uuid = metadataRecord.getUUID();
        EObject eObj = this.lookupEObject(uuid);
        Properties extProps = new Properties();
        if (eObj != null && eObj.eResource() != null && eObj.eResource() instanceof EmfResource && (annotation = (contents = new ModelContents(emfResource = (EmfResource)eObj.eResource())).getAnnotation(eObj)) != null) {
            Iterator entryIter = annotation.getTags().entrySet().iterator();
            while (entryIter.hasNext()) {
                Map.Entry entry = (Map.Entry)entryIter.next();
                extProps.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return extProps;
    }

    public String getVirtualDatabaseName() throws MetaMatrixComponentException, QueryMetadataException {
        return null;
    }

    protected Collection findMetadataRecords(char recordType, String entityName, boolean isPartialName) throws MetaMatrixComponentException {
        EObject eObj;
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        String uuid = null;
        if (StringUtil.startsWithIgnoreCase(entityName, "mmuuid")) {
            uuid = entityName.toLowerCase();
        } else {
            try {
                String shortName = super.getShortElementName(entityName);
                if (StringUtil.startsWithIgnoreCase(shortName, "mmuuid")) {
                    uuid = shortName.toLowerCase();
                }
            }
            catch (QueryMetadataException e2) {
                throw new MetaMatrixComponentException((Throwable)e2);
            }
        }
        if (uuid != null && (eObj = this.lookupEObject(uuid)) != null && (eObj.eContainer() != null || eObj.eResource() != null)) {
            eObjects.add(eObj);
        }
        if (eObjects.isEmpty()) {
            String debugMsg;
            Collection sysObjects = this.findSystemMetadataRecords(recordType, entityName, isPartialName);
            if (!sysObjects.isEmpty()) {
                return sysObjects;
            }
            List tokens = StringUtil.getTokens(entityName, ".");
            String firstSegment = (String)tokens.get(0);
            if (eObjects.isEmpty() && this.getIndexSelector() instanceof ModelResourceIndexSelector) {
                if (ModelerCore.DEBUG_QUERY_RESOLUTION) {
                    debugMsg = TransformationPlugin.Util.getString("ModelerMetadata.Resolving_entity_{0}_using_index_files_1", entityName);
                    TransformationPlugin.Util.log(1, debugMsg);
                }
                ModelResourceIndexSelector resourceSelector = (ModelResourceIndexSelector)this.getIndexSelector();
                ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource(resourceSelector.getResource());
                if (modelResource != null) {
                    Collection records = super.findMetadataRecords(recordType, entityName, isPartialName);
                    if (!super.getContext().isRestrictedSearch() && records.isEmpty()) {
                        ModelWorkspaceIndexSelector workspaceSelector = new ModelWorkspaceIndexSelector();
                        super.getContext().setIndexSelector(workspaceSelector);
                        records = super.findMetadataRecords(recordType, entityName, isPartialName);
                        super.getContext().setIndexSelector(resourceSelector);
                    }
                    if (ModelerCore.DEBUG_QUERY_RESOLUTION) {
                        Object[] params = new Object[]{Integer.toString(records.size()), entityName};
                        String debugMsg2 = TransformationPlugin.Util.getString("ModelerMetadata.Found_{0}_records_for_the_entity_{1}_1", params);
                        ModelerCore.Util.log(1, debugMsg2);
                    }
                    if (records.isEmpty() && uuid != null) {
                        ResourceSet[] resourceSets = this.getContainer().getExternalResourceSets();
                        for (int i2 = 0; i2 < resourceSets.length; ++i2) {
                            Container externalContainer;
                            EObject externalEObj;
                            ResourceSet currentResourceSet = resourceSets[i2];
                            if (currentResourceSet == null || !(currentResourceSet instanceof Container) || (externalEObj = (EObject)(externalContainer = (Container)currentResourceSet).getEObjectFinder().find(uuid)) == null || externalEObj.eContainer() == null && externalEObj.eResource() == null) continue;
                            eObjects.add(externalEObj);
                        }
                    } else {
                        return records;
                    }
                }
            }
            if (ModelerCore.DEBUG_QUERY_RESOLUTION) {
                debugMsg = TransformationPlugin.Util.getString("ModelerMetadata.Resolving_entity_{0}_by_navigating_the_workspace_1", entityName);
                TransformationPlugin.Util.log(1, debugMsg);
            }
            Iterator resourceIter = this.findResourcesByName(firstSegment).iterator();
            while (resourceIter.hasNext()) {
                Resource resource = (Resource)resourceIter.next();
                if (resource == null) continue;
                Collection entities = this.findEntitiesByName(resource, entityName, recordType, isPartialName);
                Iterator iter = entities.iterator();
                while (iter.hasNext()) {
                    EObject eObj2 = (EObject)iter.next();
                    if (eObj2 == null || eObj2.eContainer() == null && eObj2.eResource() == null) continue;
                    eObjects.add(eObj2);
                }
            }
        }
        if (!eObjects.isEmpty()) {
            Collection records = this.createMetadataRecords(recordType, eObjects);
            if (ModelerCore.DEBUG_QUERY_RESOLUTION) {
                Object[] params = new Object[]{Integer.toString(records.size()), entityName};
                String debugMsg = TransformationPlugin.Util.getString("ModelerMetadata.Found_{0}_records_for_the_entity_{1}_1", params);
                ModelerCore.Util.log(1, debugMsg);
            }
            return records;
        }
        return Collections.EMPTY_LIST;
    }

    protected boolean isSystemModelName(String firstSegment) {
        if (StringUtil.startsWithIgnoreCase(firstSegment, "mmuuid")) {
            return false;
        }
        return systemModelByNameMap.containsKey(firstSegment.toUpperCase());
    }

    protected Collection findSystemMetadataRecords(char recordType, String entityName, boolean isPartialName) throws MetaMatrixComponentException {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        List tokens = StringUtil.getTokens(entityName, ".");
        String firstSegment = (String)tokens.get(0);
        if (!this.isSystemModelName(firstSegment)) {
            return eObjects;
        }
        Object value = systemModelByNameMap.get(firstSegment.toUpperCase());
        if (value != null && value instanceof EmfResource) {
            ObjectID eResourceUuid = ((EmfResource)value).getUuid();
            Resource wsEResource = this.getContainer().getResourceFinder().findByUUID(eResourceUuid, false);
            if (wsEResource != null) {
                value = wsEResource;
            }
        }
        Collection entities = this.findEntitiesByName(value, entityName, recordType, isPartialName);
        Iterator iter = entities.iterator();
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            if (eObj == null || eObj.eContainer() == null && eObj.eResource() == null) continue;
            eObjects.add(eObj);
        }
        Collection records = this.createMetadataRecords(recordType, eObjects);
        if (ModelerCore.DEBUG_QUERY_RESOLUTION) {
            Object[] params = new Object[]{Integer.toString(records.size()), entityName};
            String debugMsg = TransformationPlugin.Util.getString("ModelerMetadata.Found_{0}_records_for_the_entity_{1}_1", params);
            ModelerCore.Util.log(1, debugMsg);
        }
        return records;
    }

    protected Collection createMetadataRecords(char recordType, Collection eObjects) throws MetaMatrixComponentException {
        if (eObjects != null && !eObjects.isEmpty()) {
            ArrayList<MetadataRecord> records = new ArrayList<MetadataRecord>(eObjects.size());
            Iterator eObjIter = eObjects.iterator();
            while (eObjIter.hasNext()) {
                MetadataRecord record = this.createMetadataRecord(recordType, (EObject)eObjIter.next());
                if (record == null) continue;
                records.add(record);
            }
            return records;
        }
        return Collections.EMPTY_LIST;
    }

    protected MetadataRecord createMetadataRecord(char recordType, EObject eObject) throws MetaMatrixComponentException {
        MetadataRecord record = null;
        SqlAspect sqlAspect = AspectManager.getSqlAspect(eObject);
        if (!sqlAspect.isQueryable(eObject)) {
            return null;
        }
        switch (recordType) {
            case 'A': {
                if (!(sqlAspect instanceof SqlModelAspect)) break;
                record = new ModelRecordImpl(sqlAspect, eObject);
                break;
            }
            case 'B': {
                if (!(sqlAspect instanceof SqlTableAspect)) break;
                record = new TableRecordImpl(sqlAspect, eObject);
                break;
            }
            case 'E': {
                if (!(sqlAspect instanceof SqlProcedureAspect)) break;
                record = new ProcedureRecordImpl(sqlAspect, eObject);
                break;
            }
            case 'F': {
                if (!(sqlAspect instanceof SqlProcedureParameterAspect)) break;
                record = new ProcedureParameterRecordImpl(sqlAspect, eObject);
                break;
            }
            case 'G': {
                if (!(sqlAspect instanceof SqlColumnAspect)) break;
                record = new ColumnRecordImpl(sqlAspect, eObject);
                break;
            }
            case 'C': 
            case 'H': 
            case 'I': 
            case 'K': 
            case 'L': {
                if (!(sqlAspect instanceof SqlColumnSetAspect)) break;
                record = new ColumnSetRecordImpl(sqlAspect, eObject, recordType);
                break;
            }
            case 'J': {
                if (!(sqlAspect instanceof SqlForeignKeyAspect)) break;
                record = new ForeignKeyRecordImpl(sqlAspect, eObject);
                break;
            }
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': {
                record = this.getTransforMationRecord(sqlAspect, eObject, recordType);
            }
            case 'M': {
                if (sqlAspect instanceof SqlDatatypeAspect) {
                    record = new DatatypeRecordImpl(sqlAspect, eObject);
                }
            }
            case 'V': {
                if (!(sqlAspect instanceof SqlVdbAspect)) break;
                record = new VdbRecordImpl(sqlAspect, eObject);
                break;
            }
            case 'W': {
                if (!(sqlAspect instanceof SqlAnnotationAspect)) break;
                record = new AnnotationRecordImpl(sqlAspect, eObject);
                break;
            }
            case 'D': 
            case 'X': {
                return null;
            }
            default: {
                throw new MetaMatrixComponentException(TransformationPlugin.Util.getString("TransformationMetadata.No_known_index_file_type_associated_with_the_recordType_1", new Character(recordType)));
            }
        }
        return record;
    }

    private TransformationRecord getTransforMationRecord(SqlAspect sqlAspect, EObject eObject, char recordType) {
        if (sqlAspect instanceof SqlTransformationAspect) {
            switch (recordType) {
                case 'P': {
                    return new TransformationRecordImpl(sqlAspect, eObject, "Select");
                }
                case 'Q': {
                    return new TransformationRecordImpl(sqlAspect, eObject, "Insert");
                }
                case 'R': {
                    return new TransformationRecordImpl(sqlAspect, eObject, "Update");
                }
                case 'S': {
                    return new TransformationRecordImpl(sqlAspect, eObject, "Delete");
                }
                case 'T': {
                    return new TransformationRecordImpl(sqlAspect, eObject, "Procedure");
                }
                case 'U': {
                    return new TransformationRecordImpl(sqlAspect, eObject, "Mapping");
                }
            }
            throw new ModelerCoreRuntimeException(TransformationPlugin.Util.getString("TransformationMetadata.No_known_index_file_type_associated_with_the_recordType_1", new Character(recordType)));
        }
        return null;
    }

    protected Collection findChildRecords(MetadataRecord parentRecord, char childRecordType) throws MetaMatrixComponentException {
        ArgCheck.isNotNull(parentRecord);
        EObject parentObj = parentRecord.getEObject();
        if (parentObj == null) {
            String uuid = parentRecord.getUUID();
            parentObj = this.lookupEObject(uuid);
        }
        if (parentObj != null) {
            SqlAspect sqlAspect = AspectManager.getSqlAspect(parentObj);
            if (sqlAspect instanceof SqlTableAspect) {
                SqlTableAspect tableAspect = (SqlTableAspect)sqlAspect;
                switch (childRecordType) {
                    case 'G': {
                        List columns = tableAspect.getColumns(parentObj);
                        return this.findMetadataRecords(childRecordType, columns);
                    }
                    case 'J': {
                        Collection foreignKeys = tableAspect.getForeignKeys(parentObj);
                        return this.findMetadataRecords(childRecordType, foreignKeys);
                    }
                    case 'I': {
                        Collection uniqueKeys = tableAspect.getUniqueKeys(parentObj);
                        return this.findMetadataRecords(childRecordType, uniqueKeys);
                    }
                    case 'K': {
                        EObject primaryKey = (EObject)tableAspect.getPrimaryKey(parentObj);
                        MetadataRecord record = this.createMetadataRecord(childRecordType, primaryKey);
                        if (record == null) break;
                        ArrayList<MetadataRecord> records = new ArrayList<MetadataRecord>(1);
                        records.add(record);
                        return records;
                    }
                    case 'H': {
                        Collection accPtterns = tableAspect.getAccessPatterns(parentObj);
                        return this.findMetadataRecords(childRecordType, accPtterns);
                    }
                    case 'L': {
                        Collection indexes = tableAspect.getIndexes(parentObj);
                        return this.findMetadataRecords(childRecordType, indexes);
                    }
                }
            } else if (sqlAspect instanceof SqlProcedureAspect) {
                SqlProcedureAspect procAspect = (SqlProcedureAspect)sqlAspect;
                switch (childRecordType) {
                    case 'F': {
                        List params = procAspect.getParameters(parentObj);
                        return this.findMetadataRecords(childRecordType, params);
                    }
                    case 'C': {
                        EObject result = (EObject)procAspect.getResult(parentObj);
                        MetadataRecord record = this.createMetadataRecord(childRecordType, result);
                        if (record == null) break;
                        ArrayList<MetadataRecord> records = new ArrayList<MetadataRecord>(1);
                        records.add(record);
                        return records;
                    }
                }
            } else if (sqlAspect instanceof SqlColumnSetAspect) {
                SqlColumnSetAspect colSetAspect = (SqlColumnSetAspect)sqlAspect;
                switch (childRecordType) {
                    case 'G': {
                        List column = colSetAspect.getColumns(parentObj);
                        return this.findMetadataRecords(childRecordType, column);
                    }
                }
            }
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection findMetadataRecords(IEntryResult[] results) {
        return RuntimeAdapter.getMetadataRecord(results, this.getContainer());
    }

    protected MetadataRecord findMetadataRecord(IEntryResult result) {
        return RuntimeAdapter.getMetadataRecord(result, this.getContainer());
    }

    protected final Collection getResources() {
        return super.getContext().getResources();
    }

    protected final Container getContainer() {
        return super.getContext().getContainer();
    }

    protected EObject lookupEObject(String uuid) throws MetaMatrixComponentException {
        EObject eObject;
        ArgCheck.isNotEmpty(uuid);
        if (this.getResources() != null) {
            Iterator iter = this.getResources().iterator();
            while (iter.hasNext()) {
                Resource r2 = (Resource)iter.next();
                if (r2.isLoaded()) continue;
                try {
                    r2.load(Collections.EMPTY_MAP);
                }
                catch (IOException e2) {
                    TransformationPlugin.Util.log(4, e2.getLocalizedMessage());
                }
            }
        }
        if ((eObject = (EObject)this.getContainer().getEObjectFinder().find(uuid)) != null) {
            Container cntr;
            Resource resource = eObject.eResource();
            if (this.getResources() != null && (cntr = ModelerCore.getContainer(resource)) == this.getContainer() && !this.getResources().contains(resource)) {
                return null;
            }
        }
        return eObject;
    }

    private Collection findMetadataRecords(char recordType, Collection eObjects) throws MetaMatrixComponentException {
        ArrayList<MetadataRecord> records = new ArrayList<MetadataRecord>(eObjects.size());
        Iterator eObjIter = eObjects.iterator();
        while (eObjIter.hasNext()) {
            EObject eObj = (EObject)eObjIter.next();
            MetadataRecord record = this.createMetadataRecord(recordType, eObj);
            if (record == null) continue;
            records.add(record);
        }
        return records;
    }

    private Collection findResourcesByName(String modelName) {
        ArgCheck.isNotEmpty(modelName);
        ArrayList<Resource> rsrcs = new ArrayList<Resource>(this.getResources() != null ? this.getResources() : this.getContainer().getResources());
        Resource[] systemModels = ModelerCore.getSystemVdbResources();
        for (int i2 = 0; i2 != systemModels.length; ++i2) {
            Resource systemModel = systemModels[i2];
            if (rsrcs.contains(systemModel)) continue;
            rsrcs.add(systemModel);
        }
        ModelEditor modelEditor = ModelerCore.getModelEditor();
        ArrayList<Resource> resources = new ArrayList<Resource>(1);
        IndexSelector selector = this.getIndexSelector();
        if (selector != null && selector instanceof ModelResourceIndexSelector) {
            ModelResourceIndexSelector resourceSelector = (ModelResourceIndexSelector)selector;
            Resource modelResource = resourceSelector.getResource();
            String resourceName = modelEditor.getModelName(modelResource);
            if (resourceName.equalsIgnoreCase(modelName)) {
                resources.add(modelResource);
            } else {
                Iterator importIter = resourceSelector.getModelImports().iterator();
                block1: while (importIter.hasNext()) {
                    ModelImport modelImport = (ModelImport)importIter.next();
                    String importName = modelImport.getName();
                    if (!importName.equalsIgnoreCase(modelName)) continue;
                    String importPath = modelImport.getPath();
                    Iterator resourceIter = rsrcs.iterator();
                    while (resourceIter.hasNext()) {
                        Resource resource = (Resource)resourceIter.next();
                        String resourceUri = URI.decode(resource.getURI().toString());
                        if (!StringUtil.endsWithIgnoreCase(resourceUri, importPath)) continue;
                        resources.add(resource);
                        continue block1;
                    }
                }
            }
        } else {
            Iterator resourceIter = rsrcs.iterator();
            while (resourceIter.hasNext()) {
                Resource resource = (Resource)resourceIter.next();
                String resourceName = modelEditor.getModelName(resource);
                if (!resourceName.equalsIgnoreCase(modelName)) continue;
                resources.add(resource);
                break;
            }
        }
        if (!resources.isEmpty()) {
            return resources;
        }
        return rsrcs;
    }

    private Collection findEntitiesByName(Object container, String entityName, char recordType, boolean isPartialName) {
        ArgCheck.isNotEmpty(entityName);
        AbstractNameFinder finder = null;
        switch (recordType) {
            case 'A': {
                finder = new ModelNameFinder(entityName, isPartialName);
                break;
            }
            case 'B': {
                finder = new TableNameFinder(entityName, isPartialName);
                break;
            }
            case 'E': {
                finder = new ProcedureNameFinder(entityName, isPartialName);
                break;
            }
            case 'F': 
            case 'G': {
                finder = new ColumnNameFinder(entityName, isPartialName);
                break;
            }
            case 'C': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': {
                finder = new ColumnNameFinder(entityName, isPartialName);
                break;
            }
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': {
                return this.getTransforMationsForTable(container, entityName, recordType, isPartialName);
            }
            case 'M': {
                finder = new DatatypeNameFinder(entityName, isPartialName);
                break;
            }
            case 'D': 
            case 'V': 
            case 'W': 
            case 'X': {
                break;
            }
            default: {
                throw new ModelerCoreRuntimeException(TransformationPlugin.Util.getString("TransformationMetadata.No_known_index_file_type_associated_with_the_recordType_1", new Character(recordType)));
            }
        }
        if (finder != null) {
            ModelerMetadata.executeVisitor(container, finder, 2);
            return finder.getMatchingEObjects();
        }
        return Collections.EMPTY_LIST;
    }

    private static void executeVisitor(Object container, ModelVisitor visitor, int depth) {
        ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
        try {
            if (container instanceof Resource) {
                processor.walk((Resource)container, depth);
            } else if (container instanceof EObject) {
                processor.walk((EObject)container, depth);
            }
        }
        catch (ModelerCoreException e2) {
            ModelerCore.Util.log(e2);
        }
    }

    private Collection getTransforMationsForTable(Object container, String entityName, char recordType, boolean isPartialName) {
        AbstractNameFinder finder = null;
        switch (recordType) {
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'U': {
                finder = new TableNameFinder(entityName, isPartialName);
                break;
            }
            case 'T': {
                finder = new ProcedureNameFinder(entityName, isPartialName);
                break;
            }
            default: {
                throw new ModelerCoreRuntimeException(TransformationPlugin.Util.getString("TransformationMetadata.No_known_index_file_type_associated_with_the_recordType_1", new Character(recordType)));
            }
        }
        if (finder != null) {
            ModelerMetadata.executeVisitor(container, finder, 2);
            Collection matches = finder.getMatchingEObjects();
            ArrayList<EObject> transforms = new ArrayList<EObject>(matches.size());
            Iterator targetIter = matches.iterator();
            while (targetIter.hasNext()) {
                EObject targetObj = (EObject)targetIter.next();
                if (!SqlAspectHelper.isValidTransformationTarget(targetObj)) continue;
                EObject mappinRoot = TransformationHelper.getMappingRoot(targetObj);
                transforms.add(mappinRoot);
            }
            return transforms;
        }
        return Collections.EMPTY_LIST;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (ModelerCore.getPlugin() != null) {
            Resource[] systemModels = ModelerCore.getSystemVdbResources();
            systemModelByNameMap = new HashMap(systemModels.length);
            for (int i2 = 0; i2 != systemModels.length; ++i2) {
                String name = systemModels[i2].getURI().trimFileExtension().lastSegment();
                systemModelByNameMap.put(name.toUpperCase(), systemModels[i2]);
            }
        }
    }
}

