/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.metadata;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.internal.core.index.ModelResourceIndexSelector;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.metadata.ModelerMetadata;
import com.metamatrix.modeler.transformation.metadata.QueryMetadataContext;
import com.metamatrix.modeler.transformation.metadata.ServerRuntimeMetadata;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadata;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadataFacade;
import com.metamatrix.modeler.transformation.metadata.VdbMetadata;
import com.metamatrix.query.m.e;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class TransformationMetadataFactory {
    private static final TransformationMetadataFactory INSTANCE = new TransformationMetadataFactory();

    private TransformationMetadataFactory() {
    }

    public static TransformationMetadataFactory getInstance() {
        return INSTANCE;
    }

    public e getModelerMetadata(QueryMetadataContext context) {
        return new ModelerMetadata(context);
    }

    public e getModelerMetadata(EObject eObject) {
        ArgCheck.isNotNull(eObject);
        return this.getModelerMetadata(eObject, false);
    }

    public e getModelerMetadata(EObject eObject, boolean restrictSearch) {
        ArgCheck.isNotNull(eObject);
        List<Resource> resources = null;
        Container container = null;
        try {
            container = ModelerCore.getModelContainer();
            ModelWorkspace workspace = ModelerCore.getModelWorkspace();
            resources = Arrays.asList(workspace.getEmfResources());
        }
        catch (CoreException e2) {
            TransformationPlugin.Util.log(e2);
        }
        Resource resource = ModelerCore.getModelEditor().findResource(container, eObject);
        ModelResourceIndexSelector selector = new ModelResourceIndexSelector(resource);
        QueryMetadataContext context = new QueryMetadataContext(selector);
        context.setContainer(container);
        context.setResources(resources);
        context.setRestrictedSearch(restrictSearch);
        return this.getModelerMetadata(context);
    }

    public e getServerMetadata(IndexSelector selector) {
        QueryMetadataContext context = new QueryMetadataContext(selector);
        return this.getServerMetadata(context);
    }

    public e getServerMetadata(QueryMetadataContext context) {
        ArgCheck.isNotNull(context);
        return new ServerRuntimeMetadata(context);
    }

    public e createCachingServerMetadata(IndexSelector selector) {
        QueryMetadataContext context = new QueryMetadataContext(selector);
        return this.createCachingServerMetadata(context);
    }

    public e createCachingServerMetadata(QueryMetadataContext context) {
        TransformationMetadata metadata = (TransformationMetadata)this.getServerMetadata(context);
        return new TransformationMetadataFacade(metadata);
    }

    public e createCachingServerMetadata(QueryMetadataContext context, int cacheSize) {
        TransformationMetadata metadata = (TransformationMetadata)this.getServerMetadata(context);
        return new TransformationMetadataFacade(metadata, cacheSize);
    }

    public e getVdbMetadata(QueryMetadataContext context) {
        ArgCheck.isNotNull(context);
        return new TransformationMetadataFacade(new VdbMetadata(context));
    }
}

