/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.edit.refactor;

import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.refactor.ModelResourceCollectorVisitor;
import com.metamatrix.modeler.core.refactor.ResourceRefactorCommand;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.rules.CoreValidationRulesUtil;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.internal.edit.VdbEditingContextImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ResourceRenameVdbCommand
extends ResourceRefactorCommand {
    public static final int ERROR_MISSING_NAME = 1201;
    public static final int ERROR_RENAME_PROJECT = 1202;
    public static final int ERROR_READONLY_RESOURCES = 1206;
    public static final int EXCEPTION_DURING_RENAME = 1207;
    public static final int ERROR_SIBLING_NAME = 1208;
    public static final int ERROR_SAME_NAME = 1208;
    private static final String UNDO_RENAME = ModelerCore.Util.getString("ResourceRenameCommand.label");
    private IStatus currentStatus;
    private String nameBeforeRename;
    private String extension;
    private HashMap pathMap;
    private HashMap undoMap;
    private String undoLabel = UNDO_RENAME;
    private String undoDescription = UNDO_RENAME;

    public ResourceRenameVdbCommand() {
        super(UNDO_RENAME);
    }

    private void checkStatus() {
        if (this.getNewName() == null || this.getNewName().length() == 0) {
            String msg = ModelerCore.Util.getString("ResourceRenameCommand.No_name_has_been_selected");
            this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 1201, msg, null);
            return;
        }
        if (this.getResource() instanceof IProject) {
            String msg = ModelerCore.Util.getString("ResourceRenameCommand.Cannot_rename_project");
            this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 1202, msg, null);
            return;
        }
        ValidationResultImpl result = new ValidationResultImpl(this.getNewName());
        CoreValidationRulesUtil.validateStringNameChars(result, this.getNewName(), null);
        if (result.hasProblems()) {
            ValidationProblem problem = result.getProblems()[0];
            this.currentStatus = new Status(problem.getSeverity(), "com.metamatrix.modeler.core", problem.getCode(), problem.getMessage(), null);
            return;
        }
        if (this.getNewName().equals(this.nameBeforeRename)) {
            String msg = ModelerCore.Util.getString("ResourceRenameCommand.Same_as_old_name");
            this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 1208, msg, null);
            return;
        }
        if (this.siblingNameClash(this.getNewName())) {
            String msg = ModelerCore.Util.getString("ResourceRenameCommand.Name_already_exists_in_container");
            this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 1208, msg, null);
            return;
        }
        Object[] params = new Object[]{this.nameBeforeRename, this.getNewName()};
        String msg = ModelerCore.Util.getString("ResourceRenameCommand.Ready_to_rename", params);
        this.currentStatus = new Status(0, "com.metamatrix.modeler.core", 1000, msg, null);
    }

    protected IStatus getCanExecuteStatus() {
        this.checkStatus();
        return this.currentStatus;
    }

    protected IStatus modifyResource(IResource resource, IProgressMonitor monitor) {
        this.pathMap = new HashMap();
        this.undoMap = new HashMap();
        return this.modifyResource(resource, this.getNewName(), this.pathMap, this.undoMap, monitor);
    }

    private IStatus modifyResource(IResource resource, String newResourceName, Map preToPostPathMap, Map postToPrePathMap, IProgressMonitor monitor) {
        try {
            IStatus result;
            IResource resourceToRename = super.getResource();
            this.nameBeforeRename = resourceToRename.getName();
            if (resource instanceof IFile) {
                this.extension = ((IFile)resource).getFileExtension();
                if (this.extension != null && this.extension.length() > 0) {
                    this.nameBeforeRename = this.nameBeforeRename.substring(0, this.nameBeforeRename.lastIndexOf(this.extension) - 1);
                }
            }
            ModelResourceCollectorVisitor preMoveVisitor = new ModelResourceCollectorVisitor();
            resource.accept(preMoveVisitor);
            ArrayList<String> preMoveList = new ArrayList<String>(preMoveVisitor.getResources().size());
            Iterator iter = preMoveVisitor.getResources().iterator();
            while (iter.hasNext()) {
                preMoveList.add(((Object)((IResource)iter.next()).getFullPath().makeAbsolute()).toString());
            }
            this.unloadModelResources(resource);
            this.preProcessVDB(monitor, resource);
            this.setResourceName(resource, newResourceName, monitor);
            String newPathString = this.getModifiedPathString(newResourceName);
            IWorkspaceRoot workspaceRoot = this.getResource().getWorkspace().getRoot();
            IResource newResource = workspaceRoot.findMember(newPathString);
            super.setModifiedResource(newResource);
            ModelResourceCollectorVisitor postMoveVisitor = new ModelResourceCollectorVisitor();
            newResource.accept(postMoveVisitor);
            ArrayList<String> postMoveList = new ArrayList<String>(postMoveVisitor.getResources().size());
            Iterator iter2 = postMoveVisitor.getResources().iterator();
            while (iter2.hasNext()) {
                postMoveList.add(((Object)((IResource)iter2.next()).getFullPath().makeAbsolute()).toString());
            }
            preToPostPathMap.clear();
            postToPrePathMap.clear();
            if (preMoveList.size() == postMoveList.size()) {
                Iterator preIter = preMoveList.iterator();
                Iterator postIter = postMoveList.iterator();
                while (preIter.hasNext()) {
                    Object pre = preIter.next();
                    Object post = postIter.next();
                    preToPostPathMap.put(pre, post);
                    postToPrePathMap.put(post, pre);
                }
            }
            if ((result = this.refactorModifiedResources(monitor, this.getModifiedResource(), preToPostPathMap)) != null && result.getSeverity() == 4) {
                return result;
            }
            result = this.postProcessVdb(monitor, newResource);
            if (result != null && result.getSeverity() == 4) {
                return result;
            }
            String msg = ModelerCore.Util.getString("ResourceRenameCommand.Rename_succeeded");
            return new Status(0, "com.metamatrix.modeler.core", 1001, msg, null);
        }
        catch (CoreException e2) {
            String msg = ModelerCore.Util.getString("ResourceRenameCommand.Rename_failed");
            return new Status(4, "com.metamatrix.modeler.core", 1207, msg, e2);
        }
    }

    protected IStatus refactorModifiedResources(IProgressMonitor monitor, IResource resource, Map refactoredPaths) {
        ArrayList<Status> errorList = new ArrayList<Status>();
        int severity = 0;
        try {
            String msg;
            ModelResource mResource;
            IFile iFile;
            ModelResourceCollectorVisitor visitor = new ModelResourceCollectorVisitor();
            resource.accept(visitor);
            Iterator iter = visitor.getResources().iterator();
            while (iter.hasNext()) {
                iFile = (IFile)iter.next();
                mResource = ModelerCore.getModelEditor().findModelResource(iFile);
                if (mResource == null) {
                    mResource = ModelerCore.create(iFile);
                }
                if (mResource != null) {
                    mResource.save(null, false);
                    super.buildIndexes(monitor, iFile);
                    continue;
                }
                if (severity < 2) {
                    severity = 2;
                }
                msg = ModelerCore.Util.getString("ResourceRefactorCommand.Model_resource_not_in_ws", iFile.getName());
                errorList.add(new Status(2, "com.metamatrix.modeler.core", 1101, msg, null));
            }
            iter = visitor.getResources().iterator();
            while (iter.hasNext()) {
                iFile = (IFile)iter.next();
                mResource = ModelerCore.getModelEditor().findModelResource(iFile);
                if (mResource != null) {
                    super.rebuildImports(mResource, monitor, refactoredPaths);
                    mResource.save(null, false);
                    mResource.close();
                    continue;
                }
                if (severity < 2) {
                    severity = 2;
                }
                msg = ModelerCore.Util.getString("ResourceRefactorCommand.Rebuild_model_imports_complete");
                errorList.add(new Status(2, "com.metamatrix.modeler.core", 1101, msg, null));
            }
        }
        catch (Exception e2) {
            severity = 4;
            String msg = ModelerCore.Util.getString("ResourceRenameVdbCommand.Exception_rename_vdb_references_for_resource_0_1", resource);
            errorList.add(new Status(4, "com.metamatrix.modeler.core", 1102, msg, e2));
        }
        String msg = ModelerCore.Util.getString("ResourceRefactorCommand.Execution_complete");
        return new MultiStatus("com.metamatrix.modeler.core", 1103, errorList.toArray(EMPTY_ISTATUS), msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private IStatus postProcessVdb(IProgressMonitor monitor, IResource resource) {
        block12: {
            editor = null;
            try {
                newPath = resource.getLocation();
                editor = new VdbEditingContextImpl(newPath);
                editor.setLoadModelsOnOpen(true);
                if (!editor.isOpen()) {
                    editor.open();
                    editor.updateVdbXmiName();
                    editor.save(monitor);
                    editor.close();
                }
                resource.refreshLocal(0, monitor);
                var8_6 = null;
                ** if (editor == null) goto lbl-1000
            }
            catch (Throwable var7_14) {
                var8_8 = null;
                if (editor != null) {
                    try {
                        editor.close();
                    }
                    catch (IOException e1) {
                        VdbEditPlugin.Util.log(e1);
                        editor = null;
                    }
                }
                throw var7_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    editor.close();
                }
                catch (IOException e1) {
                    VdbEditPlugin.Util.log(e1);
                    editor = null;
                }
            }
lbl-1000:
            // 2 sources

            {
                break block12;
                catch (Exception err) {
                    msg = ModelerCore.Util.getString("ResourceRenameVdbCommand.Exception_rename_vdb_references_for_resource_0_1", resource);
                    var6_13 = new Status(4, "com.metamatrix.modeler.core", 1106, msg, err);
                    var8_7 = null;
                    if (editor != null) {
                        try {
                            editor.close();
                        }
                        catch (IOException e1) {
                            VdbEditPlugin.Util.log(e1);
                            editor = null;
                        }
                    }
                    return var6_13;
                }
            }
        }
        msg = ModelerCore.Util.getString("ResourceRenameCommand.Rename_succeeded");
        return new Status(0, "com.metamatrix.modeler.core", 1001, msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private IStatus preProcessVDB(IProgressMonitor monitor, IResource resource) {
        block12: {
            editor = null;
            try {
                block11: {
                    path = resource.getLocation();
                    editor = (VdbEditingContextImpl)VdbEditPlugin.createVdbEditingContext(path);
                    if (!editor.isOpen()) break block11;
                    editor.close(false, true, false);
                }
                var8_6 = null;
                ** if (editor == null) goto lbl-1000
            }
            catch (Throwable var7_14) {
                var8_8 = null;
                if (editor != null) {
                    try {
                        editor.close();
                    }
                    catch (IOException e1) {
                        VdbEditPlugin.Util.log(e1);
                        editor = null;
                    }
                }
                throw var7_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    editor.close();
                }
                catch (IOException e1) {
                    VdbEditPlugin.Util.log(e1);
                    editor = null;
                }
            }
lbl-1000:
            // 2 sources

            {
                break block12;
                catch (Exception err) {
                    msg = ModelerCore.Util.getString("ResourceRenameVdbCommand.Exception_rename_vdb_references_for_resource_0_1", resource);
                    var6_13 = new Status(4, "com.metamatrix.modeler.core", 1106, msg, err);
                    var8_7 = null;
                    if (editor != null) {
                        try {
                            editor.close();
                        }
                        catch (IOException e1) {
                            VdbEditPlugin.Util.log(e1);
                            editor = null;
                        }
                    }
                    return var6_13;
                }
            }
        }
        msg = ModelerCore.Util.getString("ResourceRenameCommand.Rename_succeeded");
        return new Status(0, "com.metamatrix.modeler.core", 1001, msg, null);
    }

    private String getModifiedPathString(String proposedName) {
        String parentPath = ((Object)this.getResource().getParent().getFullPath()).toString();
        String newPath = parentPath + '/' + proposedName;
        if (this.extension != null && this.extension.length() > 0) {
            newPath = newPath + '.' + this.extension;
        }
        return newPath;
    }

    private boolean siblingNameClash(String proposedName) {
        String newPath = this.getModifiedPathString(proposedName);
        IWorkspaceRoot workspaceRoot = this.getResource().getWorkspace().getRoot();
        boolean result = workspaceRoot.findMember(newPath) != null;
        return result;
    }

    private void setResourceName(IResource oldResource, String newName, IProgressMonitor monitor) {
        monitor.beginTask(ModelerCore.Util.getString("ResourceRenameCommand.Monitor_begin_rename"), 100);
        String newPathString = this.getModifiedPathString(newName);
        IWorkspaceRoot workspaceRoot = oldResource.getWorkspace().getRoot();
        try {
            Path newPath = new Path(newPathString);
            IResource newResource = workspaceRoot.findMember(newPathString);
            if (newResource != null) {
                if (oldResource.getType() == 1 && newResource.getType() == 1) {
                    IFile file = (IFile)oldResource;
                    IFile newFile = (IFile)newResource;
                    this.setUndo(file, newFile);
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 50);
                    newFile.setContents(file.getContents(), 2, (IProgressMonitor)subMonitor);
                    file.delete(2, (IProgressMonitor)subMonitor);
                    monitor.worked(100);
                    return;
                }
                newResource.delete(2, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
            System.gc();
            oldResource.move((IPath)newPath, 34, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
        catch (Exception e2) {
            String msg = ModelerCore.Util.getString("ResourceRenameCommand.Exception_during_rename", newName);
            super.addProblem(new Status(4, "com.metamatrix.modeler.core", 1207, msg, e2));
        }
    }

    public IStatus undoResourceModification(IProgressMonitor monitor) {
        return this.modifyResource(super.getModifiedResource(), this.nameBeforeRename, this.pathMap, this.undoMap, monitor);
    }

    public IStatus redoResourceModification(IProgressMonitor monitor) {
        return this.modifyResource(super.getModifiedResource(), this.getNewName(), this.pathMap, this.undoMap, monitor);
    }

    public String getLabel() {
        return this.undoLabel;
    }

    public String getDescription() {
        return this.undoDescription;
    }

    public void setResource(IResource resource) {
        super.setResource(resource);
        this.extension = resource.getFileExtension();
    }

    protected Map getMovedResourcePathMap(boolean isUndo) {
        if (isUndo) {
            return this.undoMap;
        }
        return this.pathMap;
    }

    private void setUndo(IFile oldFile, IFile newFile) {
        Object[] params = new Object[]{oldFile.getName(), newFile.getName()};
        this.undoLabel = ModelerCore.Util.getString("ResourceRenameCommand.rename_label", params);
        this.undoDescription = ModelerCore.Util.getString("ResourceRenameCommand.rename_description", params);
    }
}

