/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.internal.edit.VdbEditingContextImpl;
import com.metamatrix.vdb.internal.edit.VdbEditingContextImplProblemMarker;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class MissingModelsValidator {
    private VdbEditingContextImpl vdbEditingContextImpl;
    private Resource eResource;
    private IPath modelPath;
    private ModelReference modelRef;
    private String MSGKEY = "VdbEditingContextImpl.The_model_{0}_is_dependent_on_{1}_which_is_not_part_of_the_vdb._1";

    public MissingModelsValidator(Resource eResource, IPath modelPath, ModelReference modelRef) {
        this.eResource = eResource;
        this.modelPath = modelPath;
        this.modelRef = modelRef;
    }

    protected void validateMissingModels(URI importUri, String importPath, List problemMarker, List problems) {
        if (importPath != null) {
            if (this.vdbEditingContextImpl.getVdbContainer().getResource(importUri, false) != null) {
                return;
            }
            if (importUri.isRelative()) {
                this.validateImportPathRelative(importPath, problemMarker, problems);
            } else if (importUri.isFile()) {
                this.validateImportPathFile(importPath, problemMarker, problems);
            } else {
                this.validateImportPathOther(importPath, importUri, problemMarker, problems);
            }
        }
    }

    private void validateImportPathRelative(String importPath, List problemMarker, List problems) {
        Collection unresolvedRefs;
        if (this.vdbEditingContextImpl.getModelReferenceByPath(new Path(importPath)) == null && !(unresolvedRefs = this.vdbEditingContextImpl.getUnresolvedExternalReferencePaths(this.eResource)).isEmpty()) {
            this.setProblems(importPath, 4, 4, problemMarker, problems);
            Iterator iterator = unresolvedRefs.iterator();
            while (iterator.hasNext()) {
                String refPath = (String)iterator.next();
                if (refPath.equalsIgnoreCase(importPath)) continue;
                this.setProblems(refPath, 4, 4, problemMarker, problems);
            }
        }
    }

    private void validateImportPathFile(String importPath, List problemMarker, List problems) {
        Collection unresolvedRefs;
        if (this.vdbEditingContextImpl.getModelReferenceByPartialPath(new Path(importPath)) == null && !(unresolvedRefs = this.vdbEditingContextImpl.getUnresolvedExternalReferencePaths(this.eResource)).isEmpty()) {
            this.setProblems(importPath, 4, 4, problemMarker, problems);
            Iterator iterator = unresolvedRefs.iterator();
            while (iterator.hasNext()) {
                String refPath = (String)iterator.next();
                if (refPath.equalsIgnoreCase(importPath)) continue;
                this.setProblems(refPath, 4, 4, problemMarker, problems);
            }
        }
    }

    private void validateImportPathOther(String importPath, URI importUri, List problemMarker, List problems) {
        if (this.vdbEditingContextImpl.getVdbContainer().getResource(importUri, false) == null) {
            Path iImportPart = new Path(importPath);
            if (this.modelPath.matchingFirstSegments(iImportPart) > 0) {
                this.setProblems(importPath, 4, 4, problemMarker, problems);
            } else {
                this.setProblems(importPath, 4, 2, problemMarker, problems);
            }
        }
    }

    private String getMsgDescription(String path) {
        Object[] params = new Object[]{this.modelPath, path};
        return VdbEditPlugin.Util.getString(this.MSGKEY, params);
    }

    private void setProblems(String path, int markerStatus, int problemStatus, List problemMarker, List problems) {
        String msg = this.getMsgDescription(path);
        problemMarker.add(new VdbEditingContextImplProblemMarker(this.modelRef, markerStatus, msg, null));
        problems.add(new Status(problemStatus, "com.metamatrix.vdb.edit", 0, msg, null));
    }
}

