/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.TempDirectory;
import com.metamatrix.internal.core.xml.JdomHelper;
import com.metamatrix.internal.core.xml.xmi.ModelImportInfo;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.internal.core.xml.xmi.XMIHeaderReader;
import com.metamatrix.internal.core.xml.xsd.XsdHeader;
import com.metamatrix.internal.core.xml.xsd.XsdHeaderReader;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlModelSourceAspect;
import com.metamatrix.modeler.internal.core.resource.EResourceFactory;
import com.metamatrix.modeler.internal.core.resource.EResourceSetImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.sdt.ModelerSdtPlugin;
import com.metamatrix.vdb.edit.VdbArtifactGenerator;
import com.metamatrix.vdb.edit.VdbContextEditor;
import com.metamatrix.vdb.edit.VdbContextValidator;
import com.metamatrix.vdb.edit.VdbContextValidatorResult;
import com.metamatrix.vdb.edit.VdbEditException;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.edit.VdbGenerationContext;
import com.metamatrix.vdb.edit.VdbGenerationContextFactory;
import com.metamatrix.vdb.edit.VdbGenerationContextParameters;
import com.metamatrix.vdb.edit.loader.VDBWriter;
import com.metamatrix.vdb.edit.manifest.ManifestFactory;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.edit.manifest.NonModelReference;
import com.metamatrix.vdb.edit.manifest.ProblemMarker;
import com.metamatrix.vdb.edit.manifest.ProblemMarkerContainer;
import com.metamatrix.vdb.edit.manifest.Severity;
import com.metamatrix.vdb.edit.manifest.VirtualDatabase;
import com.metamatrix.vdb.internal.edit.InternalVdbGenerationContext;
import com.metamatrix.vdb.internal.edit.NullVdbContextValidator;
import com.metamatrix.vdb.internal.edit.RuntimeIndexArtifactGenerator;
import com.metamatrix.vdb.internal.edit.SharedWsVdbContextValidator;
import com.metamatrix.vdb.internal.edit.VdbContextImpl;
import com.metamatrix.vdb.internal.edit.VdbFileWriter;
import com.metamatrix.vdb.internal.edit.VdbGenerationContextFactoryImpl;
import com.metamatrix.vdb.internal.edit.WsdlArtifactGenerator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.jdom.Document;

public class SharedWsVdbContextEditor
extends VdbContextImpl
implements VdbContextEditor {
    public static final int DEFAULT_VDB_FORM = 1;
    public static final int FILE_COPY_ERROR_CODE = 100101;
    public static final int CREATE_BACKUP_ERROR_CODE = 100102;
    public static final int CREATE_ARCHIVER_ERROR_CODE = 100103;
    public static final int ARCHIVE_ADD_ERROR_CODE = 100104;
    public static final int ARCHIVE_WRITE_ERROR_CODE = 100105;
    public static final int ARCHIVE_CLOSE_ERROR_CODE = 100106;
    public static final int RESTORE_BACKUP_ERROR_CODE = 100107;
    public static final int NO_MODELS_ERROR_CODE = 100108;
    public static final int FILE_WRITE_ERROR_CODE = 100109;
    public static final int CLOSE_STREAM_ERROR_CODE = 100110;
    public static final int ARTIFACT_GENERATOR_CANCEL_ERROR_CODE = 100111;
    public static final int ARTIFACT_GENERATOR_EXECUTE_ERROR_CODE = 100112;
    public static final int SAVEAS_COPY_CONTENTS_ERROR_CODE = 100113;
    public static final int SAVEAS_SAVE_CONTEXT_ERROR_CODE = 100114;
    public static final int SAVEAS_CLOSE_CONTEXT_ERROR_CODE = 100115;
    public static final int ERROR_LOADING_RESOURCE_ERROR_CODE = 100116;
    public static final int WARNING_REMOVING_MODEL_ERROR_CODE = 100117;
    public static final int WARNING_REMOVING_NONMODEL_ERROR_CODE = 100118;
    private static final String BACKUP_EXTENSION = ".BAK";
    private ResourceSet sharedContainer;
    private VdbGenerationContextFactory vdbGenerationContextFactory;
    private VdbContextValidator vdbContextValidator;
    private List generators;
    private int vdbArchiveForm;
    private boolean saveIsRequired;

    public SharedWsVdbContextEditor(File theVdbFile, File theVdbWorkingFolder, ResourceSet theSharedContainer) {
        super(theVdbFile, theVdbWorkingFolder);
        ArgCheck.isNotNull(theSharedContainer);
        this.sharedContainer = theSharedContainer;
        this.generators = new ArrayList();
        this.vdbArchiveForm = 1;
        this.saveIsRequired = false;
    }

    public synchronized void open(IProgressMonitor theMonitor, boolean notify) throws IOException {
        super.open(theMonitor, false);
        IProgressMonitor monitor = theMonitor == null ? new NullProgressMonitor() : theMonitor;
        int totalFileCount = this.getVirtualDatabase().getModels().size();
        String taskName = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Loading_vdb_contents_into_container", this.getVdbFile().getName());
        monitor.beginTask(taskName, totalFileCount);
        int amountWorked = 0;
        TempDirectory tempDir = this.getTempDirectory();
        ArrayList<String> problems = new ArrayList<String>();
        EList modelRefs = this.getVirtualDatabase().getModels();
        Iterator i2 = modelRefs.iterator();
        while (i2.hasNext()) {
            ModelReference modelRef = (ModelReference)i2.next();
            try {
                String pathInTempDir = modelRef.getModelLocation();
                File tempDirFile = this.getTempDirectoryFile(tempDir, pathInTempDir);
                if (tempDirFile != null && tempDirFile.exists()) {
                    URI fileUri = URI.createFileURI(tempDirFile.getAbsolutePath());
                    Resource eResource = this.getVdbResourceSet().getResource(fileUri, false);
                    if (eResource == null) {
                        eResource = this.getVdbResourceSet().createResource(fileUri);
                    }
                    if (!eResource.isLoaded()) {
                        eResource.load(this.getLoadOptions());
                    }
                } else {
                    String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Unable_to_find_file_in_temp_directory", pathInTempDir);
                    problems.add(msg);
                }
                monitor.worked(amountWorked++);
            }
            catch (Exception e2) {
                problems.add(e2.getLocalizedMessage());
            }
        }
        if (!problems.isEmpty()) {
            StringBuffer sb = new StringBuffer(2000);
            Iterator i3 = problems.iterator();
            while (i3.hasNext()) {
                sb.append((String)i3.next());
                if (!i3.hasNext()) continue;
                sb.append(StringUtil.Constants.NEW_LINE);
            }
            throw new IOException(sb.toString());
        }
        if (notify) {
            this.fireStateChanged();
        }
    }

    public ModelReference[] addModel(IProgressMonitor theMonitor, File theModel, String pathInArchive, boolean addDependentModels) throws VdbEditException {
        return this.addModel(theMonitor, theModel, pathInArchive, addDependentModels, new ArrayList());
    }

    private ModelReference[] addModel(IProgressMonitor theMonitor, File theModel, String pathInArchive, boolean addDependentModels, List modelsToBeAdded) throws VdbEditException {
        ArgCheck.isNotNull(theModel);
        ArgCheck.isNotNull(pathInArchive);
        ArgCheck.isNotZeroLength(pathInArchive);
        this.assertContextIsOpen();
        ModelReference existing = this.getModelReference(pathInArchive);
        if (existing != null) {
            return new ModelReference[]{existing};
        }
        if (!theModel.exists()) {
            String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Model_cannot_be_found", theModel.getAbsolutePath());
            throw new VdbEditException(msg);
        }
        if (!ModelUtil.isXmiFile(theModel) && !ModelUtil.isXsdFile(theModel)) {
            String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.File_is_not_model", theModel.getAbsolutePath());
            throw new VdbEditException(msg);
        }
        if (!ModelUtil.isXsdFile(theModel)) {
            EList models = this.getVirtualDatabase().getModels();
            Iterator i2 = models.iterator();
            while (i2.hasNext()) {
                ModelReference modelRef = (ModelReference)i2.next();
                if (!theModel.getName().equalsIgnoreCase(modelRef.getName()) || "http://www.eclipse.org/xsd/2002/XSD".equals(modelRef.getPrimaryMetamodelUri())) continue;
                Object[] params = new Object[]{theModel.getName(), modelRef.getModelLocation()};
                String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Model_same_name_as_existing", params);
                throw new VdbEditException(msg);
            }
        }
        IProgressMonitor monitor = theMonitor == null ? new NullProgressMonitor() : theMonitor;
        String taskName = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Adding_model", pathInArchive);
        monitor.setTaskName(taskName);
        monitor.worked(1);
        if (!modelsToBeAdded.contains(theModel)) {
            modelsToBeAdded.add(theModel);
        }
        ArrayList<ModelReference> result = new ArrayList<ModelReference>();
        File tempDirFolder = new File(this.getTempDirectory().getPath());
        if (addDependentModels) {
            String[] importLocations = this.getImportLocations(theModel, true);
            for (int i3 = 0; i3 < importLocations.length; ++i3) {
                File importedModel = new File(importLocations[i3]);
                if (!importedModel.exists() || modelsToBeAdded.contains(importedModel)) continue;
                modelsToBeAdded.add(importedModel);
                String importedModelPathInArchive = this.getPathRelativeToFolder(tempDirFolder, importedModel);
                ModelReference[] modelRefs = this.addModel(monitor, importedModel, importedModelPathInArchive, addDependentModels, modelsToBeAdded);
                result.addAll(Arrays.asList(modelRefs));
            }
        }
        String normalizedPath = ((Object)this.createNormalizedPath(pathInArchive)).toString();
        ModelReference modelRef = this.createModelReference(theModel, normalizedPath);
        result.add(modelRef);
        this.getManifestResource().setModified(true);
        this.fireStateChanged();
        return result.toArray(new ModelReference[result.size()]);
    }

    public NonModelReference addNonModel(IProgressMonitor monitor, File theNonModel, String pathInArchive) throws VdbEditException {
        ArgCheck.isNotNull(theNonModel);
        ArgCheck.isNotNull(pathInArchive);
        ArgCheck.isNotZeroLength(pathInArchive);
        this.assertContextIsOpen();
        NonModelReference existing = this.getNonModelReference(pathInArchive);
        if (existing != null) {
            return existing;
        }
        if (!theNonModel.exists()) {
            String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.NonModel_cannot_be_found", theNonModel.getAbsolutePath());
            throw new VdbEditException(msg);
        }
        String normalizedPath = ((Object)this.createNormalizedPath(pathInArchive)).toString();
        NonModelReference nonModelRef = this.createNonModelReference(theNonModel, normalizedPath);
        this.getManifestResource().setModified(true);
        this.fireStateChanged();
        return nonModelRef;
    }

    public IStatus removeModel(IProgressMonitor monitor, ModelReference theReference) throws VdbEditException {
        ArgCheck.isNotNull(theReference);
        this.assertContextIsOpen();
        Status status = null;
        ModelReference modelRef = this.getModelReference(theReference.getModelLocation());
        if (modelRef != null) {
            this.getVirtualDatabase().getModels().remove(modelRef);
            this.getManifestResource().setModified(true);
            String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Removed_model", modelRef.getModelLocation());
            status = new Status(0, "com.metamatrix.vdb.edit", 0, msg, null);
        } else {
            String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Unable_to_find_modelReference", theReference.getModelLocation());
            status = new Status(2, "com.metamatrix.vdb.edit", 100117, msg, null);
        }
        this.fireStateChanged();
        return status;
    }

    public IStatus removeNonModel(IProgressMonitor monitor, NonModelReference theReference) throws VdbEditException {
        ArgCheck.isNotNull(theReference);
        this.assertContextIsOpen();
        Status status = null;
        NonModelReference nonModelRef = this.getNonModelReference(theReference.getPath());
        if (nonModelRef != null) {
            this.getVirtualDatabase().getNonModels().remove(nonModelRef);
            this.getManifestResource().setModified(true);
            String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Removed_nonModel", nonModelRef.getPath());
            status = new Status(0, "com.metamatrix.vdb.edit", 0, msg, null);
        } else {
            String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Unable_to_find_nonModelReference", theReference.getPath());
            status = new Status(2, "com.metamatrix.vdb.edit", 100118, msg, null);
        }
        this.fireStateChanged();
        return status;
    }

    public void setDescription(String description) {
        this.assertContextIsOpen();
        this.getVirtualDatabase().setDescription(description);
        this.getManifestResource().setModified(true);
    }

    public void setSaveIsRequired() {
        this.saveIsRequired = true;
    }

    public boolean isSaveRequired() {
        this.assertContextIsOpen();
        if (this.saveIsRequired) {
            return true;
        }
        if (this.getManifestResource().isModified()) {
            return true;
        }
        TempDirectory sourceTempDir = this.getTempDirectory();
        File sourceDirectory = new File(sourceTempDir.getPath());
        File[] sourceFiles = this.findAllFilesInDirectoryRecursively(sourceDirectory);
        return this.requiresSynchronizeManifest(sourceDirectory, sourceFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized IStatus save(IProgressMonitor theMonitor) throws VdbEditException {
        IStatus writeStatus;
        block56: {
            VdbFileWriter writer;
            File backupVdbFile;
            TempDirectory targetTempDir;
            IProgressMonitor monitor;
            ArrayList<Artifact> artifactsToWrite;
            ArrayList<Status> problems;
            block53: {
                boolean fatalError;
                Object pathInTempDir;
                File targetDirectory;
                File sourceDirectory;
                block52: {
                    Object msg;
                    this.assertContextIsOpen();
                    problems = new ArrayList<Status>();
                    artifactsToWrite = new ArrayList<Artifact>();
                    monitor = theMonitor == null ? new NullProgressMonitor() : theMonitor;
                    TempDirectory sourceTempDir = this.getTempDirectory();
                    sourceDirectory = new File(sourceTempDir.getPath());
                    File[] sourceFiles = this.findAllFilesInDirectoryRecursively(sourceDirectory);
                    File vdbWorkingFolder = sourceDirectory.getParentFile();
                    targetTempDir = this.createTempDirectory(vdbWorkingFolder);
                    targetDirectory = new File(targetTempDir.getPath());
                    int totalFileCount = 2 * (sourceFiles.length + 1);
                    String taskName = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Saving", this.getVdbFile().getName());
                    monitor.beginTask(taskName, totalFileCount);
                    this.synchronizeManifest(sourceDirectory, sourceFiles);
                    this.synchronizeContainer(this.getVdbResourceSet(), sourceDirectory, sourceFiles);
                    this.saveGlobalResourcesInVdb(targetDirectory, this.getVdbResourceSet(), problems, artifactsToWrite);
                    File sourceFile = null;
                    try {
                        for (int i2 = 0; i2 < sourceFiles.length; ++i2) {
                            sourceFile = sourceFiles[i2];
                            if ("ConfigurationInfo.def".equals(sourceFile.getName())) {
                                String vdbName = FileUtils.getFilenameWithoutExtension(this.getVdbFile().getName());
                                VDBWriter.updateConfigDefFile(sourceFile, vdbName);
                            }
                            String pathInTempDir2 = this.getPathRelativeToFolder(sourceDirectory, sourceFile);
                            IPath normalizedPath = this.createNormalizedPath(pathInTempDir2);
                            File targetFile = this.copyTempDirectoryEntryForSave(((Object)normalizedPath).toString(), sourceTempDir, targetTempDir);
                            artifactsToWrite.add(new Artifact(normalizedPath, targetFile, 1));
                            monitor.setTaskName(VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Copying_to_scratch", targetFile.getName()));
                            monitor.worked(1);
                        }
                    }
                    catch (Exception e2) {
                        String msg2 = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_copying_to_scratch", sourceFile.getName());
                        problems.add(new Status(4, "com.metamatrix.vdb.edit", 100101, msg2, e2));
                    }
                    if (!problems.isEmpty()) {
                        String msg3 = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_setting_up_scratch_directory");
                        IStatus result = this.createSingleIStatus(problems, msg3);
                        if (result.getSeverity() == 4) {
                            targetTempDir.remove();
                            this.fireStateChanged();
                            return result;
                        }
                        VdbEditPlugin.Util.log(result);
                    }
                    this.getVirtualDatabase().getMarkers().clear();
                    Iterator i3 = this.getVirtualDatabase().getModels().iterator();
                    while (i3.hasNext()) {
                        ((ModelReference)i3.next()).getMarkers().clear();
                    }
                    ArrayList<Resource> modelList = new ArrayList<Resource>();
                    modelList.add(this.getManifestResource());
                    modelList.addAll(this.getVdbResourceSet().getResources());
                    VdbContextValidatorResult validatorResult = this.getVdbContextValidator().validate(monitor, modelList.toArray(new Resource[modelList.size()]));
                    Iterator i4 = modelList.iterator();
                    while (i4.hasNext()) {
                        Resource eResource = (Resource)i4.next();
                        IStatus[] validationProblems = validatorResult.getProblems(eResource);
                        for (int j2 = 0; j2 < validationProblems.length; ++j2) {
                            int severity = validationProblems[j2].getSeverity();
                            msg = validationProblems[j2].getMessage();
                            Throwable e3 = validationProblems[j2].getException();
                            if (eResource == this.getManifestResource()) {
                                this.addProblemMarker(this.getVirtualDatabase(), severity, (String)msg, e3);
                                continue;
                            }
                            if (!eResource.getURI().isFile()) continue;
                            pathInTempDir = this.getPathRelativeToFolder(sourceDirectory, new File(eResource.getURI().toFileString()));
                            ModelReference modelRef = this.getModelReference((String)pathInTempDir);
                            this.addProblemMarker(modelRef, severity, (String)msg, e3);
                        }
                    }
                    Date currentDate = DateUtil.getCurrentDate();
                    this.setVdbProblems(this.getVirtualDatabase(), problems);
                    this.getVirtualDatabase().setName(FileUtils.getFilenameWithoutExtension(this.getVdbFile().getName()));
                    this.getVirtualDatabase().setTimeLastChangedAsDate(currentDate);
                    this.getVirtualDatabase().setTimeLastProducedAsDate(currentDate);
                    this.saveInternalResourceInVdb(targetDirectory, this.getManifestResource(), new Path("MetaMatrix-VdbManifestModel.xmi"), problems, artifactsToWrite);
                    fatalError = false;
                    backupVdbFile = null;
                    if (this.getVdbFile().exists() && this.getVdbFile().length() > 0L) {
                        try {
                            String fromFileName = this.getVdbFile().getAbsolutePath();
                            String toFileName = fromFileName + BACKUP_EXTENSION;
                            FileUtils.copy(fromFileName, toFileName, true);
                            backupVdbFile = new File(toFileName);
                            Object var26_38 = null;
                            if (!fatalError) break block52;
                            targetTempDir.remove();
                            if (backupVdbFile == null || !backupVdbFile.exists()) break block52;
                            backupVdbFile.delete();
                        }
                        catch (Throwable throwable) {
                            Object var26_40 = null;
                            if (fatalError) {
                                targetTempDir.remove();
                                if (backupVdbFile != null && backupVdbFile.exists()) {
                                    backupVdbFile.delete();
                                }
                            }
                            throw throwable;
                        }
                        {
                            break block52;
                            catch (Exception e4) {
                                fatalError = true;
                                this.fireStateChanged();
                                String msg4 = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_writing_backup", this.getVdbFile().getName());
                                msg = new Status(4, "com.metamatrix.vdb.edit", 100102, msg4, e4);
                                Object var26_39 = null;
                                if (fatalError) {
                                    targetTempDir.remove();
                                    if (backupVdbFile != null && backupVdbFile.exists()) {
                                        backupVdbFile.delete();
                                    }
                                }
                                return msg;
                            }
                        }
                    }
                }
                problems.clear();
                this.generateAdditionalArtifacts(monitor, this.generators, sourceDirectory, targetDirectory, this.getVdbResourceSet(), problems, artifactsToWrite);
                Path vdbFilePath = null;
                writer = null;
                try {
                    vdbFilePath = new Path(this.getVdbFile().getAbsolutePath());
                    writer = new VdbFileWriter(vdbFilePath, this.vdbArchiveForm);
                    Object var28_45 = null;
                    if (!fatalError) break block53;
                    targetTempDir.remove();
                    if (backupVdbFile == null || !backupVdbFile.exists()) break block53;
                    backupVdbFile.delete();
                }
                catch (Throwable throwable) {
                    Object var28_47 = null;
                    if (fatalError) {
                        targetTempDir.remove();
                        if (backupVdbFile != null && backupVdbFile.exists()) {
                            backupVdbFile.delete();
                        }
                    }
                    throw throwable;
                }
                {
                    break block53;
                    catch (Exception e5) {
                        fatalError = true;
                        String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_creating_vdb_file_writer");
                        this.fireStateChanged();
                        pathInTempDir = new Status(4, "com.metamatrix.vdb.edit", 100103, msg, e5);
                        Object var28_46 = null;
                        if (fatalError) {
                            targetTempDir.remove();
                            if (backupVdbFile != null && backupVdbFile.exists()) {
                                backupVdbFile.delete();
                            }
                        }
                        return pathInTempDir;
                    }
                }
            }
            Iterator i5 = artifactsToWrite.iterator();
            while (i5.hasNext()) {
                Artifact artifact = (Artifact)i5.next();
                IPath path = artifact.path;
                File content = artifact.content;
                int work = artifact.workToWrite;
                try {
                    monitor.setTaskName(VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Adding_to_archive", content.getName()));
                    writer.addEntry(path, content);
                }
                catch (IOException e6) {
                    String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_adding_to_archive", path);
                    problems.add(new Status(4, "com.metamatrix.vdb.edit", 100104, msg, e6));
                }
                finally {
                    monitor.worked(work);
                }
            }
            writeStatus = null;
            String desc = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Writing_archive");
            writer.open();
            writeStatus = writer.write(monitor);
            Object var31_51 = null;
            try {
                writer.close();
            }
            catch (Throwable e3) {
                String msg5 = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_closing_writer", this.getVdbFile().getName());
                problems.add(new Status(4, "com.metamatrix.vdb.edit", 100106, msg5, null));
            }
            boolean saveBackup = false;
            if (writeStatus.getSeverity() == 4 && backupVdbFile != null && backupVdbFile.exists()) {
                try {
                    String toFileName = this.getVdbFile().getAbsolutePath();
                    String fromFileName = toFileName + BACKUP_EXTENSION;
                    FileUtils.copy(fromFileName, toFileName, true);
                }
                catch (Exception e7) {
                    saveBackup = true;
                    String msg6 = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_restoring_backup", this.getVdbFile().getName());
                    VdbEditPlugin.Util.log(4, e7, msg6);
                }
            }
            IStatus problemStatus = this.createSingleIStatus(problems, desc);
            writeStatus = this.merge(writeStatus, problemStatus, desc);
            targetTempDir.remove();
            if (!saveBackup && backupVdbFile != null && backupVdbFile.exists()) {
                backupVdbFile.delete();
            }
            this.saveIsRequired = false;
            {
                break block56;
                catch (Throwable e8) {
                    String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_writing_vdb_file", this.getVdbFile().getName());
                    Status status = new Status(4, "com.metamatrix.vdb.edit", 100105, msg, e8);
                    problems.add(status);
                    if (writeStatus == null) {
                        writeStatus = status;
                    }
                    Object var31_52 = null;
                    try {
                        writer.close();
                    }
                    catch (Throwable e3) {
                        String msg5 = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_closing_writer", this.getVdbFile().getName());
                        problems.add(new Status(4, "com.metamatrix.vdb.edit", 100106, msg5, null));
                    }
                    saveBackup = false;
                    if (writeStatus.getSeverity() == 4 && backupVdbFile != null && backupVdbFile.exists()) {
                        try {
                            String toFileName = this.getVdbFile().getAbsolutePath();
                            String fromFileName = toFileName + BACKUP_EXTENSION;
                            FileUtils.copy(fromFileName, toFileName, true);
                        }
                        catch (Exception e7) {
                            saveBackup = true;
                            String msg6 = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_restoring_backup", this.getVdbFile().getName());
                            VdbEditPlugin.Util.log(4, e7, msg6);
                        }
                    }
                    problemStatus = this.createSingleIStatus(problems, desc);
                    writeStatus = this.merge(writeStatus, problemStatus, desc);
                    targetTempDir.remove();
                    if (!saveBackup && backupVdbFile != null && backupVdbFile.exists()) {
                        backupVdbFile.delete();
                    }
                    this.saveIsRequired = false;
                }
            }
            catch (Throwable throwable) {
                Object var31_53 = null;
                try {
                    writer.close();
                }
                catch (Throwable e3) {
                    String msg5 = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_closing_writer", this.getVdbFile().getName());
                    problems.add(new Status(4, "com.metamatrix.vdb.edit", 100106, msg5, null));
                }
                saveBackup = false;
                if (writeStatus.getSeverity() == 4 && backupVdbFile != null && backupVdbFile.exists()) {
                    try {
                        String toFileName = this.getVdbFile().getAbsolutePath();
                        String fromFileName = toFileName + BACKUP_EXTENSION;
                        FileUtils.copy(fromFileName, toFileName, true);
                    }
                    catch (Exception e7) {
                        saveBackup = true;
                        String msg6 = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_restoring_backup", this.getVdbFile().getName());
                        VdbEditPlugin.Util.log(4, e7, msg6);
                    }
                }
                problemStatus = this.createSingleIStatus(problems, desc);
                writeStatus = this.merge(writeStatus, problemStatus, desc);
                targetTempDir.remove();
                if (!saveBackup && backupVdbFile != null && backupVdbFile.exists()) {
                    backupVdbFile.delete();
                }
                this.saveIsRequired = false;
                throw throwable;
            }
        }
        this.fireStateChanged();
        return writeStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized IStatus saveAs(IProgressMonitor monitor, File newVdbFile) throws VdbEditException {
        ArgCheck.isNotNull(newVdbFile);
        this.assertContextIsOpen();
        if (newVdbFile.equals(this.getVdbFile())) {
            return this.save(monitor);
        }
        if (newVdbFile.exists()) {
            newVdbFile.delete();
        }
        File vdbWorkingFolder = this.getVdbWorkingFolder();
        SharedWsVdbContextEditor editor = new SharedWsVdbContextEditor(newVdbFile, vdbWorkingFolder, this.createSaveAsResourceSet());
        editor.setVdbContextValidator(new SharedWsVdbContextValidator());
        editor.addArtifactGenerator(new WsdlArtifactGenerator());
        editor.addArtifactGenerator(new RuntimeIndexArtifactGenerator());
        try {
            editor.open(monitor);
        }
        catch (IOException e2) {
            throw new VdbEditException(e2);
        }
        TempDirectory sourceTempDir = this.getTempDirectory();
        File sourceDirectory = new File(sourceTempDir.getPath());
        File[] sourceFiles = sourceDirectory.listFiles();
        TempDirectory targetTempDir = editor.getTempDirectory();
        File targetDirectory = new File(targetTempDir.getPath());
        String origVdbName = FileUtils.getFilenameWithoutExtension(this.getVdbFile().getName());
        for (int i2 = 0; i2 < sourceFiles.length; ++i2) {
            try {
                if (sourceFiles[i2].isDirectory() && origVdbName.equalsIgnoreCase(sourceFiles[i2].getName())) {
                    String newVdbName = FileUtils.getFilenameWithoutExtension(newVdbFile.getName());
                    File targetFolder = new File(targetDirectory, newVdbName);
                    FileUtils.copyDirectoryContentsRecursively(sourceFiles[i2], targetFolder);
                    continue;
                }
                if (sourceFiles[i2].isDirectory()) {
                    File targetFolder = new File(targetDirectory, sourceFiles[i2].getName());
                    FileUtils.copyDirectoryContentsRecursively(sourceFiles[i2], targetFolder);
                    continue;
                }
                File sourceFile = new File(sourceDirectory, sourceFiles[i2].getName());
                File targetFile = new File(targetDirectory, sourceFiles[i2].getName());
                FileUtils.copy(sourceFile.getCanonicalPath(), targetFile.getCanonicalPath(), true);
                continue;
            }
            catch (Throwable e3) {
                Object[] params = new Object[]{sourceFiles[i2], newVdbFile.getName()};
                String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_copying_contents_before_saving", params);
                throw new VdbEditException(e3, 100113, msg);
            }
        }
        editor.getVirtualDatabase().setWsdlOptions(this.getVirtualDatabase().getWsdlOptions());
        IStatus status = null;
        try {
            try {
                status = editor.save(monitor);
            }
            catch (Throwable e5) {
                String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_saving_temp_context", newVdbFile.getName());
                throw new VdbEditException(e5, 100114, msg);
            }
            Object var16_19 = null;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            try {
                editor.close(monitor, false, false);
            }
            catch (Throwable e4) {
                String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_closing_temp_context", newVdbFile.getName());
                throw new VdbEditException(e4, 100115, msg);
            }
            editor.dispose();
            throw throwable;
        }
        try {}
        catch (Throwable e4) {
            String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_closing_temp_context", newVdbFile.getName());
            throw new VdbEditException(e4, 100115, msg);
        }
        editor.close(monitor, false, false);
        editor.dispose();
        return status;
    }

    public void setVdbContextValidator(VdbContextValidator theValidator) {
        ArgCheck.isNotNull(theValidator);
        this.vdbContextValidator = theValidator;
    }

    public ResourceSet getVdbResourceSet() {
        return this.sharedContainer;
    }

    public void addArtifactGenerator(VdbArtifactGenerator theGenerator) {
        if (theGenerator != null) {
            this.generators.add(theGenerator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(IProgressMonitor theMonitor, boolean notify, boolean vetoable) throws IOException {
        if (this.isOpen() && (!vetoable || this.fireVetoableChange("closing", "opened", "closed"))) {
            IProgressMonitor monitor = theMonitor == null ? new NullProgressMonitor() : theMonitor;
            ArrayList eResources = new ArrayList(this.getVdbResourceSet().getResources());
            String taskName = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Closing_context", this.getVdbFile().getName());
            monitor.beginTask(taskName, eResources.size());
            int amountWorked = 0;
            try {
                Iterator i2 = eResources.iterator();
                while (i2.hasNext()) {
                    Resource eResource = (Resource)i2.next();
                    if (eResource.isLoaded()) {
                        eResource.unload();
                    }
                    this.getVdbResourceSet().getResources().remove(eResource);
                    monitor.worked(amountWorked++);
                }
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                super.close(monitor, false, vetoable);
                if (notify) {
                    this.fireStateChanged();
                }
                throw throwable;
            }
            super.close(monitor, false, vetoable);
            if (notify) {
                this.fireStateChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        try {
            try {
                this.close(null, false, false);
                if (this.generators != null) {
                    this.generators.clear();
                }
                super.dispose();
            }
            catch (Exception e2) {
                String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_disposing_of_vdbContextEditor");
                VdbEditPlugin.Util.log(4, e2, msg);
                Object var4_2 = null;
                this.generators = null;
                this.sharedContainer = null;
                this.vdbContextValidator = null;
                this.vdbGenerationContextFactory = null;
            }
            Object var4_1 = null;
            this.generators = null;
            this.sharedContainer = null;
            this.vdbContextValidator = null;
            this.vdbGenerationContextFactory = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.generators = null;
            this.sharedContainer = null;
            this.vdbContextValidator = null;
            this.vdbGenerationContextFactory = null;
            throw throwable;
        }
    }

    public VdbGenerationContextFactory getVdbGenerationContextFactory() {
        if (this.vdbGenerationContextFactory == null) {
            this.vdbGenerationContextFactory = new VdbGenerationContextFactoryImpl();
        }
        return this.vdbGenerationContextFactory;
    }

    public void setVdbGenerationContextFactory(VdbGenerationContextFactory theVdbGenerationContextFactory) {
        ArgCheck.isNotNull(theVdbGenerationContextFactory);
        this.vdbGenerationContextFactory = theVdbGenerationContextFactory;
    }

    public VdbContextValidator getVdbContextValidator() {
        if (this.vdbContextValidator == null) {
            this.vdbContextValidator = new NullVdbContextValidator();
        }
        return this.vdbContextValidator;
    }

    protected File[] findAllFilesInDirectoryRecursively(File directory) {
        File[] files = FileUtils.findAllFilesInDirectoryRecursively(directory.getAbsolutePath());
        ArrayList<File> result = new ArrayList<File>(Arrays.asList(files));
        Iterator i2 = result.iterator();
        while (i2.hasNext()) {
            File f2 = (File)i2.next();
            if (!f2.getName().startsWith(".")) continue;
            i2.remove();
        }
        return result.toArray(new File[result.size()]);
    }

    protected ResourceSet createSaveAsResourceSet() {
        EResourceSetImpl rs = new EResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new EResourceFactory());
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        rs.addExternalResourceSet(XSDSchemaImpl.getGlobalResourceSet());
        rs.addExternalResourceSet(ModelerSdtPlugin.getGlobalResourceSet());
        return rs;
    }

    protected void addProblemMarker(ModelReference markerCntr, int severity, String msg, Throwable e2) {
        ArgCheck.isNotNull(markerCntr);
        this.createProblem(markerCntr, severity, msg, e2);
    }

    protected void addProblemMarker(VirtualDatabase markerCntr, int severity, String msg, Throwable e2) {
        ArgCheck.isNotNull(markerCntr);
        this.createProblem(markerCntr, severity, msg, e2);
    }

    protected void createProblem(ProblemMarkerContainer theMarkerContainer, int severity, String msg, Throwable t2) {
        ProblemMarker marker = ManifestFactory.eINSTANCE.createProblemMarker();
        switch (severity) {
            case 4: {
                marker.setSeverity(Severity.ERROR_LITERAL);
                break;
            }
            case 2: {
                marker.setSeverity(Severity.WARNING_LITERAL);
                break;
            }
            case 1: {
                marker.setSeverity(Severity.INFO_LITERAL);
                break;
            }
            case 0: {
                marker.setSeverity(Severity.OK_LITERAL);
            }
        }
        if (theMarkerContainer instanceof VirtualDatabase && ((VirtualDatabase)theMarkerContainer).getName() != null) {
            marker.setTarget(((VirtualDatabase)theMarkerContainer).getName());
        } else if (theMarkerContainer instanceof ModelReference && ((ModelReference)theMarkerContainer).getModelLocation() != null) {
            marker.setTarget(((ModelReference)theMarkerContainer).getModelLocation());
        }
        marker.setMessage(msg);
        if (t2 != null) {
            marker.setStackTrace(StringUtil.getStackTrace(t2));
        }
        marker.setMarked(theMarkerContainer);
    }

    protected void setVdbProblems(VirtualDatabase vdb, List statuses) {
        Iterator i2 = statuses.iterator();
        while (i2.hasNext()) {
            IStatus status = (IStatus)i2.next();
            this.addVdbStatus(vdb, status);
        }
        if (vdb.getModels().isEmpty()) {
            String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Vdb_has_no_models");
            boolean foundNoModelsWarning = false;
            Iterator i3 = vdb.getMarkers().iterator();
            while (i3.hasNext()) {
                ProblemMarker marker = (ProblemMarker)i3.next();
                if (!marker.getMessage().equals(msg)) continue;
                foundNoModelsWarning = true;
                break;
            }
            if (!foundNoModelsWarning) {
                this.createProblem(vdb, 2, msg, null);
            }
        }
    }

    protected void addVdbStatus(VirtualDatabase vdb, IStatus status) {
        if (status == null) {
            return;
        }
        if (status.isMultiStatus()) {
            IStatus[] statuses = status.getChildren();
            for (int i2 = 0; i2 < statuses.length; ++i2) {
                this.addVdbStatus(vdb, statuses[i2]);
            }
        } else if (status.getSeverity() == 2) {
            this.createProblem(vdb, status.getSeverity(), status.getMessage(), status.getException());
        } else if (status.getSeverity() == 4) {
            this.createProblem(vdb, status.getSeverity(), status.getMessage(), status.getException());
        }
    }

    protected IStatus merge(IStatus status1, IStatus status2, String desc) {
        ArgCheck.isNotNull(status1);
        if (status2 == null) {
            return status1;
        }
        if (status2 instanceof Status && status2.isOK()) {
            return status1;
        }
        LinkedList<IStatus> statuses = new LinkedList<IStatus>();
        for (int i2 = 0; i2 != 2; ++i2) {
            IStatus xstatus;
            IStatus iStatus = xstatus = i2 == 0 ? status2 : status1;
            if (xstatus instanceof MultiStatus) {
                IStatus[] xStatuses = ((MultiStatus)xstatus).getChildren();
                for (int j2 = 0; j2 < xStatuses.length; ++j2) {
                    IStatus status = xStatuses[j2];
                    statuses.add(status);
                }
                continue;
            }
            statuses.add(status2);
        }
        IStatus results = this.createSingleIStatus(statuses, desc);
        return results;
    }

    protected IStatus createSingleIStatus(List problems, String desc) {
        ArgCheck.isNotNull(problems);
        ArgCheck.isNotNull(desc);
        String PLUGINID = "com.metamatrix.vdb.edit";
        IStatus resultStatus = null;
        if (problems.isEmpty()) {
            String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Completed", desc);
            Status status = new Status(0, "com.metamatrix.vdb.edit", 0, msg, null);
            resultStatus = status;
        } else if (problems.size() == 1) {
            resultStatus = (IStatus)problems.get(0);
        } else {
            Object[] params;
            int numErrors = 0;
            int numWarnings = 0;
            Iterator i2 = problems.iterator();
            while (i2.hasNext()) {
                IStatus aStatus = (IStatus)i2.next();
                if (aStatus.getSeverity() == 2) {
                    ++numWarnings;
                    continue;
                }
                if (aStatus.getSeverity() != 4) continue;
                ++numErrors;
            }
            IStatus[] statusArray = problems.toArray(new IStatus[problems.size()]);
            if (numWarnings != 0 && numErrors == 0) {
                params = new Object[]{desc, new Integer(numWarnings)};
                String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Completed_with_warnings", params);
                resultStatus = new MultiStatus("com.metamatrix.vdb.edit", 0, statusArray, msg, null);
            } else if (numWarnings == 0 && numErrors != 0) {
                params = new Object[]{desc, new Integer(numErrors)};
                String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Resulted_in_errors", params);
                resultStatus = new MultiStatus("com.metamatrix.vdb.edit", 0, statusArray, msg, null);
            } else if (numWarnings != 0 && numErrors != 0) {
                params = new Object[]{desc, new Integer(numWarnings), new Integer(numErrors)};
                String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Resulted_in_errors_and_warnings", params);
                resultStatus = new MultiStatus("com.metamatrix.vdb.edit", 0, statusArray, msg, null);
            } else {
                String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Completed", desc);
                resultStatus = new MultiStatus("com.metamatrix.vdb.edit", 0, statusArray, msg, null);
            }
        }
        return resultStatus;
    }

    protected void synchronizeContainer(ResourceSet cntr, File directory, File[] files) {
        ArgCheck.isNotNull(cntr);
        ArgCheck.isNotNull(directory);
        ArgCheck.isNotNull(files);
        this.assertContextIsOpen();
        HashSet<URI> fileUris = new HashSet<URI>(files.length);
        for (int i2 = 0; i2 < files.length; ++i2) {
            File fileInTempDir = files[i2];
            if (!ModelUtil.isXmiFile(fileInTempDir) && !ModelUtil.isXsdFile(fileInTempDir)) continue;
            fileUris.add(URI.createFileURI(fileInTempDir.getAbsolutePath()));
        }
        Iterator i3 = cntr.getResources().iterator();
        while (i3.hasNext()) {
            URI eResourceUri = ((Resource)i3.next()).getURI();
            if (!fileUris.contains(eResourceUri)) {
                i3.remove();
                continue;
            }
            fileUris.remove(eResourceUri);
        }
        i3 = fileUris.iterator();
        while (i3.hasNext()) {
            URI fileUri = (URI)i3.next();
            if (cntr.getResource(fileUri, false) != null) continue;
            cntr.createResource(fileUri);
        }
    }

    protected void synchronizeManifest(File directory, File[] files) {
        long checkSum;
        String pathInArchive;
        ArgCheck.isNotNull(directory);
        ArgCheck.isNotNull(files);
        this.assertContextIsOpen();
        HashMap<String, File> pathsInTempDir = new HashMap<String, File>(files.length);
        for (int i2 = 0; i2 < files.length; ++i2) {
            String pathInTempDir = this.getPathRelativeToFolder(directory, files[i2]);
            String normalizedPath = ((Object)this.createNormalizedPath(pathInTempDir)).toString();
            pathsInTempDir.put(normalizedPath, files[i2]);
        }
        Iterator<Object> i3 = this.getVirtualDatabase().getModels().iterator();
        while (i3.hasNext()) {
            ModelReference modelRef = (ModelReference)i3.next();
            pathInArchive = ((Object)this.createNormalizedPath(modelRef.getModelLocation())).toString();
            if (!pathsInTempDir.containsKey(pathInArchive)) {
                i3.remove();
                continue;
            }
            checkSum = this.getCheckSum((File)pathsInTempDir.get(pathInArchive));
            modelRef.setChecksum(checkSum);
            pathsInTempDir.remove(pathInArchive);
        }
        i3 = this.getVirtualDatabase().getNonModels().iterator();
        while (i3.hasNext()) {
            NonModelReference nonModelRef = (NonModelReference)i3.next();
            pathInArchive = ((Object)this.createNormalizedPath(nonModelRef.getPath())).toString();
            if (!pathsInTempDir.containsKey(pathInArchive)) {
                i3.remove();
                continue;
            }
            checkSum = this.getCheckSum((File)pathsInTempDir.get(pathInArchive));
            nonModelRef.setChecksum(checkSum);
            pathsInTempDir.remove(pathInArchive);
        }
        i3 = pathsInTempDir.entrySet().iterator();
        while (i3.hasNext()) {
            Map.Entry entry = (Map.Entry)i3.next();
            String pathInTempDir = (String)entry.getKey();
            File fileInTempDir = (File)entry.getValue();
            if (ModelUtil.isXmiFile(fileInTempDir) || ModelUtil.isXsdFile(fileInTempDir)) {
                ModelReference modelRef = this.getModelReference(pathInTempDir);
                if (modelRef != null) continue;
                this.createModelReference(fileInTempDir, pathInTempDir);
                continue;
            }
            NonModelReference nonModelRef = this.getNonModelReference(pathInTempDir);
            if (nonModelRef != null) continue;
            this.createNonModelReference(fileInTempDir, pathInTempDir);
        }
    }

    protected boolean requiresSynchronizeManifest(File directory, File[] files) {
        long checkSum;
        String pathInArchive;
        ArgCheck.isNotNull(directory);
        ArgCheck.isNotNull(files);
        this.assertContextIsOpen();
        HashMap<String, File> pathsInTempDir = new HashMap<String, File>(files.length);
        for (int i2 = 0; i2 < files.length; ++i2) {
            String pathInTempDir = this.getPathRelativeToFolder(directory, files[i2]);
            String normalizedPath = ((Object)this.createNormalizedPath(pathInTempDir)).toString();
            pathsInTempDir.put(normalizedPath, files[i2]);
        }
        Iterator i3 = this.getVirtualDatabase().getModels().iterator();
        while (i3.hasNext()) {
            ModelReference modelRef = (ModelReference)i3.next();
            pathInArchive = ((Object)this.createNormalizedPath(modelRef.getModelLocation())).toString();
            if (!pathsInTempDir.containsKey(pathInArchive)) {
                return true;
            }
            checkSum = this.getCheckSum((File)pathsInTempDir.get(pathInArchive));
            if (checkSum != modelRef.getChecksum()) {
                return true;
            }
            pathsInTempDir.remove(pathInArchive);
        }
        i3 = this.getVirtualDatabase().getNonModels().iterator();
        while (i3.hasNext()) {
            NonModelReference nonModelRef = (NonModelReference)i3.next();
            pathInArchive = ((Object)this.createNormalizedPath(nonModelRef.getPath())).toString();
            if (!pathsInTempDir.containsKey(pathInArchive)) {
                return true;
            }
            checkSum = this.getCheckSum((File)pathsInTempDir.get(pathInArchive));
            if (checkSum != nonModelRef.getChecksum()) {
                return true;
            }
            pathsInTempDir.remove(pathInArchive);
        }
        Iterator iter = pathsInTempDir.entrySet().iterator();
        while (iter.hasNext()) {
            NonModelReference nonModelRef;
            ModelReference modelRef;
            Map.Entry entry = iter.next();
            String pathInTempDir = (String)entry.getKey();
            File fileInTempDir = (File)entry.getValue();
            if (!(ModelUtil.isXmiFile(fileInTempDir) || ModelUtil.isXsdFile(fileInTempDir) ? (modelRef = this.getModelReference(pathInTempDir)) == null : (nonModelRef = this.getNonModelReference(pathInTempDir)) == null)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected ModelReference createModelReference(File f, String pathInArchive) {
        ArgCheck.isNotNull(f);
        ArgCheck.isNotNull(pathInArchive);
        ArgCheck.isNotZeroLength(pathInArchive);
        modelReference = ManifestFactory.eINSTANCE.createModelReference();
        modelReference.setModelLocation(pathInArchive);
        modelReference.setUri(null);
        modelReference.setVisible(true);
        modelReference.setTimeLastSynchronizedAsDate(DateUtil.getCurrentDate());
        modelReference.setName(f.getName());
        try {
            if (ModelUtil.isXmiFile(f)) {
                header = XMIHeaderReader.readHeader(f);
                if (header != null) {
                    if (header.getModelType() != null) {
                        modelReference.setModelType(ModelType.get(header.getModelType()));
                    }
                    if (header.getUUID() != null) {
                        modelReference.setUuid(header.getUUID());
                    }
                    if (header.getPrimaryMetamodelURI() != null) {
                        modelReference.setPrimaryMetamodelUri(header.getPrimaryMetamodelURI());
                    }
                    modelReference.setVisible(header.isVisible());
                }
                try {
                    fileUri = URI.createFileURI(f.getAbsolutePath());
                    eResource = this.getVdbResourceSet().getResource(fileUri, true);
                    Assertion.isNotNull(eResource);
                    modelSourceProps = this.getModelSourceProperties(eResource);
                    if (modelSourceProps == null) ** GOTO lbl50
                    modelSource = ManifestFactory.eINSTANCE.createModelSource();
                    modelReference.setModelSource(modelSource);
                    i = modelSourceProps.entrySet().iterator();
                    while (i.hasNext()) {
                        entry = i.next();
                        name = (String)entry.getKey();
                        value = (String)entry.getValue();
                        if (name == null || value == null) continue;
                        srcProp = ManifestFactory.eINSTANCE.createModelSourceProperty();
                        srcProp.setName(name);
                        srcProp.setValue(value);
                        srcProp.setSource(modelSource);
                    }
                }
                catch (Throwable e) {
                    msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_loading", f.getName());
                    VdbEditPlugin.Util.log(4, e, msg);
                }
            } else if (ModelUtil.isXsdFile(f)) {
                modelReference.setModelType(ModelType.TYPE_LITERAL);
                modelReference.setPrimaryMetamodelUri("http://www.eclipse.org/xsd/2002/XSD");
            } else {
                modelReference.setModelType(ModelType.UNKNOWN_LITERAL);
            }
lbl50:
            // 5 sources

            modelReference.setVirtualDatabase(this.getVirtualDatabase());
            if (f.exists()) {
                checkSum = this.getCheckSum(f);
                modelReference.setChecksum(checkSum);
            }
        }
        catch (Throwable e) {
            VdbEditPlugin.Util.log(e);
        }
        return modelReference;
    }

    protected Properties getModelSourceProperties(Resource eResource) {
        ArgCheck.isNotNull(eResource);
        Iterator iter = eResource.getContents().iterator();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            SqlAspect aspect = AspectManager.getSqlAspect(eObject);
            if (aspect == null || !(aspect instanceof SqlModelSourceAspect)) continue;
            return ((SqlModelSourceAspect)aspect).getProperties(eObject);
        }
        return null;
    }

    protected NonModelReference createNonModelReference(File f2, String pathInArchive) {
        ArgCheck.isNotNull(f2);
        ArgCheck.isNotNull(pathInArchive);
        ArgCheck.isNotZeroLength(pathInArchive);
        NonModelReference nonModelRef = ManifestFactory.eINSTANCE.createNonModelReference();
        nonModelRef.setPath(pathInArchive);
        nonModelRef.setName(f2.getName());
        nonModelRef.setChecksum(this.getCheckSum(f2));
        nonModelRef.setVirtualDatabase(this.getVirtualDatabase());
        return nonModelRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void saveInternalResourceInVdb(File targetDirectory, Resource internalResource, IPath pathInArchive, List problems, List artifactsToWrite) {
        ArgCheck.isNotNull(targetDirectory);
        ArgCheck.isNotNull(internalResource);
        ArgCheck.isNotNull(pathInArchive);
        ArgCheck.isNotNull(problems);
        ArgCheck.isNotNull(artifactsToWrite);
        this.assertContextIsOpen();
        OutputStream ostream = null;
        File targetFile = new File(targetDirectory, ((Object)pathInArchive).toString());
        if (targetFile.exists()) {
            targetFile.delete();
        }
        ostream = new FileOutputStream(targetFile);
        internalResource.save(ostream, this.getLoadOptions());
        artifactsToWrite.add(new Artifact(pathInArchive, targetFile, 1));
        Object var10_9 = null;
        if (ostream == null) return;
        try {
            ostream.close();
            return;
        }
        catch (IOException ignored) {}
        return;
        {
            catch (Exception e2) {
                String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_writing_to_scratch", pathInArchive);
                problems.add(new Status(4, "com.metamatrix.vdb.edit", 100109, msg, e2));
                Object var10_10 = null;
                if (ostream == null) return;
                try {
                    ostream.close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (ostream == null) throw throwable;
            try {
                ostream.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected void saveGlobalResourcesInVdb(File targetDirectory, ResourceSet resourceSet, List problems, List artifactsToWrite) {
        ArgCheck.isNotNull(targetDirectory);
        ArgCheck.isNotNull(resourceSet);
        ArgCheck.isNotNull(problems);
        ArgCheck.isNotNull(artifactsToWrite);
        this.assertContextIsOpen();
        ArrayList eResources = new ArrayList(resourceSet.getResources());
        Iterator i2 = eResources.iterator();
        while (i2.hasNext()) {
            Resource eResource = (Resource)i2.next();
            if (!this.hasImportTo(eResource, "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance")) continue;
            URI uri = URI.createURI("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
            Resource mmTypes = resourceSet.getResource(uri, false);
            if (mmTypes == null) break;
            Path pathInArchive = new Path("builtInDataTypes.xsd");
            this.saveInternalResourceInVdb(targetDirectory, mmTypes, pathInArchive, problems, artifactsToWrite);
            break;
        }
    }

    protected String[] getImportLocations(File modelFile, boolean makeAbsolute) {
        ArgCheck.isNotNull(modelFile);
        ArrayList<String> result = new ArrayList<String>();
        if (modelFile != null && modelFile.exists()) {
            try {
                if (ModelUtil.isXsdFile(modelFile)) {
                    XsdHeader header = XsdHeaderReader.readHeader(modelFile);
                    if (header != null) {
                        result.addAll(Arrays.asList(header.getImportSchemaLocations()));
                        result.addAll(Arrays.asList(header.getIncludeSchemaLocations()));
                    }
                } else if (ModelUtil.isXmiFile(modelFile)) {
                    File tempDirFolder = new File(this.getTempDirectory().getPath());
                    File[] modelFiles = this.findAllFilesInDirectoryRecursively(tempDirFolder);
                    XMIHeader header = XMIHeaderReader.readHeader(modelFile);
                    if (header != null) {
                        ModelImportInfo[] infos = header.getModelImportInfos();
                        block2: for (int i2 = 0; i2 < infos.length; ++i2) {
                            String location = infos[i2].getLocation();
                            String path = infos[i2].getPath();
                            if (!StringUtil.isEmpty(location)) {
                                result.add(location);
                                continue;
                            }
                            if (StringUtil.isEmpty(path)) continue;
                            if (path.startsWith("http")) {
                                result.add(path);
                                continue;
                            }
                            for (int j2 = 0; j2 < modelFiles.length; ++j2) {
                                File f2 = modelFiles[j2];
                                if (!f2.getAbsolutePath().endsWith(path)) continue;
                                URI modelUri = URI.createFileURI(modelFile.getAbsolutePath());
                                URI importUri = URI.createFileURI(f2.getAbsolutePath());
                                URI deresolvedURI = importUri.deresolve(modelUri, true, true, false);
                                if (!deresolvedURI.hasRelativePath()) continue;
                                importUri = deresolvedURI;
                                result.add(URI.decode(importUri.toString()));
                                continue block2;
                            }
                        }
                    }
                }
                if (makeAbsolute) {
                    ArrayList<String> tmp = new ArrayList<String>(result.size());
                    Iterator i3 = result.iterator();
                    while (i3.hasNext()) {
                        String location = (String)i3.next();
                        URI baseUri = URI.createFileURI(modelFile.getAbsolutePath());
                        URI locationUri = URI.createURI(location);
                        if (baseUri.isHierarchical() && !baseUri.isRelative() && locationUri.isRelative()) {
                            locationUri = locationUri.resolve(baseUri);
                        }
                        String uriString = locationUri.isFile() ? locationUri.toFileString() : URI.decode(locationUri.toString());
                        tmp.add(uriString);
                    }
                    result.clear();
                    result.addAll(tmp);
                }
            }
            catch (Exception e2) {
                String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_reading_header", modelFile.getName());
                VdbEditPlugin.Util.log(4, e2, msg);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected String[] getImportLocations(Resource eResource, boolean makeAbsolute) {
        ArgCheck.isNotNull(eResource);
        ArrayList result = new ArrayList();
        if (eResource != null && eResource.getURI().isFile()) {
            File file = new File(eResource.getURI().toFileString());
            return this.getImportLocations(file, makeAbsolute);
        }
        return result.toArray(new String[result.size()]);
    }

    protected boolean hasImportTo(Resource eResource, String theLocationToMatch) {
        ArgCheck.isNotNull(eResource);
        ArgCheck.isNotNull(theLocationToMatch);
        String[] locations = this.getImportLocations(eResource, false);
        for (int i2 = 0; i2 < locations.length; ++i2) {
            String location = locations[i2];
            if (!location.equalsIgnoreCase(theLocationToMatch)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void generateAdditionalArtifacts(IProgressMonitor theMonitor, List artifactGenerators, File sourceDirectory, File targetDirectory, ResourceSet resourceSet, List problems, List artifactsToWrite) {
        ArgCheck.isNotNull(artifactGenerators);
        ArgCheck.isNotNull(sourceDirectory);
        ArgCheck.isNotNull(targetDirectory);
        ArgCheck.isNotNull(resourceSet);
        ArgCheck.isNotNull(problems);
        ArgCheck.isNotNull(artifactsToWrite);
        this.assertContextIsOpen();
        if (this.generators.size() == 0) {
            return;
        }
        monitor = theMonitor == null ? new NullProgressMonitor() : theMonitor;
        genContext = this.createVdbGenerationContext(monitor, sourceDirectory, targetDirectory, resourceSet, artifactsToWrite);
        if (genContext instanceof InternalVdbGenerationContext) {
            ((InternalVdbGenerationContext)genContext).setResourceSet(this.getVdbResourceSet());
            ((InternalVdbGenerationContext)genContext).setVdbContext(this);
        }
        i = resourceSet.getResources().iterator();
        while (i.hasNext()) {
            eResource = (Resource)i.next();
            if (eResource.isLoaded()) continue;
            try {
                eResource.load(this.getLoadOptions());
            }
            catch (Throwable e) {
                msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_loading_resource", eResource.getURI().lastSegment());
                problems.add(new Status(4, "com.metamatrix.vdb.edit", 100116, msg, e));
            }
        }
        this.executeGenerators(monitor, genContext, problems);
        problems.addAll(genContext.getProblems());
        newArtifactsByPath = genContext.getGeneratedArtifactsByPath();
        i = newArtifactsByPath.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            tempFile = null;
            try {
                block34: {
                    path = this.createNormalizedPath((String)entry.getKey());
                    content = entry.getValue();
                    tempFile = new File(targetDirectory, path.toOSString());
                    if (content instanceof String) {
                        stream = null;
                        try {
                            stream = new ByteArrayInputStream(((String)content).getBytes());
                            FileUtils.write(stream, tempFile);
                            var18_19 = null;
                            ** if (stream == null) goto lbl-1000
                        }
                        catch (Throwable var17_28) {
                            var18_19 = null;
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException e) {
                                    msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_closing_stream", path);
                                    problems.add(new Status(4, "com.metamatrix.vdb.edit", 100110, msg, e));
                                }
                            }
                            throw var17_28;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_closing_stream", path);
                                problems.add(new Status(4, "com.metamatrix.vdb.edit", 100110, msg, e));
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block34;
                        }
                    }
                    if (content instanceof Document) {
                        fileStream = new FileOutputStream(tempFile);
                        try {
                            JdomHelper.write((Document)content, fileStream);
                            var22_22 = null;
                            ** if (fileStream == null) goto lbl-1000
                        }
                        catch (Throwable var21_29) {
                            var22_22 = null;
                            if (fileStream != null) {
                                try {
                                    fileStream.close();
                                }
                                catch (IOException e) {
                                    msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_closing_stream", path);
                                    problems.add(new Status(4, "com.metamatrix.vdb.edit", 100110, msg, e));
                                }
                            }
                            throw var21_29;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                fileStream.close();
                            }
                            catch (IOException e) {
                                msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_closing_stream", path);
                                problems.add(new Status(4, "com.metamatrix.vdb.edit", 100110, msg, e));
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block34;
                        }
                    }
                    if (content instanceof InputStream) {
                        stream = (InputStream)content;
                        try {
                            FileUtils.write(stream, tempFile);
                            var26_25 = null;
                            ** if (stream == null) goto lbl-1000
                        }
                        catch (Throwable var25_30) {
                            var26_25 = null;
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException e) {
                                    msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_closing_stream", path);
                                    problems.add(new Status(4, "com.metamatrix.vdb.edit", 100110, msg, e));
                                }
                            }
                            throw var25_30;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_closing_stream", path);
                                problems.add(new Status(4, "com.metamatrix.vdb.edit", 100110, msg, e));
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block34;
                        }
                    }
                    if (content instanceof File) {
                        tempFile = (File)content;
                    }
                }
                if (!(tempFile != null & tempFile.exists())) continue;
                artifactsToWrite.add(new Artifact(path, tempFile, 0));
            }
            catch (Throwable e) {
                params = new Object[]{tempFile.getName(), this.getVdbFile(), e.getMessage()};
                msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_writing_artifact_file", params);
                problems.add(new Status(4, "com.metamatrix.vdb.edit", 100109, msg, e));
            }
        }
        if (genContext instanceof InternalVdbGenerationContext) {
            ((InternalVdbGenerationContext)genContext).dispose();
        }
        genContext = null;
    }

    protected VdbGenerationContext createVdbGenerationContext(IProgressMonitor theMonitor, File sourceDirectory, File targetDirectory, ResourceSet resourceSet, List artifactsToWrite) {
        ArgCheck.isNotNull(sourceDirectory);
        ArgCheck.isNotNull(targetDirectory);
        ArgCheck.isNotNull(resourceSet);
        ArgCheck.isNotNull(artifactsToWrite);
        this.assertContextIsOpen();
        IProgressMonitor monitor = theMonitor == null ? new NullProgressMonitor() : theMonitor;
        monitor.setTaskName(VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Creating_vdb_generation_context"));
        HashMap<Resource, String> modelNamesByResource = new HashMap<Resource, String>();
        HashMap<Resource, String> modelPathsByResource = new HashMap<Resource, String>();
        HashMap<Resource, Boolean> modelVisibilityByResource = new HashMap<Resource, Boolean>();
        HashMap<ObjectID, ArrayList<ProblemMarker>> problemsByObjectId = new HashMap<ObjectID, ArrayList<ProblemMarker>>();
        ArrayList modelList = new ArrayList(resourceSet.getResources());
        Resource[] models = modelList.toArray(new Resource[modelList.size()]);
        Iterator i2 = modelList.iterator();
        while (i2.hasNext()) {
            Resource r2 = (Resource)i2.next();
            URI uri = r2.getURI();
            String pathInTempDir = uri.isFile() ? this.getPathRelativeToFolder(sourceDirectory, new File(uri.toFileString())) : URI.decode(uri.toString());
            modelPathsByResource.put(r2, pathInTempDir);
            modelNamesByResource.put(r2, uri.lastSegment());
            ModelReference modelRef = this.getModelReference(pathInTempDir);
            if (modelRef != null) {
                Boolean isVisible = modelRef.isVisible() ? Boolean.TRUE : Boolean.FALSE;
                modelVisibilityByResource.put(r2, isVisible);
            }
            if (modelRef == null) continue;
            Iterator j2 = modelRef.getMarkers().iterator();
            while (j2.hasNext()) {
                ProblemMarker marker = (ProblemMarker)j2.next();
                EObject target = this.getProblemMarkerEObject(marker);
                if (target == null) continue;
                ObjectID targetId = target.getObjectId();
                ArrayList<ProblemMarker> targetProblems = (ArrayList<ProblemMarker>)problemsByObjectId.get(targetId);
                if (targetProblems == null) {
                    targetProblems = new ArrayList<ProblemMarker>(7);
                    problemsByObjectId.put(targetId, targetProblems);
                }
                targetProblems.add(marker);
            }
        }
        ArrayList<IPath> paths = new ArrayList<IPath>();
        Iterator i3 = artifactsToWrite.iterator();
        while (i3.hasNext()) {
            Artifact artifact = (Artifact)i3.next();
            paths.add(artifact.path);
        }
        IPath[] existingArtifactPaths = paths.toArray(new IPath[paths.size()]);
        VdbGenerationContextParameters parameters = new VdbGenerationContextParameters();
        parameters.setModels(models);
        parameters.setExistingPathsInVdb(existingArtifactPaths);
        parameters.setModelNameByResource(modelNamesByResource);
        parameters.setModelVisibilityByResource(modelVisibilityByResource);
        parameters.setProblemsByObjectId(problemsByObjectId);
        parameters.setTempFolderAbsolutePath(targetDirectory.getAbsolutePath());
        parameters.setWorkspacePathByResource(modelPathsByResource);
        VdbGenerationContext genContext = this.getVdbGenerationContextFactory().createVdbGenerationContext(parameters);
        return genContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeGenerators(IProgressMonitor theMonitor, VdbGenerationContext genContext, List problems) {
        ArgCheck.isNotNull(genContext);
        ArgCheck.isNotNull(problems);
        IProgressMonitor monitor = theMonitor == null ? new NullProgressMonitor() : theMonitor;
        Iterator i2 = this.generators.iterator();
        while (i2.hasNext()) {
            Status status;
            String msg;
            Throwable error;
            Object var10_11;
            if (monitor.isCanceled()) {
                return;
            }
            VdbArtifactGenerator generator = (VdbArtifactGenerator)i2.next();
            ArtifactGeneratorThread thread = new ArtifactGeneratorThread(genContext, generator);
            thread.start();
            try {
                try {
                    while ((monitor == null || !monitor.isCanceled()) && thread.isAlive()) {
                        String displayMessage = genContext.getProgressMessage();
                        monitor.setTaskName(displayMessage);
                        Thread.sleep(100L);
                    }
                    if (monitor != null && monitor.isCanceled() && thread.isAlive()) {
                        try {
                            thread.stop();
                        }
                        catch (Throwable ignored) {
                        }
                    }
                    var10_11 = null;
                    error = thread.getThrowable();
                    if (error == null) continue;
                }
                catch (InterruptedException e2) {
                    var10_11 = null;
                    error = thread.getThrowable();
                    if (error == null) continue;
                    if (error instanceof InterruptedException) {
                        msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Generator_cancelled", generator.getClass().getName());
                        status = new Status(2, "com.metamatrix.vdb.edit", 100111, msg, error);
                        problems.add(status);
                        continue;
                    }
                    msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_executing_generator", generator.getClass().getName());
                    status = new Status(4, "com.metamatrix.vdb.edit", 100112, msg, error);
                    problems.add(status);
                    VdbEditPlugin.Util.log(status);
                    continue;
                }
            }
            catch (Throwable throwable) {
                var10_11 = null;
                error = thread.getThrowable();
                if (error == null) throw throwable;
                if (error instanceof InterruptedException) {
                    msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Generator_cancelled", generator.getClass().getName());
                    status = new Status(2, "com.metamatrix.vdb.edit", 100111, msg, error);
                    problems.add(status);
                    throw throwable;
                }
                msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_executing_generator", generator.getClass().getName());
                status = new Status(4, "com.metamatrix.vdb.edit", 100112, msg, error);
                problems.add(status);
                VdbEditPlugin.Util.log(status);
                throw throwable;
            }
            if (error instanceof InterruptedException) {
                msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Generator_cancelled", generator.getClass().getName());
                status = new Status(2, "com.metamatrix.vdb.edit", 100111, msg, error);
                problems.add(status);
                continue;
            }
            msg = VdbEditPlugin.Util.getString("SharedWsVdbContextEditor.Error_executing_generator", generator.getClass().getName());
            status = new Status(4, "com.metamatrix.vdb.edit", 100112, msg, error);
            problems.add(status);
            VdbEditPlugin.Util.log(status);
        }
    }

    protected EObject getProblemMarkerEObject(ProblemMarker marker) {
        if (marker != null && marker.getTargetUri() != null && marker.getTargetUri().startsWith("mmuuid")) {
            Iterator i2 = this.getVdbResourceSet().getResources().iterator();
            while (i2.hasNext()) {
                Resource r2 = (Resource)i2.next();
                EObject eObj = r2.getEObject(marker.getTargetUri());
                if (eObj == null) continue;
                return eObj;
            }
        }
        return null;
    }

    private class ArtifactGeneratorThread
    extends Thread {
        private VdbGenerationContext context;
        private VdbArtifactGenerator generator;
        private Throwable throwable;

        protected ArtifactGeneratorThread(VdbGenerationContext context, VdbArtifactGenerator generator) {
            super("VdbArtifactGeneratorThread");
            this.context = context;
            this.generator = generator;
        }

        public void run() {
            try {
                this.generator.execute(this.context);
            }
            catch (Throwable t2) {
                this.throwable = t2;
            }
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    private class Artifact {
        public final IPath path;
        public final File content;
        public final int workToWrite;

        public Artifact(IPath path, File content, int workToWrite) {
            this.path = path;
            this.content = content;
            this.workToWrite = workToWrite;
        }
    }
}

