/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.vdb.edit.VdbContextValidator;
import com.metamatrix.vdb.edit.VdbContextValidatorResult;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.internal.edit.VdbContextValidatorResultImpl;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class SharedWsVdbContextValidator
implements VdbContextValidator {
    public VdbContextValidatorResult validate(IProgressMonitor theMonitor, Resource[] models) {
        ArgCheck.isNotNull(models);
        IProgressMonitor monitor = theMonitor == null ? new NullProgressMonitor() : theMonitor;
        int totalFileCount = models.length;
        String taskName = VdbEditPlugin.Util.getString("SharedWsVdbContextValidator.Validating");
        monitor.beginTask(taskName, totalFileCount);
        VdbContextValidatorResultImpl result = new VdbContextValidatorResultImpl();
        for (int i2 = 0; i2 < models.length; ++i2) {
            Resource eResource = models[i2];
            String name = eResource.getURI().isFile() ? eResource.getURI().lastSegment() : URI.decode(eResource.getURI().toString());
            try {
                monitor.setTaskName(VdbEditPlugin.Util.getString("SharedWsVdbContextValidator.Validating_model", name));
                ModelResource mResource = ModelerCore.getModelWorkspace().findModelResource(eResource);
                if (mResource != null) {
                    IResource iResource = mResource.getResource();
                    IMarker[] markers = iResource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                    for (int j2 = 0; j2 < markers.length; ++j2) {
                        IMarker marker = markers[j2];
                        int severity = 0;
                        int markerSeverity = marker.getAttribute("severity", -1);
                        switch (markerSeverity) {
                            case 2: {
                                severity = 4;
                                break;
                            }
                            case 1: {
                                severity = 2;
                                break;
                            }
                            case 0: {
                                severity = 1;
                                break;
                            }
                        }
                        String msg = (String)marker.getAttribute("message");
                        Throwable t2 = null;
                        result.addProblem(eResource, severity, msg, t2);
                    }
                }
                monitor.worked(1);
                continue;
            }
            catch (Throwable t3) {
                String msg = VdbEditPlugin.Util.getString("SharedWsVdbContextValidator.Error_validating_model", name);
                result.addProblem(eResource, 4, msg, t3);
            }
        }
        return result;
    }
}

