/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.internal.edit.VdbEditingContextImpl;
import com.metamatrix.vdb.internal.edit.VdbEditingContextImplProblemMarker;
import com.metamatrix.vdb.internal.edit.VdbWsdlGenerationOptionsValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class VdbEditingContextImplValidationHelper {
    private String MSGKEY = "VdbEditingContextImpl.The_model_{0}_is_dependent_on_{1}_which_is_not_part_of_the_vdb._1";
    private VdbEditingContextImpl vdbEditingContextImpl;
    private Collection eResources;
    private boolean partialValidation;
    private List problemMarker;
    private List problems;
    private Map problemsMarkerInfo;
    private IPath modelPath;
    private ModelReference modelRef;
    private String modelPathString;

    public VdbEditingContextImplValidationHelper(VdbEditingContextImpl vdbEditingContextImpl, Collection eResources, boolean partialValidation) {
        this.vdbEditingContextImpl = vdbEditingContextImpl;
        this.eResources = eResources;
        this.partialValidation = partialValidation;
    }

    protected IStatus getVdbStatus() {
        IStatus status = null;
        this.problems = new ArrayList();
        this.problemMarker = new ArrayList();
        this.problemsMarkerInfo = new HashMap();
        Iterator iter = this.eResources.iterator();
        while (iter.hasNext()) {
            Resource eResource = (Resource)iter.next();
            if (!this.isValidVdbInitial(eResource)) continue;
            if (ModelerCore.getPlugin() != null) {
                this.isStale();
            }
            this.validateModels(eResource);
        }
        if (!this.partialValidation) {
            this.validateVdbWsdlGenerationOptions();
        }
        if (!this.problems.isEmpty()) {
            String desc = VdbEditPlugin.Util.getString("VdbEditingContextImpl.errors_validating_vdb");
            status = this.getVdbEditingContextImpl().createSingleIStatus(this.problems, desc);
        }
        return status;
    }

    private void validateModels(Resource eResource) {
        String[] unresolvedLocations = this.getVdbEditingContextImpl().getVdbContainer().getResourceFinder().findUnresolvedResourceLocations(eResource);
        if (unresolvedLocations.length > 0) {
            for (int i2 = 0; i2 != unresolvedLocations.length; ++i2) {
                String location = unresolvedLocations[i2];
                if (!location.startsWith("http")) {
                    location = URI.createURI(location).lastSegment();
                }
                this.setProblems(location, 4, 4, this.problemMarker, this.problems);
            }
        }
    }

    private String getMsgDescription(String path) {
        Object[] params = new Object[]{this.modelPath, path};
        return VdbEditPlugin.Util.getString(this.MSGKEY, params);
    }

    private void setProblems(String path, int markerStatus, int problemStatus, List problemMarker, List problems) {
        String msg = this.getMsgDescription(path);
        problemMarker.add(new VdbEditingContextImplProblemMarker(this.modelRef, markerStatus, msg, null));
        problems.add(new Status(problemStatus, "com.metamatrix.vdb.edit", 0, msg, null));
    }

    private void validateVdbWsdlGenerationOptions() {
        VdbWsdlGenerationOptionsValidator vdbWsdlGenerationOptionsValidator = new VdbWsdlGenerationOptionsValidator(this.getVdbEditingContextImpl());
        vdbWsdlGenerationOptionsValidator.validateVdbWsdlGenerationOptions(this.problemMarker, this.problems);
    }

    protected void markProblems() {
        if (this.problemMarker == null || this.problemMarker.size() == 0) {
            return;
        }
        Iterator problemMarkerIter = this.problemMarker.iterator();
        while (problemMarkerIter.hasNext()) {
            VdbEditingContextImplProblemMarker marker = (VdbEditingContextImplProblemMarker)problemMarkerIter.next();
            marker.markProblem();
        }
    }

    private boolean isValidVdbInitial(Resource eResource) {
        if (!this.isValidModelPathString(eResource)) {
            return false;
        }
        this.setPath();
        if ("MetaMatrix-VdbManifestModel.xmi".equals(this.modelPathString) || "MetaMatrixDataServices.wsdl".equals(this.modelPathString)) {
            return false;
        }
        return this.isValidModelReference(eResource);
    }

    private boolean isValidModelPathString(Resource eResource) {
        this.modelPathString = this.getVdbEditingContextImpl().getResourcePath(eResource);
        if (this.modelPathString == null) {
            URI uri = eResource.getURI();
            String location = uri.isFile() ? uri.toFileString() : URI.decode(uri.toString());
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.finding_model_reference", location);
            this.problemMarker.add(new VdbEditingContextImplProblemMarker(this.vdbEditingContextImpl.getVirtualDatabase(), 4, msg, null));
            this.problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg, null));
            return false;
        }
        return true;
    }

    private boolean isValidModelReference(Resource eResource) {
        this.modelRef = this.getVdbEditingContextImpl().getModelReferenceByPath(this.modelPath);
        if (this.modelRef == null) {
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.finding_model_reference", this.modelPath);
            this.problemMarker.add(new VdbEditingContextImplProblemMarker(this.vdbEditingContextImpl.getVirtualDatabase(), 4, msg, null));
            this.problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg, null));
            return false;
        }
        return true;
    }

    private void isStale() {
        String msg;
        boolean isStale = this.getVdbEditingContextImpl().isStale(this.modelRef);
        if (isStale && !this.containsMessage(msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.staleModel", this.modelRef.getName()))) {
            this.problemMarker.add(new VdbEditingContextImplProblemMarker(this.modelRef, 2, msg, null));
        }
    }

    private boolean containsMessage(String msg) {
        return this.problemsMarkerInfo.containsKey(msg);
    }

    private void setPath() {
        this.modelPath = new Path(this.modelPathString);
    }

    private VdbEditingContextImpl getVdbEditingContextImpl() {
        return this.vdbEditingContextImpl;
    }
}

