/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.vdb.edit.VdbContextEditor;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.edit.VdbWsdlGenerationOptions;
import com.metamatrix.vdb.edit.manifest.VirtualDatabase;
import com.metamatrix.vdb.edit.manifest.WsdlOptions;
import com.metamatrix.vdb.internal.edit.VdbEditingContextImpl;
import com.metamatrix.vdb.internal.edit.VdbEditingContextImplProblemMarker;
import com.metamatrix.vdb.internal.edit.VdbWsdlGenerationOptionsImpl;
import com.metamatrix.vdb.internal.edit.WsdlGenerationOptionsHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.xerces.util.URI;
import org.eclipse.core.runtime.Status;

public class VdbWsdlGenerationOptionsValidator {
    private VdbEditingContextImpl vdbEditingContextImpl;
    private VdbContextEditor vdbContextEditor;
    private final List eResources;
    private final WsdlOptions wsdlOptions;
    private final Map eResourceToPath;

    public VdbWsdlGenerationOptionsValidator(VdbEditingContextImpl vdbEditingContextImpl) {
        ArgCheck.isNotNull(vdbEditingContextImpl);
        this.vdbEditingContextImpl = vdbEditingContextImpl;
        this.vdbContextEditor = null;
        this.eResources = null;
        this.wsdlOptions = null;
        this.eResourceToPath = null;
    }

    public VdbWsdlGenerationOptionsValidator(VdbContextEditor vdbContextEditor, List eResources, WsdlOptions wsdlOptions, Map eResourceToPath) {
        ArgCheck.isNotNull(vdbContextEditor);
        ArgCheck.isNotNull(eResources);
        ArgCheck.isNotNull(wsdlOptions);
        ArgCheck.isNotNull(eResourceToPath);
        this.vdbEditingContextImpl = null;
        this.vdbContextEditor = vdbContextEditor;
        this.eResources = eResources;
        this.wsdlOptions = wsdlOptions;
        this.eResourceToPath = eResourceToPath;
    }

    public void validateVdbWsdlGenerationOptions(List problems) {
        this.validateVdbWsdlGenerationOptions(new ArrayList(), problems);
    }

    protected void validateVdbWsdlGenerationOptions(List problemMarker, List problems) {
        VdbWsdlGenerationOptions wsdlGenOptions = null;
        if (this.vdbEditingContextImpl != null) {
            wsdlGenOptions = this.vdbEditingContextImpl.getVdbWsdlGenerationOptions();
        } else if (this.eResources != null) {
            wsdlGenOptions = new WsdlGenerationOptionsHelper(this.eResources, this.wsdlOptions, this.eResourceToPath);
        } else if (this.vdbContextEditor != null) {
            wsdlGenOptions = new VdbWsdlGenerationOptionsImpl(this.vdbContextEditor);
        }
        if (wsdlGenOptions.canWsdlBeGenerated()) {
            VirtualDatabase vdb = this.getVirtualDatabase();
            WsdlOptions wsdlOptions = vdb.getWsdlOptions();
            if (wsdlOptions == null) {
                String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.wsdlTargetNamespaceUriMissing");
                this.setProblems(vdb, msg, 4, 4, problemMarker, problems);
            } else {
                this.validateTargetNamespaceUri(vdb, wsdlOptions, problemMarker, problems);
                this.validateDefaultNamespaceUri(vdb, wsdlOptions, problemMarker, problems);
            }
        }
    }

    private VirtualDatabase getVirtualDatabase() {
        VirtualDatabase vdb = null;
        if (this.vdbEditingContextImpl != null) {
            vdb = this.vdbEditingContextImpl.getVirtualDatabase();
        } else if (this.vdbContextEditor != null) {
            vdb = this.vdbContextEditor.getVirtualDatabase();
        }
        return vdb;
    }

    private void validateTargetNamespaceUri(VirtualDatabase vdb, WsdlOptions wsdlOptions, List problemMarker, List problems) {
        String targetNamespaceUri = wsdlOptions.getTargetNamespaceUri();
        if (targetNamespaceUri == null || targetNamespaceUri.trim().length() == 0) {
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.wsdlTargetNamespaceUriMissing");
            this.setProblems(vdb, msg, 4, 4, problemMarker, problems);
        } else {
            try {
                new URI(targetNamespaceUri);
            }
            catch (URI.MalformedURIException err) {
                String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.wsdlTargetNamespaceUriIsInvalid", targetNamespaceUri);
                this.setProblems(vdb, msg, 4, 4, problemMarker, problems);
            }
        }
    }

    private void validateDefaultNamespaceUri(VirtualDatabase vdb, WsdlOptions wsdlOptions, List problemMarker, List problems) {
        String defaultNamespaceUri = wsdlOptions.getDefaultNamespaceUri();
        if (defaultNamespaceUri == null || defaultNamespaceUri.trim().length() == 0) {
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.wsdlDefaultNamespaceUriMissing");
            this.setProblems(vdb, msg, 2, 2, problemMarker, problems);
        } else if (!"http://schemas.xmlsoap.org/wsdl/".equals(defaultNamespaceUri)) {
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.wsdlDefaultNamespaceUriNotWsdlNamespace");
            this.setProblems(vdb, msg, 2, 2, problemMarker, problems);
        }
    }

    private void setProblems(VirtualDatabase vdb, String msg, int markerStatus, int problemStatus, List problemMarker, List problems) {
        problemMarker.add(new VdbEditingContextImplProblemMarker(vdb, markerStatus, msg, null));
        problems.add(new Status(problemStatus, "com.metamatrix.vdb.edit", 0, msg, null));
    }
}

