/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit.materialization.template.engine;

import com.metamatrix.vdb.edit.materialization.DatabaseDialect;
import com.metamatrix.vdb.internal.edit.materialization.template.engine.ExpandedTemplate;
import com.metamatrix.vdb.internal.edit.materialization.template.engine.Template;
import com.metamatrix.vdb.internal.edit.materialization.template.engine.TemplateData;
import java.io.Reader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

public class TemplateExpander {
    private TemplateData data;
    private DatabaseDialect database;

    public TemplateExpander(TemplateData data, DatabaseDialect database) {
        this.data = data;
        this.database = database;
    }

    public ExpandedTemplate expand(String nameTemplate, Reader[] templateReaders, String templateName) {
        return new ExpandedTemplate(this.expandText(nameTemplate), this.expandFromReaders(templateReaders, templateName), this.database.getType());
    }

    private String expandFromReaders(Reader[] readers, String templateName) {
        StringTemplateGroup group = new StringTemplateGroup(readers[0]);
        for (int i2 = 1; i2 < readers.length; ++i2) {
            StringTemplateGroup tempGroup = group;
            group = new StringTemplateGroup(readers[i2]);
            group.setSuperGroup(tempGroup);
        }
        return this.processTemplate(group.getInstanceOf(templateName));
    }

    String expandText(String templateText) {
        return this.processTemplate(new StringTemplate(templateText));
    }

    private String processTemplate(final StringTemplate template) {
        this.data.populateTemplate(new Template(){

            public void setAttribute(String attributeName, Object value) {
                template.setAttribute(attributeName, value);
            }
        }, this.database);
        return template.toString();
    }
}

