/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.codenorm;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.StringTokenizer;
import net.sf.saxon.codenorm.NormalizerData;
import net.sf.saxon.codenorm.UnicodeData;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntToIntHashMap;

class UnicodeDataParser {
    private static final int SBase = 44032;
    private static final int LBase = 4352;
    private static final int VBase = 4449;
    private static final int TBase = 4519;
    private static final int LCount = 19;
    private static final int VCount = 21;
    private static final int TCount = 28;
    private static final int NCount = 588;
    private static final int SCount = 11172;

    private UnicodeDataParser() {
    }

    static NormalizerData build() {
        IntToIntHashMap intToIntHashMap = new IntToIntHashMap(400);
        intToIntHashMap.setDefaultValue(0);
        IntHashMap intHashMap = new IntHashMap(18000);
        IntToIntHashMap intToIntHashMap2 = new IntToIntHashMap(15000);
        intToIntHashMap2.setDefaultValue(65535);
        BitSet bitSet = new BitSet(128000);
        BitSet bitSet2 = new BitSet(128000);
        UnicodeDataParser.readExclusionList(bitSet2);
        UnicodeDataParser.readCompatibilityList(bitSet);
        UnicodeDataParser.readCanonicalClassTable(intToIntHashMap);
        UnicodeDataParser.readDecompositionTable(intHashMap, intToIntHashMap2, bitSet2, bitSet);
        return new NormalizerData(intToIntHashMap, intHashMap, intToIntHashMap2, bitSet, bitSet2);
    }

    private static void readExclusionList(BitSet bitSet) {
        for (int i2 = 0; i2 < UnicodeData.exclusionList.length; ++i2) {
            String string = UnicodeData.exclusionList[i2];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = Integer.parseInt(string2, 32);
                bitSet.set(n2);
            }
        }
    }

    private static void readCompatibilityList(BitSet bitSet) {
        for (int i2 = 0; i2 < UnicodeData.compatibilityList.length; ++i2) {
            String string = UnicodeData.compatibilityList[i2];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = Integer.parseInt(string2, 32);
                bitSet.set(n2);
            }
        }
    }

    private static void readCanonicalClassTable(IntToIntHashMap intToIntHashMap) {
        Object object;
        Object object2;
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(5000);
        for (n2 = 0; n2 < UnicodeData.canonicalClassKeys.length; ++n2) {
            String string = UnicodeData.canonicalClassKeys[n2];
            object2 = new StringTokenizer(string, ",");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                int n3 = Integer.parseInt((String)object, 32);
                arrayList.add(new Integer(n3));
            }
        }
        n2 = 0;
        for (int i2 = 0; i2 < UnicodeData.canonicalClassValues.length; ++i2) {
            object2 = UnicodeData.canonicalClassValues[i2];
            object = new StringTokenizer((String)object2, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                int n4 = Integer.parseInt(string, 32);
                intToIntHashMap.put((Integer)arrayList.get(n2++), n4);
            }
        }
    }

    private static void readDecompositionTable(IntHashMap intHashMap, IntToIntHashMap intToIntHashMap, BitSet bitSet, BitSet bitSet2) {
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < UnicodeData.decompositionKeys.length; ++n3) {
            String string = UnicodeData.decompositionKeys[n3];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                n2 = Integer.parseInt(string2, 32);
                String string3 = UnicodeData.decompositionValues[n4++];
                intHashMap.put(n2, string3);
                if (bitSet2.get(n2) || bitSet.get(n2)) continue;
                char c2 = '\u0000';
                char c3 = string3.charAt(0);
                if (string3.length() > 1) {
                    c2 = c3;
                    c3 = string3.charAt(1);
                }
                int n5 = c2 << 16 | c3;
                intToIntHashMap.put(n5, n2);
            }
        }
        for (n3 = 0; n3 < 11172; ++n3) {
            char c4;
            char c5;
            int n6 = n3 % 28;
            if (n6 != 0) {
                c5 = (char)(44032 + n3 - n6);
                c4 = (char)(4519 + n6);
            } else {
                c5 = (char)(4352 + n3 / 588);
                c4 = (char)(4449 + n3 % 588 / 28);
            }
            n2 = c5 << 16 | c4;
            int n7 = n3 + 44032;
            intHashMap.put(n7, String.valueOf(c5) + c4);
            intToIntHashMap.put(n2, n7);
        }
    }
}

